/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawConnectionConfig;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface DatabaseConnectionPoint
extends RawConnectionConfig {
    @NotNull
    public LocalDataSource getDataSource();

    public DatabaseDriver getDatabaseDriver();

    @NotNull
    public Properties getConnectionProperties();

    public boolean isReadOnly();

    @NotNull
    public Map<String, String> getAdditionalProperties();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    default public Map<String, String> getAdditionalJdbcProperties() {
        Map<String, String> map2 = this.getAdditionalProperties();
        if (map2 == null) {
            DatabaseConnectionPoint.$$$reportNull$$$0(0);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionPoint", "getAdditionalJdbcProperties"));
    }

    public static class Adapter
    implements DatabaseConnectionPoint {
        private final DatabaseConnectionPoint myDelegate;

        public Adapter(DatabaseConnectionPoint delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Properties getConnectionProperties() {
            Properties properties = this.myDelegate.getConnectionProperties();
            if (properties == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            return properties;
        }

        @Override
        public boolean isReadOnly() {
            return this.myDelegate.isReadOnly();
        }

        @Override
        @NotNull
        public LocalDataSource getDataSource() {
            LocalDataSource localDataSource = this.myDelegate.getDataSource();
            if (localDataSource == null) {
                Adapter.$$$reportNull$$$0(1);
            }
            return localDataSource;
        }

        @Override
        @NotNull
        public Map<String, String> getAdditionalProperties() {
            Map<String, String> map2 = this.myDelegate.getAdditionalProperties();
            if (map2 == null) {
                Adapter.$$$reportNull$$$0(2);
            }
            return map2;
        }

        @Override
        public DatabaseDriver getDatabaseDriver() {
            return this.myDelegate.getDatabaseDriver();
        }

        @Override
        public String getName() {
            return this.myDelegate.getName();
        }

        @Override
        public String getDriverClass() {
            return this.myDelegate.getDriverClass();
        }

        @Override
        public String getUrl() {
            return this.myDelegate.getUrl();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectionProperties";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalProperties";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

