/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDriverCore
extends Iconable {
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers();

    @Nullable
    public String getDriverClass();

    @Nullable
    public Dbms getForcedDbms();

    public boolean isPredefined();

    public String getId();

    public String getSqlDialect();

    @Nullable
    public Bounds getConnectionBounds();

    public <T> T getOption(@NotNull Option<T> var1);

    public <T> void setOption(@NotNull Option<T> var1, T var2);

    @Nullable
    public String getVmOptions();

    public static class Option<T> {
        private static final Map<String, Option<?>> ourInstances = new LinkedHashMap();
        private final String myName;
        private final T myDef;

        @Nullable
        public static Option byName(String name) {
            return ourInstances.get(name);
        }

        @NotNull
        public static Collection<? extends Option<?>> enumerate() {
            Collection<Option<?>> collection = ourInstances.values();
            if (collection == null) {
                Option.$$$reportNull$$$0(0);
            }
            return collection;
        }

        public Option(String name, T def) {
            this.myName = name;
            this.myDef = def;
            ourInstances.put(name, this);
        }

        public String getName() {
            return this.myName;
        }

        public T getDefault() {
            return this.myDef;
        }

        public T get(@Nullable DatabaseDriverCore driver) {
            return driver != null ? driver.getOption(this) : this.myDef;
        }

        public T fromString(String value2) {
            if (value2 == null) {
                return this.myDef;
            }
            if (this.myDef instanceof String) {
                return (T)value2;
            }
            if (this.myDef instanceof Boolean) {
                return (T)Boolean.valueOf(value2);
            }
            if (this.myDef instanceof Enum) {
                return (T)Enum.valueOf(((Enum)this.myDef).getClass(), value2);
            }
            throw new AssertionError((Object)(this + "!=" + value2));
        }

        public String toString() {
            return this.myName + "(" + this.myDef + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverCore$Option", "enumerate"));
        }
    }

    public static class Bounds {
        public boolean inReadOnlyMode = false;
        @NotNull
        public ObjectKind boundTo = ObjectKind.DATABASE;
        @NotNull
        public List<Pair<String, Boolean>> rewriteParameters = new SmartList();
        @Nullable
        public String defaultValue = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bounds bounds = (Bounds)o;
            return this.inReadOnlyMode == bounds.inReadOnlyMode && this.boundTo.equals(bounds.boundTo) && this.rewriteParameters.equals(bounds.rewriteParameters) && Objects.equals(this.defaultValue, bounds.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.inReadOnlyMode, this.boundTo, this.rewriteParameters, this.defaultValue);
        }
    }
}

