/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.OneShotSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementBasis;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableParameterizedStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u0016\u001a\u00020\u001cR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dataSource/connection/statements/ParameterizedSmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementData;", "Lcom/intellij/database/dataSource/connection/statements/OneShotSmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementBasis;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "input", "statement", "decoration", "escapeIndex", "", "extract", "", "reuse", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "intellij.database.core.impl"})
public final class ParameterizedSmartStatement
extends JdbcBasedSmartStatement.Parameterized<ParameterizedStatementData>
implements OneShotSmartStatement<ParameterizedStatementData, ParameterizedStatementBasis, ParameterizedStatementDecoration> {
    @NotNull
    private final StatementHolder.OneShot<RemotePreparedStatement> statementHolder;

    @Override
    @NotNull
    protected StatementHolder.OneShot<RemotePreparedStatement> getStatementHolder() {
        return this.statementHolder;
    }

    @Override
    @NotNull
    public String extract(@NotNull ParameterizedStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getBasis().getSql();
    }

    @Override
    @NotNull
    protected Either<StagedException, Unit> before(@NotNull ParameterizedStatementData input, @NotNull RemotePreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.getAuditService().beforeParameterizedStatement(input, this);
        return super.before(input, statement);
    }

    @Override
    public int escapeIndex(@NotNull ParameterizedStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getBasis().getEscapeIdx();
    }

    @Override
    @NotNull
    public ParameterizedStatementDecoration decoration(@NotNull ParameterizedStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getDecoration();
    }

    @Override
    @NotNull
    public ReusableSmartStatement<ParameterizedStatementDecoration> reuse(@NotNull ParameterizedStatementBasis input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new ReusableParameterizedStatement(input, this.getConnection(), this.getAuditService(), this.getConfiguration());
    }

    @Override
    @NotNull
    public final ReusableSmartStatement<ParameterizedStatementDecoration> reuse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.reuse(new StatementParameters().asBasis(input));
    }

    public ParameterizedSmartStatement(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(connection2, auditService, configuration);
        this.statementHolder = new StatementHolder.OneShot(auditService, this);
    }
}

