/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.DbSrcMigration;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcChangesBrowser.class);
    public static final ChangeNodeDecorator MY_DECORATOR = new ChangeNodeDecorator(){

        public void decorate(@NotNull Change change, @NotNull SimpleColoredComponent component, boolean isShowFlatten) {
            ContentRevision revision;
            if (change == null) {
                1.$$$reportNull$$$0(0);
            }
            if (component == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((revision = change.getAfterRevision()) == null) {
                return;
            }
            Icon icon = DbSrcUtils.getIcon(null, revision.getFile().getPath());
            if (icon != null) {
                component.setIcon(icon);
            }
        }

        public void preDecorate(@NotNull Change change, @NotNull ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
            if (change == null) {
                1.$$$reportNull$$$0(2);
            }
            if (renderer == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decorate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preDecorate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public DbSrcChangesBrowser(Project project) {
        super(project, false, true);
        this.init();
        this.myViewer.rebuildTree();
        DbSrcChangesTracker.getInstance(project).addListener((ModificationTrackerListener<DbSrcChangesTracker>)((ModificationTrackerListener)source -> DbUIUtil.invokeLater(() -> this.myViewer.rebuildTree())), this);
    }

    public int getToolbarAnchor() {
        return 2;
    }

    @NotNull
    protected Border createViewerBorder() {
        Border border = JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)0);
        if (border == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(0);
        }
        return border;
    }

    public void dispose() {
    }

    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        DefaultTreeModel defaultTreeModel = new MyTreeModelBuilder(this.myProject, this.getGrouping()).setDBChangeLists(ContainerUtil.filter(DbSrcChangesTracker.getInstance(this.myProject).getChangeLists(), c2 -> !c2.getChanges().isEmpty())).build();
        if (defaultTreeModel == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(1);
        }
        return defaultTreeModel;
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        AnAction revertAction = DbSrcMigration.RevertAction.getInstance();
        revertAction.registerCustomShortcutSet((JComponent)this.myViewer, null);
        AnAction commitAction = DbSrcMigration.SubmitAction.getInstance();
        commitAction.registerCustomShortcutSet((JComponent)this.myViewer, null);
        List<AnAction> list = Arrays.asList(commitAction, revertAction, this.getDiffAction());
        if (list == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        List list = ContainerUtil.prepend((List)super.createPopupMenuActions(), (Object[])new AnAction[]{DbSrcMigration.SubmitAction.getInstance(), DbSrcMigration.RevertAction.getInstance()});
        if (list == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void showDiff() {
        DbSrcChangesTracker.flushAndUpdateFiles(this.getSelectedFiles());
        super.showDiff();
    }

    @NotNull
    protected List<VirtualFile> getSelectedFiles() {
        DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
        List<VirtualFile> list = VcsTreeModelData.selected((JTree)this.myViewer).userObjects().stream().map(c2 -> {
            Change change = (Change)ObjectUtils.tryCast((Object)c2, Change.class);
            ContentRevision revision = change == null ? null : change.getAfterRevision();
            return revision == null ? null : dbFs.findFileByPath(revision.getFile().getPath());
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            DbSrcChangesBrowser.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewerBorder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class MyTreeModelBuilder
    extends TreeModelBuilder {
        private MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping) {
            if (project == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            if (grouping == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            super(project, grouping);
        }

        @NotNull
        public TreeModelBuilder setDBChangeLists(@NotNull Collection<DbSrcChangesTracker.DbSrcChangeList> changeLists) {
            if (changeLists == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            for (DbSrcChangesTracker.DbSrcChangeList list : changeLists) {
                List changes = ContainerUtil.sorted(list.getChanges(), (Comparator)CHANGE_COMPARATOR);
                ChangesBrowserChangeListNode listNode = this.createDBChangeListNode(list, changes);
                listNode.markAsHelperNode();
                this.insertSubtreeRoot((ChangesBrowserNode)listNode);
                for (Change change : changes) {
                    this.insertChangeNode(change, (ChangesBrowserNode)listNode, this.createChangeNode(change, MY_DECORATOR), MyTreeModelBuilder::createDBPathNode);
                }
            }
            MyTreeModelBuilder myTreeModelBuilder = this;
            if (myTreeModelBuilder == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(3);
            }
            return myTreeModelBuilder;
        }

        private ChangesBrowserChangeListNode createDBChangeListNode(final @NotNull DbSrcChangesTracker.DbSrcChangeList list, List<Change> changes) {
            if (list == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(4);
            }
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            return new ChangesBrowserChangeListNode(this.myProject, list, listRemoteState){

                public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
                    if (renderer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.render(renderer, selected, expanded, hasFocus);
                    LocalDataSource dataSource2 = list.getDataSource();
                    if (dataSource2 != null) {
                        renderer.setIcon(dataSource2.getBaseIcon());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$1", "render"));
                }
            };
        }

        @Nullable
        private static ChangesBrowserNode createDBPathNode(@NotNull StaticFilePath path) {
            Boolean res2;
            if (path == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(5);
            }
            if (!Boolean.TRUE.equals(res2 = DbSrcFileSystem.processPath(path.getPath(), new DbSrcFileSystemCore.ItemProcessor<Boolean>(){

                @Override
                public Boolean processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                    if (dataSourceId == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (type == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return type == DbSrcFileSystemCore.ItemType.SRC;
                }

                @Override
                public Boolean processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind kind) {
                    if (dataSourceId == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return Boolean.TRUE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dataSourceId";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processFile";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processFolder";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }))) {
                return null;
            }
            return new MyChangesBrowserFilePathNode(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDBChangeLists";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setDBChangeLists";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDBChangeListNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createDBPathNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class MyChangesBrowserFilePathNode
        extends ChangesBrowserFilePathNode {
            private MyChangesBrowserFilePathNode(@NotNull StaticFilePath path) {
                if (path == null) {
                    MyChangesBrowserFilePathNode.$$$reportNull$$$0(0);
                }
                super(VcsUtil.getFilePath((String)path.getPath(), (boolean)true));
            }

            @NotNull
            protected String getRelativePath(FilePath path) {
                FilePath parent2 = MyChangesBrowserFilePathNode.safeCastToFilePath((ChangesBrowserNode)this.getParent());
                if (parent2 == null) {
                    String res2 = DbSrcFileSystem.processPath(path.getPath(), new DbSrcFileSystemCore.ItemProcessor<String>(){

                        @Override
                        public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                            if (dataSourceId == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            StringBuilder res2 = this.build(path);
                            if (group != null) {
                                (res2.length() == 0 ? res2 : res2.append(".")).append(group.code());
                            }
                            return res2.toString();
                        }

                        @Override
                        public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                            if (dataSourceId == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (path == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (type == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return this.build(path).toString();
                        }

                        @NotNull
                        private StringBuilder build(@Nullable ObjectPath path) {
                            StringBuilder res2 = new StringBuilder();
                            if (path != null) {
                                path.reduce(res2, (t, v) -> (t.length() == 0 ? t : t.append(".")).append(v.name));
                            }
                            StringBuilder stringBuilder = res2;
                            if (stringBuilder == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return stringBuilder;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 4: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 4: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "dataSourceId";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "path";
                                    break;
                                }
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "type";
                                    break;
                                }
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode$1";
                                    break;
                                }
                                case 4: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "build";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "processFolder";
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "processFile";
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 4: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    String string = res2 == null ? path.getPath() : res2;
                    if (string == null) {
                        MyChangesBrowserFilePathNode.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String result2 = FileUtil.getRelativePath((String)parent2.getPath(), (String)path.getPath(), (char)'/', (boolean)true);
                if (result2 == null) {
                    String string = path.getPath();
                    if (string == null) {
                        MyChangesBrowserFilePathNode.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                String string = StringUtil.join(DbSrcUtilsCore.splitPath(result2), (String)".");
                if (string == null) {
                    MyChangesBrowserFilePathNode.$$$reportNull$$$0(3);
                }
                return string;
            }

            public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
                Icon icon;
                if (renderer == null) {
                    MyChangesBrowserFilePathNode.$$$reportNull$$$0(4);
                }
                super.render(renderer, selected, expanded, hasFocus);
                FilePath path = (FilePath)ObjectUtils.tryCast((Object)this.userObject, FilePath.class);
                if (path != null && (icon = DbSrcUtils.getIcon(null, path.getPath())) != null) {
                    renderer.setIcon(icon);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$MyTreeModelBuilder$MyChangesBrowserFilePathNode";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRelativePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "render";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

