/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.backend.DbSrcZipFile;
import com.intellij.database.util.GuardedRef;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class DbSrcBackendZipWriter {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendZipWriter.class);
    public static volatile Consumer<String> ourCloseHook = null;
    private final String myPath;
    private final Runnable myOnClose;
    private final boolean myReadOnly;
    private volatile boolean myExists;
    private DbSrcZipFile myFileSession;
    private int myRefCount;

    public DbSrcBackendZipWriter(@NotNull String path, @NotNull Runnable onClose) {
        if (path == null) {
            DbSrcBackendZipWriter.$$$reportNull$$$0(0);
        }
        if (onClose == null) {
            DbSrcBackendZipWriter.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myOnClose = onClose;
        Path targetPath = FileSystems.getDefault().getPath(this.myPath, new String[0]);
        this.myExists = Files.isRegularFile(targetPath, new LinkOption[0]);
        this.myReadOnly = !Files.isWritable(this.myExists ? targetPath : targetPath.getParent());
    }

    public boolean isExists() {
        return this.myExists;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    synchronized void dropFile() throws IOException {
        if (!this.myExists) {
            return;
        }
        LOG.assertTrue(this.myRefCount == 0, (Object)"Ref count should be 0");
        LOG.assertTrue(this.myFileSession == null, (Object)"Session should be closed");
        Files.deleteIfExists(FileSystems.getDefault().getPath(this.myPath, new String[0]));
        this.myExists = false;
    }

    @NotNull
    public GuardedRef<DbSrcZipFile> openZip() throws IOException {
        return new GuardedRef<DbSrcZipFile>(this.acquire()){

            @Override
            protected void close(@NotNull DbSrcZipFile ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbSrcBackendZipWriter.this.release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipWriter$1", "close"));
            }
        };
    }

    @NotNull
    private synchronized DbSrcZipFile acquire() throws IOException {
        if (this.myFileSession == null) {
            File file = new File(this.myPath);
            this.myExists = true;
            this.myFileSession = new DbSrcZipFile(file);
        }
        ++this.myRefCount;
        DbSrcZipFile dbSrcZipFile = this.myFileSession;
        if (dbSrcZipFile == null) {
            DbSrcBackendZipWriter.$$$reportNull$$$0(2);
        }
        return dbSrcZipFile;
    }

    private synchronized void release() {
        --this.myRefCount;
        if (this.myRefCount == 0) {
            this.myOnClose.run();
        }
    }

    public synchronized boolean close() {
        LOG.assertTrue(this.myRefCount == 0, (Object)"Ref count should be 0");
        try {
            DbSrcZipFile session2 = this.myFileSession;
            this.myFileSession = null;
            if (session2 != null) {
                session2.close();
                Consumer<String> hook = ourCloseHook;
                if (hook != null) {
                    hook.consume((Object)this.myPath);
                }
                this.myExists = session2.fileExists();
                return true;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to close zip", (Throwable)e);
        }
        return false;
    }

    public synchronized boolean canClose() {
        return this.myRefCount == 0;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            DbSrcBackendZipWriter.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClose";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipWriter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "acquire";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

