/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.BridgeDataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridService;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.WeakHashMap;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataBusGridDataHookUp
extends GridDataHookUpBase<DataConsumer.Row, DataConsumer.Column>
implements DataRequest.OwnerEx,
TxMarkerAuditor.TxMarkerHolder {
    protected final DataAuditors.BusyCounter myBusyCounter;
    protected final DataGridListModel myModel;
    private final GridMutationModel myMutationModel;
    private final GridStorageAndModelUpdater myModelUpdater;
    protected final GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> myPageModel;
    protected final DataBusLoader myLoader;
    protected final MutationsStorage myStorage;
    protected final Map<DataRequest, GridRequestSource> myRequestSourceMap;
    private final BridgeDataBus myMessageBus;

    protected DataBusGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(1);
        }
        super(project);
        this.myRequestSourceMap = new WeakHashMap<DataRequest, GridRequestSource>();
        this.myMessageBus = new BridgeDataBus(this, messageBus.filterFor(this));
        this.myBusyCounter = new DataAuditors.BusyCounter();
        this.myMessageBus.addAuditor(this.myBusyCounter);
        this.myModel = new DataGridListModel((Function2<Object, Object, Boolean>)((Function2)this::valuesEqual));
        this.myMutationModel = new GridMutationModel(this);
        this.myStorage = this.createMutationStorage();
        this.myModelUpdater = new GridStorageAndModelUpdater(this.myModel, this.myMutationModel, this.myStorage);
        this.myPageModel = new GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column>(this.myMutationModel);
        this.myLoader = this.createLoader();
        this.myMessageBus.addAuditor(this.createAuditor());
        this.myMessageBus.addConsumer(DataGridService.getInstance().createEDTSafeWrapper(this.myLoader, this));
    }

    @Nullable
    protected MutationsStorage createMutationStorage() {
        return null;
    }

    private Boolean valuesEqual(Object v1, Object v2) {
        return DbImplUtilCore.valuesEqual(v1, v2, this.getDbms());
    }

    protected void setDataBus(@NotNull DataBus.Consuming bus) {
        if (bus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(2);
        }
        this.myMessageBus.setDataBus(bus);
    }

    @NotNull
    protected DataAuditor createAuditor() {
        return new BusAuditor();
    }

    @NotNull
    public DataGridListModel getDataModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(3);
        }
        return dataGridListModel;
    }

    @NotNull
    public GridMutationModel getMutationModel() {
        GridMutationModel gridMutationModel = this.myMutationModel;
        if (gridMutationModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(4);
        }
        return gridMutationModel;
    }

    @Override
    @NotNull
    public GridPagingModel<DataConsumer.Row, DataConsumer.Column> getPageModel() {
        GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> multiPage = this.myPageModel;
        if (multiPage == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(5);
        }
        return multiPage;
    }

    @NotNull
    public DataBusLoader getLoader() {
        DataBusLoader dataBusLoader = this.myLoader;
        if (dataBusLoader == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(6);
        }
        return dataBusLoader;
    }

    @Override
    public int getBusyCount() {
        return this.myBusyCounter.getCount();
    }

    @Override
    public void cancelRequests() {
        this.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(this));
    }

    @Override
    @NotNull
    public DataBus.Consuming getMessageBus() {
        BridgeDataBus bridgeDataBus = this.myMessageBus;
        if (bridgeDataBus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(7);
        }
        return bridgeDataBus;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = DataRequest.NONE;
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(8);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(9);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @Override
    @NlsSafe
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.notNullize((String)this.myLoader.getQueryText());
        if (string == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void dispose() {
    }

    public int getResultSetIndex() {
        return this.myLoader.getResultSetIndex();
    }

    @Nullable
    public String getQueryText() {
        return this.myLoader.getQueryText();
    }

    @Nullable
    public String getUnlimitedQueryText(boolean ordered) {
        return this.getQueryText();
    }

    @NotNull
    protected DataBusLoader createLoader() {
        return new DataBusLoader();
    }

    public void processRequest(@NotNull GridRequestSource source, @NotNull DataRequest request, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(11);
        }
        if (request == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(12);
        }
        this.myRequestSourceMap.put(request, source);
        request.getPromise().onProcessed(aVoid -> this.onProcessed(source, request, reloadPolicy));
        this.myMessageBus.getDataProducer().processRequest(request);
    }

    protected void onProcessed(@NotNull GridRequestSource source, @NotNull DataRequest request, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(13);
        }
        if (request == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(14);
        }
        boolean isSucceeded = request.getPromise().isSucceeded();
        if (reloadPolicy == ReloadPolicy.WHEN_PROCESSED || reloadPolicy == ReloadPolicy.WHEN_DONE && isSucceeded) {
            this.myLoader.reloadCurrentPage(source);
        } else {
            this.requestFinished(source, isSucceeded, reloadPolicy);
        }
    }

    protected void requestFinished(@NotNull GridRequestSource source, boolean isSucceeded, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(15);
        }
        this.notifyRequestFinished(source, isSucceeded);
    }

    @Nullable
    public DbDataSource getDataSource() {
        return null;
    }

    @Nullable
    public Dbms getDbms() {
        DbDataSource dataSource2 = this.getDataSource();
        if (dataSource2 == null) {
            return null;
        }
        return dataSource2.getDbms();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.getDbms());
        if (databaseDialectEx == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(16);
        }
        return databaseDialectEx;
    }

    protected int getPageSizeForRequest(@NotNull GridRequestSource source) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(17);
        }
        return this.myPageModel.getPageSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDataBus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onProcessed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "requestFinished";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPageSizeForRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class QueryAttributes {
        private final Integer limit;
        private final Integer offset;
        private final boolean ordered;

        private QueryAttributes(@Nullable Integer offset, @Nullable Integer limit, boolean ordered) {
            this.offset = offset;
            this.limit = limit;
            this.ordered = ordered;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        @NotNull
        public OptionalInt offset() {
            OptionalInt optionalInt = this.offset == null ? OptionalInt.empty() : OptionalInt.of(this.offset);
            if (optionalInt == null) {
                QueryAttributes.$$$reportNull$$$0(0);
            }
            return optionalInt;
        }

        @NotNull
        public OptionalInt limit() {
            OptionalInt optionalInt = this.limit == null ? OptionalInt.empty() : OptionalInt.of(this.limit);
            if (optionalInt == null) {
                QueryAttributes.$$$reportNull$$$0(1);
            }
            return optionalInt;
        }

        @NotNull
        public static QueryAttributes unlimited(boolean ordered) {
            return new QueryAttributes(null, null, ordered);
        }

        @NotNull
        public static QueryAttributes limited(int offset, int limit, boolean order) {
            return new QueryAttributes(offset, limit, order);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp$QueryAttributes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "offset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "limit";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected class BusAuditor
    extends DataAuditors.Adapter {
        protected BusAuditor() {
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(0);
            }
            GridRequestSource source = DataBusGridDataHookUp.this.myRequestSourceMap.get((Object)context.request);
            List fixes = (List)DatabaseErrorHandler.FIXES.get((UserDataHolder)context);
            if (source != null) {
                DataBusGridDataHookUp.this.notifyRequestError(source, message2, fixes, th);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
            GridRequestSource source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(1);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get((Object)context.request)) != null) {
                DataBusGridDataHookUp.this.notifyUpdateCountReceived(source, updateCount2);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, @NotNull DataAuditor.TxEvent event) {
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(2);
            }
            if (event == null) {
                BusAuditor.$$$reportNull$$$0(3);
            }
            if (!event.reverted || !this.reloadOnRollback()) {
                return;
            }
            int offset = DataBusGridDataHookUp.this.myPageModel.getPageStart() - 1;
            int pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize();
            DataBusGridDataHookUp.this.myLoader.updateQueryText(DbImplUtilCore.isPageSizeUnlimited(pageSize) ? QueryAttributes.unlimited(true) : QueryAttributes.limited(0, offset + pageSize + 1, true), null);
            String query = Objects.requireNonNull(DataBusGridDataHookUp.this.myLoader.getQueryText());
            int resultSetIdx = DataBusGridDataHookUp.this.myLoader.getResultSetIndex();
            DataRequest.Constraints constraints = DataRequest.newConstraints(offset, pageSize, 0, resultSetIdx);
            DataRequest request = DataRequest.newRequest(DataBusGridDataHookUp.this, DataRequest.AUTO_COMMIT, query, constraints);
            request.getPromise().onProcessed(aVoid -> DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW));
            DataBusGridDataHookUp.this.myMessageBus.getDataProducer().processRequest(request);
        }

        protected boolean reloadOnRollback() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$BusAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ReloadPolicy {
        WHEN_DONE,
        WHEN_PROCESSED,
        DO_NOT_RELOAD;

    }

    public class DataBusLoader
    implements DataConsumer,
    GridLoader<DataConsumer.Row, DataConsumer.Column> {
        private String myQueryText;
        private boolean myQueryInvalidated;
        private boolean myTotalRowCountInvalidated;
        private int myResultSetIndex;
        private int myRowsLoaded = -1;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
            boolean sameQuery;
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(1);
            }
            if (!(sameQuery = Objects.equals(this.myQueryText, context.getQuery())) || this.myTotalRowCountInvalidated) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(0L, false);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageStart(firstRowNum);
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(firstRowNum - 1);
            this.myRowsLoaded = 0;
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(true);
            this.myResultSetIndex = resultSetIndex;
            this.setQueryText(context.getQuery());
            DataBusGridDataHookUp.this.setCurrentTx(context.txMarker);
            columns = this.prepareColumns(columns);
            boolean sameColumns = this.sameColumnsAsInModel(columns);
            if (!sameQuery || !sameColumns) {
                DataBusGridDataHookUp.this.myModelUpdater.removeRows(0, DataBusGridDataHookUp.this.myMutationModel.getRowCount());
                DataBusGridDataHookUp.this.myModelUpdater.setColumns(Arrays.asList(columns));
            } else if (DataBusGridDataHookUp.this.myStorage != null) {
                DataBusGridDataHookUp.this.myStorage.clearColumns();
            }
            this.validateRowCount();
        }

        @Override
        public void updateColumns(@NotNull DataRequest.Context context, DataConsumer.Column @NotNull [] columns) {
            boolean sameColumns;
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(2);
            }
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(3);
            }
            if (!(sameColumns = this.sameColumnsAsInModel(columns = this.prepareColumns(columns)))) {
                DataBusGridDataHookUp.this.myModelUpdater.setColumns(Arrays.asList(columns));
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(4);
            }
            if (rows.isEmpty()) {
                return;
            }
            if (this.myRowsLoaded == 0) {
                DataBusGridDataHookUp.this.myPageModel.setPageStart(rows.get(0).getRowNum());
            }
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(rows.get(rows.size() - 1).getRowNum());
            DataBusGridDataHookUp.this.myModelUpdater.setRows(this.myRowsLoaded, rows);
            this.myRowsLoaded += rows.size();
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(5);
            }
            if (this.myRowsLoaded >= 0 && this.myRowsLoaded < DataBusGridDataHookUp.this.myMutationModel.getRowCount()) {
                int rowsToRemove = DataBusGridDataHookUp.this.myMutationModel.getRowCount() - this.myRowsLoaded;
                DataBusGridDataHookUp.this.myModelUpdater.removeRows(DataBusGridDataHookUp.this.myMutationModel.getRowCount() - rowsToRemove, rowsToRemove);
            }
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(false);
            this.setTotalRowCount(DataBusGridDataHookUp.this.myRequestSourceMap.get((Object)context.request), total);
            DataBusGridDataHookUp.this.myMutationModel.afterLastRowAdded();
        }

        protected void setTotalRowCount(@Nullable GridRequestSource source, int total) {
            if ((long)total > DataBusGridDataHookUp.this.myPageModel.getTotalRowCount() || DataBusGridDataHookUp.this.myPageModel.getPageEnd() == total) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(total, DataBusGridDataHookUp.this.myPageModel.getPageEnd() >= total);
            }
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(6);
            }
            this.reloadCurrentPage(source, null);
        }

        public void reloadCurrentPage(@NotNull GridRequestSource source, @Nullable ReloadPolicy reloadPolicy) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(7);
            }
            this.load(source, this.getCurrentPageOffset(), reloadPolicy);
        }

        private int getCurrentPageOffset() {
            return Math.max(0, DataBusGridDataHookUp.this.myPageModel.getPageStart() - 1);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(8);
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageEnd());
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(9);
            }
            this.load(source, Math.max(0, DataBusGridDataHookUp.this.myPageModel.getPageStart() - DataBusGridDataHookUp.this.myPageModel.getPageSize() - 1));
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource source) {
            int pageSize;
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(10);
            }
            this.load(source, -((pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize()) > 0 ? pageSize : 100) - 1);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(11);
            }
            this.load(source, 0);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(12);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilterAndSorting(@NotNull GridRequestSource source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(13);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Nullable
        public String getQueryText() {
            return this.myQueryText;
        }

        public int getResultSetIndex() {
            return this.myResultSetIndex;
        }

        public void invalidateQuery() {
            this.myQueryInvalidated = true;
        }

        @Override
        public void load(@NotNull GridRequestSource source, int offset) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(14);
            }
            this.load(source, offset, null);
        }

        protected void load(@NotNull GridRequestSource source, int offset, @Nullable ReloadPolicy reloadPolicy) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(15);
            }
            this.tryApplyCurrentFilterText();
            this.tryApplyCurrentSorting();
            int queryOffset = this.updateQueryText(offset, source);
            if (this.myQueryText == null) {
                DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DataBusGridDataHookUp owner = DataBusGridDataHookUp.this;
            int resultOffset = queryOffset == 0 ? offset : 0;
            int pageSize = DataBusGridDataHookUp.this.getPageSizeForRequest(source);
            DataRequest r = DataRequest.newRequest(owner, this.myQueryText, resultOffset, queryOffset, pageSize, this.myResultSetIndex);
            DataBusGridDataHookUp.this.processRequest(source, r, reloadPolicy != null ? reloadPolicy : ReloadPolicy.DO_NOT_RELOAD);
        }

        private int updateQueryText(int offset, @Nullable GridRequestSource source) {
            if (!this.canUpdateQueryText()) {
                return 0;
            }
            boolean unlimited = DbImplUtilCore.isPageSizeUnlimited(DataBusGridDataHookUp.this.myPageModel.getPageSize());
            if (unlimited) {
                this.updateQueryText(QueryAttributes.unlimited(true), source);
                return 0;
            }
            if (DbImplUtil.supportsOffset(DataBusGridDataHookUp.this.getDbms()) && Registry.is((String)"database.grid.paging.offset")) {
                this.updateQueryText(QueryAttributes.limited(offset, DataBusGridDataHookUp.this.myPageModel.getPageSize() + 1, true), source);
                return offset;
            }
            this.updateQueryText(QueryAttributes.limited(0, offset + DataBusGridDataHookUp.this.myPageModel.getPageSize() + 1, true), source);
            return 0;
        }

        public void updateQueryText() {
            this.updateQueryText(this.getCurrentPageOffset(), null);
        }

        private void tryApplyCurrentFilterText() {
            GridFilteringModel model = DataBusGridDataHookUp.this.getFilteringModel();
            if (model == null) {
                return;
            }
            if (!model.isIgnoreCurrentText()) {
                model.applyCurrentText();
            } else {
                model.setIgnoreCurrentText(false);
            }
        }

        private void tryApplyCurrentSorting() {
            GridSortingModel model = DataBusGridDataHookUp.this.getSortingModel();
            if (model == null) {
                return;
            }
            model.apply();
        }

        protected boolean canUpdateQueryText() {
            return false;
        }

        protected final void updateQueryText(@NotNull QueryAttributes attributes2, @Nullable GridRequestSource source) {
            if (attributes2 == null) {
                DataBusLoader.$$$reportNull$$$0(16);
            }
            if (this.canUpdateQueryText()) {
                this.setQueryText(this.createQueryText(attributes2, source));
                this.queryTextUpdated();
            }
        }

        protected void queryTextUpdated() {
        }

        @Nullable
        protected String createQueryText(@NotNull QueryAttributes attributes2, @Nullable GridRequestSource source) {
            if (attributes2 == null) {
                DataBusLoader.$$$reportNull$$$0(17);
            }
            return null;
        }

        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                DataBusLoader.$$$reportNull$$$0(18);
            }
            return columns;
        }

        protected void setQueryText(String query) {
            this.myQueryText = query;
            this.validateQuery();
        }

        protected void invalidateRowCount() {
            this.myTotalRowCountInvalidated = true;
        }

        protected boolean isQueryInvalidated() {
            return this.myQueryInvalidated;
        }

        protected boolean sameColumnsAsInModel(DataConsumer.Column[] columns) {
            if (columns.length != DataBusGridDataHookUp.this.myMutationModel.getColumnCount()) {
                return false;
            }
            for (int i2 = 0; i2 < columns.length; ++i2) {
                if (Comparing.equal((Object)columns[i2], (Object)DataBusGridDataHookUp.this.myMutationModel.getColumn((ModelIndex)ModelIndex.forColumn(DataBusGridDataHookUp.this.myMutationModel, i2)))) continue;
                return false;
            }
            return true;
        }

        private void validateQuery() {
            this.myQueryInvalidated = false;
        }

        private void validateRowCount() {
            this.myTotalRowCountInvalidated = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColumns";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reloadCurrentPage";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadNextPage";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadPreviousPage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadLastPage";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFirstPage";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateTotalRowCount";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilterAndSorting";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateQueryText";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createQueryText";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareColumns";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

