/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutator;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.TypesMutationsStorage;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnMutation;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.DatabaseMutation;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.AddColumnAction;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMutatorImpl
implements DatabaseMutator {
    private final GridListModelBase<DataConsumer.Row, DataConsumer.Column> myModel;
    private final GridMutationModel myMutationModel;
    private final DatabaseGridDataHookUp myHookUp;
    private final MutationsStorage myStorage;
    private boolean myFailed;

    public DatabaseMutatorImpl(@NotNull GridListModelBase<DataConsumer.Row, DataConsumer.Column> model, @NotNull GridMutationModel mutationModel, @NotNull DatabaseGridDataHookUp hookUp, @NotNull MutationsStorage storage) {
        if (model == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(0);
        }
        if (mutationModel == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(1);
        }
        if (hookUp == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(3);
        }
        this.myModel = model;
        this.myMutationModel = mutationModel;
        this.myHookUp = hookUp;
        this.myStorage = storage;
        this.myHookUp.addRequestListener(new MyRequestListener(), this.myHookUp);
    }

    @Override
    public void mutate(@NotNull GridRequestSource source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue2, boolean allowImmediateUpdate) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(4);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(6);
        }
        this.mutate(source, DataGridUtil.createMutations(rows, columns, newValue2), allowImmediateUpdate);
    }

    @Override
    public void mutate(@NotNull GridRequestSource source, @NotNull List<CellMutation> mutations, boolean allowImmediateUpdate) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(7);
        }
        if (mutations == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(8);
        }
        boolean hasInsertedRows = false;
        boolean hasNotInsertedRows = false;
        for (CellMutation mutation : mutations) {
            boolean shouldSkip;
            ModelIndex<DataConsumer.Column> columnIdx;
            Object value2 = mutation.getValue();
            ModelIndex<DataConsumer.Row> rowIdx = mutation.getRow();
            MutationData oldMutation = this.myStorage.get(rowIdx, columnIdx = mutation.getColumn());
            boolean bl = shouldSkip = oldMutation == null && this.myModel.allValuesEqualTo(Collections.singletonList(mutation)) || oldMutation != null && DbImplUtilCore.valuesEqual(oldMutation.getValue(), value2, this.myHookUp.getDbms());
            if (shouldSkip) continue;
            boolean isInserted = this.isInsertedRow(rowIdx);
            hasInsertedRows |= isInserted;
            hasNotInsertedRows |= !isInserted;
            boolean valuesEqual = !rowIdx.isValid(this.myModel) || !columnIdx.isValid(this.myModel) ? mutation.getValue() == ReservedCellValue.UNSET && this.getType(rowIdx, columnIdx) == null : DbImplUtilCore.valuesEqual(mutation.getValue(), this.myModel.getValueAt((DataConsumer.Row)((Object)rowIdx), (DataConsumer.Column)((Object)columnIdx)), this.myHookUp.getDbms());
            CellMutation newValue2 = valuesEqual ? null : mutation;
            this.myStorage.set(rowIdx, columnIdx, newValue2);
            this.myStorage.removeColumnFromDeleted(columnIdx);
            this.myStorage.removeRowFromDeleted(rowIdx);
            this.myMutationModel.notifyCellsUpdated(ModelIndexSet.forRows(this.myModel, rowIdx), ModelIndexSet.forColumns(this.myModel, columnIdx), source.place);
        }
        this.myFailed = false;
        if (allowImmediateUpdate && this.isUpdateImmediately() && this.hasPendingChanges() && !this.hasUnparsedValues()) {
            this.submit(source, hasInsertedRows && hasNotInsertedRows && this.isUpdateImmediately());
            return;
        }
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void setType(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Domain domain) {
        TypesMutationsStorage storage;
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(10);
        }
        if ((storage = this.myStorage.getTypesMutationsStorage()) != null) {
            storage.setType(row, column2, domain);
        }
    }

    @Override
    @Nullable
    public Domain getType(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        TypesMutationsStorage storage;
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(12);
        }
        return (storage = this.myStorage.getTypesMutationsStorage()) != null ? storage.getType(row, column2) : null;
    }

    @Override
    public void revert(@NotNull GridRequestSource source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(13);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(14);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(15);
        }
        JBIterable<ModelIndex<DataConsumer.Row>> sorted = DatabaseMutatorImpl.sorted(rows);
        List modifiedRows = sorted.filter(idx -> !this.myStorage.isInsertedRow((ModelIndex<DataConsumer.Row>)idx) && this.myStorage.isModified((ModelIndex<DataConsumer.Row>)idx)).toList();
        List modifiedColumns = DatabaseMutatorImpl.sorted(columns).filter(idx -> !this.isDeletedColumn((ModelIndex<DataConsumer.Column>)idx)).toList();
        modifiedRows.forEach(rowIdx -> modifiedColumns.forEach(colIdx -> this.revert((ModelIndex<DataConsumer.Row>)rowIdx, (ModelIndex<DataConsumer.Column>)colIdx)));
        this.myMutationModel.notifyCellsUpdated(ModelIndexSet.forRows(this.myModel, modifiedRows), ModelIndexSet.forColumns(this.myModel, modifiedColumns), source.place);
        List deletedRows = sorted.filter(this::isDeletedRow).toList();
        deletedRows.forEach(this.myStorage::removeRowFromDeleted);
        this.myMutationModel.notifyCellsUpdated(ModelIndexSet.forRows(this.myModel, deletedRows), this.myMutationModel.getColumnIndices(), source.place);
        List deletedColumns = DatabaseMutatorImpl.sorted(columns).filter(this::isDeletedColumn).toList();
        deletedColumns.forEach(this.myStorage::removeColumnFromDeleted);
        this.myMutationModel.notifyCellsUpdated(this.myMutationModel.getRowIndices(), ModelIndexSet.forColumns(this.myModel, deletedColumns), source.place);
        this.doDeleteRows(ModelIndexSet.forRows(this.myModel, sorted.filter(this::isInsertedRow)));
        this.doDeleteColumns(ModelIndexSet.forColumns(this.myModel, columns.asIterable().filter(this::isInsertedColumn)));
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, true);
    }

    private void revert(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> colIdx) {
        if (rowIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(16);
        }
        if (colIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(17);
        }
        this.myStorage.set(rowIdx, colIdx, null);
    }

    @Override
    public boolean isUpdateSafe(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue2) {
        if (rowIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(18);
        }
        if (columnIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(19);
        }
        if (!this.hasPendingChanges() || !this.isUpdateImmediately() || this.hasDifferentRowTypes(rowIndices)) {
            return true;
        }
        List<ModelIndex<DataConsumer.Row>> rows = this.getRowsInDatabaseDataModel(rowIndices);
        ModelIndex first2 = (ModelIndex)JBIterable.from(rows).filter(Conditions.notNull()).first();
        return first2 == null || this.myModel.allValuesEqualTo(rowIndices, columnIndices, newValue2);
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(20);
        }
        return this.myStorage.isInsertedRow(row);
    }

    @Override
    public boolean isInsertedColumn(@NotNull ModelIndex<DataConsumer.Column> idx) {
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(21);
        }
        return this.myStorage.isInsertedColumn(idx);
    }

    @Override
    public boolean isDeletedColumn(@NotNull ModelIndex<DataConsumer.Column> idx) {
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(22);
        }
        return this.myStorage.isDeletedColumn(idx);
    }

    @Override
    @Nullable
    public DataConsumer.Column getInsertedColumn(@NotNull ModelIndex<DataConsumer.Column> idx) {
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(23);
        }
        return this.myStorage.getInsertedColumn(idx);
    }

    @Override
    public int getInsertedRowsCount() {
        return this.myStorage.getInsertedRowsCount();
    }

    @Override
    public int getInsertedColumnsCount() {
        return this.myStorage.getInsertedColumnsCount();
    }

    @Override
    @Nullable
    public MutationData getMutation(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(24);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(25);
        }
        return this.myStorage.get(row, column2);
    }

    @Override
    @Nullable
    public MutationType getMutationType(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(26);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(27);
        }
        if (this.isDeletedRow(row) || this.isDeletedColumn(column2)) {
            return MutationType.DELETE;
        }
        if (this.isInsertedRow(row) || this.isInsertedColumn(column2)) {
            return MutationType.INSERT;
        }
        return this.getMutation(row, column2) == null ? null : MutationType.MODIFY;
    }

    @Override
    public boolean isUpdateImmediately() {
        return DatabaseSettings.getSettings().isSubmitImmediately();
    }

    @Override
    public boolean hasPendingChanges() {
        return this.myStorage.hasChanges();
    }

    @Override
    public boolean hasUnparsedValues() {
        return this.myStorage.hasUnparsedValues();
    }

    @Override
    public void deleteRows(@NotNull GridRequestSource source, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(28);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(29);
        }
        this.deleteRowsOrColumns(source, rows, this::doDeleteRows);
    }

    @Override
    public void insertRow(@NotNull GridRequestSource source) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(30);
        }
        if (!this.isReadOnly()) {
            this.doInsertRow(this.createRow(null));
        }
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void cloneRow(@NotNull GridRequestSource source, @NotNull ModelIndex<DataConsumer.Row> toClone) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(31);
        }
        if (toClone == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(32);
        }
        if (this.isReadOnly() || !this.isValidRowIdx(toClone)) {
            this.notifyRequestFinished(source, false);
            return;
        }
        DataConsumer.Row newRow = this.createRow(toClone);
        this.doInsertRow(newRow);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public boolean isFailed() {
        return this.myFailed;
    }

    @NotNull
    protected DataConsumer.Row createRow(@Nullable ModelIndex<DataConsumer.Row> templateIdx) {
        Object[] newRow = new Object[this.myMutationModel.getColumnCount()];
        THashMap nameToDasColumn = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        DasTable dasTable = this.myHookUp.getDatabaseTable();
        if (dasTable != null) {
            for (DasColumn dasColumn : DasUtil.getColumns(dasTable)) {
                nameToDasColumn.put(dasColumn.getName(), dasColumn);
            }
        }
        for (ModelIndex columnIdx : this.myMutationModel.getColumnIndices().asIterable()) {
            Object existing;
            MutationData mutation;
            DataConsumer.Column column2 = (DataConsumer.Column)Objects.requireNonNull(this.myMutationModel.getColumn(columnIdx));
            DasColumn dasColumn = (DasColumn)nameToDasColumn.get(column2.name);
            MutationData mutationData = mutation = templateIdx == null ? null : this.getMutation(templateIdx, columnIdx);
            Object object = mutation != null ? mutation.getValue() : (existing = templateIdx != null ? this.myMutationModel.getValueAt(templateIdx, columnIdx) : null);
            ReservedCellValue value2 = DbImplUtilCore.isRowId(column2) ? ReservedCellValue.COMPUTED : (templateIdx != null && !DasUtil.isPrimary(dasColumn) ? existing : DataGridUtil.getDefaultNullValue(dasColumn, this.myHookUp.getDbms()));
            newRow[columnIdx.asInteger()] = value2;
        }
        DataConsumer.Row row = DataConsumer.Row.create(this.myHookUp.getPageModel().getPageEnd() + this.myStorage.getInsertedRowsCount(), newRow);
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(33);
        }
        return row;
    }

    @Override
    @Nullable
    public ModelIndex<DataConsumer.Row> getLastInsertedRow() {
        return this.myStorage.getLastInsertedRow();
    }

    @Override
    public boolean isDeletedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(34);
        }
        return this.myStorage.isDeletedRow(row);
    }

    @Override
    public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(35);
        }
        return this.myStorage.isDeletedRows(rows);
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getAffectedRows() {
        HashSet affectedRows = new HashSet();
        affectedRows.addAll(this.myStorage.getModifiedRows());
        affectedRows.addAll(this.myStorage.getDeletedRows().toList());
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myModel, affectedRows);
        if (modelIndexSet == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(36);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public JBIterable<ModelIndex<DataConsumer.Row>> getInsertedRows() {
        JBIterable<ModelIndex<DataConsumer.Row>> jBIterable = this.myStorage.getInsertedRows();
        if (jBIterable == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(37);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<ModelIndex<DataConsumer.Column>> getInsertedColumns() {
        JBIterable<ModelIndex<DataConsumer.Column>> jBIterable = this.myStorage.getInsertedColumns();
        if (jBIterable == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(38);
        }
        return jBIterable;
    }

    @Override
    public void submit(@NotNull GridRequestSource source, boolean includeInserted) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(39);
        }
        DasTable table = this.getDatabaseTable();
        if (this.isReadOnly() || table == null) {
            this.notifyRequestFinished(source, false);
            return;
        }
        if (!(this.myStorage.getDeletedRowsCount() != 0 || this.myStorage.getModifiedRowsCount() != 0 || this.myStorage.getDeletedColumnsCount() != 0 || this.myStorage.getInsertedRowsCount() != 0 && includeInserted)) {
            this.notifyUpdateCountReceived(source, this.myStorage.getInsertedRowsCount());
            this.notifyRequestFinished(source, true);
            return;
        }
        PendingContexts contexts = this.generatePendingContexts(includeInserted);
        List<DataRequest.DmlRequest> requests = new ArrayList<DataRequest.DmlRequest>();
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newDeleteRequest), contexts.delete));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newUpdateRequest), contexts.update));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newInsertRequest), contexts.insert));
        requests = ContainerUtil.filter(requests, Objects::nonNull);
        if (!requests.isEmpty()) {
            DataRequest request = DataRequest.newCompositeRequest(this.myHookUp, requests);
            this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.WHEN_DONE);
            return;
        }
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, true);
    }

    @Override
    @NotNull
    public String getPendingChanges() {
        PendingContexts contexts = this.generatePendingContexts(true);
        ArrayList<JdbcEngine.StatementPrinter.StatementRecipe> recipes = new ArrayList<JdbcEngine.StatementPrinter.StatementRecipe>();
        if (contexts.delete != null) {
            recipes.add(new JdbcEngine.StatementPrinter.StatementRecipe(QueryData.Operation.DELETE, contexts.delete));
        }
        if (contexts.update != null) {
            recipes.add(new JdbcEngine.StatementPrinter.StatementRecipe(QueryData.Operation.UPDATE, contexts.update));
        }
        if (contexts.insert != null) {
            recipes.add(new JdbcEngine.StatementPrinter.StatementRecipe(QueryData.Operation.INSERT, contexts.insert));
        }
        String string = new JdbcEngine.StatementPrinter(recipes).printAll(this.myHookUp.getDbms());
        if (string == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Override
    public void pageReloaded() {
        this.myFailed = false;
    }

    @Override
    public boolean hasMutatedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(41);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(42);
        }
        for (ModelIndex row : rows.asIterable()) {
            for (ModelIndex column2 : columns.asIterable()) {
                MutationData mutation = this.myStorage.get(row, column2);
                if (mutation == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public MutationType getMutationType(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(43);
        }
        return !this.isValidRowIdx(row) ? null : (this.isInsertedRow(row) ? MutationType.INSERT : (this.isDeletedRow(row) ? MutationType.DELETE : (this.myStorage.isModified(row) ? MutationType.MODIFY : null)));
    }

    private boolean isValidRowIdx(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(44);
        }
        return this.myModel.isValidRowIdx(row) || this.isInsertedRow(row);
    }

    private boolean isValidColumnIdx(@NotNull ModelIndex<DataConsumer.Column> column2) {
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(45);
        }
        return this.myModel.isValidColumnIdx(column2) || this.isInsertedColumn(column2);
    }

    @Override
    public boolean hasUnparsedValues(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(46);
        }
        return this.isValidRowIdx(row) && this.myStorage.hasUnparsedValues(row);
    }

    @NotNull
    protected List<ModelIndex<DataConsumer.Row>> getRowsInDatabaseDataModel(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(47);
        }
        List list = rows.asIterable().map(row -> this.isValidRowIdx((ModelIndex<DataConsumer.Row>)row) && this.isInsertedRow((ModelIndex<DataConsumer.Row>)row) ? null : row).toList();
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(48);
        }
        return list;
    }

    protected void processRequest(@NotNull GridRequestSource source, @NotNull DataRequest request, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(49);
        }
        if (request == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(50);
        }
        this.myHookUp.processRequest(source, request, reloadPolicy);
    }

    @NotNull
    protected List<DataConsumer.Column> getPhysicalColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnIndices) {
        if (columnIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(51);
        }
        List list = columnIndices.asIterable().filterMap(columnIndex -> {
            DataConsumer.Column column2 = this.myModel.getColumn((ModelIndex<DataConsumer.Column>)columnIndex);
            return column2 != null && DbImplUtilCore.isRowId(column2) ? null : column2;
        }).toList();
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(52);
        }
        return list;
    }

    @Override
    public void deleteColumns(@NotNull GridRequestSource source, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(53);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(54);
        }
        this.deleteRowsOrColumns(source, columns, this::doDeleteColumns);
    }

    private <T> void deleteRowsOrColumns(GridRequestSource source, ModelIndexSet<T> objects2, Function<ModelIndexSet<T>, Boolean> delete) {
        if (this.isReadOnly() || !((Boolean)delete.fun(objects2)).booleanValue()) {
            source.setMutatedDataLocally(true);
            this.notifyRequestFinished(source, !this.isReadOnly() && this.getDatabaseTable() != null);
            return;
        }
        if (this.isUpdateImmediately()) {
            this.submit(source, false);
            return;
        }
        source.setMutatedDataLocally(true);
        this.notifyRequestFinished(source, true);
    }

    private boolean doDeleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(55);
        }
        this.myFailed = false;
        return this.doDeleteRowsOrColumns(columns, this::isValidColumnIdx, this::isInsertedColumn, this.myStorage::deleteColumn, row -> this.myMutationModel.notifyColumnsRemoved(ModelIndexSet.forColumns(this.myModel, row)));
    }

    @Override
    public void insertColumn(@NotNull GridRequestSource source, @Nullable String name) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(56);
        }
        if (!this.isReadOnly()) {
            this.doInsertColumn(name);
        }
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    private void doInsertColumn(@Nullable String name) {
        this.myFailed = false;
        int newColumnIdx = this.myMutationModel.getColumnCount();
        ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, newColumnIdx);
        String columnName = name != null ? name : AddColumnAction.generateColumnName(this.myMutationModel);
        String columnType = DatabaseMutatorImpl.getStringTypeName(this.myHookUp.getDbms(), this.myHookUp.getDataSource().getVersion());
        DataConsumer.Column column2 = new DataConsumer.Column(columnIdx.asInteger(), columnName, 12, (String)ObjectUtils.notNull((Object)columnType, (Object)"unknown"), "");
        this.myStorage.insertColumn(columnIdx, column2);
        this.myMutationModel.notifyColumnsAdded(ModelIndexSet.forColumns(this.myModel, columnIdx));
    }

    @Override
    public void renameColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<DataConsumer.Column> idx, @NotNull String newName) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(57);
        }
        if (idx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(58);
        }
        if (newName == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(59);
        }
        this.myStorage.renameColumn(idx, newName);
    }

    @Nullable
    private static String getStringTypeName(@NotNull Dbms dbms, @Nullable Version version) {
        DomainRegistry registry;
        if (dbms == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(60);
        }
        if ((registry = BaseDomainRegistry.get(dbms, version)) == null) {
            return null;
        }
        Domain textDomain = (Domain)ContainerUtil.find(registry.getDomains(), domain -> LogicalType.isText(domain.getLogicType()));
        return textDomain == null ? null : textDomain.simpleName();
    }

    @Override
    public void cloneColumn(@NotNull GridRequestSource source, @NotNull ModelIndex<DataConsumer.Column> toClone) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(61);
        }
        if (toClone == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(62);
        }
    }

    @NotNull
    private static <T> JBIterable<ModelIndex<T>> sorted(@NotNull ModelIndexSet<T> objects2) {
        if (objects2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(63);
        }
        JBIterable jBIterable = objects2.asIterable().sort(Comparator.comparingInt(Index::asInteger));
        if (jBIterable == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(64);
        }
        return jBIterable;
    }

    private boolean doDeleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(65);
        }
        this.myFailed = false;
        return this.doDeleteRowsOrColumns(rows, this::isValidRowIdx, this::isInsertedRow, this.myStorage::deleteRow, row -> this.myMutationModel.notifyRowsRemoved(ModelIndexSet.forRows(this.myModel, row)));
    }

    private <T> boolean doDeleteRowsOrColumns(@NotNull ModelIndexSet<T> indexes, @NotNull Function<ModelIndex<T>, Boolean> isValid, @NotNull Function<ModelIndex<T>, Boolean> isInserted, @NotNull Consumer<ModelIndex<T>> deleteInStorage, @NotNull Consumer<ModelIndex<T>> notifyRemoved) {
        if (indexes == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(66);
        }
        if (isValid == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(67);
        }
        if (isInserted == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(68);
        }
        if (deleteInStorage == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(69);
        }
        if (notifyRemoved == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(70);
        }
        boolean databaseDataModified = false;
        JBIterable<ModelIndex<T>> sorted = DatabaseMutatorImpl.sorted(indexes);
        for (int i2 = sorted.size() - 1; i2 >= 0; --i2) {
            ModelIndex idx = (ModelIndex)sorted.get(i2);
            if (!((Boolean)isValid.fun((Object)Objects.requireNonNull(idx))).booleanValue()) continue;
            boolean inserted = (Boolean)isInserted.fun((Object)idx);
            databaseDataModified |= !inserted;
            deleteInStorage.accept(idx);
            if (!inserted) continue;
            notifyRemoved.accept(idx);
        }
        return databaseDataModified && this.getDatabaseTable() != null;
    }

    @NotNull
    private PendingContexts generatePendingContexts(boolean includeInserted) {
        DmlMutationContext insert = includeInserted ? this.createInsertContext() : null;
        DmlMutationContext update2 = this.createUpdateContext();
        DmlMutationContext delete = this.createDeleteContext();
        return new PendingContexts(insert, update2, delete);
    }

    @Nullable
    private DmlMutationContext createInsertContext() {
        ArrayList<DatabaseMutation> rowMutations = new ArrayList<DatabaseMutation>();
        for (ModelIndex rowIdx : this.myStorage.getInsertedRows()) {
            Object[] values2 = new Object[this.myModel.getColumnCount()];
            for (ModelIndex columnIdx : this.myModel.getColumnIndices().asIterable()) {
                MutationData data = this.myStorage.get(rowIdx, columnIdx);
                values2[columnIdx.asInteger()] = data == null ? null : data.getValue();
            }
            DataConsumer.Row row = DataConsumer.Row.create(rowIdx.asInteger(), values2);
            List<ColumnQueryData> infos = this.createUpdateData(rowIdx);
            rowMutations.add(new RowMutation(row, infos));
        }
        return this.asContext(rowMutations);
    }

    @Nullable
    private DmlMutationContext createDeleteContext() {
        List mutations = this.myStorage.getDeletedRows().map(this.myModel::getRow).filter(Objects::nonNull).map(row -> new RowMutation((DataConsumer.Row)row, DatabaseMutatorImpl.createColumnsUpdateData(row, this.myModel.getColumns()))).append((Iterable)this.myStorage.getDeletedColumns().map(column2 -> new ColumnMutation(this.myModel.getColumn((ModelIndex<DataConsumer.Column>)column2)))).toList();
        return this.asContext(mutations);
    }

    @Nullable
    private DmlMutationContext createUpdateContext() {
        ArrayList<DatabaseMutation> rowMutations = new ArrayList<DatabaseMutation>();
        for (ModelIndex<DataConsumer.Row> rowIdx : this.myStorage.getModifiedRows()) {
            DataConsumer.Row row;
            if (this.isInsertedRow(rowIdx) || !this.myStorage.isModified(rowIdx) || !this.isValidRowIdx(rowIdx) || (row = this.myModel.getRow(rowIdx)) == null) continue;
            List<ColumnQueryData> infos = this.createUpdateData(rowIdx);
            rowMutations.add(new RowMutation(row, infos));
        }
        return this.asContext(rowMutations);
    }

    @Nullable
    private DmlMutationContext asContext(@NotNull List<DatabaseMutation> mutations) {
        if (mutations == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(71);
        }
        if (mutations.isEmpty() || this.getDatabaseTable() == null) {
            return null;
        }
        ArrayList<DatabaseMutation> sorted = new ArrayList<DatabaseMutation>(mutations);
        ContainerUtil.sort(sorted);
        return new DmlMutationContext(sorted, this.myModel.getColumns(), this.getDatabaseTable());
    }

    @NotNull
    private List<ColumnQueryData> createUpdateData(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(72);
        }
        ArrayList<ColumnQueryData> infos = new ArrayList<ColumnQueryData>();
        int columnCount = this.myMutationModel.getColumnCount();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            Object column2;
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, i2);
            MutationData mutation = this.myStorage.get(row, columnIdx);
            if (mutation == null || !this.isValidColumnIdx(columnIdx) || (column2 = this.myMutationModel.getColumn((ModelIndex)columnIdx)) == null) continue;
            infos.add(new ColumnQueryData((DataConsumer.Column)column2, mutation.getValue()));
        }
        ArrayList<ColumnQueryData> arrayList = infos;
        if (arrayList == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    private void doInsertRow(@NotNull DataConsumer.Row newRow) {
        if (newRow == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(74);
        }
        this.myFailed = false;
        int newRowIdx = this.myMutationModel.getRowCount();
        ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(this.myModel, newRowIdx);
        this.myStorage.insertRow(rowIdx);
        List<DataConsumer.Column> columns = this.getPhysicalColumns(this.myModel.getColumnIndices());
        for (DataConsumer.Column column2 : columns) {
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, column2.columnNum);
            CellMutation mutation = new CellMutation(rowIdx, columnIdx, column2.getValue(newRow));
            this.myStorage.set(rowIdx, columnIdx, mutation);
        }
        this.myMutationModel.notifyRowsAdded(ModelIndexSet.forRows(this.myModel, rowIdx));
    }

    @Nullable
    private DasTable getDatabaseTable() {
        return this.myHookUp.getDatabaseTable();
    }

    private void notifyRequestFinished(@NotNull GridRequestSource source, boolean success) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(75);
        }
        this.myHookUp.notifyRequestFinished(source, success);
    }

    private void notifyUpdateCountReceived(@NotNull GridRequestSource source, int count) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(76);
        }
        this.myHookUp.notifyUpdateCountReceived(source, count);
    }

    private boolean isReadOnly() {
        return this.myHookUp.isReadOnly();
    }

    private boolean hasDifferentRowTypes(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(77);
        }
        boolean hasInserted = false;
        boolean hasNotInserted = false;
        for (ModelIndex rowModelIndex : rows.asIterable()) {
            boolean inserted = this.isInsertedRow(rowModelIndex);
            hasInserted |= inserted;
            hasNotInserted |= !inserted;
        }
        return hasInserted && hasNotInserted;
    }

    @Nullable
    private DataRequest.DmlRequest createRequest(@NotNull PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest> creator, @Nullable DmlMutationContext context) {
        if (creator == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(78);
        }
        return context == null ? null : (DataRequest.DmlRequest)((Object)creator.fun((Object)this.myHookUp, (Object)context));
    }

    @NotNull
    private static List<ColumnQueryData> createColumnsUpdateData(@NotNull DataConsumer.Row row, @NotNull List<DataConsumer.Column> columns) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(79);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(80);
        }
        List list = ContainerUtil.map(columns, column2 -> new ColumnQueryData((DataConsumer.Column)column2, column2.getValue(row)));
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(81);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 48: 
            case 52: 
            case 64: 
            case 73: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 48: 
            case 52: 
            case 64: 
            case 73: 
            case 81: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 28: 
            case 30: 
            case 31: 
            case 39: 
            case 49: 
            case 53: 
            case 56: 
            case 57: 
            case 61: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 14: 
            case 29: 
            case 35: 
            case 41: 
            case 47: 
            case 65: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 6: 
            case 15: 
            case 42: 
            case 54: 
            case 55: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 8: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 24: 
            case 26: 
            case 34: 
            case 43: 
            case 44: 
            case 46: 
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 10: 
            case 12: 
            case 25: 
            case 27: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIdx";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 19: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 32: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClone";
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 48: 
            case 52: 
            case 64: 
            case 73: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseMutatorImpl";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isValid";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isInserted";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteInStorage";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifyRemoved";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRow";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseMutatorImpl";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createRow";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedRows";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedRows";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedColumns";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingChanges";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowsInDatabaseDataModel";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalColumns";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateData";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsUpdateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mutate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateSafe";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedColumn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedColumn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInsertedColumn";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMutation";
                break;
            }
            case 26: 
            case 27: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getMutationType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 48: 
            case 52: 
            case 64: 
            case 73: 
            case 81: {
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRow";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRows";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasMutatedRows";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasUnparsedValues";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRowsInDatabaseDataModel";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalColumns";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteColumns";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "insertColumn";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "renameColumn";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getStringTypeName";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "cloneColumn";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRows";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRowsOrColumns";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "asContext";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateData";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "doInsertRow";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestFinished";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "notifyUpdateCountReceived";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "hasDifferentRowTypes";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsUpdateData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 48: 
            case 52: 
            case 64: 
            case 73: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PendingContexts {
        final DmlMutationContext insert;
        final DmlMutationContext update;
        final DmlMutationContext delete;

        private PendingContexts(@Nullable DmlMutationContext insert, @Nullable DmlMutationContext update2, @Nullable DmlMutationContext delete) {
            this.insert = insert;
            this.update = update2;
            this.delete = delete;
        }
    }

    private class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private MyRequestListener() {
        }

        @Override
        public void error(@NotNull GridRequestSource source, String message2, @Nullable List<DatabaseErrorHandler.Fix> fixes, Throwable th) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(0);
            }
            DatabaseMutatorImpl.this.myFailed = message2 != null || th != null;
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount2) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/database/datagrid/DatabaseMutatorImpl$MyRequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

