/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataInputType
implements ImportAction.InputType {
    protected final LocalDataSource myProducerLocalDataSource;
    protected final DbDataSource myProducerSource;
    private final String myProducerName;
    private final DasTable myTable;

    protected AbstractDataInputType(@NotNull DbDataSource dbDataSource, @NotNull LocalDataSource localDataSource, @NotNull String name, @Nullable DasTable table) {
        if (dbDataSource == null) {
            AbstractDataInputType.$$$reportNull$$$0(0);
        }
        if (localDataSource == null) {
            AbstractDataInputType.$$$reportNull$$$0(1);
        }
        if (name == null) {
            AbstractDataInputType.$$$reportNull$$$0(2);
        }
        this.myProducerLocalDataSource = localDataSource;
        this.myProducerSource = dbDataSource;
        this.myProducerName = name;
        this.myTable = table;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = DatabaseBundle.message("import.table", this.myProducerName);
        if (string == null) {
            AbstractDataInputType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public DasDataSource getProducerSystem() {
        return this.myProducerLocalDataSource;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myProducerLocalDataSource.getDbms();
        if (dbms == null) {
            AbstractDataInputType.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (context == null) {
            AbstractDataInputType.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            AbstractDataInputType.$$$reportNull$$$0(6);
        }
        DeModel model = context.getDeModel();
        ImportInfo.Builder builder = context.getBuilder();
        List<? extends ColumnDescriptor> visibleProducers = builder.getVisibleProducers();
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        DeTable table = ImportUtil.createDeTableFromColumns(model, producers, this.myProducerName);
        table.parent = ImportUtil.getSchema(context);
        table.name = context.getTableName();
        table.comment = this.myTable == null ? table.comment : this.myTable.getComment();
        table.setEditedObject((DeObject)null);
        table.getChildren().forEach(child -> child.setEditedObject((DeObject)null));
        for (int i2 = 0; i2 < Math.min(producers.size(), table.columns.size()); ++i2) {
            ImportUtil.ColumnTypePredictorInfo info = new ImportUtil.ColumnTypePredictorInfo(context, (ColumnDescriptor)producers.get(i2), rows);
            table.columns.get((int)i2).dataType = this.getPreferredConsumerColumnType(info);
        }
        ImportUtil.removeUnsupportedObjects(table, context.getCaps());
        ImportUtil.removeUntransferableObjects(table);
        DeTable deTable = table;
        if (deTable == null) {
            AbstractDataInputType.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    @NotNull
    private String getPreferredConsumerColumnType(@NotNull ImportUtil.ColumnTypePredictorInfo info) {
        if (info == null) {
            AbstractDataInputType.$$$reportNull$$$0(8);
        }
        Dbms producerDbms = this.myProducerLocalDataSource.getDbms();
        Version producerVersion = this.myProducerLocalDataSource.getVersion();
        Domain producerDomain = BaseDomainRegistry.getDomain(producerDbms, producerVersion, info.column, false);
        Dbms dbms = info.context.getDbms();
        DbDataSource source = info.context.getDataSource();
        Version version = DbImplUtilCore.getDatabaseVersion(source);
        Domain consumerDomain = producerDomain == null ? null : (dbms != Dbms.UNKNOWN && producerDbms == dbms && producerVersion.equals(version) ? producerDomain : BaseDomainRegistry.getMostRecentDomain(producerDomain, dbms, version));
        String string = consumerDomain == null ? ImportUtil.getPreferredTypeBasedOnContent(info) : consumerDomain.name();
        if (string == null) {
            AbstractDataInputType.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/AbstractDataInputType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/AbstractDataInputType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredConsumerColumnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewTable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredConsumerColumnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

