/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportInputType;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ErrorTaskInfo;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.ObjectToTextConverter;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportInfo {
    private final CsvFormat myFormat;
    private final DeTable myTable;
    private final String myProducerName;
    private final ImportType myType;
    private final ImportInputType myInputType;
    private final ErrorTaskInfo myErrorTaskInfo;
    private final boolean myLockTable;
    private final List<? extends ColumnDescriptor> myProducers;
    private final Cache myCache;
    private final DatabaseEditorContext myContext;
    private final boolean myInsertAsNull;
    private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
    private List<AutoValueDescriptor> myConsumers;

    private ImportInfo(@Nullable CsvFormat format, @NotNull DeTable table, @NotNull List<AutoValueDescriptor> consumers, @NotNull List<? extends ColumnDescriptor> producers, @NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map2, @NotNull String producerName, @NotNull ImportType importType, @NotNull DatabaseEditorContext context, @NotNull ImportInputType inputType, @NotNull ErrorTaskInfo errorTaskInfo, boolean lockTable, boolean insertAsNull) {
        if (table == null) {
            ImportInfo.$$$reportNull$$$0(0);
        }
        if (consumers == null) {
            ImportInfo.$$$reportNull$$$0(1);
        }
        if (producers == null) {
            ImportInfo.$$$reportNull$$$0(2);
        }
        if (map2 == null) {
            ImportInfo.$$$reportNull$$$0(3);
        }
        if (producerName == null) {
            ImportInfo.$$$reportNull$$$0(4);
        }
        if (importType == null) {
            ImportInfo.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ImportInfo.$$$reportNull$$$0(6);
        }
        if (inputType == null) {
            ImportInfo.$$$reportNull$$$0(7);
        }
        if (errorTaskInfo == null) {
            ImportInfo.$$$reportNull$$$0(8);
        }
        this.myFormat = format;
        this.myTable = table;
        this.myProducers = producers;
        this.myProducerName = producerName;
        this.myType = importType;
        this.myInputType = inputType;
        this.myErrorTaskInfo = errorTaskInfo;
        this.myLockTable = lockTable;
        this.myConsumers = consumers;
        this.myConsumerToProducer = map2;
        this.myContext = context;
        this.myInsertAsNull = insertAsNull;
        this.myCache = new Cache();
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumersForInsert() {
        List list = ContainerUtil.filter(this.myConsumers, consumer2 -> this.myConsumerToProducer.get(consumer2) != null || JdbcEngineUtils.shouldParticipateInInsert(this.myContext.getDbms(), consumer2) && !consumer2.isComputed() && (consumer2.isAutogenerated() || consumer2.hasDefault()));
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<? extends ColumnDescriptor> getProducers() {
        List<? extends ColumnDescriptor> list = this.myProducers;
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public ImportInputType getInputType() {
        ImportInputType importInputType = this.myInputType;
        if (importInputType == null) {
            ImportInfo.$$$reportNull$$$0(11);
        }
        return importInputType;
    }

    public boolean isInsertAsNull() {
        return this.myInsertAsNull;
    }

    @Nullable
    public CsvFormat getFormat() {
        return this.myFormat;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTable.getName();
        if (string == null) {
            ImportInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            ImportInfo.$$$reportNull$$$0(13);
        }
        return databaseEditorContext;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = this.myTable;
        if (deTable == null) {
            ImportInfo.$$$reportNull$$$0(14);
        }
        return deTable;
    }

    @NotNull
    public ImportType getType() {
        ImportType importType = this.myType;
        if (importType == null) {
            ImportInfo.$$$reportNull$$$0(15);
        }
        return importType;
    }

    @NotNull
    public ErrorTaskInfo getErrorTaskInfo() {
        ErrorTaskInfo errorTaskInfo = this.myErrorTaskInfo;
        if (errorTaskInfo == null) {
            ImportInfo.$$$reportNull$$$0(16);
        }
        return errorTaskInfo;
    }

    public boolean shouldLockTable() {
        return this.myLockTable;
    }

    @NotNull
    public String getProducerName() {
        String string = this.myProducerName;
        if (string == null) {
            ImportInfo.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public Cache cache() {
        Cache cache = this.myCache;
        if (cache == null) {
            ImportInfo.$$$reportNull$$$0(18);
        }
        return cache;
    }

    public void setConsumers(@NotNull List<ColumnDescriptor> consumers) {
        if (consumers == null) {
            ImportInfo.$$$reportNull$$$0(19);
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> newMapping = new LinkedHashMap<AutoValueDescriptor, ColumnDescriptor>();
        ArrayList<AutoValueDescriptor> newConsumers = new ArrayList<AutoValueDescriptor>();
        for (ColumnDescriptor consumer2 : consumers) {
            AutoValueDescriptor oldOne = this.findOldConsumer(consumer2);
            boolean autogenerated = oldOne != null && oldOne.isAutogenerated();
            boolean hasDefault = oldOne != null && oldOne.hasDefault();
            boolean computed = oldOne != null && oldOne.isComputed();
            AutoValueDescriptor newOne = ImportUtilCore.createDescriptor(consumer2, autogenerated, hasDefault, computed);
            newConsumers.add(newOne);
            newMapping.put(newOne, oldOne == null ? null : this.myConsumerToProducer.get(oldOne));
        }
        this.myConsumers = newConsumers;
        this.myConsumerToProducer = newMapping;
    }

    @Nullable
    private AutoValueDescriptor findOldConsumer(@NotNull ColumnDescriptor consumer2) {
        if (consumer2 == null) {
            ImportInfo.$$$reportNull$$$0(20);
        }
        String name = consumer2.getName();
        Dbms dbms = this.myContext.getDbms();
        BasicModel model = Objects.requireNonNull(this.myContext.getModel());
        NamingService namingService = NamingServices.getNamingService(dbms, model);
        Casing casing = model.getCasing(ObjectKind.COLUMN, null);
        return (AutoValueDescriptor)ContainerUtil.find(this.myConsumers, c2 -> {
            String candidate = c2.getName();
            boolean quoted = namingService.isQuoted(name);
            candidate = namingService.unquoteIdentifier(candidate);
            return Comparing.equal((String)candidate, (String)name, (boolean)casing.choose((boolean)DasSchemaExporters.treatAsPlainIdentifier((String)candidate, (boolean)quoted, null)).sensitive);
        });
    }

    @NotNull
    private Collection<AutoValueDescriptor> mappedConsumers() {
        List list = ContainerUtil.filter(this.myConsumers, consumer2 -> this.myConsumerToProducer.get(consumer2) != null);
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTaskInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumersForInsert";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTaskInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "cache";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "mappedConsumers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setConsumers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findOldConsumer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private CsvFormat myFormat;
        private DeTable myTable;
        private String myProducerName;
        private ImportType myImportType;
        private ImportInputType myInputType;
        private ErrorTaskInfo myErrorTaskInfo;
        private boolean myLockTable;
        private List<? extends ColumnDescriptor> myProducers;
        private DatabaseEditorContext myContext;
        private boolean myInsertAsNull;
        private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
        private List<AutoValueDescriptor> myConsumers;
        private List<DataConsumer.Row> myRows;
        private List<? extends ColumnDescriptor> myVisibleProducers;

        @NotNull
        public Builder rows(@NotNull List<DataConsumer.Row> rows) {
            if (rows == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myRows = rows;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder csvFormat(@Nullable CsvFormat format) {
            this.myFormat = format;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder consumer(@NotNull DeTable table) {
            if (table == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myTable = table;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder producerName(@NotNull String producerName) {
            if (producerName == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myProducerName = producerName;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder importType(@NotNull ImportType type) {
            if (type == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myImportType = type;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder inputType(@NotNull ImportInputType type) {
            if (type == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myInputType = type;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder errorTaskInfo(@NotNull ErrorTaskInfo info) {
            if (info == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myErrorTaskInfo = info;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder lockTable(boolean lockTable) {
            this.myLockTable = lockTable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder producers(@NotNull List<? extends ColumnDescriptor> producers) {
            if (producers == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myProducers = producers;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @NotNull
        public Builder visibleProducers(@NotNull List<? extends ColumnDescriptor> visibleProducers) {
            if (visibleProducers == null) {
                Builder.$$$reportNull$$$0(16);
            }
            this.myVisibleProducers = visibleProducers;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder;
        }

        @NotNull
        public Builder editorContext(@NotNull DatabaseEditorContext context) {
            if (context == null) {
                Builder.$$$reportNull$$$0(18);
            }
            this.myContext = context;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return builder;
        }

        @NotNull
        public Builder insertAsNull(boolean insertAsNull) {
            this.myInsertAsNull = insertAsNull;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder;
        }

        @NotNull
        public Builder mapping(@NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map2) {
            if (map2 == null) {
                Builder.$$$reportNull$$$0(21);
            }
            this.myConsumerToProducer = map2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return builder;
        }

        @NotNull
        public Builder consumers(@NotNull List<AutoValueDescriptor> descriptors) {
            if (descriptors == null) {
                Builder.$$$reportNull$$$0(23);
            }
            this.myConsumers = descriptors;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return builder;
        }

        @NotNull
        public ImportInfo build() {
            return new ImportInfo(this.myFormat, this.myTable, this.myConsumers, this.myProducers, this.myConsumerToProducer, this.myProducerName, this.myImportType, this.myContext, this.myInputType, this.myErrorTaskInfo, this.myLockTable, this.myInsertAsNull);
        }

        public DatabaseEditorContext getContext() {
            return this.myContext;
        }

        public ImportInputType getInputType() {
            return this.myInputType;
        }

        public ImportType getImportType() {
            return this.myImportType;
        }

        public CsvFormat getFormat() {
            return this.myFormat;
        }

        public LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> getMapping() {
            return this.myConsumerToProducer;
        }

        public List<AutoValueDescriptor> getConsumers() {
            return this.myConsumers;
        }

        public List<? extends ColumnDescriptor> getProducers() {
            return this.myProducers;
        }

        public List<? extends ColumnDescriptor> getVisibleProducers() {
            return this.myVisibleProducers;
        }

        public DeTable getTable() {
            return this.myTable;
        }

        public String getProducerName() {
            return this.myProducerName;
        }

        public List<DataConsumer.Row> getRows() {
            return this.myRows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producerName";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producers";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleProducers";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "csvFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "consumer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "producerName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "importType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inputType";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "errorTaskInfo";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lockTable";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "producers";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visibleProducers";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "editorContext";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertAsNull";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mapping";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "consumers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rows";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "consumer";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "producerName";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "importType";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "inputType";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "errorTaskInfo";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "producers";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visibleProducers";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "editorContext";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "mapping";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "consumers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ConversionException
    extends Exception {
        private static final String ERROR_MASK = "conversion failed: \"%s\" to %s";
        private final int myIndex;

        private ConversionException(@NotNull Object value2, @NotNull String typeName, @Nullable String columnName, int index2) {
            if (value2 == null) {
                ConversionException.$$$reportNull$$$0(0);
            }
            if (typeName == null) {
                ConversionException.$$$reportNull$$$0(1);
            }
            super(ConversionException.getMessage(value2, typeName, columnName));
            this.myIndex = index2;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @NotNull
        private static String getMessage(@NotNull Object value2, @NotNull String typeName, @Nullable String columnName) {
            if (value2 == null) {
                ConversionException.$$$reportNull$$$0(2);
            }
            if (typeName == null) {
                ConversionException.$$$reportNull$$$0(3);
            }
            String string = String.format(ERROR_MASK, value2, StringUtil.toLowerCase((String)typeName)) + (String)(columnName == null ? "" : " (" + columnName + ")");
            if (string == null) {
                ConversionException.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$ConversionException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$ConversionException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class Cache {
        private final Map<ColumnDescriptor, Integer> myCachedMapping = new HashMap<ColumnDescriptor, Integer>();
        private final Map<ColumnDescriptor, Domain> myCachedDomains = new HashMap<ColumnDescriptor, Domain>();
        private final Map<Object, Function<Object, Object>> myConverters = new HashMap<Object, Function<Object, Object>>();
        private final ObjectToTextConverter myToTextConverter;
        private final SchemaApplyHelper myApplyHelper;

        Cache() {
            this.myApplyHelper = new SchemaApplyHelper(ImportInfo.this.myContext, ImportInfo.this.myTable.model);
            this.myToTextConverter = new ObjectToTextConverter(ImportInfo.this.myInputType.getDbms());
        }

        @NotNull
        public Object[] convertLine(@NotNull Object[] objects2) throws ConversionException {
            if (objects2 == null) {
                Cache.$$$reportNull$$$0(0);
            }
            Collection<AutoValueDescriptor> consumers = ImportInfo.this.mappedConsumers();
            Object[] convertedLine = new Object[objects2.length];
            for (AutoValueDescriptor consumer2 : consumers) {
                boolean originalValueIsEmpty;
                ColumnDescriptor producer;
                int index2 = this.getProducerIndex(consumer2);
                Object o = index2 == -1 ? null : ObjectFormatter.unwrap(objects2[index2]);
                Function<Object, Object> converter = this.getConverter(o, consumer2, producer = ImportInfo.this.myProducers.get(index2));
                Object converted = converter == null ? (this.getDomain(consumer2) != null ? null : this.myToTextConverter.convert(o, producer)) : converter.fun(o);
                boolean bl = originalValueIsEmpty = o == null || o instanceof String && ((String)o).isEmpty();
                if (!ImportInfo.this.myInsertAsNull && !originalValueIsEmpty && converted == null) {
                    Object text2 = this.myToTextConverter.convert(o, producer);
                    throw new ConversionException(text2 == null ? o : text2, consumer2.getTypeName(), consumer2.getName(), index2);
                }
                convertedLine[index2] = DbImplUtilCore.prepareValue(ImportInfo.this.myContext.getDbms(), converted);
            }
            if (convertedLine == null) {
                Cache.$$$reportNull$$$0(1);
            }
            return convertedLine;
        }

        @Nullable
        private Domain getDomain(@NotNull ColumnDescriptor consumer2) {
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(2);
            }
            if (this.myCachedDomains.containsKey(consumer2)) {
                return this.myCachedDomains.get(consumer2);
            }
            Version version = DbImplUtilCore.getDatabaseVersion(ImportInfo.this.myContext.getDataSource());
            Domain domain = BaseDomainRegistry.getDomain(ImportInfo.this.myContext.getDbms(), version, consumer2, true);
            this.myCachedDomains.put(consumer2, domain);
            return domain;
        }

        @Nullable
        private Function<Object, Object> getConverter(@Nullable Object o, @NotNull ColumnDescriptor consumer2, @NotNull ColumnDescriptor producer) {
            ColumnDescriptor key;
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(3);
            }
            if (producer == null) {
                Cache.$$$reportNull$$$0(4);
            }
            ColumnDescriptor columnDescriptor = key = this.isMultiTypeColumn(producer, ImportInfo.this.myInputType.getDbms()) && o != null ? new Pair(o.getClass(), (Object)consumer2) : consumer2;
            if (this.myConverters.containsKey(key)) {
                return this.myConverters.get(key);
            }
            Function<Object, Object> converter = this.getNoCached(o, consumer2, producer);
            this.myConverters.put(key, converter);
            return converter;
        }

        private boolean isMultiTypeColumn(ColumnDescriptor producer, @NotNull Dbms dbms) {
            if (dbms == null) {
                Cache.$$$reportNull$$$0(5);
            }
            return dbms.is(Dbms.MONGO) || dbms.is(Dbms.SQLITE) && StringUtil.equalsIgnoreCase((CharSequence)"numeric", (CharSequence)producer.getTypeName());
        }

        @NotNull
        public List<ColumnInfo> getColumnInfos() {
            Collection<AutoValueDescriptor> descriptors = ImportInfo.this.mappedConsumers();
            ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>();
            for (AutoValueDescriptor descriptor2 : descriptors) {
                int index2 = this.getProducerIndex(descriptor2);
                infos.add(new ColumnInfo(descriptor2.getJavaClassName(), descriptor2.getTypeName(), descriptor2.getType(), index2));
            }
            ArrayList<ColumnInfo> arrayList = infos;
            if (arrayList == null) {
                Cache.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @NotNull
        public DasTable getBasicTable() {
            DasTable dasTable = (DasTable)((Object)this.getBasicElement(ImportInfo.this.myTable));
            if (dasTable == null) {
                Cache.$$$reportNull$$$0(7);
            }
            return dasTable;
        }

        @NotNull
        public BasicElement getBasicElement(@NotNull DeObject object) {
            if (object == null) {
                Cache.$$$reportNull$$$0(8);
            }
            BasicElement basicElement = Objects.requireNonNull(this.myApplyHelper.apply(object));
            if (basicElement == null) {
                Cache.$$$reportNull$$$0(9);
            }
            return basicElement;
        }

        @Nullable
        private Function<Object, Object> getNoCached(@Nullable Object o, @NotNull ColumnDescriptor consumer2, @NotNull ColumnDescriptor producer) {
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(10);
            }
            if (producer == null) {
                Cache.$$$reportNull$$$0(11);
            }
            DbDataSource source = ImportInfo.this.myContext.getDataSource();
            return DataTypeConversion.getConverter(ImportInfo.this.myInputType.getDbms(), ImportInfo.this.myContext.getDbms(), ImportInfo.this.myInputType.getProducerSystem(), source, producer, consumer2, o);
        }

        private int getProducerIndex(@NotNull AutoValueDescriptor consumer2) {
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(12);
            }
            if (this.myCachedMapping.containsKey(consumer2)) {
                return this.myCachedMapping.get(consumer2);
            }
            ColumnDescriptor producer = ImportInfo.this.myConsumerToProducer.get(consumer2);
            int result2 = producer == null ? -1 : ContainerUtil.indexOf(ImportInfo.this.myProducers, current -> StringUtil.equals((CharSequence)producer.getName(), (CharSequence)current.getName()));
            this.myCachedMapping.put(consumer2, result2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$Cache";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$Cache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertLine";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnInfos";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicTable";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertLine";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDomain";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getConverter";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isMultiTypeColumn";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getBasicElement";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getNoCached";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getProducerIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

