/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.TableSettings;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ImportType {
    NEW_TABLE(false){

        @Override
        boolean suitable(DasObject element2) {
            return element2.getKind() == ObjectKind.SCHEMA || element2.getKind() == ObjectKind.DATABASE || element2 instanceof DbDataSource;
        }

        @Override
        @NotNull
        public DeTable createTable(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                1.$$$reportNull$$$0(1);
            }
            DeTable deTable = context.getBuilder().getInputType().createNewTable(context, descriptors, rows);
            if (deTable == null) {
                1.$$$reportNull$$$0(2);
            }
            return deTable;
        }

        @Override
        @NotNull
        public TableSettings getCodeGenerationSettings() {
            return new TableSettings(TableSettings.FinalAction.EXEC_IN_DB, TableSettings.CodeType.CREATE_NEW_CODE);
        }

        @Override
        @NotNull
        public CsvFormatUISettings getCsvFormatSettings() {
            CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.DEFAULT;
            if (csvFormatUISettings == null) {
                1.$$$reportNull$$$0(3);
            }
            return csvFormatUISettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportType$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportType$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCsvFormatSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTable";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    EXISTING_TABLE(true){

        @Override
        boolean suitable(DasObject element2) {
            return element2.getKind() == ObjectKind.TABLE;
        }

        @Override
        @NotNull
        public DeTable createTable(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                2.$$$reportNull$$$0(1);
            }
            DeTable deTable = ImportUtilCore.createDeTableFromDasObject(Objects.requireNonNull(context.getDataSource()).getModel(), (BasicElement)DbImplUtilCore.unwrap(context.getElement()), context.getDeModel());
            if (deTable == null) {
                2.$$$reportNull$$$0(2);
            }
            return deTable;
        }

        @Override
        @NotNull
        public TableSettings getCodeGenerationSettings() {
            return new TableSettings(TableSettings.FinalAction.EXEC_IN_DB, TableSettings.CodeType.ALTER_CODE);
        }

        @Override
        @NotNull
        public CsvFormatUISettings getCsvFormatSettings() {
            CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.IMPORT_IN_TABLE;
            if (csvFormatUISettings == null) {
                2.$$$reportNull$$$0(3);
            }
            return csvFormatUISettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportType$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportType$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCsvFormatSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTable";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private final boolean myTableCreated;

    private ImportType(boolean created) {
        this.myTableCreated = created;
    }

    public boolean isTableCreated() {
        return this.myTableCreated;
    }

    @NotNull
    public abstract CsvFormatUISettings getCsvFormatSettings();

    @NotNull
    public abstract TableSettings getCodeGenerationSettings();

    @NotNull
    public abstract DeTable createTable(@NotNull ImportEditorContext var1, @NotNull List<? extends ColumnDescriptor> var2, @Nullable List<DataConsumer.Row> var3);

    abstract boolean suitable(DasObject var1);

    @Nullable
    public static ImportType of(@NotNull DasObject element2) {
        if (element2 == null) {
            ImportType.$$$reportNull$$$0(0);
        }
        for (ImportType type : ImportType.values()) {
            if (!type.suitable(element2)) continue;
            return type;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportType", "of"));
    }
}

