/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseErrorHandlerSink;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.Security;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDatabaseErrorHandler
implements DatabaseErrorHandler {
    private static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    protected final Logger LOG = Logger.getInstance(this.getClass());
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\n+");

    @Override
    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource2, @NotNull Throwable original, @NotNull Throwable cause, @NotNull DatabaseErrorHandlerSink sink) {
        if (original == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(2);
        }
        if (original instanceof DatabaseErrorHandler.KnownException) {
            sink.addKnownException((DatabaseErrorHandler.KnownException)original);
            String string = original.getMessage();
            if (string == null) {
                BaseDatabaseErrorHandler.$$$reportNull$$$0(3);
            }
            return string;
        }
        @Nls StringBuilder sb = new StringBuilder();
        String causeMsg = JdbcUtil.getMessage(cause);
        String origMsg = JdbcUtil.getMessage(original);
        if (original != cause && original instanceof SQLException && !origMsg.equals(causeMsg)) {
            BaseDatabaseErrorHandler.appendGenericMessage(original, sb);
        }
        if (cause instanceof UnsupportedOperationException) {
            sb.append(causeMsg);
        } else if (cause instanceof SQLException) {
            SQLException next;
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)causeMsg) == -1) {
                sb.append(JdbcUtil.getMessagePrefix(cause)).append(causeMsg);
            }
            if ((next = (SQLException)ObjectUtils.doIfCast((Object)cause, SQLException.class, ex -> ex.getNextException())) != null && next != cause) {
                sb.append("\n").append(this.getErrorMessage(dataSource2, next, ExceptionUtil.getRootCause((Throwable)next), sink));
            }
        } else if (cause instanceof ClassNotFoundException) {
            sink.addDriverClassNotFoundFixes(sb, dataSource2, cause.getMessage());
        } else if (cause instanceof ExecutionException) {
            DatabaseDriver driver;
            DatabaseDriver databaseDriver = driver = dataSource2 == null ? null : dataSource2.getDatabaseDriver();
            if (causeMsg.contains("java.lang.ClassNotFoundException")) {
                Matcher matcher = Pattern.compile("java\\.lang\\.ClassNotFoundException:\\s+((?:\\w+\\.)*\\w+)").matcher(causeMsg);
                sink.addDriverClassNotFoundFixes(sb, dataSource2, matcher.find() ? matcher.group(1) : null);
            } else if (causeMsg.contains("java.lang.InstantiationException")) {
                Matcher matcher = Pattern.compile("java\\.lang\\.InstantiationException:\\s+((?:\\w+\\.)*\\w+)").matcher(causeMsg);
                sb.append(DatabaseBundle.message("message.driver.class.not.instantiable", matcher.find() ? matcher.group(1) : ""));
                sink.addChangeClassFix(driver);
            } else if (causeMsg.contains("java.lang.UnsupportedClassVersionError")) {
                Matcher matcher = Pattern.compile("java.lang.UnsupportedClassVersionError:\\s+((?:\\w+/)*\\w+)").matcher(causeMsg);
                sb.append(DatabaseBundle.message("message.driver.class.wrong.version", matcher.find() ? matcher.group(1).replace('/', '.') : ""));
                sink.addEditDriverFix(driver);
            } else {
                sb.append(causeMsg);
                this.LOG.warn(cause);
            }
        } else if (cause instanceof RemoteException) {
            sb.append(cause);
            this.LOG.warn(cause);
        } else if (causeMsg.contains("Protocol family unavailable")) {
            sb.append(causeMsg);
            if (dataSource2 != null) {
                BaseDatabaseErrorHandler.addPreferIPv4Fix(dataSource2, sink);
            }
        } else if (BaseDatabaseErrorHandler.isNoSslProtocol(causeMsg)) {
            sb.append(causeMsg);
            if (dataSource2 != null) {
                BaseDatabaseErrorHandler.addEnableDisabledProtocols(dataSource2, sink, sb);
            }
        } else if (cause instanceof EOFException && original instanceof RemoteException) {
            sb.append(dataSource2 == null ? "unknown data source" : dataSource2.getName()).append(": process exited");
        } else if (cause instanceof IOException) {
            sb.append(origMsg);
            this.LOG.warn(cause);
        } else if (cause instanceof SuppressUserStackTrace) {
            sb.append(causeMsg);
        } else if (cause instanceof JdbcEngineUtils.UnsafeUpdateRolledBackException) {
            sb.append(cause.getMessage());
        } else if (cause instanceof OutOfMemoryError) {
            sb.append(DatabaseBundle.message("error.message.remote.oomerror", dataSource2 == null ? null : dataSource2.getName()));
        } else if (original instanceof NoClassDefFoundError) {
            sb.append(DatabaseBundle.message("missing.driver.class", original.getMessage()));
            this.LOG.warn(cause);
        } else {
            sb.append(causeMsg);
            this.LOG.warn(original);
        }
        String string = sb.toString();
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected static boolean isNoSslProtocol(String causeMsg) {
        return causeMsg.contains("javax.net.ssl.SSLHandshakeException") && (causeMsg.contains("No appropriate protocol") || causeMsg.contains("protocol_version") || causeMsg.contains("The server selected protocol version"));
    }

    protected static void addEnableDisabledProtocols(@NotNull LocalDataSource dataSource2, @NotNull DatabaseErrorHandlerSink sink, @NotNull StringBuilder sb) {
        if (dataSource2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(6);
        }
        if (sb == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(7);
        }
        String disabledRemote = BaseDatabaseErrorHandler.getPropValue(dataSource2.getVmOptions(), PROPERTY_TLS_DISABLED_ALGS);
        String disabledLocal = Security.getProperty(PROPERTY_TLS_DISABLED_ALGS);
        String disabled = disabledRemote == null ? disabledLocal : disabledRemote;
        sb.append("\n\n").append(DatabaseBundle.message("required.algorithm.may.be.disabled", disabled));
        sink.addOptionFix(DatabaseBundle.message("edit.disabled.algorithms", new Object[0]), dataSource2, PROPERTY_TLS_DISABLED_ALGS, disabled);
        String[] list = disabled == null ? ArrayUtil.EMPTY_STRING_ARRAY : disabled.split("\\s*,\\s");
        BaseDatabaseErrorHandler.addEnableTls(dataSource2, sink, list, "TLSv1");
        BaseDatabaseErrorHandler.addEnableTls(dataSource2, sink, list, "TLSv1.1");
    }

    private static void addEnableTls(@NotNull LocalDataSource dataSource2, @NotNull DatabaseErrorHandlerSink sink, String[] list, String tls) {
        if (dataSource2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(9);
        }
        if (ArrayUtil.indexOf((Object[])list, (Object)tls) != -1) {
            String newDisabled = StringUtil.join((Iterable)JBIterable.of((Object[])list).filter(o -> !o.equals(tls)), (String)", ");
            sink.addOptionFix(DatabaseBundle.message("enable.0", tls), dataSource2, PROPERTY_TLS_DISABLED_ALGS, newDisabled);
        }
    }

    private static void addPreferIPv4Fix(@NotNull LocalDataSource dataSource2, @NotNull DatabaseErrorHandlerSink sink) {
        if (dataSource2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(11);
        }
        if (BaseDatabaseErrorHandler.removeOrRemoveForced(dataSource2, sink, false)) {
            return;
        }
        DatabaseDriver driver = dataSource2.getDatabaseDriver();
        if (driver != null && BaseDatabaseErrorHandler.removeOrRemoveForced(driver, sink, false)) {
            return;
        }
        boolean idePreferIPv4 = Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")));
        if (idePreferIPv4) {
            if (!BaseDatabaseErrorHandler.removeOrRemoveForced(dataSource2, sink, true)) {
                return;
            }
            if (driver != null && !BaseDatabaseErrorHandler.removeOrRemoveForced(driver, sink, true)) {
                return;
            }
        }
    }

    private static boolean removeOrRemoveForced(@NotNull Object driverOrDataSource, @NotNull DatabaseErrorHandlerSink sink, boolean set) {
        if (driverOrDataSource == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(13);
        }
        LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)driverOrDataSource, LocalDataSource.class);
        DatabaseDriverCore dr = (DatabaseDriverCore)ObjectUtils.tryCast((Object)driverOrDataSource, DatabaseDriverCore.class);
        assert (ds != null || dr != null);
        String options = dr == null ? ds.getVmOptions() : dr.getVmOptions();
        String forcedVal = BaseDatabaseErrorHandler.getPropValue(options, "java.net.preferIPv4Stack");
        if (set) {
            if ("false".equals(forcedVal)) {
                return false;
            }
        } else {
            if (forcedVal == null) {
                return false;
            }
            if (!"true".equals(forcedVal)) {
                return true;
            }
        }
        String text2 = set ? DatabaseBundle.message("set.d.0.false.in.1.choice.0.driver.1.data.source.settings", "java.net.preferIPv4Stack", ds == null ? 0 : 1) : DatabaseBundle.message("remove.d.0.from.1.choice.0.driver.1.data.source.settings", "java.net.preferIPv4Stack", ds == null ? 0 : 1);
        BaseDatabaseErrorHandler.setOptionFix(text2, driverOrDataSource, sink, "java.net.preferIPv4Stack", set ? "false" : null);
        return true;
    }

    private static void setOptionFix(@NotNull @Nls String text2, @NotNull Object driverOrDataSource, @NotNull DatabaseErrorHandlerSink sink, @NotNull String name, @Nullable String val) {
        if (text2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(14);
        }
        if (driverOrDataSource == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(15);
        }
        if (sink == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(16);
        }
        if (name == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(17);
        }
        if (driverOrDataSource instanceof LocalDataSource) {
            sink.addOptionFix(text2, (LocalDataSource)driverOrDataSource, name, val);
        } else {
            sink.addOptionFix(text2, (DatabaseDriverCore)driverOrDataSource, name, val);
        }
    }

    @Nullable
    private static String getPropValue(@Nullable String options, String prop) {
        ParametersList dsParams = new ParametersList();
        dsParams.addParametersString(options);
        return dsParams.getPropertyValue(prop);
    }

    @Override
    @Nullable
    public Boolean mayRequestPassword(@NotNull SQLException e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Override
    public boolean isPasswordExpired(@NotNull SQLException e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(19);
        }
        return false;
    }

    @Override
    public boolean isConnectionUnusable(@NotNull SQLException e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(20);
        }
        return false;
    }

    protected static void appendGenericMessage(@NotNull Throwable e, @NotNull StringBuilder sb) {
        String message2;
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(21);
        }
        if (sb == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(22);
        }
        if (StringUtil.indexOf((CharSequence)sb, (CharSequence)(message2 = JdbcUtil.getMessage(e))) == -1) {
            if (message2.contains("\n")) {
                String m = LINE_BREAK_PATTERN.matcher(message2).replaceAll(r -> r.group(0) + "\t");
                sb.append(JdbcUtil.getMessagePrefix(e).trim());
                sb.append("\n\t");
                sb.append(m);
                sb.append("\n");
            } else {
                sb.append(JdbcUtil.getMessagePrefix(e)).append(message2).append("\n");
            }
        }
    }

    @NotNull
    protected static String getGenericMessage(@NotNull Throwable t) {
        if (t == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(23);
        }
        StringBuilder sb = new StringBuilder();
        BaseDatabaseErrorHandler.appendGenericMessage(t, sb);
        String string = sb.toString();
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(24);
        }
        return string;
    }

    protected static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message2, @NotNull String queryText2, @Nullable StringFinder finder) {
        Matcher matcher;
        if (pattern == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(25);
        }
        if (message2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(26);
        }
        if (queryText2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(27);
        }
        if ((matcher = Pattern.compile(pattern).matcher(message2)).find()) {
            return BaseDatabaseErrorHandler.getOffsetFromMessageImpl(queryText2, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null, finder);
        }
        return -1;
    }

    protected static int getOffsetFromMessageImpl(@NotNull String queryText2, @Nullable String near, @Nullable String strLine, @Nullable String strColumn, @Nullable StringFinder finder) {
        int offset;
        int column2;
        if (queryText2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(28);
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column2 = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column2 < 0 ? -1 : column2 - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText2, (int)(line - 1), (int)(column2 < 0 ? 0 : column2 - 1)));
        if (line > -1 && column2 > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText2, near, offset);
        return refined == -1 ? offset : refined;
    }

    protected static StringFinder byTokenFinder(@NotNull Language language, @NotNull Project project, int cropping) {
        if (language == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(29);
        }
        if (project == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(30);
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            ParserDefinition parser2 = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)language);
            if (parser2 == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser2.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/BaseDatabaseErrorHandler";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverOrDataSource";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/BaseDatabaseErrorHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 3: 
            case 4: 
            case 24: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addEnableDisabledProtocols";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addEnableTls";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPreferIPv4Fix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeOrRemoveForced";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setOptionFix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordExpired";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isConnectionUnusable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendGenericMessage";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getGenericMessage";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromMessageImpl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "byTokenFinder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }
}

