/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseErrorHandlerSink;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseErrorHandlerSinkImpl
extends DatabaseErrorHandlerSink {
    @NotNull
    private final Consumer<? super DatabaseErrorHandler.Fix> myFixes;

    public DatabaseErrorHandlerSinkImpl(@NotNull Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        if (fixes == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(0);
        }
        this.myFixes = fixes;
    }

    @Override
    public void addKnownException( @NotNull DatabaseErrorHandler.KnownException exception) {
        if (exception == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(1);
        }
        for (DatabaseErrorHandler.Fix fix : exception.fixes) {
            this.myFixes.consume((Object)fix);
        }
    }

    @Override
    public void addChangeClassFix(@Nullable DatabaseDriverCore driver) {
        this.addSettingsFix(DatabaseBundle.message("DatabaseErrorHandler.change.driver.class", new Object[0]), driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)DatabaseDriverConfigurable::focusDriverClassSelector));
    }

    @Override
    public void addEditDriverFix(@Nullable DatabaseDriverCore driver) {
        this.addSettingsFix(DatabaseBundle.message("DatabaseErrorHandler.edit.driver", new Object[0]), driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> {}));
    }

    @Override
    public void addDriverClassNotFoundFixes(StringBuilder sb, @Nullable LocalDataSource dataSource2, @Nullable String message2) {
        if (dataSource2 == null) {
            return;
        }
        sb.append(DatabaseBundle.message("message.driver.class.not.found.text", StringUtil.notNullize((String)message2)));
        DatabaseDriver driver = dataSource2.getDatabaseDriver();
        if (driver == null || DbImplUtilCore.hasDriverFiles(dataSource2)) {
            this.addChangeClassFix(driver);
            return;
        }
        if (driver.getArtifacts().isEmpty()) {
            sb.append(" ").append(DatabaseBundle.message("DataSourceConfigurable.no.driver.files", new Object[0]));
            this.addEditDriverFix(driver);
            return;
        }
        boolean downloaded = DatabaseDriverValidator.isDriverFilesUpToDate(driver, driver.getArtifacts());
        sb.append(" ").append(DatabaseBundle.message(downloaded ? "DataSourceConfigurable.drivers.not.configured" : "DataSourceConfigurable.drivers.not.downloaded", new Object[0]));
        this.addSwitchToLatestDriverFix(dataSource2, downloaded);
    }

    private void addSwitchToLatestDriverFix(final @NotNull LocalDataSource dataSource2, final boolean downloaded) {
        if (dataSource2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(2);
        }
        this.myFixes.consume((Object)new DatabaseErrorHandler.Fix(){

            @Override
            public String getName() {
                return DatabaseBundle.message(downloaded ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver", new Object[0]);
            }

            @Override
            public void apply(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseConfigEditor editor = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                final NamedProgressive task2 = DatabaseDriverValidator.createDownloaderTask(dataSource2, editor);
                new Task.Modal(project, task2.getName(), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        task2.run(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/DatabaseErrorHandlerSinkImpl$1$1", "run"));
                    }
                }.queue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseErrorHandlerSinkImpl$1", "apply"));
            }
        });
    }

    @Override
    public void addOptionFix(@NotNull @Nls String text2, @NotNull LocalDataSource dataSource2, @NotNull String name, @Nullable String val) {
        if (text2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(3);
        }
        if (dataSource2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(4);
        }
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(5);
        }
        this.addSettingsFix(text2, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> ds.setVmOptions(DatabaseErrorHandlerSinkImpl.setOption(ds.getVmOptions(), name, val))));
            DatabaseErrorHandlerSinkImpl.focusVmOptions(c2);
        }));
    }

    @Override
    public void addOptionFix(@NotNull @Nls String text2, @NotNull DatabaseDriverCore driver, @NotNull String name, @Nullable String val) {
        if (text2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(6);
        }
        if (driver == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(7);
        }
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(8);
        }
        this.addSettingsFix(text2, driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c2 -> {
            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)dr -> dr.setVmOptions(DatabaseErrorHandlerSinkImpl.setOption(dr.getVmOptions(), name, val))), c2);
            DatabaseErrorHandlerSinkImpl.focusVmOptions(c2);
        }));
    }

    @Override
    public void addEnableSSLFix(@Nullable LocalDataSource dataSource2) {
        DataSourceSslConfiguration ssl;
        DataSourceSslConfiguration dataSourceSslConfiguration = ssl = dataSource2 != null ? dataSource2.getSslCfg() : null;
        if (ssl == null || !ssl.myEnabled) {
            this.addSettingsFix(DatabaseBundle.message("enable.ssl", new Object[0]), dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)c2 -> DataSourceUiUtil.modify(c2, (Consumer<? super LocalDataSource>)((Consumer)ds -> {
                DataSourceSslConfiguration cur2 = ds.getSslCfg();
                if (cur2 == null) {
                    cur2 = new DataSourceSslConfiguration("", "", "", true, JdbcSettings.SslMode.REQUIRE, LocalDataSource.Storage.PERSIST);
                } else {
                    cur2.myEnabled = true;
                }
                ds.setSslCfg(cur2);
            }))));
        }
    }

    @Override
    public void addSetDriverPropertyFix(@Nullable LocalDataSource dataSource2, @Nls @NotNull String message2, @NotNull String prop, @Nullable String value2) {
        if (message2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(9);
        }
        if (prop == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(10);
        }
        this.addSettingsFix(message2, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> this.setDriverProperty((DataSourceConfigurable)configurable, prop, value2)));
    }

    protected void setDriverProperty(@NotNull DataSourceConfigurable configurable, @NotNull String prop, @Nullable String value2) {
        if (configurable == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(11);
        }
        if (prop == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(12);
        }
        DataSourceUiUtil.modify(configurable, (Consumer<? super LocalDataSource>)((Consumer)ds -> {
            if (value2 != null) {
                ds.getDriverProperties().put(prop, value2);
            } else {
                ds.getDriverProperties().remove(prop);
            }
        }));
        JComponent panel2 = configurable.selectAdvancedPanel();
        IdeFocusManager.getInstance((Project)configurable.getProject()).doWhenFocusSettlesDown(() -> {
            TableView props = (TableView)UIUtil.uiTraverser((Component)panel2).filter(TableView.class).first();
            if (props != null) {
                for (int i2 = 0; i2 < props.getRowCount(); ++i2) {
                    if (!prop.equals(props.getModel().getValueAt(i2, 0))) continue;
                    props.setRowSelectionInterval(i2, i2);
                    TableUtil.scrollSelectionToVisible((JTable)props);
                    break;
                }
            }
        });
    }

    public static void focusVmOptions(AbstractDatabaseConfigurable<?> c2) {
        JComponent panel2;
        String ex;
        if (c2 instanceof DataSourceConfigurable) {
            DataSourceConfigurable dsc = (DataSourceConfigurable)c2;
            ex = dsc.getTempDataSource().getVmOptions();
            panel2 = dsc.selectAdvancedPanel();
        } else if (c2 instanceof DatabaseDriverConfigurable) {
            DatabaseDriverConfigurable drc = (DatabaseDriverConfigurable)c2;
            ex = drc.getTempDriver().getVmOptions();
            panel2 = drc.selectAdvancedPanel();
        } else {
            return;
        }
        Condition filter2 = e -> e.getText().equals(ex);
        Project project = c2.getProject();
        DatabaseErrorHandlerSinkImpl.findComponent(project, panel2, RawCommandLineEditor.class, filter2, e -> {
            if (e != null) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)e.getTextField(), true);
            }
        });
    }

    private static <T extends Component> void findComponent(Project project, JComponent panel2, Class<T> clazz, Condition<? super T> filter2, Consumer<? super T> consumer2) {
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
            JBIterable editors = UIUtil.uiTraverser((Component)panel2).filter(clazz).collect();
            consumer2.consume(editors.filter(filter2).append((Iterable)editors).first());
        });
    }

    @Nullable
    private static String setOption(@Nullable String options, @NotNull String name, @Nullable String val) {
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(13);
        }
        ParametersList list = new ParametersList();
        list.addParametersString(options);
        if (val == null) {
            list.replaceOrAppend("-D" + name, "");
        } else {
            list.addProperty(name, val);
        }
        return StringUtil.nullize((String)list.getParametersString());
    }

    public void addSettingsFix(@Nls @NotNull String name, @Nullable DatabaseDriverCore dr, @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(14);
        }
        if (consumer2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(15);
        }
        if (dr != null) {
            this.myFixes.consume((Object)DatabaseErrorHandlerSinkImpl.settingsFix(name, dr, consumer2));
        }
    }

    public void addSettingsFix(@Nls @NotNull String name, @Nullable LocalDataSource ds, @NotNull Consumer<? super DataSourceConfigurable> consumer2) {
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(16);
        }
        if (consumer2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(17);
        }
        if (ds != null) {
            this.myFixes.consume((Object)DatabaseErrorHandlerSinkImpl.settingsFix(name, ds, consumer2));
        }
    }

    @NotNull
    private static DatabaseErrorHandler.Fix settingsFix(final @Nls @NotNull String name, final @NotNull LocalDataSource ds, final @NotNull Consumer<? super DataSourceConfigurable> consumer2) {
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(18);
        }
        if (ds == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(19);
        }
        if (consumer2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(20);
        }
        return new DatabaseErrorHandler.Fix(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isSilent() {
                return false;
            }

            @Override
            public void apply(@NotNull DataContext dataContext) {
                DatabaseConfigEditor editor;
                if (dataContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((editor = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext)) == null) {
                    return;
                }
                DataSourceUiUtil.navigate(editor, ds, (Consumer<? super DataSourceConfigurable>)consumer2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseErrorHandlerSinkImpl$2", "apply"));
            }
        };
    }

    @NotNull
    private static DatabaseErrorHandler.Fix settingsFix(@Nls @NotNull String name, @NotNull DatabaseDriverCore dr, @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(21);
        }
        if (dr == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(22);
        }
        if (consumer2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(23);
        }
        return DatabaseErrorHandlerSinkImpl.settingsFix(name, dr, true, consumer2);
    }

    @NotNull
    private static DatabaseErrorHandler.Fix settingsFix(final @Nls @NotNull String name, final @NotNull DatabaseDriverCore dr, final boolean navigate, final @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(24);
        }
        if (dr == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(25);
        }
        if (consumer2 == null) {
            DatabaseErrorHandlerSinkImpl.$$$reportNull$$$0(26);
        }
        return new DatabaseErrorHandler.Fix(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isSilent() {
                return false;
            }

            @Override
            public void apply(@NotNull DataContext dataContext) {
                DatabaseConfigEditor editor;
                if (dataContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((editor = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(dataContext)) == null) {
                    return;
                }
                if (navigate) {
                    DataSourceUiUtil.navigate(editor, dr, (Consumer<? super DatabaseDriverConfigurable>)consumer2);
                } else {
                    DatabaseDriverConfigurable configurable = editor.getConfigurable(dr, true, DatabaseDriverConfigurable.class);
                    if (configurable != null) {
                        consumer2.consume((Object)configurable);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dialects/DatabaseErrorHandlerSinkImpl$3", "apply"));
            }
        };
    }

    @NotNull
    public static DatabaseErrorHandler.Fix createSetUpArtifactFix(DatabaseDriver driver, boolean navigate, Supplier<@Nullable DatabaseArtifactList.ArtifactVersion> artifact) {
        return DatabaseErrorHandlerSinkImpl.settingsFix(DatabaseBundle.message("set.up.required.libraries", new Object[0]), driver, navigate, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)configurable -> {
            DatabaseArtifactList.ArtifactVersion version = (DatabaseArtifactList.ArtifactVersion)artifact.get();
            if (version == null) {
                return;
            }
            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)d2 -> d2.getArtifacts().add(DatabaseDriverImpl.createArtifactRef(version.artifact.id, version.version, "stable"))), configurable);
            DatabaseErrorHandlerSinkImpl.download(driver, configurable, version);
        }));
    }

    public static void download(DatabaseDriver driver, DatabaseDriverConfigurable configurable, DatabaseArtifactList.ArtifactVersion artifact) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        final NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(artifact, driver, configurable.getController());
        if (indicator != null) {
            downloader.run(indicator);
        } else {
            new Task.Modal(configurable.getProject(), downloader.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    downloader.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/DatabaseErrorHandlerSinkImpl$4", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/DatabaseErrorHandlerSinkImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addKnownException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSwitchToLatestDriverFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addOptionFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addSetDriverPropertyFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setDriverProperty";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setOption";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addSettingsFix";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "settingsFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

