/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.DateDelegate;
import com.intellij.database.run.ui.grid.editors.DateToLocalDateTimeDelegate;
import com.intellij.database.run.ui.grid.editors.EraDateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimestampDelegate;
import com.intellij.database.run.ui.grid.editors.TimeDelegate;
import com.intellij.database.run.ui.grid.editors.TimestampDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimestampDelegate;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormatterCreator {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String ERA_PATTERN = "[ ][GGG]";

    private FormatterCreator() {
    }

    @NotNull
    public static NumberFormatter newDecimalFormat() {
        return FormatterCreator.configureDecimalFormat(new DecimalFormat());
    }

    @NotNull
    public static NumberFormatter newFloatFormat() {
        return FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text2, ParsePosition pos) {
                Number n = super.parse(text2, pos);
                return n != null ? Float.valueOf(n.floatValue()) : null;
            }

            @Override
            public StringBuffer format(double number, StringBuffer result2, FieldPosition fieldPosition) {
                number = Double.valueOf(Float.toString((float)number));
                return super.format(number, result2, fieldPosition);
            }
        });
    }

    @NotNull
    public static NumberFormatter newDoubleFormat() {
        return FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text2, ParsePosition pos) {
                Number n = super.parse(text2, pos);
                return n == null ? (Number)null : (Number)((Number)ObjectUtils.notNull((Object)FormatterCreator.asInt(n), (Object)n));
            }
        });
    }

    @NotNull
    public static NumberFormatter newIntFormat() {
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text2, ParsePosition pos) {
                Number n = super.parse(text2, pos);
                return n != null ? Integer.valueOf(n.intValue()) : null;
            }
        });
        formatter.setParseIntegerOnly(true);
        NumberFormatter numberFormatter = formatter;
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(0);
        }
        return numberFormatter;
    }

    @NotNull
    public static NumberFormatter newLongFormat() {
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text2, ParsePosition pos) {
                Number n = super.parse(text2, pos);
                return n != null ? Long.valueOf(n.longValue()) : null;
            }
        });
        formatter.setParseIntegerOnly(true);
        NumberFormatter numberFormatter = formatter;
        if (numberFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(1);
        }
        return numberFormatter;
    }

    public static NumberFormatter getDecimalFormatWithPriorityType(final int priorityType) {
        NumberFormatter formatter = FormatterCreator.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text2, ParsePosition pos) {
                Number n = super.parse(text2, pos);
                return n == null ? (Number)null : (Number)((Number)ObjectUtils.notNull((Object)(priorityType == 4 ? FormatterCreator.asInt(n) : null), (Object)((Number)ObjectUtils.notNull((Object)(priorityType == 4 || priorityType == -5 ? FormatterCreator.asLong(n) : null), (Object)((Number)ObjectUtils.notNull((Object)(priorityType == 8 ? FormatterCreator.asDouble(n) : null), (Object)n))))));
            }
        });
        formatter.setParseBigDecimal(true);
        formatter.setMaximumFractionDigits(340);
        return formatter;
    }

    @Nullable
    private static Integer asInt(Number n) {
        try {
            return n instanceof Long && (long)n.intValue() == (Long)n ? Integer.valueOf(n.intValue()) : (n instanceof BigDecimal ? Integer.valueOf(((BigDecimal)n).intValueExact()) : null);
        }
        catch (ArithmeticException ignored) {
            return null;
        }
    }

    @Nullable
    private static Long asLong(Number n) {
        try {
            return n instanceof Long ? (Long)n : (n instanceof BigDecimal ? Long.valueOf(((BigDecimal)n).longValueExact()) : null);
        }
        catch (ArithmeticException ignored) {
            return null;
        }
    }

    private static Double asDouble(Number n) {
        return n instanceof Double ? (Double)n : (n instanceof BigDecimal && n.equals(BigDecimal.valueOf(n.doubleValue())) ? Double.valueOf(n.doubleValue()) : null);
    }

    @NotNull
    public static CompositeFormatter newShortZonedTimeFormat(int scale) {
        return FormatterCreator.newZonedTimeFormat(new ShortZonedTimeDelegate(), scale);
    }

    @NotNull
    public static CompositeFormatter newZonedTimeFormat(int scale) {
        return FormatterCreator.newZonedTimeFormat(new ZonedTimeDelegate(), scale);
    }

    @NotNull
    public static DateAndTimeFormatter<Time, OffsetTime> newTimeFormat() {
        return FormatterCreator.newTimeFormat(new TimeDelegate());
    }

    @NotNull
    public static <T, V extends TemporalAccessor> DateAndTimeFormatter<T, V> newTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(2);
        }
        Builders builders = new Builders();
        FormatterCreator.appendTime(builders);
        return new DateAndTimeFormatter<T, V>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), delegate);
    }

    @NotNull
    public static DateAndTimeFormatter<Timestamp, OffsetDateTime> newTimestampFormat(int scale) {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append(' ');
        builders.fb.appendPattern("[ ]");
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        return new DateAndTimeFormatter<Timestamp, OffsetDateTime>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate());
    }

    @NotNull
    public static CompositeFormatter newZonedTimestampFormat(@NotNull Dbms family, @Nullable DataConsumer.Column column2, int scale) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(3);
        }
        return FormatterCreator.newZonedTimestampFormat(family, new ZonedTimestampDelegate(), column2, scale);
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newZonedTimestampFormat(@NotNull Dbms family, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @Nullable DataConsumer.Column column2, int scale) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(5);
        }
        return FormatterCreator.newZonedTimestampFormat(delegate, BoundaryValueResolver.getResolver(family, column2), scale);
    }

    @NotNull
    public static Formatter newIsoFormatter(@NotNull DateAndTimeFormatterDelegate<?, ?> delegate) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(6);
        }
        return new DateAndTimeFormatter("ISO-8601", DateTimeFormatter.ISO_DATE_TIME, delegate);
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newZonedTimestampFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, int scale) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(7);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(8);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders);
        String pattern = builders.sb.toString();
        List mapped = ContainerUtil.map(formatters, f -> FormatterCreator.eraFormatter(pattern, f, delegate, resolver, false));
        return new CompositeFormatter(mapped);
    }

    @NotNull
    public static Formatter newEraTimestampFormat(@NotNull Dbms dbms, @Nullable DataConsumer.Column column2, int scale) {
        if (dbms == null) {
            FormatterCreator.$$$reportNull$$$0(9);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        return FormatterCreator.eraFormatter(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate(), BoundaryValueResolver.getResolver(dbms, column2), dbms.is(Dbms.ORACLE) && column2 == null || StringUtil.equalsIgnoreCase((CharSequence)"date", (CharSequence)column2.typeName));
    }

    @NotNull
    public static Formatter newShortEraZonedTimestampFormat(int scale) {
        return FormatterCreator.newShortZonedTimestampFormat(scale, (PairFunction<DateTimeFormatter, String, Formatter>)((PairFunction)(formatter, pattern) -> FormatterCreator.eraFormatter(pattern, formatter, new ShortZonedTimestampDelegate(), BoundaryValueResolver.ALWAYS_NULL, false)));
    }

    @NotNull
    public static EraDateAndTimeFormatter newEraDateFormatter(@Nullable Dbms family, @Nullable DataConsumer.Column column2) {
        return FormatterCreator.newEraDateFormatter(new DateDelegate(), family, column2);
    }

    @NotNull
    public static <T, V extends TemporalAccessor> EraDateAndTimeFormatter newEraDateFormatter(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @Nullable Dbms dbms, @Nullable DataConsumer.Column column2) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(10);
        }
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(dbms, column2);
        String pattern = builders.sb.toString();
        DateAndTimeFormatter<T, V> regular = new DateAndTimeFormatter<T, V>(pattern, FormatterCreator.toFormatter(builders.fb), delegate, resolver, null);
        builders.fb.appendPattern(ERA_PATTERN);
        DateAndTimeFormatter<T, V> era = new DateAndTimeFormatter<T, V>(pattern, FormatterCreator.toFormatter(builders.fb), delegate, resolver, null);
        return new EraDateAndTimeFormatter(regular, era);
    }

    @NotNull
    public static DateAndTimeFormatter<Date, LocalDate> newDateFormatter() {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        return new DateAndTimeFormatter<Date, LocalDate>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new DateDelegate());
    }

    @NotNull
    public static DateAndTimeFormatter<Date, LocalDateTime> newDateFormatWithTime() {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append('T');
        builders.fb.appendLiteral('T');
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, 3);
        builders.sb.append('Z');
        builders.fb.appendLiteral('Z');
        return new DateAndTimeFormatter<Date, LocalDateTime>(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new DateToLocalDateTimeDelegate());
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newZonedTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, int scale) {
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(11);
        }
        Builders builders = new Builders();
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders);
        String pattern = builders.sb.toString();
        List mapped = ContainerUtil.map(formatters, f -> new DateAndTimeFormatter(pattern, (DateTimeFormatter)f, delegate));
        return new CompositeFormatter(mapped);
    }

    public static boolean supportsEra(@NotNull Dbms family) {
        if (family == null) {
            FormatterCreator.$$$reportNull$$$0(12);
        }
        return family.isPostgres() || family.isOracle();
    }

    @NotNull
    private static Formatter newShortZonedTimestampFormat(int scale, @NotNull PairFunction<DateTimeFormatter, String, Formatter> mapper) {
        if (mapper == null) {
            FormatterCreator.$$$reportNull$$$0(13);
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        List<DateTimeFormatter> formatters = FormatterCreator.appendTimeZone(builders);
        String pattern = builders.sb.toString();
        return new CompositeFormatter(ContainerUtil.map(formatters, formatter -> (Formatter)mapper.fun(formatter, (Object)pattern)));
    }

    private static void appendTime(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(14);
        }
        builders.sb.append("HH:mm:ss");
        FormatterCreator.appendTime(builders.fb);
    }

    public static DateTimeFormatterBuilder appendTime(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(15);
        }
        return builder.parseLenient().optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().parseStrict();
    }

    @NotNull
    private static List<DateTimeFormatter> appendTimeZone(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(16);
        }
        return FormatterCreator.withZoneOffsets(builders, builder -> builder.appendOffset("+HH:MM:ss", "+00:00"), builder -> builder.appendOffset("+HH:mm", "+00:00"), builder -> builder.appendOffset("+HHmm", "+0000"), builder -> builder.appendZoneOrOffsetId());
    }

    @NotNull
    private static List<DateTimeFormatter> withZoneOffsets(@NotNull Builders builders, Consumer<DateTimeFormatterBuilder> ... consumers) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(17);
        }
        if (consumers == null) {
            FormatterCreator.$$$reportNull$$$0(18);
        }
        List list = ContainerUtil.append((List)ContainerUtil.map((Object[])consumers, c2 -> {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(FormatterCreator.toFormatter(builders.fb)).appendPattern("[ ]");
            c2.consume((Object)builder);
            return FormatterCreator.toFormatter(builder);
        }), (Object[])new DateTimeFormatter[]{FormatterCreator.toFormatter(builders.fb)});
        if (list == null) {
            FormatterCreator.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static void appendDate(@NotNull Builders builders) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(20);
        }
        builders.sb.append(DATE_PATTERN);
        FormatterCreator.appendDate(builders.fb);
    }

    public static DateTimeFormatterBuilder appendDate(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(21);
        }
        return builder.parseLenient().appendValue(ChronoField.YEAR_OF_ERA, 4, 7, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).parseStrict();
    }

    private static void appendFraction(@NotNull Builders builders, int scale) {
        if (builders == null) {
            FormatterCreator.$$$reportNull$$$0(22);
        }
        builders.sb.append(scale > 0 ? "." : "");
        for (int i2 = 0; i2 < scale; ++i2) {
            builders.sb.append('f');
        }
        if (scale > 0) {
            builders.fb.parseLenient().appendFraction(ChronoField.NANO_OF_SECOND, scale, scale, true).parseStrict();
        }
    }

    @NotNull
    private static <T, V extends TemporalAccessor> EraDateAndTimeFormatter eraFormatter(@NotNull String regular, @NotNull DateTimeFormatter regularFormatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, boolean omitEmptyTime) {
        Builders dateBuilders;
        if (regular == null) {
            FormatterCreator.$$$reportNull$$$0(23);
        }
        if (regularFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(24);
        }
        if (delegate == null) {
            FormatterCreator.$$$reportNull$$$0(25);
        }
        if (resolver == null) {
            FormatterCreator.$$$reportNull$$$0(26);
        }
        DateTimeFormatter era = FormatterCreator.toFormatter(new DateTimeFormatterBuilder().append(regularFormatter).appendPattern(ERA_PATTERN));
        Builders builders = dateBuilders = omitEmptyTime ? new Builders() : null;
        if (dateBuilders != null) {
            FormatterCreator.appendDate(dateBuilders);
        }
        return new EraDateAndTimeFormatter(new DateAndTimeFormatter<T, V>(regular, regularFormatter, delegate, resolver, dateBuilders == null ? null : FormatterCreator.toFormatter(dateBuilders.fb)), new DateAndTimeFormatter<T, V>(regular, era, delegate, resolver, dateBuilders == null ? null : FormatterCreator.toFormatter(dateBuilders.fb)));
    }

    @NotNull
    private static DateTimeFormatter toFormatter(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            FormatterCreator.$$$reportNull$$$0(27);
        }
        DateTimeFormatter dateTimeFormatter = builder.toFormatter(Locale.US);
        if (dateTimeFormatter == null) {
            FormatterCreator.$$$reportNull$$$0(28);
        }
        return dateTimeFormatter;
    }

    @NotNull
    private static Builders createBuildersForTimestamp(int scale) {
        Builders builders = new Builders();
        FormatterCreator.appendDate(builders);
        builders.sb.append(' ');
        builders.fb.appendPattern("[ ]");
        FormatterCreator.appendTime(builders);
        FormatterCreator.appendFraction(builders, scale);
        Builders builders2 = builders;
        if (builders2 == null) {
            FormatterCreator.$$$reportNull$$$0(29);
        }
        return builders2;
    }

    @NotNull
    private static NumberFormatter configureDecimalFormat(@NotNull DecimalFormat format) {
        if (format == null) {
            FormatterCreator.$$$reportNull$$$0(30);
        }
        format.setGroupingUsed(false);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setNaN("NaN");
        symbols.setInfinity("Infinity");
        symbols.setMinusSign('-');
        format.setDecimalFormatSymbols(symbols);
        return new NumberFormatter(format);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/FormatterCreator";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 15: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularFormatter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newIntFormat";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newLongFormat";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/FormatterCreator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withZoneOffsets";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toFormatter";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildersForTimestamp";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newTimeFormat";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimestampFormat";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newIsoFormatter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newEraTimestampFormat";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newEraDateFormatter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimeFormat";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsEra";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newShortZonedTimestampFormat";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendTime";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendTimeZone";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withZoneOffsets";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendDate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendFraction";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "eraFormatter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toFormatter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "configureDecimalFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Builders {
        private final StringBuilder sb = new StringBuilder();
        private final DateTimeFormatterBuilder fb = new DateTimeFormatterBuilder();

        private Builders() {
        }
    }
}

