/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.layoutedQueries;

import com.intellij.database.layoutedQueries.BaseSeanceRunner;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateCursor;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateSeance;
import com.intellij.database.remote.jdba.core.ResultLayout;
import java.lang.reflect.Array;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseQueryRunner<S>
implements DBQueryRunner<S>,
BaseSeanceRunner {
    @NotNull
    protected final IntegralIntermediateSeance myInterSeance;
    @NotNull
    private final ResultLayout<S> myResultLayout;
    @Nullable
    private IntegralIntermediateCursor<S> myCursor;
    private int myPackLimit;
    private boolean myMultiPackMode;

    protected BaseQueryRunner(@NotNull IntegralIntermediateSeance interSeance, @NotNull ResultLayout<S> resultLayout) {
        if (interSeance == null) {
            BaseQueryRunner.$$$reportNull$$$0(0);
        }
        if (resultLayout == null) {
            BaseQueryRunner.$$$reportNull$$$0(1);
        }
        this.myPackLimit = 0;
        this.myMultiPackMode = false;
        this.myInterSeance = interSeance;
        this.myResultLayout = resultLayout;
    }

    @Override
    @NotNull
    public synchronized BaseQueryRunner<S> withParams(Object ... params) {
        if (this.myCursor != null) {
            throw new IllegalStateException("Cursor is open. Close (or completely fetch) it before run the query again.");
        }
        if (params != null && params.length > 0) {
            this.myInterSeance.setInParameters(params);
        }
        BaseQueryRunner baseQueryRunner = this;
        if (baseQueryRunner == null) {
            BaseQueryRunner.$$$reportNull$$$0(2);
        }
        return baseQueryRunner;
    }

    @Override
    @NotNull
    public synchronized BaseQueryRunner<S> packBy(int rowsPerPack) {
        this.endFetching();
        this.myPackLimit = rowsPerPack;
        this.myMultiPackMode = true;
        BaseQueryRunner baseQueryRunner = this;
        if (baseQueryRunner == null) {
            BaseQueryRunner.$$$reportNull$$$0(3);
        }
        return baseQueryRunner;
    }

    @Override
    public synchronized S run() {
        this.start();
        return this.fetchPack();
    }

    @Override
    public synchronized void start() {
        this.endFetching();
        this.myInterSeance.setPackLimit(this.myPackLimit);
        this.myInterSeance.execute();
        this.myCursor = this.myInterSeance.openCursor(0, (ResultLayout)this.myResultLayout);
    }

    @Override
    public synchronized S nextPack() {
        if (this.myCursor != null) {
            return this.fetchPack();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S fetchPack() {
        assert (this.myCursor != null);
        boolean ok = false;
        try {
            Object result2 = this.myCursor.fetch();
            ok = true;
            Object object = result2 != null ? result2 : this.emptyResult();
            return (S)object;
        }
        finally {
            if (!(ok && this.myMultiPackMode && this.myCursor.hasRows())) {
                this.myCursor.close();
                this.myCursor = null;
            }
        }
    }

    private S emptyResult() {
        switch (this.myResultLayout.kind) {
            case ARRAY: {
                return (S)Array.newInstance(this.myResultLayout.row.rowClass, 0);
            }
            case ARRAY_OF_PRIMITIVES: {
                return (S)Array.newInstance(this.myResultLayout.row.rowClass, 0);
            }
            case LIST: {
                return (S)Collections.emptyList();
            }
            case SET: {
                return (S)Collections.emptySet();
            }
            case MAP: {
                return (S)Collections.emptyMap();
            }
        }
        return null;
    }

    public synchronized void endFetching() {
        if (this.myCursor != null) {
            this.myCursor.close();
            this.myCursor = null;
        }
    }

    @Override
    public synchronized void close() {
        this.endFetching();
        this.myInterSeance.close();
    }

    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        if (serviceClass == null) {
            BaseQueryRunner.$$$reportNull$$$0(4);
        }
        if (serviceName == null) {
            BaseQueryRunner.$$$reportNull$$$0(5);
        }
        return (I)this.myInterSeance.getSpecificService(serviceClass, serviceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interSeance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultLayout";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/layoutedQueries/BaseQueryRunner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/layoutedQueries/BaseQueryRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withParams";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "packBy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

