/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelIdIndex;
import com.intellij.database.model.ModelMemoryManager;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.psi.ModelNameIndexImpl;
import com.intellij.database.script.CompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.JBIterable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModel
implements BasicModModel {
    private static final AtomicInteger ourModelCounter = new AtomicInteger(0);
    private final int myModelInstanceNumber;
    @NotNull
    private ModelTextStorage myTextStorage;
    @NotNull
    private final ModelEntityStorage myEntityStorage;
    @NotNull
    private final Logger log;
    @NotNull
    private final ModelNameIndex myIndex;
    @NotNull
    private final ConcurrentMap<DasTypeAwareObject, DasType> myDasTypeCache;
    private final Set<BaseElement<?>> myLastCreatedElements;
    private final Set<BaseElement<?>> myLastModifiedElements;
    private final Set<BaseElement<?>> myLastRemovedElements;
    private final ReentrantReadWriteLock myLock;
    private volatile long myModificationThreadId;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners;
    private boolean myFastMode;
    private boolean myFrozen;
    private boolean myPreserveSources;

    @Override
    @NotNull
    public abstract BasicRoot getRoot();

    protected BaseModel(@NotNull ModelTextStorage textStorage) {
        ModelEntityStorage.Backend backend;
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(0);
        }
        this.myModelInstanceNumber = ourModelCounter.incrementAndGet();
        this.log = Logger.getInstance(this.getClass());
        this.myIndex = new ModelNameIndexImpl(this);
        this.myDasTypeCache = new ConcurrentHashMap<DasTypeAwareObject, DasType>();
        this.myLastCreatedElements = new HashSet();
        this.myLastModifiedElements = new HashSet();
        this.myLastRemovedElements = new HashSet();
        this.myLock = new ReentrantReadWriteLock();
        this.myModificationThreadId = Long.MIN_VALUE;
        this.myListeners = new CopyOnWriteArrayList();
        this.myTextStorage = textStorage;
        if (textStorage instanceof DbSrcModelStorageCore) {
            DbSrcModelStorageCore storage = (DbSrcModelStorageCore)textStorage;
            backend = storage.createEntityStorage((BasicMetaModel<?>)this.getMetaModel());
            ModelMemoryManager.getInstance().registerModel(this);
        } else {
            backend = ModelEntityStorage.NO_OP;
        }
        this.myEntityStorage = new ModelEntityStorage((BasicMetaModel<?>)this.getMetaModel(), backend);
    }

    public void moveEntities() {
        if (this.myTextStorage instanceof DbSrcModelStorageCore) {
            DbSrcModelStorageCore storage = (DbSrcModelStorageCore)this.myTextStorage;
            ModelEntityStorage.Backend backend = storage.createEntityStorage((BasicMetaModel<?>)this.getMetaModel());
            this.myEntityStorage.moveEntities(backend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            BaseModel.$$$reportNull$$$0(1);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            V v = reader.perform(this);
            return v;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public <R extends BasicModRoot> void modify(@NotNull Class<R> rootClass, @NotNull ModelModifier<? super R> modifier) {
        if (rootClass == null) {
            BaseModel.$$$reportNull$$$0(2);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(3);
        }
        this.modify(this.getRoot(), rootClass, modifier);
    }

    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element2, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(5);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(6);
        }
        this.modify(element2, clazz, this.myFastMode, modifier);
    }

    public <E extends BasicElement, M extends E> void modify(@NotNull E element2, @NotNull Class<M> clazz, boolean fast, @NotNull ModelModifier<? super M> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(8);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(9);
        }
        if (element2.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (!this.contains(element2)) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element2.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element2;
        this.modify(modElement, fast, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BasicElement> void modify(@NotNull E element2, boolean fast, @NotNull ModelModifier<? super E> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(10);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(11);
        }
        long time1 = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        writeLock.lock();
        long time2 = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Model entered into modifying mode (lock delay was " + (time2 - time1) + " ms)");
        }
        boolean prevFast = this.myFastMode;
        try {
            this.myFastMode = fast;
            this.clearModifications();
            this.myIndex.clear();
            this.myDasTypeCache.clear();
            this.myModificationThreadId = Thread.currentThread().getId();
            long time3 = System.currentTimeMillis();
            modifier.perform(element2);
            long time4 = System.currentTimeMillis();
            this.compactListeners();
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Model was modified during %d ms, %d created, %d updated, %d removed ", time4 - time3, this.myLastCreatedElements.size(), this.myLastModifiedElements.size(), this.myLastRemovedElements.size()));
            }
        }
        finally {
            long timeFreeze = System.currentTimeMillis();
            try {
                this.freezeAllData();
            }
            finally {
                this.myFastMode = prevFast;
                writeLock.unlock();
            }
            this.myModificationThreadId = Integer.MIN_VALUE;
            long time5 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Freezing took " + (time5 - timeFreeze) + " ms");
            }
            this.notifyListeners();
            this.clearModifications();
            long time6 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Listeners took " + (time6 - time5) + " ms");
            }
            long time7 = System.currentTimeMillis();
            this.removeDroppedSources();
            long time8 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Dropping sources took " + (time8 - time7) + " ms");
            }
        }
    }

    void doingObjectCreate(@NotNull BaseElement<?> element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(12);
        }
        this.doingAnyModification();
        if (this.shouldCollectChanges()) {
            this.myLastCreatedElements.add(element2);
        }
    }

    private boolean shouldCollectChanges() {
        return !this.myFastMode && this.myModificationThreadId != Integer.MIN_VALUE;
    }

    void doingObjectModify(@NotNull BaseElement<?> element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(13);
        }
        this.doingAnyModification();
        if (this.shouldCollectChanges()) {
            this.myLastModifiedElements.add(element2);
        }
    }

    void doingObjectRemove(@NotNull BaseElement<?> element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(14);
        }
        this.doingAnyModification();
        if (element2 instanceof BasicModIdentifiedElement) {
            ((BasicModIdentifiedElement)((Object)element2)).setObjectId(Long.MIN_VALUE);
        }
        if (!this.myPreserveSources && (element2 instanceof BasicSourceAware || element2 instanceof BasicNamespace)) {
            this.myTextStorage.queueDelete(element2);
        }
        if (this.shouldCollectChanges()) {
            this.myLastRemovedElements.add(element2);
        }
        element2.putToStorage(null);
    }

    private void doingAnyModification() {
        if (this.myFrozen) {
            throw new IllegalStateException("Model is frozen");
        }
    }

    public void setFrozen(boolean frozen) {
        this.myFrozen = frozen;
    }

    @Override
    public void addListener(@NotNull BasicModelListener listener2) {
        if (listener2 == null) {
            BaseModel.$$$reportNull$$$0(15);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull BasicModelListener listener2) {
        if (listener2 == null) {
            BaseModel.$$$reportNull$$$0(16);
        }
        this.myListeners.remove(listener2);
    }

    @Override
    public void clearModel() {
        BasicModModel.super.clearModel();
        this.myEntityStorage.clear();
    }

    @Override
    public void writeSources(@NotNull Runnable r) {
        if (r == null) {
            BaseModel.$$$reportNull$$$0(17);
        }
        this.myTextStorage.writeSession(this, r);
    }

    private void compactListeners() {
        this.myLastCreatedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastCreatedElements);
    }

    private void freezeAllData() {
        if (this.myFastMode) {
            for (BaseElement element2 : this.basicTraverser().filter(BaseElement.class)) {
                element2.freezeData();
            }
        } else {
            for (BaseElement<?> element3 : this.myLastCreatedElements) {
                element3.freezeData();
            }
            for (BaseElement<?> element3 : this.myLastModifiedElements) {
                element3.freezeData();
            }
        }
    }

    private void notifyListeners() {
        if (this.myLastCreatedElements.isEmpty() && this.myLastModifiedElements.isEmpty() && this.myLastRemovedElements.isEmpty()) {
            return;
        }
        Set<BasicElement> lastCreatedElements = Collections.unmodifiableSet(this.myLastCreatedElements);
        Set<BasicElement> lastModifiedElements = Collections.unmodifiableSet(this.myLastModifiedElements);
        Set<BasicElement> lastRemovedElements = Collections.unmodifiableSet(this.myLastRemovedElements);
        for (BasicModelListener listener2 : this.myListeners) {
            listener2.modified(lastCreatedElements, lastModifiedElements, lastRemovedElements);
        }
    }

    private void removeDroppedSources() {
        this.myTextStorage.flushQueues();
    }

    private void clearModifications() {
        this.myLastCreatedElements.clear();
        this.myLastModifiedElements.clear();
        this.myLastRemovedElements.clear();
    }

    public void preserveSources(Runnable r) {
        boolean prev = this.myPreserveSources;
        this.myPreserveSources = true;
        try {
            r.run();
        }
        finally {
            this.myPreserveSources = prev;
        }
    }

    @Override
    @NotNull
    public ModelNameIndex getNameIndex() {
        ModelNameIndex modelNameIndex = this.myIndex;
        if (modelNameIndex == null) {
            BaseModel.$$$reportNull$$$0(18);
        }
        return modelNameIndex;
    }

    @Override
    @NotNull
    public DasType getCacheableDasType(@NotNull DasTypeAwareObject element2, @NotNull Supplier<? extends DasType> computeType) {
        DasType dasType;
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(19);
        }
        if (computeType == null) {
            BaseModel.$$$reportNull$$$0(20);
        }
        if ((dasType = (DasType)this.myDasTypeCache.get(element2)) == null) {
            dasType = (DasType)ConcurrencyUtil.cacheOrGet(this.myDasTypeCache, (Object)element2, (Object)computeType.get());
        }
        DasType dasType2 = dasType;
        if (dasType2 == null) {
            BaseModel.$$$reportNull$$$0(21);
        }
        return dasType2;
    }

    @Override
    public void saveSourceText(@NotNull BasicSourceAware object, @Nullable CompositeText sourceText) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(22);
        }
        this.myTextStorage.save(object, sourceText);
    }

    @Override
    @Nullable
    public CompositeText loadSourceText(@NotNull BasicSourceAware object) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(23);
        }
        return this.myTextStorage.load(object);
    }

    @Override
    public void setSchemaSourcesVersion(@NotNull BasicSchema schema, @Nullable Long version) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(24);
        }
        this.myTextStorage.setVersion(schema, version);
    }

    @Override
    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema schema) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(25);
        }
        return this.myTextStorage.getVersion(schema);
    }

    public void setTextStorage(@NotNull ModelTextStorage textStorage) {
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(26);
        }
        this.myTextStorage = textStorage;
    }

    @Override
    @NotNull
    public ModelTextStorage getTextStorage() {
        ModelTextStorage modelTextStorage = this.myTextStorage;
        if (modelTextStorage == null) {
            BaseModel.$$$reportNull$$$0(27);
        }
        return modelTextStorage;
    }

    @Override
    public void shelve(boolean clear2) {
        if (clear2) {
            this.myEntityStorage.clear();
        }
        this.myEntityStorage.shelve();
    }

    void handleRename(@NotNull BaseElement<?> e, @NotNull String oldName) {
        if (e == null) {
            BaseModel.$$$reportNull$$$0(28);
        }
        if (oldName == null) {
            BaseModel.$$$reportNull$$$0(29);
        }
        if (oldName.isEmpty()) {
            return;
        }
        this.getTextStorage().handleRename(e, oldName);
    }

    private static <B extends ImmutableCollection.Builder<T>, T> B deduplicateStrings(@NotNull Collection<T> v, B builder) {
        if (v == null) {
            BaseModel.$$$reportNull$$$0(30);
        }
        for (T t : v) {
            builder.add(BaseModel.deduplicateIfString(t));
        }
        return builder;
    }

    private static <B extends ImmutableMap.Builder<K, V>, K, V> B deduplicateStrings(@NotNull Map<K, V> v, B builder) {
        if (v == null) {
            BaseModel.$$$reportNull$$$0(31);
        }
        for (Map.Entry<K, V> t : v.entrySet()) {
            builder.put(BaseModel.deduplicateIfString(t.getKey()), BaseModel.deduplicateIfString(t.getValue()));
        }
        return builder;
    }

    private static <T> T deduplicateIfString(T t) {
        return (T)(t instanceof String ? DbUtil.intern((String)t) : t);
    }

    @NotNull
    protected static <T> List<T> immutable(@Nullable List<T> v) {
        if (v == null || v.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                BaseModel.$$$reportNull$$$0(32);
            }
            return immutableList;
        }
        if (v instanceof ImmutableList || !(v.get(0) instanceof String)) {
            ImmutableList immutableList = ImmutableList.copyOf(v);
            if (immutableList == null) {
                BaseModel.$$$reportNull$$$0(33);
            }
            return immutableList;
        }
        ImmutableList immutableList = BaseModel.deduplicateStrings(v, ImmutableList.builderWithExpectedSize((int)v.size())).build();
        if (immutableList == null) {
            BaseModel.$$$reportNull$$$0(34);
        }
        return immutableList;
    }

    @NotNull
    protected static <T> Set<T> immutable(@Nullable Set<T> v) {
        if (v == null || v.isEmpty()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                BaseModel.$$$reportNull$$$0(35);
            }
            return immutableSet;
        }
        if (v instanceof ImmutableSet || !(v.iterator().next() instanceof String)) {
            ImmutableSet immutableSet = ImmutableSet.copyOf(v);
            if (immutableSet == null) {
                BaseModel.$$$reportNull$$$0(36);
            }
            return immutableSet;
        }
        ImmutableSet immutableSet = BaseModel.deduplicateStrings(v, ImmutableSet.builderWithExpectedSize((int)v.size())).build();
        if (immutableSet == null) {
            BaseModel.$$$reportNull$$$0(37);
        }
        return immutableSet;
    }

    @NotNull
    protected static <K, V> Map<K, V> immutable(@Nullable Map<K, V> v) {
        if (v == null || v.isEmpty()) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                BaseModel.$$$reportNull$$$0(38);
            }
            return immutableMap;
        }
        if (v instanceof ImmutableMap || !(v.keySet().iterator().next() instanceof String) && !(v.values().iterator().next() instanceof String)) {
            ImmutableMap immutableMap = ImmutableMap.copyOf(v);
            if (immutableMap == null) {
                BaseModel.$$$reportNull$$$0(39);
            }
            return immutableMap;
        }
        ImmutableMap immutableMap = BaseModel.deduplicateStrings(v, ImmutableMap.builderWithExpectedSize((int)v.size())).build();
        if (immutableMap == null) {
            BaseModel.$$$reportNull$$$0(40);
        }
        return immutableMap;
    }

    @NotNull
    protected static String deduplicate(@NotNull String str) {
        if (str == null) {
            BaseModel.$$$reportNull$$$0(41);
        }
        String string = str.isEmpty() ? ModelConsts.NO_NAME : DbUtil.intern2(str);
        if (string == null) {
            BaseModel.$$$reportNull$$$0(42);
        }
        return string;
    }

    protected static String deduplicateNullable(@Nullable String str) {
        return StringUtil.isEmpty((String)str) ? null : DbUtil.intern2(str);
    }

    @Nullable
    @Contract(value="null,_ -> null", pure=true)
    protected static <X> X findFirst(@Nullable Iterable<? extends X> items2, @NotNull Predicate<? super X> predicate) {
        if (predicate == null) {
            BaseModel.$$$reportNull$$$0(43);
        }
        if (items2 == null) {
            return null;
        }
        for (X item : items2) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    protected static boolean eq(@Nullable Object value1, @Nullable Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    protected static boolean eq(@Nullable String value1, @Nullable String value2) {
        return BaseModel.eq((Object)StringUtil.nullize((String)value1), (Object)StringUtil.nullize((String)value2));
    }

    public int hashCode() {
        return this.myModelInstanceNumber;
    }

    public String toString() {
        return String.format("%s model [instance %d]", this.getDbms().getName(), this.myModelInstanceNumber);
    }

    public static boolean isLoaded(@NotNull BasicElement e) {
        BaseElement element2;
        if (e == null) {
            BaseModel.$$$reportNull$$$0(44);
        }
        return (element2 = (BaseElement)ObjectUtils.tryCast((Object)e, BaseElement.class)) != null && BaseElement.asData(element2.myData) != null;
    }

    public static boolean forceLoad(@NotNull BasicElement e) {
        if (e == null) {
            BaseModel.$$$reportNull$$$0(45);
        }
        if (BaseModel.isLoaded(e)) {
            return true;
        }
        BaseElement element2 = (BaseElement)ObjectUtils.tryCast((Object)e, BaseElement.class);
        if (element2 != null) {
            element2.getData();
        }
        return BaseModel.isLoaded(e);
    }

    public static boolean forceUnload(@NotNull BasicElement e) {
        if (e == null) {
            BaseModel.$$$reportNull$$$0(46);
        }
        if (!BaseModel.isLoaded(e)) {
            return true;
        }
        BaseElement element2 = (BaseElement)ObjectUtils.tryCast((Object)e, BaseElement.class);
        return element2 != null && element2.unload();
    }

    @Nullable
    public static Integer getPersistentEntityId(@Nullable BasicElement e) {
        BaseElement element2 = (BaseElement)ObjectUtils.tryCast((Object)e, BaseElement.class);
        return element2 != null && element2.getModel().myEntityStorage.isPersistent() ? Integer.valueOf(element2.myEntityId) : null;
    }

    public static boolean isPersistent(BasicModModel m) {
        BaseModel model = (BaseModel)ObjectUtils.tryCast((Object)m, BaseModel.class);
        return model != null && model.myEntityStorage.isPersistent();
    }

    public static boolean restoreFromStorage(BasicModModel m) {
        BaseModel model = (BaseModel)ObjectUtils.tryCast((Object)m, BaseModel.class);
        if (model == null || !model.myEntityStorage.isPersistent()) {
            return false;
        }
        Ref res2 = Ref.create((Object)false);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        model.modify(BaseRoot.class, r -> {
            BaseRoot er = r;
            for (ModFamily modFamily : er.getFamilies()) {
                modFamily.clear();
            }
            res2.set((Object)model.myEntityStorage.processHierarchy(er.myEntityId, er, (entityId, kind, name, objectId, parent2) -> {
                ModelIdIndex index2;
                if (parent2 == null) {
                    return null;
                }
                Family family = parent2.familyOf(kind);
                if (family == null) {
                    return null;
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                Object child = ((BaseFamily)family).createNewOne(entityId);
                ((BaseElement)child).setData(name, null);
                if (objectId != Long.MIN_VALUE && child instanceof BasicIdentifiedElement && (index2 = ModelIdIndex.getIndex(child.getDatabase())) != null) {
                    index2.registerIdentifiedElement(objectId, (BasicIdentifiedElement)child);
                }
                return child;
            }));
        });
        return (Boolean)res2.get();
    }

    protected static <S extends BasicElement, T extends BasicElement> void bind(BasicMetaReference<S, T> ref, BasicMetaObject<?> scope, BasicMetaObject<? extends T> ... targets2) {
        ref.scope = scope;
        System.arraycopy(targets2, 0, ref.targets, 0, targets2.length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeType";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 28: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheableDasType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStorage";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "immutable";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectCreate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectModify";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectRemove";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeSources";
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableDasType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaSourcesVersion";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSourcesVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setTextStorage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateStrings";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isLoaded";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "forceLoad";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "forceUnload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class NullFamily<T extends BasicModNamedElement & BasicModArrangedElement>
    implements ModPositioningNamingFamily<T>,
    ModNamingIdentifyingFamily<T>,
    ModSingletonFamily<T> {
        public static final NullFamily INSTANCE = new NullFamily();

        protected NullFamily() {
        }

        @Override
        public void markChildrenAsSyncPending() {
        }

        @Override
        public void removeSyncPendingChildren() {
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return "null-family";
        }

        @Override
        @NotNull
        public T first() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(@Nullable BasicElement element2) {
            return -1;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @NotNull
        public BasicMetaObject<T> getMetaObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createNewOne() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createNewOne(@Nullable BasicDataObject data) {
            BasicModElement basicModElement = this.createNewOne();
            if (basicModElement == null) {
                NullFamily.$$$reportNull$$$0(0);
            }
            return (T)basicModElement;
        }

        @Override
        public void remove(@NotNull Predicate condition) {
            if (condition == null) {
                NullFamily.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void sort() {
        }

        @Override
        public void clear() {
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator = JBIterable.empty().iterator();
            if (iterator == null) {
                NullFamily.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        @Override
        public T renewAt(short position, @NotNull String name) {
            if (name == null) {
                NullFamily.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public T createOrGet(@NotNull String name) {
            if (name == null) {
                NullFamily.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public T createOrGetAt(short position) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T get() {
            return null;
        }

        @Override
        @NotNull
        public T createOrGet() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T renew(long objectId, String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T renew(long objectId, String name, BiConsumer<String, String> renameHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public T createOrGet(long objectId) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$NullFamily";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$NullFamily";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "renewAt";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createOrGet";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class BaseIdentifyingFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements ModIdentifyingFamily<E> {
        public BaseIdentifyingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            return BaseIdentifyingFamily.createOrGetImpl(objectId, this);
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            return BaseIdentifyingFamily.getByObjectIdImpl(objectId, this);
        }

        @NotNull
        static <E extends BaseElement<?>> E createOrGetImpl(long objectId, ModIdentifyingFamily<E> f) {
            BaseElement element2 = (BaseElement)f.getByObjectId(objectId);
            if (element2 == null) {
                element2 = (BaseElement)f.createNewOne();
                ((BasicModIdentifiedElement)((Object)element2)).setObjectId(objectId);
            } else {
                element2.resetSyncPending();
            }
            BaseElement baseElement = element2;
            if (baseElement == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(3);
            }
            return (E)baseElement;
        }

        @Nullable
        static <E extends BaseElement<?>> E getByObjectIdImpl(long objectId, BaseFamily<E> f) {
            List elements = f.myElements;
            if (elements == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (((BasicIdentifiedElement)((Object)element2)).getObjectId() != objectId) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGetImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class BaseNamingIdentifyingFamily<E extends BaseElement<?> & BasicModIdentifiedElement>
    extends BaseNamingFamily<E>
    implements ModNamingIdentifyingFamily<E> {
        public BaseNamingIdentifyingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String string) {
            void name;
            if (string == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(3);
            }
            E e = this.renew(objectId, (String)name, (String s2, String s22) -> {});
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(4);
            }
            return e;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String name, @NotNull BiConsumer<String, String> biConsumer) {
            E e;
            if (name == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(5);
            }
            if (biConsumer == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(6);
            }
            if (objectId != Long.MIN_VALUE && (e = this.getByObjectId(objectId)) != null) {
                String oldName = ((BasicNamedElement)e).getName();
                ((BasicModNamedElement)e).setName(name);
                ((BaseElement)e).resetSyncPending();
                String newName = ((BasicNamedElement)e).getName();
                if (!Objects.equals(oldName, newName)) {
                    void renameHandler;
                    renameHandler.accept(oldName, newName);
                }
                E e2 = e;
                if (e2 == null) {
                    BaseNamingIdentifyingFamily.$$$reportNull$$$0(7);
                }
                return e2;
            }
            List elements = this.myElements;
            if (elements != null && name != ModelConsts.NO_NAME) {
                for (BaseElement e3 : elements) {
                    if (((BasicIdentifiedElement)((Object)e3)).getObjectId() != Long.MIN_VALUE || !((BasicNamedElement)((Object)e3)).getName().equals(name)) continue;
                    ((BasicModIdentifiedElement)((Object)e3)).setObjectId(objectId);
                    e3.resetSyncPending();
                    BaseElement baseElement = e3;
                    if (baseElement == null) {
                        BaseNamingIdentifyingFamily.$$$reportNull$$$0(8);
                    }
                    return (E)baseElement;
                }
            }
            BaseElement e4 = this.createNewOne();
            ((BasicModIdentifiedElement)((Object)e4)).setObjectId(objectId);
            ((BasicModNamedElement)((Object)e4)).setName(name);
            BaseElement baseElement = e4;
            if (baseElement == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(9);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object e = BaseIdentifyingFamily.createOrGetImpl(objectId, this);
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(10);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            return BaseIdentifyingFamily.getByObjectIdImpl(objectId, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renameHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renew";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "renew";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface BasePositioningFamilyMixin<E extends BaseElement<?>>
    extends ModPositioningFamily<E> {
        @Override
        default public E createOrGetAt(short position) {
            List elements = ((BaseFamily)((Object)this)).myElements;
            if (elements == null) {
                BaseElement element2 = (BaseElement)this.createNewOne();
                ((BasicModArrangedElement)((Object)element2)).setPosition(position);
                CopyOnWriteArrayList<BaseElement> newElements = new CopyOnWriteArrayList<BaseElement>();
                newElements.add(element2);
                ((BaseFamily)((Object)this)).myElements = newElements;
                return (E)element2;
            }
            for (BaseElement element3 : elements) {
                if (((BasicArrangedElement)((Object)element3)).getPosition() != position) continue;
                element3.resetSyncPending();
                return (E)element3;
            }
            BaseElement element2 = (BaseElement)this.createNewOne();
            ((BasicModArrangedElement)((Object)element2)).setPosition(position);
            return (E)element2;
        }

        @Override
        @Nullable
        default public E getByNaturalPosition(short position) {
            List elements = ((BaseFamily)((Object)this)).myElements;
            return (E)BaseModel.findFirst(elements, e -> ((BasicArrangedElement)((Object)e)).getPosition() == position);
        }
    }

    protected static class BasePositioningFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements BasePositioningFamilyMixin<E> {
        public BasePositioningFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BasePositioningFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BasePositioningFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BasePositioningFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/model/BaseModel$BasePositioningFamily";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class BasePositioningNamingFamily<E extends BaseElement<? extends BasicModNamedElement> & BasicModNamedElement>
    extends BaseNamingFamily<E>
    implements ModPositioningNamingFamily<E>,
    BasePositioningFamilyMixin<E> {
        public BasePositioningNamingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        public E renewAt(short position, @NotNull String name) {
            List elements;
            BaseElement e;
            if (name == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(3);
            }
            if ((e = BaseModel.findFirst(elements = this.myElements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName().equals(name))) != null) {
                e.resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName() == ModelConsts.NO_NAME);
            if (e != null) {
                ((BasicModNamedElement)((Object)e)).setName(name);
                e.resetSyncPending();
                return (E)e;
            }
            if (!(position != 0 && name.equals(ModelConsts.NO_NAME) || (e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == 0 && ((BasicNamedElement)((Object)x)).getName().equals(name))) == null)) {
                ((BasicModArrangedElement)((Object)e)).setPosition(position);
                e.resetSyncPending();
                return (E)e;
            }
            e = this.createNewOne();
            ((BasicModArrangedElement)((Object)e)).setPosition(position);
            ((BasicModNamedElement)((Object)e)).setName(name);
            return (E)e;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BasePositioningNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renewAt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BaseNamingFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements ModNamingFamily<E> {
        public BaseNamingFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseNamingFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseNamingFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseNamingFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        public E createOrGet(@NotNull String name) {
            Object element2;
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(3);
            }
            if ((element2 = this.get(name)) == null) {
                element2 = this.createNewOne();
                ((BasicModNamedElement)element2).setName(name);
            } else {
                ((BaseElement)element2).resetSyncPending();
            }
            return element2;
        }

        @Override
        @Nullable
        public E get(@NotNull String name) {
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(4);
            }
            return this.get(name, true);
        }

        @Override
        @Nullable
        public E get(@NotNull String name, boolean caseSensitive) {
            List elements;
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(5);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                boolean matched = caseSensitive ? ((BasicNamedElement)((Object)element2)).getName().equals(name) : ((BasicNamedElement)((Object)element2)).getName().equalsIgnoreCase(name);
                if (!matched) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createOrGet";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class BaseSingletonFamily<E extends BaseElement<?>>
    extends BaseFamily<E>
    implements ModSingletonFamily<E> {
        public BaseSingletonFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseSingletonFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseSingletonFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseSingletonFamily.$$$reportNull$$$0(2);
            }
            super(owner, kind, factory);
        }

        @Override
        @Nullable
        public E get() {
            List elements = this.myElements;
            return (E)(elements == null ? null : (BaseElement)elements.get(0));
        }

        @Override
        @NotNull
        public E createNewOne(int entityId) {
            this.owner.modifying(false);
            assert (this.myElements == null);
            Object newOne = this.instantiate(entityId);
            this.myElements = Collections.singletonList(newOne);
            Object e = newOne;
            if (e == null) {
                BaseSingletonFamily.$$$reportNull$$$0(3);
            }
            return e;
        }

        @Override
        @NotNull
        public E createOrGet() {
            if (this.isEmpty()) {
                BasicModElement basicModElement = this.createNewOne();
                if (basicModElement == null) {
                    BaseSingletonFamily.$$$reportNull$$$0(4);
                }
                return (E)basicModElement;
            }
            BasicElement basicElement = this.first();
            if (basicElement == null) {
                BaseSingletonFamily.$$$reportNull$$$0(5);
            }
            return (E)basicElement;
        }

        @Override
        public void sort() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class BaseFamily<E extends BaseElement<?>>
    implements HostFamily<E>,
    ModFamily<E> {
        @NotNull
        public final BaseElement<?> owner;
        @Nullable
        protected volatile List<E> myElements;
        private final BasicMetaObject<?> myMeta;
        private final BaseFactory<E> myFactory;

        public BaseFamily(@NotNull BaseElement<?> owner, @NotNull ObjectKind kind, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                BaseFamily.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                BaseFamily.$$$reportNull$$$0(2);
            }
            this(owner, Objects.requireNonNull(BasicMetaUtils.findChild(owner.getMetaObject(), kind)), factory);
        }

        public BaseFamily(@NotNull BaseElement<?> owner, @NotNull BasicMetaObject<?> meta, @NotNull BaseFactory<E> factory) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(3);
            }
            if (meta == null) {
                BaseFamily.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                BaseFamily.$$$reportNull$$$0(5);
            }
            this.myElements = null;
            this.owner = owner;
            this.myMeta = meta;
            this.myFactory = factory;
        }

        @Override
        @NotNull
        public BasicMetaObject<?> getMetaObject() {
            BasicMetaObject<?> basicMetaObject = this.myMeta;
            if (basicMetaObject == null) {
                BaseFamily.$$$reportNull$$$0(6);
            }
            return basicMetaObject;
        }

        @Override
        @NotNull
        public BasicElement getHost() {
            BaseElement<?> baseElement = this.owner;
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(7);
            }
            return baseElement;
        }

        @Override
        @NotNull
        public ObjectKind getChildrenKind() {
            ObjectKind objectKind = this.myMeta.kind;
            if (objectKind == null) {
                BaseFamily.$$$reportNull$$$0(8);
            }
            return objectKind;
        }

        @Override
        public void removeSyncPendingChildren() {
            this.remove(BasicModMixinElement::isSyncPending);
        }

        @Override
        public void markChildrenAsSyncPending() {
            for (BaseElement e : this) {
                e.setSyncPending(true);
            }
        }

        @NotNull
        protected E instantiate(int entityId) {
            E e = this.myFactory.create(this, entityId);
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(9);
            }
            return e;
        }

        @Override
        @NotNull
        public E createNewOne() {
            E e = this.createNewOne(this.getModel().myEntityStorage.allocateEntityId());
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(10);
            }
            return e;
        }

        @NotNull
        public E createNewOne(int entityId) {
            BaseModel model = this.owner.getModel();
            this.owner.modifying(false);
            E newOne = this.instantiate(entityId);
            if (this.myElements == null) {
                this.myElements = new CopyOnWriteArrayList();
            }
            this.myElements.add(newOne);
            model.doingObjectCreate((BaseElement<?>)newOne);
            E e = newOne;
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(11);
            }
            return e;
        }

        @Override
        @NotNull
        public E createNewOne(@Nullable BasicDataObject data) {
            BasicModElement newOne = this.createNewOne();
            ((BaseElement)newOne).setData(data, false, null);
            BasicModElement basicModElement = newOne;
            if (basicModElement == null) {
                BaseFamily.$$$reportNull$$$0(12);
            }
            return (E)basicModElement;
        }

        @Override
        @NotNull
        public BaseModel getModel() {
            BaseModel baseModel = this.owner.getModel();
            if (baseModel == null) {
                BaseFamily.$$$reportNull$$$0(13);
            }
            return baseModel;
        }

        @Override
        @NotNull
        public E first() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(0);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(14);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E last() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(elements.size() - 1);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(15);
            }
            return (E)baseElement;
        }

        @Override
        public int indexOf(@Nullable BasicElement element2) {
            if (element2 == null) {
                return -1;
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return -1;
            }
            return elements.indexOf(element2);
        }

        @Override
        public boolean hasChildren() {
            List<E> elements = this.myElements;
            return elements != null && !elements.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            List<E> elements = this.myElements;
            return elements == null || elements.isEmpty();
        }

        @Override
        public int size() {
            List<E> elements = this.myElements;
            return elements != null ? elements.size() : 0;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            List<E> elements;
            if (predicate == null) {
                BaseFamily.$$$reportNull$$$0(16);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (!predicate.test(element2)) continue;
                return (E)element2;
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            List<E> elements = this.myElements;
            if (elements != null) {
                return elements.iterator();
            }
            return Collections.emptyListIterator();
        }

        @Override
        public void remove(@NotNull Predicate<? super E> condition) {
            List<E> elements;
            if (condition == null) {
                BaseFamily.$$$reportNull$$$0(17);
            }
            if ((elements = this.myElements) == null) {
                return;
            }
            int n = elements.size();
            boolean modificationSent = false;
            for (int i2 = n - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                if (!condition.test(e)) continue;
                if (!modificationSent) {
                    modificationSent = true;
                    this.owner.modifying(false);
                }
                e.internalDrop(false);
                if (elements.size() >= 2) {
                    elements.remove(i2);
                    continue;
                }
                this.myElements = null;
            }
            if (elements.isEmpty()) {
                this.myElements = null;
            }
        }

        @Override
        public void sort() {
            List<E> elements = this.myElements;
            if (elements == null || elements.size() < 2) {
                return;
            }
            this.owner.modifying(false);
            if (!(elements instanceof ArrayList) && !(elements instanceof CopyOnWriteArrayList)) {
                throw new IllegalStateException("Unknown how to reorder elements inside a " + elements.getClass().getSimpleName());
            }
            Comparator<E> comparator2 = this.getElementsComparator();
            elements.sort(comparator2);
        }

        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.DISPLAY_ORDER_COMPARATOR;
        }

        @Override
        public void clear() {
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            this.owner.modifying(false);
            this.myElements = null;
            for (int i2 = elements.size() - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                e.internalDrop(false);
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.myMeta.kind.code();
            if (string == null) {
                BaseFamily.$$$reportNull$$$0(18);
            }
            return string;
        }

        public String toString() {
            StringBuilder bf = new StringBuilder();
            if (this.isEmpty()) {
                bf.append("Empty Family of ");
            } else {
                bf.append("Family of ").append(this.size()).append(' ');
            }
            bf.append(this.getChildrenKind().getPresentableName());
            BaseElement<?> host = this.owner;
            bf.append(" (host: ").append(host.getKind().getPresentableName()).append(' ').append(host.identity()).append(')');
            return bf.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenKind";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiate";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    protected static interface BaseFactory<E extends BaseElement<?>> {
        public E create(BaseFamily<E> var1, int var2);
    }

    protected static abstract class BaseRegularElement<D extends BasicModElement>
    extends BaseElement<D> {
        @NotNull
        protected final BaseFamily<? extends BaseElement<D>> myParentFamily;
        private transient boolean myDropped;
        private transient boolean mySyncPending;

        public BaseRegularElement(@NotNull BaseFamily<? extends BaseElement<D>> parentFamily, int entityId) {
            if (parentFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(0);
            }
            super(entityId);
            this.myDropped = false;
            this.mySyncPending = false;
            this.myParentFamily = parentFamily;
        }

        @NotNull
        public BaseFamily<? extends BaseElement<D>> getParentFamily() {
            BaseFamily<? extends BaseElement<D>> baseFamily = this.myParentFamily;
            if (baseFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(1);
            }
            return baseFamily;
        }

        @Override
        @NotNull
        public BaseModel getModel() {
            BaseModel baseModel = this.myParentFamily.getModel();
            if (baseModel == null) {
                BaseRegularElement.$$$reportNull$$$0(2);
            }
            return baseModel;
        }

        @Override
        @NotNull
        public BasicMetaObject<D> getMetaObject() {
            BasicMetaObject<?> basicMetaObject = ((BaseFamily)this.getParentFamily()).getMetaObject();
            if (basicMetaObject == null) {
                BaseRegularElement.$$$reportNull$$$0(3);
            }
            return basicMetaObject;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            this.mySyncPending = syncPending;
        }

        @Override
        public boolean isSyncPending() {
            return this.mySyncPending;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            this.getModel().doingObjectRemove(this);
            BasicModMixinElement.dropChildren(this);
            if (removeFromParent) {
                ((BaseFamily)this.getParentFamily()).remove(e -> e == this);
            }
            this.myDropped = true;
        }

        @Override
        public boolean isDropped() {
            return this.myDropped;
        }

        public String toString() {
            return this.identity(true) + ": " + StringUtil.toLowerCase((String)this.getKind().name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentFamily";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class LightBaseRegularElement
    extends LightBaseElement {
        protected LightBaseRegularElement() {
        }

        @Nullable
        public Family<?> getParentFamily() {
            return null;
        }

        public String toString() {
            return this.identity(true) + ": " + this.getKind().name().toLowerCase(Locale.ROOT);
        }
    }

    protected static abstract class BaseRoot<D extends BasicModRoot>
    extends BaseElement<D>
    implements BasicModRoot {
        private final BaseModel myModel;

        protected BaseRoot(@NotNull BaseModel model) {
            if (model == null) {
                BaseRoot.$$$reportNull$$$0(0);
            }
            super(model.myEntityStorage.rootEntityId());
            this.myModel = model;
        }

        @Override
        public @Nullable Family<@NotNull ? extends BasicElement> getParentFamily() {
            return null;
        }

        @Override
        @NotNull
        public BaseModel getModel() {
            BaseModel baseModel = this.myModel;
            if (baseModel == null) {
                BaseRoot.$$$reportNull$$$0(1);
            }
            return baseModel;
        }

        @Override
        @Nullable
        public BaseElement<?> getParent() {
            return null;
        }

        @Override
        @Nullable
        public BasicSchema getSchema() {
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                BaseRoot.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            if (syncPending) {
                throw new IllegalStateException("Cannot set the root element as sync pending");
            }
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            throw new IllegalStateException("Cannot drop a root element");
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        public String toString() {
            return "ROOT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class LightBaseRoot
    extends LightBaseElement
    implements BasicModRoot {
        protected LightBaseRoot() {
        }

        @NotNull
        protected Dbms validateDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                LightBaseRoot.$$$reportNull$$$0(0);
            }
            if (this.getMetaObject().getModel() != DbImplUtilCore.getMetaModel(dbms)) {
                throw new AssertionError((Object)(dbms.getName() + " does not match " + this.getMetaObject().getModel().dbms));
            }
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                LightBaseRoot.$$$reportNull$$$0(1);
            }
            return dbms2;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                LightBaseRoot.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return "ROOT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateDbms";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "validateDbms";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class BaseElement<D extends BasicModElement>
    implements BasicHierarchicalObject {
        private static final AtomicFieldUpdater<BaseElement<?>, Object> ourDataUpdater = AtomicFieldUpdater.forFieldOfType(BaseElement.class, Object.class);
        @Nullable
        private volatile Object myData;
        private final int myEntityId;

        protected BaseElement(int entityId) {
            this.myEntityId = entityId;
        }

        private boolean setData(@Nullable Object data, @Nullable Object prev) {
            return data == this.myData || ourDataUpdater.compareAndSet((Object)this, prev, data);
        }

        protected boolean setData(@Nullable BasicDataObject data, boolean freeze, @Nullable Object prev) {
            BasicDataObject newData = data == null || data.isFrozen() || freeze ? this.putToStorage(data) : data;
            return this.setData(newData, prev);
        }

        @Nullable
        private BasicDataObject putToStorage(@Nullable BasicDataObject data) {
            int parentId;
            BaseElement parent2 = (BaseElement)ObjectUtils.tryCast((Object)this.getParent(), BaseElement.class);
            int n = parentId = parent2 == null ? Integer.MIN_VALUE : parent2.myEntityId;
            if (this.isUnderSubstituted()) {
                this.getEntityStorage().setDataObject(this.myEntityId, parentId, null);
                return data;
            }
            return this.getEntityStorage().setDataObject(this.myEntityId, parentId, data);
        }

        private boolean isUnderSubstituted() {
            BasicNamespace nsp = DasUtil.getParentOfClass(this, BasicNamespace.class, true);
            while (nsp != null) {
                if (nsp.isSubstituted()) {
                    return true;
                }
                nsp = (BasicNamespace)ObjectUtils.tryCast((Object)nsp.getParent(), BasicNamespace.class);
            }
            return false;
        }

        private boolean isPersisted() {
            return this.getEntityStorage().isPersistent() && !this.isUnderSubstituted();
        }

        @NotNull
        private ModelEntityStorage getEntityStorage() {
            ModelEntityStorage modelEntityStorage = this.getModel().myEntityStorage;
            if (modelEntityStorage == null) {
                BaseElement.$$$reportNull$$$0(0);
            }
            return modelEntityStorage;
        }

        @NotNull
        protected BasicDataObject getData() {
            Object prev;
            BasicDataObject newData;
            do {
                BasicDataObject stored;
                if ((stored = BaseElement.asData(prev = this.myData)) != null) {
                    BasicDataObject basicDataObject = stored;
                    if (basicDataObject == null) {
                        BaseElement.$$$reportNull$$$0(1);
                    }
                    return basicDataObject;
                }
                newData = this.loadEntity();
                if (newData != null) continue;
                newData = (BasicDataObject)this.getMetaObject().newDataObject();
            } while (!this.setData(newData, prev));
            BasicDataObject basicDataObject = newData;
            if (basicDataObject == null) {
                BaseElement.$$$reportNull$$$0(2);
            }
            return basicDataObject;
        }

        @Nullable
        private BasicDataObject loadEntity() {
            return this.getEntityStorage().getDataObject(this.myEntityId, this.getMetaObject());
        }

        @NotNull
        protected String getNameImpl() {
            String stub = BaseElement.asDataStub(this.myData);
            if (stub != null) {
                String string = stub;
                if (string == null) {
                    BaseElement.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = BaseElement.getDataStub(this.getData());
            if (string == null) {
                BaseElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        private boolean unload() {
            Object prev;
            BasicDataObject data;
            String stub;
            if (!this.isPersisted()) {
                return false;
            }
            do {
                if ((data = BaseElement.asData(prev = this.myData)) == null) {
                    return true;
                }
                if (data.isFrozen()) continue;
                return false;
            } while (!this.setData(stub = BaseElement.getDataStub(data), prev));
            return true;
        }

        @Nullable
        private static String getDataStub(BasicDataObject data) {
            return data == null ? null : data.getName();
        }

        @Nullable
        private static String asDataStub(Object data) {
            return (String)ObjectUtils.tryCast((Object)data, String.class);
        }

        @Nullable
        private static BasicDataObject asData(Object data) {
            return (BasicDataObject)ObjectUtils.tryCast((Object)data, BasicDataObject.class);
        }

        private void freezeData() {
            Object prev;
            BasicDataObject data;
            do {
                if ((data = BaseElement.asData(prev = this.myData)) != null && !data.isFrozen()) continue;
                return;
            } while (!this.setData(data, true, prev));
        }

        private void unfreeze() {
            Object prev;
            BasicDataObject unfrozen;
            do {
                prev = this.myData;
                BasicDataObject data = this.getData();
                boolean frozen = data.isFrozen();
                if (!frozen) {
                    return;
                }
                unfrozen = data.copy();
                assert (!unfrozen.isFrozen());
            } while (!this.setData(unfrozen, false, prev));
        }

        protected D getDelegate() {
            return (D)this.getData();
        }

        @Override
        public int getStoredHashCode() {
            return this.getData().getStoredHashCode();
        }

        @NotNull
        public abstract BasicMetaObject<D> getMetaObject();

        @Override
        @NotNull
        public abstract BaseModel getModel();

        @Override
        public void handleRename(@NotNull String oldName) {
            if (oldName == null) {
                BaseElement.$$$reportNull$$$0(5);
            }
            this.getModel().handleRename(this, oldName);
        }

        @Override
        public boolean hasData(@NotNull BasicDataObject data) {
            if (data == null) {
                BaseElement.$$$reportNull$$$0(6);
            }
            return this.getData() == data;
        }

        @Override
        public BasicDataObject frozenData() {
            BasicDataObject data = this.getData();
            if (data.isFrozen()) {
                return data;
            }
            this.freezeData();
            return this.getData();
        }

        @Override
        public boolean applyData(@NotNull BasicDataObject next) {
            ModelIdIndex index2;
            long nextId;
            long fromId;
            BasicIdentifiedElement idThis;
            String oldName;
            Object prev;
            if (next == null) {
                BaseElement.$$$reportNull$$$0(7);
            }
            do {
                BasicDataObject data;
                if (next == (data = this.getData())) {
                    return true;
                }
                if (next.getMetaObject() != this.getMetaObject()) {
                    return false;
                }
                this.modifying(false);
                prev = this.myData;
                oldName = data instanceof BasicNamedElement ? data.getName() : null;
                idThis = (BasicIdentifiedElement)ObjectUtils.tryCast((Object)this, BasicIdentifiedElement.class);
                fromId = idThis == null ? -1L : idThis.getObjectId();
                nextId = idThis == null ? -1L : ((BasicIdentifiedElement)((Object)next)).getObjectId();
                ModelIdIndex modelIdIndex = index2 = fromId != nextId ? ModelIdIndex.getIndex(this.getDatabase()) : null;
            } while (!this.setData(next, true, prev));
            if (index2 != null) {
                index2.unregisterIdentifiedElement(fromId, idThis);
                index2.registerIdentifiedElement(nextId, idThis);
            }
            if (oldName != null && !oldName.equals(this.getName())) {
                this.getModel().handleRename(this, oldName);
            }
            return true;
        }

        protected void modifying(boolean data) {
            this.getModel().doingObjectModify(this);
            if (data) {
                this.unfreeze();
            }
        }

        @Override
        @Nullable
        public abstract BaseFamily<?> familyOf(@NotNull ObjectKind var1);

        @Override
        public void drop() {
            this.internalDrop(true);
        }

        abstract void internalDrop(boolean var1);

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void resetSyncPending() {
            this.setOutdated(false);
            this.setSyncPending(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntityStorage";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameImpl";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasData";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class LightBaseElement
    implements BasicDataObject,
    Cloneable {
        protected LightBaseElement() {
        }

        @Override
        public BasicDataObject copy() {
            try {
                LightBaseElement cloned = (LightBaseElement)this.clone();
                cloned.setStoredHashCode(0);
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.rethrow((Throwable)e);
                return this;
            }
        }

        @Override
        public boolean isFrozen() {
            return this.getStoredHashCode() != 0;
        }

        @Override
        public boolean freeze() {
            int hashCode = BasicMetaUtils.hashCode(this);
            assert (hashCode != 0);
            this.setStoredHashCode(hashCode);
            return true;
        }

        protected abstract void setStoredHashCode(int var1);

        private Map<BasicMetaPropertyId<?>, Object> _properties() {
            return new AbstractMap<BasicMetaPropertyId<?>, Object>(){
                private final Set<Map.Entry<BasicMetaPropertyId<?>, Object>> myEntries = new HashSet();
                {
                    final LightBaseElement obj = this;
                    for (final BasicMetaProperty property : BasicMetaUtils.getMetaObject(obj).properties) {
                        this.myEntries.add(new Map.Entry<BasicMetaPropertyId<?>, Object>(){

                            @Override
                            public BasicMetaPropertyId<?> getKey() {
                                return property.id;
                            }

                            @Override
                            public Object getValue() {
                                return property.get(obj);
                            }

                            @Override
                            public Object setValue(Object value2) {
                                Object prev = this.getValue();
                                property.set(obj, value2);
                                return prev;
                            }
                        });
                    }
                }

                @Override
                @NotNull
                public Set<Map.Entry<BasicMetaPropertyId<?>, Object>> entrySet() {
                    Set<Map.Entry<BasicMetaPropertyId<?>, Object>> set = this.myEntries;
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/BaseModel$LightBaseElement$1", "entrySet"));
                }
            };
        }

        protected void checkFrozen() {
            if (this.isFrozen()) {
                throw new UnsupportedOperationException(this.getName() + ":" + this.getKind().code() + " is frozen!");
            }
        }

        @Override
        public void drop() {
            throw new UnsupportedOperationException("Light object");
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void resetSyncPending() {
        }

        @Override
        @Nullable
        public BasicModModel getModel() {
            return null;
        }

        @Override
        @NotNull
        public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
            List list = Collections.emptyList();
            if (list == null) {
                LightBaseElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicModElement> getChildren() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicModElement> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                LightBaseElement.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        public @Nullable ModFamily<@NotNull ? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                LightBaseElement.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public void setOutdated(boolean outdated) {
        }

        @Override
        public boolean isOutdated() {
            return false;
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$LightBaseElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$LightBaseElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "familyOf";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

