/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaObject<M extends BasicElement> {
    private static final BasicMetaObject<?>[] EMPTY_ARRAY = new BasicMetaObject[0];
    private static final BasicMetaProperty<?, ?>[] EMPTY_PROPS_ARRAY = new BasicMetaProperty[0];
    private static final BasicMetaReference<?, ?>[] EMPTY_REFS_ARRAY = new BasicMetaReference[0];
    public static final BasicMetaObject<?> DEAD_BEEF = new BasicMetaObject(ObjectKind.NONE, BasicElement.class, null, null, null, null, null);
    public final ObjectKind kind;
    public final Class<? extends BasicElement> apiClass;
    public final Supplier<? extends M> dataFactory;
    public final BiConsumer<M, Map<String, String>> dataDeserializer;
    public final BasicMetaProperty<M, ?>[] properties;
    public final BasicMetaReference<M, ?>[] references;
    public final BasicMetaObject<?>[] children;
    private Object myParent;

    public BasicMetaObject(ObjectKind kind, Class<? extends BasicElement> apiClass, Supplier<? extends M> dataFactory, BiConsumer<M, Map<String, String>> dataDeserializer, BasicMetaProperty<M, ?>[] properties, BasicMetaReference<M, ?>[] references, BasicMetaObject<?>[] children2) {
        this.kind = kind;
        this.apiClass = apiClass;
        this.dataFactory = dataFactory;
        this.dataDeserializer = dataDeserializer;
        this.properties = properties == null ? EMPTY_PROPS_ARRAY : properties;
        this.references = references == null ? EMPTY_REFS_ARRAY : references;
        for (BasicMetaObject<?> child : this.children = children2 == null ? EMPTY_ARRAY : children2) {
            assert (child.myParent == null);
            child.myParent = this;
        }
    }

    @Nullable
    public BasicMetaObject<?> getParent() {
        return (BasicMetaObject)ObjectUtils.tryCast((Object)this.myParent, BasicMetaObject.class);
    }

    @Nullable
    public BasicMetaObject<?> getParent(int i2) {
        BasicMetaObject<?> cur2;
        for (cur2 = this; i2 > 0 && cur2 != null; cur2 = cur2.getParent(), --i2) {
        }
        return cur2;
    }

    @Nullable
    public ObjectKind getParentKind(int i2) {
        BasicMetaObject<?> cur2 = this.getParent(i2);
        return cur2 == null ? null : cur2.kind;
    }

    @NotNull
    public BasicMetaModel<?> getModel() {
        Object parent2 = this.myParent;
        while (parent2 instanceof BasicMetaObject) {
            parent2 = ((BasicMetaObject)parent2).myParent;
        }
        BasicMetaModel basicMetaModel = (BasicMetaModel)parent2;
        if (basicMetaModel == null) {
            BasicMetaObject.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    void setModel(@NotNull BasicMetaModel<?> model) {
        if (model == null) {
            BasicMetaObject.$$$reportNull$$$0(1);
        }
        assert (this.myParent == null);
        this.myParent = model;
    }

    public boolean kindOf(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.apiClass);
    }

    public <T extends BasicModElement> BasicMetaObject<T> tryCast(@Nullable Class<T> clazz) {
        return this.kindOf(clazz) ? this : null;
    }

    @NotNull
    public M newDataObject() {
        BasicElement basicElement = (BasicElement)this.dataFactory.get();
        if (basicElement == null) {
            BasicMetaObject.$$$reportNull$$$0(2);
        }
        return (M)basicElement;
    }

    @Nullable
    public <T extends BasicElement> BasicMetaReference<M, T> getReference(@NotNull BasicMetaReferenceId<T> refId) {
        if (refId == null) {
            BasicMetaObject.$$$reportNull$$$0(3);
        }
        return this.getReference(refId, -1);
    }

    @Nullable
    public <T extends BasicElement> BasicMetaReference<M, T> getReference(@NotNull BasicMetaReferenceId<T> refId, int hint) {
        int idx;
        if (refId == null) {
            BasicMetaObject.$$$reportNull$$$0(4);
        }
        return (idx = this.indexOf(this.references, refId, hint, p2 -> p2.id)) == -1 ? null : this.references[idx].asId(refId);
    }

    public boolean hasObjectProperty(@NotNull BasicMetaPropertyId<?> id) {
        int idx;
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(5);
        }
        return (idx = this.indexOf(this.properties, id, -1, p2 -> p2.id)) != -1;
    }

    @Nullable
    public <T> BasicMetaProperty<M, T> getObjectProperty(@NotNull BasicMetaPropertyId<T> id) {
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(6);
        }
        return this.getObjectProperty(id, -1);
    }

    @Nullable
    public <T> BasicMetaProperty<M, T> getObjectProperty(@NotNull BasicMetaPropertyId<T> id, int hint) {
        int idx;
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(7);
        }
        return (idx = this.indexOf(this.properties, id, hint, p2 -> p2.id)) == -1 ? null : this.properties[idx].asId(id);
    }

    private <T, I> int indexOf(T @NotNull [] objects2, @NotNull I id, int hint, @NotNull Function<T, I> getId) {
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(8);
        }
        if (getId == null) {
            BasicMetaObject.$$$reportNull$$$0(9);
        }
        if (objects2 == null) {
            BasicMetaObject.$$$reportNull$$$0(10);
        }
        if (hint != -1) {
            if (getId.fun(objects2[hint]) != id) {
                throw new AssertionError((Object)("Wrong hint for " + id + " in " + this));
            }
            return hint;
        }
        int length = objects2.length;
        for (int i2 = 0; i2 < length; ++i2) {
            T p2 = objects2[i2];
            if (getId.fun(p2) != id) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    public String toString() {
        if (this.myParent instanceof BasicMetaObject) {
            String string = this.myParent + "." + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (this.myParent instanceof BasicMetaModel) {
            String string = ((BasicMetaModel)this.myParent).dbms.getDisplayName() + ": " + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = this.kind.code();
        if (string == null) {
            BasicMetaObject.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refId";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newDataObject";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasObjectProperty";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getObjectProperty";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

