/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.remote.jdba.util.Function;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaUtils {
    @Nullable
    public static <T extends BasicModElement> BasicMetaObject<T> findChild(@Nullable BasicMetaObject<?> obj, @NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaUtils.$$$reportNull$$$0(0);
        }
        if (obj == null) {
            return null;
        }
        for (BasicMetaObject<?> child : obj.children) {
            if (child.kind != kind) continue;
            return child;
        }
        return null;
    }

    public static void copyProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(1);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(2);
        }
        BasicMetaUtils.copyPropertiesImpl((BasicModElement)from, to, withSources);
    }

    private static <E extends BasicModElement> void copyPropertiesImpl(@NotNull E from, @NotNull E to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(3);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(4);
        }
        BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(to);
        BasicMetaObject<E> meta2 = BasicMetaUtils.getMetaObject(from);
        assert (meta == meta2) : "Trying to copy " + from.getClass().getName() + " to " + to.getClass().getName();
        for (BasicMetaProperty p2 : meta.properties) {
            BasicMetaUtils.copyProperty(from, to, p2);
        }
        BasicMetaUtils.copySources(from, to, withSources);
    }

    public static void copySources(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(5);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(6);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o = withSources ? (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class) : null;
            BasicModel model = to.getModel();
            if (model != null) {
                model.writeSources(() -> ((BasicModSourceAware)to).setSourceText(o == null ? null : o.getSourceText()));
            }
        }
    }

    public static void copyMatchedProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean resetOther, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(7);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(8);
        }
        BasicMetaUtils.copyMatchedPropertiesImpl((BasicModElement)from, to, resetOther, withSources);
    }

    public static <E extends BasicModElement, E2 extends BasicModElement> void copyMatchedPropertiesImpl(@NotNull E from, @NotNull E2 to, boolean resetOther, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(9);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(10);
        }
        BasicMetaObject<E2> toMeta = BasicMetaUtils.getMetaObject(to);
        for (BasicMetaProperty property : toMeta.properties) {
            if (property.id == BasicModRoot.DBMS) continue;
            BasicMetaUtils.copyMatchedProperty(from, to, property, resetOther);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o = (BasicSourceAware)ObjectUtils.tryCast(from, BasicSourceAware.class);
            if (withSources && (o != null || resetOther)) {
                ((BasicModSourceAware)to).setSourceText(o == null ? null : o.getSourceText());
            }
        }
    }

    private static <E extends BasicModElement, E2 extends BasicModElement, T> void copyMatchedProperty(@NotNull E from, @NotNull E2 to, @NotNull BasicMetaProperty<E2, T> p2, boolean resetOther) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(11);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(12);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(13);
        }
        BasicMetaProperty p1 = BasicMetaUtils.findMatchingProperty(BasicMetaUtils.getMetaObject(from).properties, p2);
        boolean copied = false;
        if (p1 != null) {
            copied = BasicMetaUtils.copyProperty(from, p1, to, p2);
        }
        if (!copied && resetOther) {
            p2.set(to, p2.def);
        }
    }

    @Nullable
    public static <E extends BasicElement> BasicMetaProperty<E, ?> findProperty(BasicMetaProperty<E, ?>[] properties, String name) {
        for (BasicMetaProperty<E, ?> property : properties) {
            if (!property.id.name.equals(name)) continue;
            return property;
        }
        return null;
    }

    private static <E extends BasicModElement, T> BasicMetaProperty<E, ?> findMatchingProperty(BasicMetaProperty<E, ?>[] properties, BasicMetaProperty<?, T> p2) {
        BasicMetaProperty<E, ?> res2 = BasicMetaUtils.findProperty(properties, p2.id.name);
        if (res2 != null && !res2.id.getValueClass().equals(p2.id.getValueClass())) {
            return null;
        }
        return res2;
    }

    private static <E extends BasicModElement, T> void copyProperty(@NotNull E from, @NotNull E to, @NotNull BasicMetaProperty<E, T> prop) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(14);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(15);
        }
        if (prop == null) {
            BasicMetaUtils.$$$reportNull$$$0(16);
        }
        BasicMetaUtils.copyPropertyInner(from, prop, to, prop, null);
    }

    private static <E extends BasicModElement, E2 extends BasicModElement, T, U> void copyPropertyInner(@NotNull E from, @NotNull BasicMetaProperty<E, T> p1, @NotNull E2 to, @NotNull BasicMetaProperty<E2, U> p2, @Nullable Function<T, U> converter) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(17);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(18);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(19);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(20);
        }
        T val = p1.get(from);
        p2.set(to, converter == null ? val : converter.apply(val));
    }

    private static <E extends BasicModElement, E2 extends BasicModElement, T, U> boolean copyProperty(@NotNull E from, @NotNull BasicMetaProperty<E, T> p1, @NotNull E2 to, @NotNull BasicMetaProperty<E2, U> p2) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(21);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(22);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(23);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(24);
        }
        Function cvt = null;
        if (p1.id.type != p2.id.type && (cvt = BasicMetaUtils.getConverter(p1.id.type, p2.id.type)) == null) {
            return false;
        }
        BasicMetaUtils.copyPropertyInner(from, p1, to, p2, cvt);
        return true;
    }

    private static <U, T> Function<T, U> getConverter(BasicMetaType<T> from, BasicMetaType<U> to) {
        if (from == to) {
            return x -> x;
        }
        if (to.valueClass.isAssignableFrom(String.class)) {
            return x -> x.toString();
        }
        if (to.valueClass.isAssignableFrom(Number.class) && from.valueClass.isAssignableFrom(Number.class)) {
            return x -> {
                try {
                    return to.importer.fun((Object)x.toString());
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        return null;
    }

    public static int hashCode(@Nullable BasicElement e) {
        if (e == null) {
            return 0;
        }
        return BasicMetaUtils.hashCodeImpl((BasicModElement)e);
    }

    private static <E extends BasicModElement> int hashCodeImpl(@NotNull E e) {
        if (e == null) {
            BasicMetaUtils.$$$reportNull$$$0(25);
        }
        BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(e);
        int hash = meta.hashCode();
        for (BasicMetaProperty property : meta.properties) {
            hash = Comparing.hashcode((Object)hash, property.get(e));
        }
        return hash == 0 ? 1 : hash;
    }

    public static boolean equals(@NotNull BasicElement e1, @NotNull BasicElement e2) {
        BasicMetaObject<?> meta2;
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(26);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(27);
        }
        if (e1 == e2) {
            return true;
        }
        BasicMetaObject<?> meta1 = e1.getMetaObject();
        if (meta1 != (meta2 = e2.getMetaObject())) {
            return false;
        }
        return BasicMetaUtils.equalsImpl((BasicModElement)e1, (BasicModElement)e2);
    }

    private static <E extends BasicModElement> boolean equalsImpl(@NotNull E e1, @NotNull E e2) {
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(28);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(29);
        }
        BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(e1);
        for (BasicMetaProperty property : meta.properties) {
            if (Comparing.equal(property.get(e1), property.get(e2))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T extends BasicElement> BasicMetaObject<T> getMetaObject(@NotNull T to) {
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(30);
        }
        BasicMetaObject<?> basicMetaObject = to.getMetaObject();
        if (basicMetaObject == null) {
            BasicMetaUtils.$$$reportNull$$$0(31);
        }
        return basicMetaObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 13: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaUtils";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertiesImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copySources";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedProperties";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedPropertiesImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyMatchedProperty";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyProperty";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertyInner";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hashCodeImpl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "equalsImpl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMetaObject";
                break;
            }
            case 31: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

