/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSessionAction
extends AlignedIconWithTextAction.Group
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(0);
        }
        ActionContext context = ChooseSessionAction.getContext(e);
        Presentation p2 = e.getPresentation();
        if (context == null || !context.isVisible() && !context.isEnabled()) {
            p2.setEnabledAndVisible(false);
            return;
        }
        boolean isToolbar = e.isFromActionToolbar();
        DatabaseSession session2 = DatabaseSessionManager.findSession(e);
        String fullText2 = isToolbar ? (session2 != null ? StringUtil.defaultIfEmpty((String)context.getSessionName(session2), (String)DatabaseBundle.message("choose.session.action.empty.placeholder", new Object[0])) : DatabaseBundle.message("choose.session.action.placeholder", new Object[0])) : (session2 == null ? this.getTemplateText() : DatabaseBundle.message("choose.session.action.switch.text", new Object[0]));
        String text2 = fullText2.length() <= 30 ? fullText2 : fullText2.substring(0, 30) + "\u2026";
        p2.setDescription(DatabaseBundle.messagePointer("action.switch.attached.session.description", new Object[0]));
        p2.setVisible(context.isVisible());
        p2.setEnabled(context.isEnabled());
        p2.setText(text2, false);
        p2.setIcon(e.isFromActionToolbar() ? DatabaseSession.getIcon(session2 != null && session2.isConnected()) : null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionContext context;
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(1);
        }
        if ((context = ChooseSessionAction.getContext(e)) == null) {
            return;
        }
        DatabaseSession session2 = DatabaseSessionManager.findSession(e);
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(DatabaseBundle.message("sessions.chooser.title", new Object[0]), context.getRunners(session2), null, e);
    }

    @Override
    public boolean canBePerformed(@NotNull DataContext context) {
        if (context == null) {
            ChooseSessionAction.$$$reportNull$$$0(2);
        }
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"toolbar", null, (DataContext)context);
        this.update(event);
        return event.getPresentation().isEnabled();
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable DatabaseSession current, @NotNull JBIterable<DbDataSource> dataSources, @NotNull Consumer<DatabaseSession> consumer2) {
        if (project == null) {
            ChooseSessionAction.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            ChooseSessionAction.$$$reportNull$$$0(4);
        }
        if (dataSources == null) {
            ChooseSessionAction.$$$reportNull$$$0(5);
        }
        if (consumer2 == null) {
            ChooseSessionAction.$$$reportNull$$$0(6);
        }
        String title = DatabaseSession.getTitle(project, virtualFile);
        boolean canDetach = !DbVFSUtils.isConsoleFile(virtualFile) && !DatabaseEditorUtil.isTableFile(virtualFile);
        List<PersistenceConsoleProvider.Runner> list = DatabaseRunners.getRunners(dataSources, project, current, title, consumer2, canDetach);
        if (list == null) {
            ChooseSessionAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static ActionContext getContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(8);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile != null && virtualFile != null && JdbcConsoleProvider.isItPossibleToAttachConsoleTo(virtualFile)) {
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            DataGridSessionClient client = DataGridUtil.getDataGridClient(grid);
            return client == null && grid != null ? null : new ConsoleActionContext(psiFile, virtualFile);
        }
        DataGridSessionClient client = (DataGridSessionClient)ObjectUtils.tryCast((Object)e.getData(SessionClientHolder.CLIENT_KEY), DataGridSessionClient.class);
        return client == null ? null : new DataGridContext(client);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseSessionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBePerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataGridContext
    implements ActionContext {
        private final DataGridSessionClient myClient;

        DataGridContext(@NotNull DataGridSessionClient client) {
            if (client == null) {
                DataGridContext.$$$reportNull$$$0(0);
            }
            this.myClient = client;
        }

        @Override
        public boolean isEnabled() {
            return this.myClient.getSession().isIdle();
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        @NotNull
        public String getSessionName(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                DataGridContext.$$$reportNull$$$0(1);
            }
            String string = session2.getTitle();
            if (string == null) {
                DataGridContext.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public List<PersistenceConsoleProvider.Runner> getRunners(@Nullable DatabaseSession session2) {
            DbDataSource dataSource2 = this.myClient.getDataSource();
            VirtualFile file = this.myClient.getVirtualFile();
            Consumer attachConsumer = nSession -> {
                if (nSession != session2) {
                    this.myClient.setSession((DatabaseSession)nSession);
                }
            };
            List<PersistenceConsoleProvider.Runner> list = ChooseSessionAction.getRunners(this.myClient.getProject(), file, session2, (JBIterable<DbDataSource>)JBIterable.of((Object)dataSource2), (Consumer<DatabaseSession>)attachConsumer);
            if (list == null) {
                DataGridContext.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSessionAction$DataGridContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction$DataGridContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSessionName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSessionName";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConsoleActionContext
    implements ActionContext {
        private final PsiFile myFile;
        private final VirtualFile myVirtualFile;

        ConsoleActionContext(@NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
            if (file == null) {
                ConsoleActionContext.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                ConsoleActionContext.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myVirtualFile = virtualFile;
        }

        @Override
        public boolean isEnabled() {
            JdbcConsole console = JdbcConsoleProvider.getConsole(this.myFile.getProject(), this.myVirtualFile);
            return console == null || console.getSession().isIdle();
        }

        @Override
        public boolean isVisible() {
            return !ConsoleActionContext.getDataSources(this.myFile).isEmpty();
        }

        @Override
        @NotNull
        public String getSessionName(@NotNull DatabaseSession session2) {
            if (session2 == null) {
                ConsoleActionContext.$$$reportNull$$$0(2);
            }
            String string = DbVFSUtils.isConsoleFile(this.myVirtualFile) || DbSrcUtilsCore.isDbSrcFile(this.myVirtualFile) ? session2.getTitle() : SessionsUtil.qualifiedName(session2);
            if (string == null) {
                ConsoleActionContext.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public List<PersistenceConsoleProvider.Runner> getRunners(@Nullable DatabaseSession session2) {
            Consumer attachConsumer = nSession -> {
                if (nSession != session2) {
                    JdbcConsoleProvider.attachConsole(this.myFile.getProject(), nSession, this.myVirtualFile);
                }
            };
            List<PersistenceConsoleProvider.Runner> list = ChooseSessionAction.getRunners(this.myFile.getProject(), this.myVirtualFile, session2, ConsoleActionContext.getDataSources(this.myFile), (Consumer<DatabaseSession>)attachConsumer);
            if (list == null) {
                ConsoleActionContext.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private static JBIterable<DbDataSource> getDataSources(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                ConsoleActionContext.$$$reportNull$$$0(5);
            }
            JBIterable<DbDataSource> jBIterable = DbSrcUtilsCore.isDbSrcFile(psiFile.getVirtualFile()) || DbVFSUtils.isConsoleFile(psiFile.getVirtualFile()) ? JBIterable.of((Object)DbImplUtilCore.getForcedDataSource(psiFile)).filter(Conditions.notNull()) : DbImplUtil.getDataSourcesForExec(psiFile, true, false);
            if (jBIterable == null) {
                ConsoleActionContext.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSessionAction$ConsoleActionContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction$ConsoleActionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSessionName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunners";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSessionName";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSources";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ActionContext {
        public boolean isEnabled();

        public boolean isVisible();

        @NotNull
        public String getSessionName(@NotNull DatabaseSession var1);

        @NotNull
        public List<PersistenceConsoleProvider.Runner> getRunners(@Nullable DatabaseSession var1);
    }
}

