/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.session.LogView;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasuringDataAuditor
extends DataAuditors.Adapter {
    public static final Key<Boolean> SILENT_KEY = Key.create((String)"SILENT_MEASURING_AUDITING_KEY");
    private final ConcurrentMap<DataRequest, Stat> myStatMap = ConcurrentFactoryMap.createWeakMap(k -> new Stat());

    protected Stat getStat(DataRequest.Context context) {
        return (Stat)this.myStatMap.get((Object)context.request);
    }

    protected QueryStat getQueryStat(DataRequest.Context context) {
        return this.getStat((DataRequest.Context)context).queries.get(context.getStatementContext());
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(0);
        }
        this.getQueryStat((DataRequest.Context)context).updateT = this.now();
        if (updateCount2 < 0) {
            return;
        }
        this.getQueryStat((DataRequest.Context)context).updateCount += (long)updateCount2;
    }

    @Override
    public void fetchStarted(@NotNull DataRequest.Context context, int index2) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(1);
        }
        this.getQueryStat((DataRequest.Context)context).fetchT1 += this.now();
        this.getQueryStat((DataRequest.Context)context).rowCount = 0L;
    }

    @Override
    public void fetchFinished(@NotNull DataRequest.Context context, int index2, int rowCount) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(2);
        }
        this.getQueryStat((DataRequest.Context)context).fetchT2 += this.now();
        this.getQueryStat((DataRequest.Context)context).rowCount += (long)rowCount;
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(3);
        }
        this.getStat((DataRequest.Context)context).reqT1 = this.now();
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(4);
        }
        this.getStat((DataRequest.Context)context).reqT2 = this.now();
        this.reportRequestFinish(context);
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, @NotNull DataAuditor.TxEvent event) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(5);
        }
        if (event == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(6);
        }
        if (MeasuringDataAuditor.isSuppressed(context) || !event.completed && !event.reverted) {
            return;
        }
        DataRequest.TxMarker marker = context.txMarker;
        if (!marker.isTransactionInProgress()) {
            return;
        }
        Object name = marker.getOwner() == null ? "" : ": " + marker;
        this.print(context, DatabaseBundle.message("notification.content.transaction.choice.committed.rolled.back", event.completed ? 0 : 1, name));
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(7);
        }
        ++this.getStat((DataRequest.Context)context).errorCount;
    }

    @Override
    public void beforeStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(8);
        }
        this.getQueryStat((DataRequest.Context)context).start = this.now();
    }

    @Override
    public void afterStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(9);
        }
        this.getQueryStat((DataRequest.Context)context).finish = this.now();
        this.reportStatementFinish(context);
    }

    private void reportStatementFinish(@NotNull DataRequest.Context context) {
        String totalTimeStr;
        long fetchTime;
        String timings;
        String executionTimeStr;
        String report;
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(10);
        }
        if (MeasuringDataAuditor.isSuppressed(context)) {
            return;
        }
        Stat stat = this.getStat(context);
        QueryStat queryStat = this.getQueryStat(context);
        long totalTime = queryStat.finish - queryStat.start;
        if (stat.errorCount == 0L && (report = this.getReport(context, queryStat, executionTimeStr, timings = Objects.equals(executionTimeStr = StringUtil.formatDuration((long)(totalTime - (fetchTime = queryStat.fetchT2 - queryStat.fetchT1))), totalTimeStr = StringUtil.formatDuration((long)totalTime)) ? executionTimeStr : totalTimeStr + " (execution: " + executionTimeStr + ", fetching: " + StringUtil.formatDuration((long)fetchTime) + ")")) != null) {
            this.print(context, report);
        }
        if (totalTime > 20000L) {
            this.bringAttentionByNotification(context);
        }
    }

    @NlsContexts.NotificationContent
    @Nullable
    private String getReport(@NotNull DataRequest.Context context, QueryStat queryStat, String executionTimeStr, String timings) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(11);
        }
        String reportText = null;
        if (queryStat.updateCount > 0L) {
            reportText = DatabaseBundle.message("notification.content.choice.row.rows.affected.in", queryStat.updateCount, queryStat.updateCount == 1L ? 0 : 1, executionTimeStr);
            this.bringAttentionToOutput(context, LogView.OutputType.INFO);
        } else if (queryStat.rowCount > 0L) {
            DataRequest request = context.request;
            int offset = request instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)request).constraints.absolutePosition : 0;
            reportText = DatabaseBundle.message("notification.content.choice.row.rows.retrieved.starting.from.in", queryStat.rowCount, queryStat.rowCount == 1L ? 0 : 1, offset + 1, timings);
        } else if (this.getStat((DataRequest.Context)context).errorCount == 0L) {
            if (queryStat.rowCount == 0L) {
                reportText = DatabaseBundle.message("notification.content.rows.retrieved.in", timings);
            } else {
                reportText = DatabaseBundle.message("completed.in", executionTimeStr);
                this.bringAttentionToOutput(context, LogView.OutputType.INFO);
            }
        }
        return reportText;
    }

    private void reportRequestFinish(@NotNull DataRequest.Context context) {
        String reportText;
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(12);
        }
        if (MeasuringDataAuditor.isSuppressed(context)) {
            return;
        }
        Stat stat = this.getStat(context);
        if (!stat.queries.isEmpty()) {
            return;
        }
        long totalTime = stat.reqT2 - stat.reqT1;
        String totalTimeStr = StringUtil.formatDuration((long)totalTime);
        String string = reportText = stat.errorCount == 0L ? DatabaseBundle.message("completed.in", totalTimeStr) : null;
        if (reportText != null) {
            this.print(context, reportText);
        }
        if (totalTime > 20000L) {
            this.bringAttentionByNotification(context);
        }
    }

    public static boolean isSilent(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(13);
        }
        return SILENT_KEY.get((UserDataHolder)context) == Boolean.TRUE;
    }

    private static boolean isSuppressed(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(14);
        }
        return MeasuringDataAuditor.isSilent(context) || SessionsUtil.isInternalOwner(context.request.owner);
    }

    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, @Nullable LogView.OutputType outputType) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(15);
        }
    }

    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(16);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/audit/MeasuringDataAuditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountReceived";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "requestStarted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFinished";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "txCompleted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "afterStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "reportStatementFinish";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getReport";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reportRequestFinish";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isSilent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuppressed";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionToOutput";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionByNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class QueryStat {
        public long start;
        public long finish;
        public long fetchT1;
        public long fetchT2;
        public long updateCount;
        public long updateT;
        public long rowCount = -1L;
    }

    public static class Stat {
        public long reqT1;
        public long reqT2;
        public long errorCount;
        public final Map<DataRequest.StatementContext, QueryStat> queries = ConcurrentFactoryMap.createMap(c2 -> new QueryStat());
    }
}

