/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.CellViewerFactory;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.Suitability;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/ui/ReadonlyEditorCellViewerFactory;", "Lcom/intellij/database/run/ui/CellViewerFactory;", "()V", "createViewer", "Lcom/intellij/database/run/ui/CellViewer;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "getSuitability", "Lcom/intellij/database/run/ui/Suitability;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "column", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "intellij.database.impl"})
public final class ReadonlyEditorCellViewerFactory
implements CellViewerFactory {
    @NotNull
    public static final ReadonlyEditorCellViewerFactory INSTANCE;

    @Override
    @NotNull
    public Suitability getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        if (!row.isValid(grid) || !column2.isValid(grid)) {
            return Suitability.NONE;
        }
        if (!grid.isEditable()) {
            return Suitability.MIN_2;
        }
        ResultView resultView = grid.getResultView();
        Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"grid.resultView");
        Object object = resultView.getEditorFactoryProvider();
        if (object == null || (object = object.getEditorFactory(grid, row, column2)) == null) {
            return Suitability.NONE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"grid.resultView.editorFa\u2026: return Suitability.NONE");
        Object factory = object;
        Object value2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
        boolean isEditable = factory.getIsEditableChecker().isEditable(DataGridUtil.getDbms(grid), value2);
        return isEditable ? Suitability.MIN_1 : Suitability.MIN_2;
    }

    @Override
    @NotNull
    public CellViewer createViewer(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Project project = DataGridUtil.getProject(grid);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"DataGridUtil.getProject(grid)");
        return new EditorCellViewer(project, grid, false);
    }

    private ReadonlyEditorCellViewerFactory() {
    }

    static {
        ReadonlyEditorCellViewerFactory readonlyEditorCellViewerFactory;
        INSTANCE = readonlyEditorCellViewerFactory = new ReadonlyEditorCellViewerFactory();
    }
}

