/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDataSupportImpl
implements GridDataSupport {
    private final GridMutator<DataConsumer.Row, DataConsumer.Column> myMutator;
    private final TableResultPanel myGrid;

    public GridDataSupportImpl(@NotNull TableResultPanel grid, @Nullable GridMutator<DataConsumer.Row, DataConsumer.Column> mutator) {
        if (grid == null) {
            GridDataSupportImpl.$$$reportNull$$$0(0);
        }
        this.myMutator = mutator;
        this.myGrid = grid;
    }

    @Override
    public void revert(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            GridDataSupportImpl.$$$reportNull$$$0(1);
        }
        if (columns == null) {
            GridDataSupportImpl.$$$reportNull$$$0(2);
        }
        if (this.getDatabaseMutator() == null) {
            return;
        }
        GridRequestSource source = new GridRequestSource(new DataGridRequestPlace(this.myGrid, rows, columns));
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.myGrid.getSelectionModel().store();
        this.getDatabaseMutator().revert(source, rows, columns);
        this.myGrid.getAutoscrollLocker().runWithLock(() -> {
            SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.myGrid.getSelectionModel();
            selectionModel.restore(selectionModel.fit(selection));
        });
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.DatabaseMutator.class);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.ColumnsMutator.class);
    }

    @Override
    public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridDataSupportImpl.$$$reportNull$$$0(3);
        }
        return this.getRowsMutator() != null && this.getRowsMutator().isDeletedRows(rows);
    }

    @Override
    public boolean isModified(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (row == null) {
            GridDataSupportImpl.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            GridDataSupportImpl.$$$reportNull$$$0(5);
        }
        if ((mutator = this.getDatabaseMutator()) == null) {
            return false;
        }
        return mutator.getMutationType(row, column2) == MutationType.MODIFY;
    }

    @Override
    public boolean isDeletedColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (column2 == null) {
            GridDataSupportImpl.$$$reportNull$$$0(6);
        }
        return (mutator = this.getColumnsMutator()) != null && mutator.isDeletedColumn(column2);
    }

    @Override
    public boolean isInsertedColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (column2 == null) {
            GridDataSupportImpl.$$$reportNull$$$0(7);
        }
        return (mutator = this.getColumnsMutator()) != null && mutator.isInsertedColumn(column2);
    }

    @Override
    public int getInsertedColumnsCount() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        return mutator == null ? 0 : mutator.getInsertedColumnsCount();
    }

    @Override
    public boolean hasPendingChanges() {
        return this.hasMutator() && Objects.requireNonNull(this.myMutator).hasPendingChanges();
    }

    @Override
    public boolean hasUnparsedValues() {
        return this.hasMutator() && Objects.requireNonNull(this.myMutator).hasUnparsedValues();
    }

    @Override
    public boolean hasMutator() {
        return this.myMutator != null;
    }

    @Override
    public boolean hasRowMutator() {
        return this.getRowsMutator() != null;
    }

    @Override
    public boolean canRevert() {
        return this.getDatabaseMutator() != null;
    }

    @Override
    public boolean isSubmitImmediately() {
        return this.myMutator != null && this.myMutator.isUpdateImmediately();
    }

    @Override
    public void finishBuildingAndApply(@NotNull List<CellMutation.Builder> builders) {
        if (builders == null) {
            GridDataSupportImpl.$$$reportNull$$$0(8);
        }
        if (this.myMutator == null) {
            return;
        }
        List mutations = ContainerUtil.map(builders, CellMutation.Builder::build);
        ModelIndexSet<DataConsumer.Row> rows = ModelIndexSet.forRows(this.myGrid, GridDataSupportImpl.uniqueIndices(mutations, Mutation::getRow));
        ModelIndexSet<DataConsumer.Column> columns = ModelIndexSet.forColumns(this.myGrid, GridDataSupportImpl.uniqueIndices(mutations, CellMutation::getColumn));
        this.myMutator.mutate(new GridRequestSource(new DataGridRequestPlace(this.myGrid, rows, columns)), mutations, true);
    }

    private static int[] uniqueIndices(@NotNull List<CellMutation> mutations, @NotNull Function<CellMutation, ModelIndex<?>> function2) {
        if (mutations == null) {
            GridDataSupportImpl.$$$reportNull$$$0(9);
        }
        if (function2 == null) {
            GridDataSupportImpl.$$$reportNull$$$0(10);
        }
        return mutations.stream().mapToInt(mutation -> ((ModelIndex)function2.fun(mutation)).asInteger()).distinct().toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridDataSupportImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "revert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeletedRows";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeletedColumn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsertedColumn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "finishBuildingAndApply";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "uniqueIndices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

