/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationRow;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMutationModel
implements GridModel<DataConsumer.Row, DataConsumer.Column> {
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final Map<ModelIndex<DataConsumer.Row>, DataConsumer.Row> myCache;
    private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myHookUp;
    private final EventDispatcher<GridModel.Listener> myDispatcher;

    public GridMutationModel(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            GridMutationModel.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(GridModel.Listener.class);
        this.myHookUp = hookUp;
        this.myModel = this.myHookUp.getDataModel();
        this.myCache = new ConcurrentHashMap<ModelIndex<DataConsumer.Row>, DataConsumer.Row>();
    }

    @Override
    @NotNull
    public List<DataConsumer.Column> getColumns() {
        List list = this.getColumnIndicesInner().map(this::wrapColumn).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public JBIterable<DataConsumer.Column> getColumnsAsIterable() {
        JBIterable jBIterable = this.getColumnIndicesInner().map(this::wrapColumn);
        if (jBIterable == null) {
            GridMutationModel.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<DataConsumer.Column> getColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnsIdxs) {
        if (columnsIdxs == null) {
            GridMutationModel.$$$reportNull$$$0(3);
        }
        List list = columnsIdxs.asIterable().filter(this::isValidColumnIdx).map(this::wrapColumn).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public JBIterable<DataConsumer.Column> getColumnsAsIterable(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = columns.asIterable().filter(this::isValidColumnIdx).map(this::wrapColumn);
        if (jBIterable == null) {
            GridMutationModel.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public DataConsumer.Column getColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(7);
        }
        return !this.isValidColumnIdx(columnIdx) ? null : this.wrapColumn(columnIdx);
    }

    @Override
    @NotNull
    public List<DataConsumer.Row> getRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(8);
        }
        List list = rows.asIterable().filter(this::isValidRowIdx).map(this::wrapRow).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2) {
        return GridMutationModel.getValueAt(row, column2, this.myHookUp.getMutator(), this.myModel);
    }

    @Nullable
    public static Object getValueAt(ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2, @Nullable GridMutator<DataConsumer.Row, DataConsumer.Column> mutator, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        MutationData value2;
        if (model == null) {
            GridMutationModel.$$$reportNull$$$0(10);
        }
        GridMutator.DatabaseMutator databaseMutator = (GridMutator.DatabaseMutator)ObjectUtils.tryCast(mutator, GridMutator.DatabaseMutator.class);
        GridMutator.ColumnsMutator columnsMutator = (GridMutator.ColumnsMutator)ObjectUtils.tryCast(mutator, GridMutator.ColumnsMutator.class);
        MutationData mutationData = value2 = databaseMutator == null ? null : databaseMutator.getMutation(row, column2);
        return value2 != null ? value2.getValue() : (row.isValid(model) && column2.isValid(model) ? model.getValueAt(row, column2) : (columnsMutator != null && (columnsMutator.isDeletedColumn(column2) || columnsMutator.isInsertedColumn(column2)) ? ReservedCellValue.UNSET : null));
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, Object what) {
        if (rowIndices == null) {
            GridMutationModel.$$$reportNull$$$0(11);
        }
        if (columnIndices == null) {
            GridMutationModel.$$$reportNull$$$0(12);
        }
        return this.myModel.allValuesEqualTo(rowIndices, columnIndices, what) && (this.getDatabaseMutator() == null || !this.getDatabaseMutator().hasMutatedRows(rowIndices, columnIndices));
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            GridMutationModel.$$$reportNull$$$0(13);
        }
        return this.myModel.allValuesEqualTo(mutations);
    }

    @Override
    @Nullable
    public DataConsumer.Row getRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            GridMutationModel.$$$reportNull$$$0(14);
        }
        return !this.isValidRowIdx(row) ? null : this.wrapRow(row);
    }

    @Override
    @NotNull
    public List<DataConsumer.Row> getRows() {
        List list = this.getRowIndicesInner().map(this::wrapRow).toList();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private DataConsumer.Row wrapRow(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rowIdx == null) {
            GridMutationModel.$$$reportNull$$$0(16);
        }
        MutationType type = (mutator = this.getDatabaseMutator()) == null ? null : mutator.getMutationType(rowIdx);
        return type == MutationType.MODIFY || type == MutationType.INSERT ? this.myCache.computeIfAbsent(rowIdx, r -> new MutationRow(rowIdx, new Object[this.getColumnCount()], mutator, this.myModel)) : this.myModel.getRow(rowIdx);
    }

    @Nullable
    private DataConsumer.Column wrapColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(17);
        }
        DataConsumer.Column column2 = (mutator = this.getColumnsMutator()) == null ? null : mutator.getInsertedColumn(columnIdx);
        return column2 != null ? column2 : this.myModel.getColumn(columnIdx);
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getColumnIndices() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ModelIndexSet.forColumns(this.myModel, this.getColumnIndicesInner());
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(18);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getRowIndices() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myModel, this.getRowIndicesInner());
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(19);
        }
        return modelIndexSet;
    }

    private JBIterable<ModelIndex<DataConsumer.Row>> getRowIndicesInner() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        return this.myModel.getRowIndices().asIterable().append(mutator == null ? ContainerUtil.emptyList() : mutator.getInsertedRows());
    }

    private JBIterable<ModelIndex<DataConsumer.Column>> getColumnIndicesInner() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        return this.myModel.getColumnIndices().asIterable().append(mutator == null ? ContainerUtil.emptyList() : mutator.getInsertedColumns());
    }

    @Override
    public int getColumnCount() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        return this.myModel.getColumnCount() + (mutator == null ? 0 : mutator.getInsertedColumnsCount());
    }

    @Override
    public int getRowCount() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        return this.myModel.getRowCount() + (mutator == null ? 0 : mutator.getInsertedRowsCount());
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            GridMutationModel.$$$reportNull$$$0(20);
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        return this.myModel.isValidRowIdx(rowIdx) || mutator != null && mutator.isInsertedRow(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(21);
        }
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        return this.myModel.isValidColumnIdx(columnIdx) || mutator != null && mutator.isInsertedColumn(columnIdx);
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myModel.isUpdatingNow();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<DataConsumer.Row, DataConsumer.Column> l, @NotNull Disposable disposable2) {
        if (l == null) {
            GridMutationModel.$$$reportNull$$$0(22);
        }
        if (disposable2 == null) {
            GridMutationModel.$$$reportNull$$$0(23);
        }
        this.myDispatcher.addListener(l, disposable2);
    }

    @Override
    public boolean hasListeners() {
        return this.myDispatcher.hasListeners();
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myHookUp.getMutator(), GridMutator.DatabaseMutator.class);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myHookUp.getMutator(), GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myHookUp.getMutator(), GridMutator.ColumnsMutator.class);
    }

    public void afterLastRowAdded() {
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).afterLastRowAdded();
    }

    public void notifyCellsUpdated(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable GridRequestSource.RequestPlace place) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(24);
        }
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(25);
        }
        if (rows.size() == 0 || columns.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).cellsUpdated(rows, columns, place);
    }

    public void notifyRowsAdded(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(26);
        }
        if (rows.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsAdded(rows);
    }

    public void notifyRowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        if (rows.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsRemoved(rows);
    }

    public void notifyColumnsAdded(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(27);
        }
        if (columns.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsAdded(columns);
    }

    public void notifyColumnsRemoved(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            GridMutationModel.$$$reportNull$$$0(28);
        }
        if (columns.size() == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsRemoved(columns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridMutationModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 5: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 7: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 8: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridMutationModel";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsAsIterable";
                break;
            }
            case 9: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnIndices";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColumnsAsIterable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValueAt";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "allValuesEqualTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrapRow";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapColumn";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyCellsUpdated";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyRowsAdded";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyColumnsAdded";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "notifyColumnsRemoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

