/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizableCellEditorsSupport
implements PropertyChangeListener,
TableColumnModelListener {
    private static final String CLIENT_PROPERTY_KEY = "ResizableCellEditorsSupport";
    private final JBTable myGrid;
    private final Timer myResetEditingCellSizeTimer;
    private final Timer myCellEditorUpdateTimer;
    private int myRowHeightBeforeEditing;
    private int myCalculatedRowHeight;

    public ResizableCellEditorsSupport(@NotNull JBTable grid) {
        if (grid == null) {
            ResizableCellEditorsSupport.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myCellEditorUpdateTimer = TimerUtil.createNamedTimer((String)"CellEditorUpdateTimer", (int)100, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizableCellEditorsSupport.this.expandCellEditorIfNeeded(ResizableCellEditorsSupport.this.myGrid.getEditingRow(), ResizableCellEditorsSupport.this.myGrid.getEditingColumn(), false);
            }
        });
        this.myResetEditingCellSizeTimer = TimerUtil.createNamedTimer((String)"ResetEditingCellSizeTimer", (int)UIUtil.getMultiClickInterval());
        this.myResetEditingCellSizeTimer.setRepeats(false);
        this.myGrid.addPropertyChangeListener((PropertyChangeListener)this);
        this.addColumnModelListener(this.myGrid.getColumnModel());
        grid.putClientProperty((Object)CLIENT_PROPERTY_KEY, (Object)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("tableCellEditor".equals(property)) {
            if (evt.getNewValue() != null) {
                this.editingStarted();
            } else {
                this.editingStopped();
            }
        } else if ("columnModel".equals(property)) {
            this.removeColumnModelListener((TableColumnModel)ObjectUtils.tryCast((Object)evt.getOldValue(), TableColumnModel.class));
            this.addColumnModelListener((TableColumnModel)ObjectUtils.tryCast((Object)evt.getNewValue(), TableColumnModel.class));
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        ApplicationManager.getApplication().invokeLater(() -> this.updateCellEditorWidth(this.myGrid.getEditingColumn(), true));
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public static ResizableCellEditorsSupport get(@Nullable JTable table) {
        return table != null ? (ResizableCellEditorsSupport)ObjectUtils.tryCast((Object)table.getClientProperty(CLIENT_PROPERTY_KEY), ResizableCellEditorsSupport.class) : null;
    }

    private void editingStarted() {
        int editingColumn = this.myGrid.getEditingColumn();
        int editingRow = this.myGrid.getEditingRow();
        if (editingColumn == -1 || editingRow == -1) {
            Point editorLocation;
            Component cellEditor = this.myGrid.getEditorComponent();
            Point point = editorLocation = cellEditor != null ? cellEditor.getBounds().getLocation() : null;
            if (editorLocation != null) {
                editingColumn = this.myGrid.columnAtPoint(editorLocation);
                editingRow = this.myGrid.rowAtPoint(editorLocation);
            }
        }
        if (editingRow != -1 && editingColumn != -1) {
            this.stopResetEditingRowHeightTimer();
            this.myRowHeightBeforeEditing = this.myGrid.getRowHeight(editingRow);
            this.expandCellEditorIfNeeded(editingRow, editingColumn, true);
            this.scrollToCellEditor();
            this.myCellEditorUpdateTimer.start();
        }
    }

    private void editingStopped() {
        this.myCellEditorUpdateTimer.stop();
        this.resetEditingCellSize();
    }

    private void scrollToCellEditor() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Component cellEditor = this.myGrid.getEditorComponent();
            if (cellEditor == null || !cellEditor.isVisible()) {
                return;
            }
            Rectangle editorBounds = cellEditor.getBounds();
            Rectangle visibleRect = this.myGrid.getVisibleRect();
            if (!visibleRect.contains(editorBounds)) {
                int margin = this.myGrid.getRowHeight();
                editorBounds.x -= margin;
                editorBounds.y -= margin;
                editorBounds.width += 2 * margin;
                editorBounds.height += 2 * margin;
                this.myGrid.scrollRectToVisible(editorBounds);
            }
        });
    }

    private void expandCellEditorIfNeeded(int editingRow, int editingColumn, boolean force) {
        this.updateCellEditorWidth(editingColumn, force);
        this.updateEditingRowHeight(editingRow, force);
    }

    private void updateCellEditorWidth(int editingColumn, boolean force) {
        Rectangle newRect;
        Component cellEditor = this.myGrid.getEditorComponent();
        if (cellEditor == null || editingColumn < 0) {
            return;
        }
        int preferredWidth = cellEditor.getPreferredSize().width + this.myGrid.getColumnModel().getColumnMargin();
        int currentWidth = cellEditor.getWidth();
        if (!force && currentWidth >= preferredWidth) {
            return;
        }
        ResizableCellEditor resizable = (ResizableCellEditor)ObjectUtils.tryCast((Object)this.myGrid.getEditorComponent(), ResizableCellEditor.class);
        Rectangle currentRect = this.myGrid.getCellRect(0, editingColumn, false);
        Rectangle rectangle = newRect = resizable != null ? resizable.getHorizontalResizeDirection().resize(this.myGrid, currentRect, editingColumn, preferredWidth) : currentRect;
        if (force && currentWidth != newRect.width || currentWidth < newRect.width) {
            Rectangle bounds = cellEditor.getBounds();
            bounds.width = newRect.width;
            bounds.x = newRect.x;
            ResizableCellEditorsSupport.setCellEditorBounds(cellEditor, bounds);
        }
    }

    private static void setCellEditorBounds(@NotNull Component cellEditor, @NotNull Rectangle bounds) {
        ResizableCellEditor widthChangeSupport;
        if (cellEditor == null) {
            ResizableCellEditorsSupport.$$$reportNull$$$0(1);
        }
        if (bounds == null) {
            ResizableCellEditorsSupport.$$$reportNull$$$0(2);
        }
        if ((widthChangeSupport = (ResizableCellEditor)ObjectUtils.tryCast((Object)cellEditor, ResizableCellEditor.class)) == null) {
            return;
        }
        widthChangeSupport.setWidthChangeEnabled(true);
        try {
            cellEditor.setBounds(bounds);
        }
        finally {
            widthChangeSupport.setWidthChangeEnabled(false);
        }
    }

    private void updateEditingRowHeight(int editingRow, boolean force) {
        Component editor = this.myGrid.getEditorComponent();
        if (editor != null && editingRow >= 0) {
            int newRowHeight = Math.min(10 * this.myGrid.getRowHeight(), editor.getPreferredSize().height + this.myGrid.getRowMargin());
            int currentRowHeight = this.myGrid.getRowHeight(editingRow);
            if (force || this.myCalculatedRowHeight == currentRowHeight) {
                if (currentRowHeight < newRowHeight) {
                    this.setCellSize(editingRow, newRowHeight);
                }
                this.myCalculatedRowHeight = newRowHeight;
            }
        }
    }

    private void stopResetEditingRowHeightTimer() {
        this.myResetEditingCellSizeTimer.stop();
        for (ActionListener listener2 : this.myResetEditingCellSizeTimer.getActionListeners()) {
            listener2.actionPerformed(null);
        }
    }

    private void resetEditingCellSize() {
        final int row = this.myGrid.getEditingRow();
        final int height = this.myRowHeightBeforeEditing;
        if (IdeEventQueue.getInstance().getTrueCurrentEvent() instanceof MouseEvent) {
            this.myResetEditingCellSizeTimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResizableCellEditorsSupport.this.setCellSize(row, height);
                    ResizableCellEditorsSupport.this.myResetEditingCellSizeTimer.removeActionListener(this);
                }
            });
            this.myResetEditingCellSizeTimer.start();
        } else {
            this.setCellSize(row, height);
        }
    }

    private void setCellSize(int row, int height) {
        this.hideExpansionHint();
        if (row != -1 && height != -1) {
            this.myGrid.setRowHeight(row, height);
        }
    }

    private void hideExpansionHint() {
        ExpandableItemsHandler h = this.myGrid.getExpandableItemsHandler();
        if (h.isEnabled() && !h.getExpandedItems().isEmpty()) {
            h.setEnabled(false);
            h.setEnabled(true);
        }
    }

    private void addColumnModelListener(@Nullable TableColumnModel to) {
        if (to != null) {
            to.addColumnModelListener(this);
        }
    }

    private void removeColumnModelListener(@Nullable TableColumnModel from) {
        if (from != null) {
            from.removeColumnModelListener(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCellEditorBounds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ResizableCellEditor {
        public void setWidthChangeEnabled(boolean var1);

        @NotNull
        public HorizontalResizeDirection getHorizontalResizeDirection();

        public static enum HorizontalResizeDirection {
            LEFT{

                @Override
                @NotNull
                Rectangle resize(@NotNull JBTable table, @NotNull Rectangle current, int column2, int preferredWidth) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (current == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Rectangle result2 = new Rectangle(current);
                    int leftmostVisibleX = table.getVisibleRect().x;
                    for (int currentColumn = column2 - 1; currentColumn > -1 && result2.width < preferredWidth; --currentColumn) {
                        Rectangle r = table.getCellRect(0, currentColumn, true);
                        if (leftmostVisibleX > r.x) continue;
                        result2.x = r.x;
                        result2.width += r.width;
                    }
                    Rectangle rectangle = result2;
                    if (rectangle == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return rectangle;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "table";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "current";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport$ResizableCellEditor$HorizontalResizeDirection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport$ResizableCellEditor$HorizontalResizeDirection$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "resize";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "resize";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }
            ,
            RIGHT{

                @Override
                @NotNull
                Rectangle resize(@NotNull JBTable table, @NotNull Rectangle current, int column2, int preferredWidth) {
                    if (table == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (current == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    Rectangle result2 = new Rectangle(current);
                    Rectangle rect = table.getVisibleRect();
                    int rightmostVisibleX = rect.x + rect.width;
                    for (int currentColumn = column2 + 1; currentColumn < table.getColumnCount() && result2.width < preferredWidth; ++currentColumn) {
                        Rectangle r = table.getCellRect(0, currentColumn, true);
                        if (rightmostVisibleX < r.x + r.width) continue;
                        result2.width += r.width;
                    }
                    Rectangle rectangle = result2;
                    if (rectangle == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return rectangle;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "table";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "current";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport$ResizableCellEditor$HorizontalResizeDirection$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/run/ui/grid/ResizableCellEditorsSupport$ResizableCellEditor$HorizontalResizeDirection$2";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "resize";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "resize";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };


            @NotNull
            abstract Rectangle resize(@NotNull JBTable var1, @NotNull Rectangle var2, int var3, int var4);
        }
    }
}

