/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.CompoundObjectEditor;
import com.intellij.database.schemaEditor.DbObjectEditor;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbObjectEditorDialogBase
extends DatabaseScriptDialog {
    private ScriptingTaskBuilder myBuilder;

    public DbObjectEditorDialogBase(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull @NlsContexts.DialogTitle String title) {
        if (project == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(2);
        }
        super(project, dataSource2, searchPath, title);
    }

    protected abstract void reset();

    protected abstract void apply();

    protected void applySourceFromPreview(@NotNull BasicModSourceAware e) {
        if (e == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(3);
        }
        DbObjectEditorDialogBase.applySource(this.myProject, DbSqlUtilCore.getSqlDialect(this.mySource), e, this.myPreviewPanel.getQuery());
    }

    public static void applySource(@NotNull Project project, @NotNull SqlLanguageDialect dialect, final @NotNull BasicModSourceAware e, String query) {
        if (project == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(5);
        }
        if (e == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(6);
        }
        final BasicModElement tmp2 = (BasicModElement)e.getMetaObject().newDataObject();
        SqlFile file = SqlPsiFacade.getInstance((Project)project).createROFile(dialect, (CharSequence)query);
        PsiObject def = (PsiObject)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)file.getDdl())).expandAndSkip(o -> o instanceof SqlAlterStatement)).filter(PsiObject.class).first();
        if (def == null) {
            return;
        }
        SqlObjectBuilder.EP.forDbms(dialect.getDbms()).build(tmp2, def, new SqlObjectBuilder.ContextWithSource(){

            @Override
            public void writeSource(@NotNull BasicModSourceAware object, @Nullable CompositeText src) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (src != null) {
                    super.writeSource(object == tmp2 ? e : object, src);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DbObjectEditorDialogBase$1", "writeSource"));
            }
        });
    }

    @Override
    @NotNull
    protected JComponent createTopComponent() {
        this.myBuilder = this.createBuilder();
        JComponent editor = this.getObjectEditor().getComponent();
        editor.setMinimumSize((Dimension)JBUI.size((int)300, (int)300));
        this.reset();
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(this::generate, this.myDisposable);
        watcher.register((Component)editor);
        ApplicationManager.getApplication().invokeLater(this::generate, ModalityState.stateForComponent((Component)this.getRootPane()));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)editor, (boolean)true);
        if (jScrollPane == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(7);
        }
        return jScrollPane;
    }

    protected abstract DbObjectEditor getObjectEditor();

    protected abstract ScriptingTaskBuilder createBuilder();

    @Override
    @NotNull
    protected List<AnAction> createPreviewActions() {
        List<AnAction> list = Collections.singletonList(DbObjectEditorDialogBase.createSettingsPopupAction(() -> this.getTask(), o -> this.settingsChanged(this.appendCodeStyle((ScriptingOptions)o))));
        if (list == null) {
            DbObjectEditorDialogBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        DbObjectEditor e = (DbObjectEditor)((JBTreeTraverser)JBTreeTraverser.from(o -> o instanceof CompoundObjectEditor ? ((CompoundObjectEditor)o).getEditors() : Collections.emptyList()).withRoot((Object)this.getObjectEditor())).traverse(TreeTraversal.LEAVES_DFS).first();
        return e == null ? null : e.getComponent();
    }

    @Override
    protected ScriptingTask getTask() {
        this.apply();
        return this.myBuilder.build();
    }

    @Override
    protected void settingsChanged(ScriptingOptions options) {
        this.myBuilder.setOptions(options);
        this.generate();
    }

    private void generate() {
        ScriptingResult script = ScriptGenerators.INSTANCE.makeScript(this.myProject, this.getTask());
        this.updateText(script);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorDialogBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorDialogBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applySourceFromPreview";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applySource";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

