/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.BaseRenderer;
import com.intellij.database.schemaEditor.GrantData;
import com.intellij.database.schemaEditor.GrantsColumnInfo;
import com.intellij.database.schemaEditor.StateKey;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.BitSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002H\u0016R\u0015\u0010\u0006\u001a\u00060\u0007R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/schemaEditor/GrantsColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/database/schemaEditor/GrantData;", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "(Lcom/intellij/database/model/properties/Grants$Controller;)V", "myEditor", "Lcom/intellij/database/schemaEditor/GrantsColumnInfo$GrantsEditor;", "getMyEditor", "()Lcom/intellij/database/schemaEditor/GrantsColumnInfo$GrantsEditor;", "myRenderer", "Ljavax/swing/table/TableCellRenderer;", "getColName", "", "idx", "", "getEditor", "Ljavax/swing/table/TableCellEditor;", "user", "getRenderer", "isCellEditable", "", "setValue", "", "value", "valueOf", "o", "ColumnPermData", "GrantsEditor", "GrantsRenderer", "PermData", "intellij.database.impl"})
public final class GrantsColumnInfo
extends ColumnInfo<GrantData, GrantData> {
    private final TableCellRenderer myRenderer;
    @NotNull
    private final GrantsEditor myEditor;

    @NotNull
    public final GrantsEditor getMyEditor() {
        return this.myEditor;
    }

    @NotNull
    public GrantData valueOf(@NotNull GrantData o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return o;
    }

    public void setValue(@NotNull GrantData user, @Nullable GrantData value2) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        user.getGrants().clear();
        if (value2 != null) {
            user.getGrants().putAll((Map<StateKey, Grants.State>)value2.getGrants());
        }
    }

    @NotNull
    public TableCellRenderer getRenderer(@NotNull GrantData user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.myRenderer;
    }

    public boolean isCellEditable(@NotNull GrantData user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return true;
    }

    @NotNull
    public TableCellEditor getEditor(@Nullable GrantData user) {
        return (TableCellEditor)((Object)this.myEditor);
    }

    private final String getColName(int idx) {
        return (String)this.myEditor.getCNames().get(idx);
    }

    public GrantsColumnInfo(@NotNull Grants.Controller<?, ?> grantCtl) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        super("");
        this.myRenderer = new GrantsRenderer();
        this.myEditor = new GrantsEditor(grantCtl);
    }

    public static final /* synthetic */ String access$getColName(GrantsColumnInfo $this, int idx) {
        return $this.getColName(idx);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/schemaEditor/GrantsColumnInfo$GrantsRenderer;", "Lcom/intellij/database/schemaEditor/BaseRenderer;", "(Lcom/intellij/database/schemaEditor/GrantsColumnInfo;)V", "myDeny", "Lcom/intellij/ui/SimpleColoredComponent;", "myGrant", "myRevoke", "appendGrants", "", "comp", "title", "", "perms", "", "extractPermissions", "grants", "Lcom/intellij/database/schemaEditor/GrantData;", "state", "Lcom/intellij/database/model/properties/Grants$State;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "setUp", "line", "intellij.database.impl"})
    public final class GrantsRenderer
    extends BaseRenderer {
        private final SimpleColoredComponent myGrant;
        private final SimpleColoredComponent myRevoke;
        private final SimpleColoredComponent myDeny;

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Object $this$castSafelyTo$iv = value2;
            boolean $i$f$castSafelyTo = false;
            Object object = $this$castSafelyTo$iv;
            if (!(object instanceof GrantData)) {
                object = null;
            }
            GrantData g = (GrantData)object;
            String string = DatabaseBundle.message("DbObjectGrantsEditor.label.grant", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026rantsEditor.label.grant\")");
            this.appendGrants(this.myGrant, string, this.extractPermissions(g, Grants.State.GRANT));
            String string2 = DatabaseBundle.message("DbObjectGrantsEditor.label.revoke", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DatabaseBundle.message(\"\u2026antsEditor.label.revoke\")");
            this.appendGrants(this.myRevoke, string2, this.extractPermissions(g, Grants.State.REVOKE));
            String string3 = DatabaseBundle.message("DbObjectGrantsEditor.label.deny", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DatabaseBundle.message(\"\u2026GrantsEditor.label.deny\")");
            this.appendGrants(this.myDeny, string3, this.extractPermissions(g, Grants.State.DENY));
            if (g == null || g.getGrants().isEmpty()) {
                this.myGrant.setVisible(true);
                this.myGrant.append(DatabaseBundle.message("DbObjectGrantsEditor.label.no.grants", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            return super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column2);
        }

        private final void setUp(SimpleColoredComponent line) {
            line.setOpaque(false);
            line.setIpad((Insets)JBUI.emptyInsets());
        }

        private final void appendGrants(SimpleColoredComponent comp, @Nls String title, Set<String> perms) {
            Collection collection = perms;
            boolean bl = false;
            boolean visible = !collection.isEmpty();
            comp.setVisible(visible);
            comp.clear();
            if (!visible) {
                return;
            }
            comp.append(title, SimpleTextAttributes.GRAY_ATTRIBUTES);
            comp.append(" ");
            comp.append(StringUtil.join((Collection)perms, (String)", "));
        }

        private final Set<String> extractPermissions(GrantData grants, Grants.State state) {
            if (grants == null) {
                return SetsKt.emptySet();
            }
            Set res2 = new TreeSet();
            Map<String, BitSet> items2 = grants.groupColumnsForState(state);
            for (Map.Entry<String, BitSet> entry : items2.entrySet()) {
                String perm;
                StringBuilder text2 = new StringBuilder();
                text2.append(entry.getKey());
                if (state.getWithGrantOption()) {
                    text2.append("+");
                }
                if (!entry.getValue().isEmpty()) {
                    text2.append('(');
                    StringUtil.join((Iterable)((Iterable)JBIterable.once(entry.getValue().stream().boxed().iterator())), (Function)new Function(this){
                        final /* synthetic */ GrantsRenderer this$0;

                        public final CharSequence fun(Integer idx) {
                            GrantsColumnInfo grantsColumnInfo = this.this$0.GrantsColumnInfo.this;
                            Integer n = idx;
                            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"idx");
                            return GrantsColumnInfo.access$getColName(grantsColumnInfo, n);
                        }
                        {
                            this.this$0 = grantsRenderer;
                        }
                    }, (String)",", (StringBuilder)text2);
                    text2.append(')');
                }
                Intrinsics.checkNotNullExpressionValue((Object)text2.toString(), (String)"text.toString()");
                res2.add(perm);
            }
            if (state == Grants.State.GRANT) {
                res2.addAll((Collection)this.extractPermissions(grants, Grants.State.GRANT_WITH_GRANT_OPTION));
            }
            return res2;
        }

        public GrantsRenderer() {
            super(new Box(1));
            this.myGrant = new SimpleColoredComponent();
            this.myRevoke = new SimpleColoredComponent();
            this.myDeny = new SimpleColoredComponent();
            this.setUp(this.myGrant);
            this.setUp(this.myRevoke);
            this.setUp(this.myDeny);
            this.getMyComponent().add((Component)this.myGrant);
            this.getMyComponent().add((Component)this.myRevoke);
            this.getMyComponent().add((Component)this.myDeny);
            this.getMyComponent().setBorder((Border)JBUI.Borders.empty((int)JBUI.scale((int)2), (int)0));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/schemaEditor/GrantsColumnInfo$PermData;", "", "perm", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "unknown", "", "(Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;Z)V", "getPerm", "()Ljava/lang/String;", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "setState", "(Lcom/intellij/database/model/properties/Grants$State;)V", "getUnknown", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.impl"})
    public static final class PermData {
        @NotNull
        private final String perm;
        @Nullable
        private Grants.State state;
        private final boolean unknown;

        @NotNull
        public final String getPerm() {
            return this.perm;
        }

        @Nullable
        public final Grants.State getState() {
            return this.state;
        }

        public final void setState(@Nullable Grants.State state) {
            this.state = state;
        }

        public final boolean getUnknown() {
            return this.unknown;
        }

        public PermData(@Nls @NotNull String perm, @Nullable Grants.State state, boolean unknown) {
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            this.perm = perm;
            this.state = state;
            this.unknown = unknown;
        }

        @NotNull
        public final String component1() {
            return this.perm;
        }

        @Nullable
        public final Grants.State component2() {
            return this.state;
        }

        public final boolean component3() {
            return this.unknown;
        }

        @NotNull
        public final PermData copy(@Nls @NotNull String perm, @Nullable Grants.State state, boolean unknown) {
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            return new PermData(perm, state, unknown);
        }

        public static /* synthetic */ PermData copy$default(PermData permData, String string, Grants.State state, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = permData.perm;
            }
            if ((n & 2) != 0) {
                state = permData.state;
            }
            if ((n & 4) != 0) {
                bl = permData.unknown;
            }
            return permData.copy(string, state, bl);
        }

        @NotNull
        public String toString() {
            return "PermData(perm=" + this.perm + ", state=" + (Object)((Object)this.state) + ", unknown=" + this.unknown + ")";
        }

        public int hashCode() {
            String string = this.perm;
            Grants.State state = this.state;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (state != null ? ((Object)((Object)state)).hashCode() : 0)) * 31;
            int n2 = this.unknown ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PermData)) break block3;
                    PermData permData = (PermData)object;
                    if (!Intrinsics.areEqual((Object)this.perm, (Object)permData.perm) || !Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)permData.state)) || this.unknown != permData.unknown) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/schemaEditor/GrantsColumnInfo$ColumnPermData;", "", "colName", "", "position", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "(Ljava/lang/String;ILcom/intellij/database/model/properties/Grants$State;)V", "getColName", "()Ljava/lang/String;", "getPosition", "()I", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "setState", "(Lcom/intellij/database/model/properties/Grants$State;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.impl"})
    public static final class ColumnPermData {
        @NotNull
        private final String colName;
        private final int position;
        @Nullable
        private Grants.State state;

        @NotNull
        public final String getColName() {
            return this.colName;
        }

        public final int getPosition() {
            return this.position;
        }

        @Nullable
        public final Grants.State getState() {
            return this.state;
        }

        public final void setState(@Nullable Grants.State state) {
            this.state = state;
        }

        public ColumnPermData(@Nls @NotNull String colName, int position, @Nullable Grants.State state) {
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            this.colName = colName;
            this.position = position;
            this.state = state;
        }

        @NotNull
        public final String component1() {
            return this.colName;
        }

        public final int component2() {
            return this.position;
        }

        @Nullable
        public final Grants.State component3() {
            return this.state;
        }

        @NotNull
        public final ColumnPermData copy(@Nls @NotNull String colName, int position, @Nullable Grants.State state) {
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            return new ColumnPermData(colName, position, state);
        }

        public static /* synthetic */ ColumnPermData copy$default(ColumnPermData columnPermData, String string, int n, Grants.State state, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = columnPermData.colName;
            }
            if ((n2 & 2) != 0) {
                n = columnPermData.position;
            }
            if ((n2 & 4) != 0) {
                state = columnPermData.state;
            }
            return columnPermData.copy(string, n, state);
        }

        @NotNull
        public String toString() {
            return "ColumnPermData(colName=" + this.colName + ", position=" + this.position + ", state=" + (Object)((Object)this.state) + ")";
        }

        public int hashCode() {
            String string = this.colName;
            Grants.State state = this.state;
            return ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.position)) * 31 + (state != null ? ((Object)((Object)state)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ColumnPermData)) break block3;
                    ColumnPermData columnPermData = (ColumnPermData)object;
                    if (!Intrinsics.areEqual((Object)this.colName, (Object)columnPermData.colName) || this.position != columnPermData.position || !Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)columnPermData.state))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\u001cH\u0016J2\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J\"\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010.\u001a\u00020)2\b\u0010/\u001a\u0004\u0018\u000100R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/intellij/database/schemaEditor/GrantsColumnInfo$GrantsEditor;", "Lcom/intellij/util/ui/AbstractTableCellEditor;", "myGrantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "(Lcom/intellij/database/schemaEditor/GrantsColumnInfo;Lcom/intellij/database/model/properties/Grants$Controller;)V", "cNames", "Lgnu/trove/TIntObjectHashMap;", "", "getCNames", "()Lgnu/trove/TIntObjectHashMap;", "current", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getMyGrantCtl", "()Lcom/intellij/database/model/properties/Grants$Controller;", "myMeta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "myModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "myTable", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "children", "Lcom/intellij/util/containers/JBIterable;", "node", "getCellEditorValue", "", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "isSelected", "", "row", "", "column", "stopCellEditing", "updateStructure", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "meta", "colNames", "updateValues", "grants", "Lcom/intellij/database/schemaEditor/GrantData;", "intellij.database.impl"})
    public final class GrantsEditor
    extends AbstractTableCellEditor {
        @NotNull
        private final DefaultMutableTreeNode root;
        @NotNull
        private final TIntObjectHashMap<String> cNames;
        private BasicMetaObject<?> myMeta;
        private final ListTreeTableModelOnColumns myModel;
        private final TreeTable myTable;
        private JBPopup current;
        @NotNull
        private final Grants.Controller<?, ?> myGrantCtl;

        @NotNull
        public final DefaultMutableTreeNode getRoot() {
            return this.root;
        }

        @NotNull
        public final TIntObjectHashMap<String> getCNames() {
            return this.cNames;
        }

        public final void updateStructure(@Nullable BasicElement e) {
            BasicElement basicElement = e;
            BasicMetaObject<?> meta = basicElement != null ? basicElement.getMetaObject() : null;
            BasicElement basicElement2 = e;
            Family<? extends BasicElement> family = basicElement2 != null ? basicElement2.familyOf(ObjectKind.COLUMN) : null;
            if (!(family instanceof PositioningFamily)) {
                family = null;
            }
            PositioningFamily cols = (PositioningFamily)family;
            TIntObjectHashMap colNames = new TIntObjectHashMap();
            PositioningFamily positioningFamily = cols;
            if (positioningFamily != null) {
                Iterable $this$forEach$iv = positioningFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BasicArrangedElement it2 = (BasicArrangedElement)element$iv;
                    boolean bl = false;
                    BasicArrangedElement basicArrangedElement = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)basicArrangedElement, (String)"it");
                    colNames.put((int)basicArrangedElement.getPosition(), (Object)it2.getName());
                }
            }
            this.updateStructure(meta, (TIntObjectHashMap<String>)colNames);
        }

        public final void updateStructure(@Nullable BasicMetaObject<?> meta, @NotNull TIntObjectHashMap<String> colNames) {
            Object object;
            List privs;
            List poses;
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter(colNames, (String)"colNames");
                    this.root.removeAllChildren();
                    this.cNames.clear();
                    int[] nArray = colNames.keys();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"colNames.keys()");
                    poses = ArraysKt.sorted((int[])nArray);
                    Iterator iterator = poses.iterator();
                    while (iterator.hasNext()) {
                        int pos = ((Number)iterator.next()).intValue();
                        this.cNames.put(pos, colNames.get(pos));
                    }
                    this.myMeta = meta;
                    if (meta == null) {
                        return;
                    }
                    privs = CollectionsKt.sorted(this.myGrantCtl.possiblePrivileges(meta));
                    object = BasicMetaUtils.findChild(meta, ObjectKind.COLUMN);
                    if (object == null) break block8;
                    BasicMetaObject basicMetaObject = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    BasicMetaObject it2 = basicMetaObject;
                    boolean bl3 = false;
                    BasicMetaObject basicMetaObject2 = it2;
                    Intrinsics.checkNotNullExpressionValue(basicMetaObject2, (String)"it");
                    object = CollectionsKt.toSet(this.myGrantCtl.possiblePrivileges(basicMetaObject2));
                    if (object != null) break block9;
                }
                object = SetsKt.emptySet();
            }
            BasicMetaObject colPrivs = object;
            for (String p2 : privs) {
                DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new PermData(p2, null, false));
                if (!this.cNames.isEmpty() && colPrivs.contains(p2)) {
                    Iterator iterator = poses.iterator();
                    while (iterator.hasNext()) {
                        int pos = ((Number)iterator.next()).intValue();
                        Object object2 = this.cNames.get(pos);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"cNames.get(pos)");
                        pNode.add(new DefaultMutableTreeNode(new ColumnPermData((String)object2, pos, null)));
                    }
                }
                this.root.add(pNode);
            }
            this.myModel.reload();
        }

        public final void updateValues(@Nullable GrantData grants) {
            Object pNode;
            StateKey k;
            Grants.State s2;
            Map.Entry element$iv;
            boolean bl;
            Object key;
            Object object;
            Cloneable cloneable = grants;
            Map values2 = cloneable != null && (cloneable = cloneable.getGrants()) != null ? (Map)((Object)cloneable) : MapsKt.emptyMap();
            LinkedHashMap processed = new LinkedHashMap();
            Iterator iterator = this.children(this.root).iterator();
            while (iterator.hasNext()) {
                PermData p2;
                DefaultMutableTreeNode pNode2;
                DefaultMutableTreeNode defaultMutableTreeNode = pNode2 = (DefaultMutableTreeNode)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"pNode");
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (!(object2 instanceof PermData)) {
                    object2 = null;
                }
                if ((PermData)object2 == null) {
                    continue;
                }
                if (p2.getUnknown()) {
                    pNode2.removeFromParent();
                    continue;
                }
                object = new StateKey(p2.getPerm(), null);
                boolean bl2 = false;
                boolean bl3 = false;
                Object key2 = object;
                boolean bl4 = false;
                p2.setState((Grants.State)((Object)values2.get(key2)));
                ((Map)processed).put(key2, pNode2);
                Iterator iterator2 = this.children(pNode2).iterator();
                while (iterator2.hasNext()) {
                    ColumnPermData cp;
                    DefaultMutableTreeNode cNode;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = cNode = (DefaultMutableTreeNode)iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode2, (String)"cNode");
                    Object object3 = defaultMutableTreeNode2.getUserObject();
                    if (!(object3 instanceof ColumnPermData)) {
                        object3 = null;
                    }
                    if ((ColumnPermData)object3 == null) {
                        continue;
                    }
                    key2 = new StateKey(p2.getPerm(), cp.getPosition());
                    bl4 = false;
                    boolean bl5 = false;
                    key = key2;
                    bl = false;
                    cp.setState((Grants.State)((Object)values2.get(key)));
                    ((Map)processed).put(key, cNode);
                    key2 = cp.getColName();
                    bl4 = false;
                    if (!(key2.length() == 0)) continue;
                    cNode.removeFromParent();
                }
            }
            int[] nArray = this.cNames.keys();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"cNames.keys()");
            List poses = ArraysKt.sorted((int[])nArray);
            Map $this$forEach$iv = values2;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv;
            boolean bl6 = false;
            Iterator iterator3 = object.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry $dstr$k$s = element$iv = iterator3.next();
                boolean bl7 = false;
                key = $dstr$k$s;
                bl = false;
                StateKey stateKey = (StateKey)key.getKey();
                key = $dstr$k$s;
                bl = false;
                s2 = (Grants.State)((Object)key.getValue());
                if (k.getPos() != null || processed.containsKey(k)) continue;
                pNode = new DefaultMutableTreeNode(new PermData(k.getPerm(), s2, true));
                this.root.add((MutableTreeNode)pNode);
                ((Map)processed).put(k, pNode);
                Iterator iterator4 = poses.iterator();
                while (iterator4.hasNext()) {
                    int pos = ((Number)iterator4.next()).intValue();
                    StateKey key3 = new StateKey(k.getPerm(), pos);
                    Object object4 = this.cNames.get(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"cNames[pos]");
                    DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new ColumnPermData((String)object4, pos, (Grants.State)((Object)values2.get(key3))));
                    ((DefaultMutableTreeNode)pNode).add(cNode);
                    ((Map)processed).put(key3, cNode);
                }
            }
            $this$forEach$iv = values2;
            $i$f$forEach = false;
            object = $this$forEach$iv;
            bl6 = false;
            iterator3 = object.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry $dstr$k$s = element$iv = iterator3.next();
                boolean bl8 = false;
                pNode = $dstr$k$s;
                boolean pos = false;
                k = (StateKey)pNode.getKey();
                pNode = $dstr$k$s;
                pos = false;
                s2 = (Grants.State)((Object)pNode.getValue());
                if (k.getPos() == null || processed.containsKey(k)) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)processed.get(new StateKey(k.getPerm(), null));
                if (defaultMutableTreeNode == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"processed[StateKey(k.per\u2026 null)] ?: return@forEach");
                pNode = defaultMutableTreeNode;
                Integer n = k.getPos();
                Intrinsics.checkNotNull((Object)n);
                DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new ColumnPermData("", n, s2));
                ((DefaultMutableTreeNode)pNode).add(cNode);
            }
            this.myModel.reload();
        }

        @NotNull
        public Component getTableCellEditorComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Component component = new GrantsRenderer().getTableCellRendererComponent(table, value2, isSelected, true, row, column2);
            Object $this$castSafelyTo$iv = value2;
            boolean $i$f$castSafelyTo = false;
            Object object = $this$castSafelyTo$iv;
            if (!(object instanceof GrantData)) {
                object = null;
            }
            this.updateValues((GrantData)object);
            UiNotifyConnector.doWhenFirstShown((Component)component, (Runnable)new Runnable(this, component){
                final /* synthetic */ GrantsEditor this$0;
                final /* synthetic */ Component $component;

                public final void run() {
                    JBPopup prev;
                    JBPopup jBPopup = prev = GrantsEditor.access$getCurrent$p(this.this$0);
                    if (jBPopup != null) {
                        jBPopup.closeOk(null);
                    }
                    JBPopup jBPopup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)GrantsEditor.access$getMyTable$p(this.this$0)), (boolean)true), (JComponent)GrantsEditor.access$getMyTable$p(this.this$0)).addListener(new JBPopupListener(this){
                        final /* synthetic */ getTableCellEditorComponent.1 this$0;

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            this.this$0.this$0.stopCellEditing();
                        }
                        {
                            this.this$0 = this$0;
                        }
                    }).setMinSize((Dimension)JBUI.size((int)300, (int)250)).setRequestFocus(true).createPopup();
                    Intrinsics.checkNotNullExpressionValue((Object)jBPopup2, (String)"JBPopupFactory.getInstan\u2026\n          .createPopup()");
                    JBPopup popup2 = jBPopup2;
                    popup2.show(new RelativePoint(this.$component, new Point(0, 0)));
                    GrantsEditor.access$setCurrent$p(this.this$0, popup2);
                }
                {
                    this.this$0 = grantsEditor;
                    this.$component = component;
                }
            });
            return component;
        }

        public boolean stopCellEditing() {
            block0: {
                JBPopup popup2;
                JBPopup jBPopup = popup2 = this.current;
                if (jBPopup == null) break block0;
                jBPopup.closeOk(null);
            }
            return super.stopCellEditing();
        }

        @NotNull
        public Object getCellEditorValue() {
            GrantData res2 = new GrantData();
            Iterator iterator = this.children(this.root).iterator();
            while (iterator.hasNext()) {
                PermData p2;
                DefaultMutableTreeNode pNode;
                DefaultMutableTreeNode defaultMutableTreeNode = pNode = (DefaultMutableTreeNode)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"pNode");
                Object object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof PermData)) {
                    object = null;
                }
                if ((PermData)object == null) {
                    continue;
                }
                if (p2.getState() != null) {
                    Grants.State state;
                    boolean bl = false;
                    boolean bl2 = false;
                    Grants.State it2 = state;
                    boolean bl3 = false;
                    ((Map)res2.getGrants()).put(new StateKey(p2.getPerm(), null), it2);
                }
                Iterator iterator2 = this.children(pNode).iterator();
                while (iterator2.hasNext()) {
                    Grants.State state;
                    ColumnPermData cp;
                    DefaultMutableTreeNode cNode;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = cNode = (DefaultMutableTreeNode)iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode2, (String)"cNode");
                    Object object2 = defaultMutableTreeNode2.getUserObject();
                    if (!(object2 instanceof ColumnPermData)) {
                        object2 = null;
                    }
                    if ((ColumnPermData)object2 == null) {
                        continue;
                    }
                    if (cp.getState() == null) continue;
                    boolean bl = false;
                    boolean bl4 = false;
                    Grants.State it3 = state;
                    boolean bl5 = false;
                    ((Map)res2.getGrants()).put(new StateKey(p2.getPerm(), cp.getPosition()), it3);
                }
            }
            return res2;
        }

        @NotNull
        public final JBIterable<DefaultMutableTreeNode> children(@NotNull DefaultMutableTreeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JBIterable jBIterable = JBIterable.once(node.children().asIterator()).filter(DefaultMutableTreeNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.once(node.chi\u2026ableTreeNode::class.java)");
            return jBIterable;
        }

        @NotNull
        public final Grants.Controller<?, ?> getMyGrantCtl() {
            return this.myGrantCtl;
        }

        public GrantsEditor(Grants.Controller<?, ?> myGrantCtl) {
            Intrinsics.checkNotNullParameter(myGrantCtl, (String)"myGrantCtl");
            this.myGrantCtl = myGrantCtl;
            this.root = new DefaultMutableTreeNode("ROOT");
            this.cNames = new TIntObjectHashMap();
            this.myModel = new ListTreeTableModelOnColumns((TreeNode)this.root, new ColumnInfo[]{(ColumnInfo)new TreeColumnInfo(""), (ColumnInfo)new ColumnInfo<DefaultMutableTreeNode, Grants.State>(this, ""){
                final /* synthetic */ GrantsEditor this$0;

                @Nullable
                public Grants.State valueOf(@NotNull DefaultMutableTreeNode o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    Object uo = o.getUserObject();
                    return uo instanceof PermData ? ((PermData)uo).getState() : (uo instanceof ColumnPermData ? ((ColumnPermData)uo).getState() : null);
                }

                public void setValue(@NotNull DefaultMutableTreeNode node, @Nullable Grants.State value2) {
                    block1: {
                        Object uo;
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            uo = node.getUserObject();
                            if (!(uo instanceof PermData)) break block0;
                            ((PermData)uo).setState(value2);
                            break block1;
                        }
                        if (!(uo instanceof ColumnPermData)) break block1;
                        ((ColumnPermData)uo).setState(value2);
                    }
                }

                public boolean isCellEditable(@NotNull DefaultMutableTreeNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return true;
                }

                @NotNull
                public TableCellRenderer getRenderer(@NotNull DefaultMutableTreeNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return (TableCellRenderer)new ColoredTableCellRenderer(this){
                        final /* synthetic */ myModel.1 this$0;

                        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
                            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                            myModel.1.access$render(this.this$0, (SimpleColoredComponent)this, value2);
                        }
                        {
                            this.this$0 = this$0;
                        }
                    };
                }

                private final void render(SimpleColoredComponent c2, Object value2) {
                    Object object = value2;
                    if (object == Grants.State.GRANT) {
                        Intrinsics.checkNotNullExpressionValue((Object)c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.grant", new Object[0])), (String)"c.append(DatabaseBundle.\u2026itor.state.label.grant\"))");
                    } else if (object == Grants.State.GRANT_WITH_GRANT_OPTION) {
                        Intrinsics.checkNotNullExpressionValue((Object)c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.grant.with.option", new Object[0])), (String)"c.append(DatabaseBundle.\u2026abel.grant.with.option\"))");
                    } else if (object == Grants.State.REVOKE) {
                        Intrinsics.checkNotNullExpressionValue((Object)c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.revoke", new Object[0])), (String)"c.append(DatabaseBundle.\u2026tor.state.label.revoke\"))");
                    } else if (object == Grants.State.DENY) {
                        Intrinsics.checkNotNullExpressionValue((Object)c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.deny", new Object[0])), (String)"c.append(DatabaseBundle.\u2026ditor.state.label.deny\"))");
                    } else {
                        c2.append(DatabaseBundle.message("DbObjectGrantsEditor.state.label.not.granted", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }

                @NotNull
                public TableCellEditor getEditor(@NotNull DefaultMutableTreeNode node) {
                    Grants.State[] stateArray;
                    block9: {
                        block8: {
                            Grants.State[] meta;
                            Object object;
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (node.getUserObject() instanceof ColumnPermData) {
                                object = BasicMetaUtils.findChild(GrantsEditor.access$getMyMeta$p(this.this$0), ObjectKind.COLUMN);
                                if (object == null) {
                                    object = GrantsEditor.access$getMyMeta$p(this.this$0);
                                }
                            } else {
                                object = GrantsEditor.access$getMyMeta$p(this.this$0);
                            }
                            stateArray = meta = object;
                            if (meta == null) break block8;
                            Grants.State[] stateArray2 = stateArray;
                            boolean bl = false;
                            boolean bl2 = false;
                            Grants.State[] it2 = stateArray2;
                            boolean bl3 = false;
                            stateArray = this.this$0.getMyGrantCtl().possibleStates((BasicMetaObject<?>)it2);
                            if (stateArray != null) break block9;
                        }
                        stateArray = Grants.State.values();
                    }
                    List states = ArraysKt.toMutableList((Object[])stateArray);
                    states.add(0, null);
                    Collection $this$toTypedArray$iv = states;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Grants.State[] stateArray3 = thisCollection$iv.toArray(new Grants.State[0]);
                    if (stateArray3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    ComboBox box = new ComboBox((Object[])stateArray3);
                    box.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Grants.State>(this){
                        final /* synthetic */ myModel.1 this$0;

                        protected void customizeCellRenderer(@NotNull JList<? extends Grants.State> list, @Nullable Grants.State value2, int index2, boolean selected, boolean hasFocus) {
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            myModel.1.access$render(this.this$0, (SimpleColoredComponent)this, (Object)((Object)value2));
                        }
                        {
                            this.this$0 = this$0;
                        }
                    });
                    Function0 function0 = (Function0)new Function0<Unit>(box){

                        public final void invoke() {
                            ((ComboBox)this.receiver).showPopup();
                        }
                    };
                    UiNotifyConnector.doWhenFirstShown((JComponent)((JComponent)box), (Runnable)new Runnable(function0){
                        private final /* synthetic */ Function0 function;
                        {
                            this.function = function0;
                        }

                        public final /* synthetic */ void run() {
                            Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                        }
                    });
                    return new DefaultCellEditor((JComboBox)box);
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                }

                public static final /* synthetic */ void access$render(myModel.1 $this, SimpleColoredComponent c2, Object value2) {
                    $this.render(c2, value2);
                }
            }});
            this.myTable = new TreeTable(this, (TreeTableModel)this.myModel){
                final /* synthetic */ GrantsEditor this$0;

                @NotNull
                public TableCellRenderer getCellRenderer(int row, int column2) {
                    Object object;
                    block6: {
                        block5: {
                            Object object2;
                            object = this.getColumnInfo(column2);
                            if (object == null) break block5;
                            ColumnInfo<Object, ?> columnInfo = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            ColumnInfo<Object, ?> colInfo = columnInfo;
                            boolean bl3 = false;
                            Object object3 = this.getRow(row);
                            if (object3 != null) {
                                Object object4 = object3;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                Object it2 = object4;
                                boolean bl6 = false;
                                object2 = colInfo.getRenderer(it2);
                            } else {
                                object2 = object = null;
                            }
                            if (object2 != null) break block6;
                        }
                        TableCellRenderer tableCellRenderer = super.getCellRenderer(row, column2);
                        object = tableCellRenderer;
                        Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer, (String)"super.getCellRenderer(row, column)");
                    }
                    return object;
                }

                @NotNull
                public TableCellEditor getCellEditor(int row, int column2) {
                    Object object;
                    block6: {
                        block5: {
                            Object object2;
                            object = this.getColumnInfo(column2);
                            if (object == null) break block5;
                            ColumnInfo<Object, ?> columnInfo = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            ColumnInfo<Object, ?> colInfo = columnInfo;
                            boolean bl3 = false;
                            Object object3 = this.getRow(row);
                            if (object3 != null) {
                                Object object4 = object3;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                Object it2 = object4;
                                boolean bl6 = false;
                                object2 = colInfo.getEditor(it2);
                            } else {
                                object2 = object = null;
                            }
                            if (object2 != null) break block6;
                        }
                        TableCellEditor tableCellEditor = super.getCellEditor(row, column2);
                        object = tableCellEditor;
                        Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor, (String)"super.getCellEditor(row, column)");
                    }
                    return object;
                }

                public boolean editCellAt(int row, int column2, @Nullable EventObject e) {
                    return super.editCellAt(row, column2 == 0 ? 1 : column2, e);
                }

                public boolean editCellAt(int row, int column2) {
                    return super.editCellAt(row, column2 == 0 ? 1 : column2);
                }

                private final Object getRow(int row) {
                    TreePath treePath = this.getTree().getPathForRow(row);
                    return treePath != null ? treePath.getLastPathComponent() : null;
                }

                private final ColumnInfo<Object, ?> getColumnInfo(int column2) {
                    ColumnInfo[] columnInfoArray;
                    TreeTableModel $this$castSafelyTo$iv = this.getTableModel();
                    boolean $i$f$castSafelyTo = false;
                    TreeTableModel treeTableModel = $this$castSafelyTo$iv;
                    if (!(treeTableModel instanceof ListTreeTableModelOnColumns)) {
                        treeTableModel = null;
                    }
                    return (columnInfoArray = (ColumnInfo[])treeTableModel) != null && (columnInfoArray = columnInfoArray.getColumns()) != null ? columnInfoArray[this.convertColumnIndexToModel(column2)] : null;
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                }
            };
            this.myTable.setRootVisible(false);
            this.myTable.setTableHeader((JTableHeader)null);
            this.myTable.setTreeCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    block2: {
                        String string;
                        Object uo;
                        block3: {
                            Object object;
                            block1: {
                                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                                Object $this$castSafelyTo$iv = value2;
                                boolean $i$f$castSafelyTo = false;
                                Object object2 = $this$castSafelyTo$iv;
                                if (!(object2 instanceof DefaultMutableTreeNode)) {
                                    object2 = null;
                                }
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                                uo = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                                object = uo;
                                if (!(object instanceof PermData)) break block1;
                                this.append(((PermData)uo).getPerm(), ((PermData)uo).getUnknown() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                                break block2;
                            }
                            if (!(object instanceof ColumnPermData)) break block2;
                            string = StringKt.nullize$default((String)((ColumnPermData)uo).getColName(), (boolean)false, (int)1, null);
                            if (string == null) break block3;
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it2 = string2;
                            boolean bl3 = false;
                            this.append(it2);
                            string = string2;
                            if (string != null) break block2;
                        }
                        this.append(DatabaseBundle.message("column.0", ((ColumnPermData)uo).getPosition()), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        string = Unit.INSTANCE;
                    }
                }
            });
        }

        public static final /* synthetic */ JBPopup access$getCurrent$p(GrantsEditor $this) {
            return $this.current;
        }

        public static final /* synthetic */ void access$setCurrent$p(GrantsEditor $this, JBPopup jBPopup) {
            $this.current = jBPopup;
        }

        public static final /* synthetic */ TreeTable access$getMyTable$p(GrantsEditor $this) {
            return $this.myTable;
        }

        public static final /* synthetic */ BasicMetaObject access$getMyMeta$p(GrantsEditor $this) {
            return $this.myMeta;
        }

        public static final /* synthetic */ void access$setMyMeta$p(GrantsEditor $this, BasicMetaObject basicMetaObject) {
            $this.myMeta = basicMetaObject;
        }
    }
}

