/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.Dbms;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMigrationUtils {
    private DbSrcMigrationUtils() {
    }

    @Nullable
    public static TextRange findCompactDefinitionRange(@NotNull Project project, Dbms dbms, ObjectPath path, CompositeText sql, Function<CompositeText, CompositeText> makeParsable) {
        if (project == null) {
            DbSrcMigrationUtils.$$$reportNull$$$0(0);
        }
        TextRange rg = null;
        if (!ContainerUtil.exists(sql.getFragments(), f -> f.getKind() == CompositeText.Kind.COMPACT_DEFINITION)) {
            TextRange content;
            SqlObjectBuilder builder = SqlObjectBuilder.EP.forDbms(dbms);
            rg = builder.getCompactDefinition(path, sql, null);
            if (rg == null) {
                TextRange r = sql.getContentRange();
                if (r == null) {
                    return null;
                }
                PsiObject object = null;
                int offset = 0;
                CompositeText parsable = sql;
                try {
                    parsable = (CompositeText)makeParsable.fun((Object)sql);
                    if (parsable != sql) {
                        TextRange pr = parsable.getContentRange();
                        if (pr == null) {
                            parsable = sql;
                        } else {
                            offset = r.getStartOffset() - pr.getStartOffset();
                        }
                    }
                    SqlFile file = SqlPsiFacade.getInstance((Project)project).createROFile(DbSqlUtilCore.getSqlDialect(dbms), parsable.getText());
                    object = (PsiObject)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)file.getDdl())).expandAndSkip(o -> o instanceof SqlAlterStatement)).filter(PsiObject.class).first();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (object != null && (rg = builder.getCompactDefinition(path, parsable, object)) != null) {
                    rg = rg.shiftRight(offset);
                }
            }
            if (rg != null && (content = sql.getContentRange()) != null) {
                rg = rg.intersection(content);
            }
        }
        return rg == null || rg.isEmpty() ? null : rg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/script/DbSrcMigrationUtils", "findCompactDefinitionRange"));
    }
}

