/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTask;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0016"}, d2={"anyCurrentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/script/generator/ScriptingTask;", "getAnyCurrentDatabase", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicDatabase;", "anyCurrentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "getAnyCurrentSchema", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicSchema;", "anyModel", "Lcom/intellij/database/model/basic/BasicModel;", "getAnyModel", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicModel;", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/Dbms;", "newModel", "getNewModel", "defaultScriptingOptions", "Lcom/intellij/database/script/generator/CustomScriptingOptions;", "model", "intellij.database.core.impl"})
public final class ScriptingTaskKt {
    @NotNull
    public static final CustomScriptingOptions defaultScriptingOptions(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Dbms dbms = model.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"model.dbms");
        return ScriptingTaskKt.defaultScriptingOptions(dbms);
    }

    @NotNull
    public static final CustomScriptingOptions defaultScriptingOptions(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return new CustomScriptingOptions(MapsKt.mapOf((Pair)TuplesKt.to(ScriptingOptionStatic.CODE_STYLE, (Object)SqlCodeStyles.getSqlSettings(null, (Language)((Language)DbSqlUtilCore.getSqlDialect(dbms))))));
    }

    @Nullable
    public static final BasicModel getAnyModel(@NotNull ScriptingTask $this$anyModel) {
        BasicModel basicModel;
        Intrinsics.checkNotNullParameter((Object)$this$anyModel, (String)"$this$anyModel");
        ScriptingTask scriptingTask = $this$anyModel;
        if (scriptingTask instanceof ScriptingSingleModelTask) {
            basicModel = ((ScriptingSingleModelTask)$this$anyModel).getModel();
        } else if (scriptingTask instanceof ScriptingNativeDefinitionTask) {
            basicModel = ((ScriptingNativeDefinitionTask)$this$anyModel).getModel();
        } else if (scriptingTask instanceof ScriptingAlterTask) {
            basicModel = ((ScriptingAlterTask)$this$anyModel).getSourceModel();
        } else if (scriptingTask instanceof ScriptingInternalTask) {
            basicModel = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return basicModel;
    }

    @Nullable
    public static final BasicModel getNewModel(@NotNull ScriptingTask $this$newModel) {
        BasicModel basicModel;
        Intrinsics.checkNotNullParameter((Object)$this$newModel, (String)"$this$newModel");
        ScriptingTask scriptingTask = $this$newModel;
        if (scriptingTask instanceof ScriptingSingleModelTask) {
            basicModel = ((ScriptingSingleModelTask)$this$newModel).getModel();
        } else if (scriptingTask instanceof ScriptingNativeDefinitionTask) {
            basicModel = ((ScriptingNativeDefinitionTask)$this$newModel).getModel();
        } else if (scriptingTask instanceof ScriptingAlterTask) {
            basicModel = ((ScriptingAlterTask)$this$newModel).getTargetModel();
        } else if (scriptingTask instanceof ScriptingInternalTask) {
            basicModel = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return basicModel;
    }

    @NotNull
    public static final Dbms getDbms(@NotNull ScriptingTask $this$dbms) {
        Dbms dbms;
        Intrinsics.checkNotNullParameter((Object)$this$dbms, (String)"$this$dbms");
        ScriptingTask scriptingTask = $this$dbms;
        if (scriptingTask instanceof ScriptingInternalTask) {
            dbms = ((ScriptingInternalTask)$this$dbms).getDbms();
        } else {
            BasicModel basicModel = ScriptingTaskKt.getAnyModel($this$dbms);
            Intrinsics.checkNotNull((Object)basicModel);
            Dbms dbms2 = basicModel.getDbms();
            dbms = dbms2;
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"anyModel!!.dbms");
        }
        return dbms;
    }

    @Nullable
    public static final BasicDatabase getAnyCurrentDatabase(@NotNull ScriptingTask $this$anyCurrentDatabase) {
        Intrinsics.checkNotNullParameter((Object)$this$anyCurrentDatabase, (String)"$this$anyCurrentDatabase");
        BasicDatabase basicDatabase = $this$anyCurrentDatabase.getCurrentDatabase();
        if (basicDatabase == null) {
            CasingProvider casingProvider = ScriptingTaskKt.getAnyModel($this$anyCurrentDatabase);
            basicDatabase = casingProvider != null && (casingProvider = casingProvider.getRoot()) != null ? casingProvider.getCurrentDatabase() : null;
        }
        return basicDatabase;
    }

    @Nullable
    public static final BasicSchema getAnyCurrentSchema(@NotNull ScriptingTask $this$anyCurrentSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$anyCurrentSchema, (String)"$this$anyCurrentSchema");
        BasicSchema basicSchema = $this$anyCurrentSchema.getCurrentSchema();
        if (basicSchema == null) {
            BasicDatabase basicDatabase = ScriptingTaskKt.getAnyCurrentDatabase($this$anyCurrentSchema);
            basicSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
        }
        return basicSchema;
    }
}

