/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.UserPatterns;
import com.intellij.database.util.TokenPattern;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenPatternCache {
    private static final Pattern ourSplitter = Pattern.compile("[\\s,]+");
    private final DatabaseSettings mySettings;
    private final ConcurrentMap<Pair<Boolean, Language>, TokenPattern> myCache1;
    private final ConcurrentMap<String, TokenPattern> myCache2;
    private final ConcurrentMap<String, Boolean> myValidityCache;

    @Nullable
    public static TokenPattern getPattern(@NotNull DatabaseSettings settings, boolean injected, @Nullable Language language) {
        if (settings == null) {
            TokenPatternCache.$$$reportNull$$$0(0);
        }
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            TokenPattern pattern = settings.patternCache.getPattern((Pair<Boolean, Language>)Pair.create((Object)injected, (Object)l));
            if (pattern == null) continue;
            return pattern;
        }
        return settings.patternCache.getPattern((Pair<Boolean, Language>)Pair.create((Object)injected, (Object)Language.ANY));
    }

    @Nullable
    public static String getPatternError(@NotNull String pattern) {
        if (pattern == null) {
            TokenPatternCache.$$$reportNull$$$0(1);
        }
        try {
            new TokenPattern(pattern);
            return null;
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
    }

    public TokenPatternCache(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            TokenPatternCache.$$$reportNull$$$0(2);
        }
        this.myCache1 = ConcurrentFactoryMap.createMap(key -> this.createPattern((Pair<Boolean, Language>)key));
        this.myCache2 = ConcurrentFactoryMap.createMap(key -> TokenPatternCache.compilePattern(key));
        this.myValidityCache = ConcurrentFactoryMap.createMap(key -> TokenPatternCache.getPatternError(key) == null);
        this.mySettings = settings;
    }

    public void clear() {
        this.myCache1.clear();
        this.myCache2.clear();
        this.myValidityCache.clear();
    }

    public TokenPattern getPattern(@NotNull Pair<Boolean, Language> key) {
        if (key == null) {
            TokenPatternCache.$$$reportNull$$$0(3);
        }
        return (TokenPattern)this.myCache1.get(key);
    }

    @Nullable
    private TokenPattern createPattern(Pair<Boolean, Language> key) {
        Application application = ApplicationManager.getApplication();
        boolean useHardcoded = !PlatformUtils.isDataGrip() || application == null || application.isUnitTestMode();
        UserPatterns userPatterns = this.mySettings.getUserPatterns();
        JBIterable p2 = JBIterable.empty().append((Iterable)(useHardcoded ? UserPatterns.Predef.HARDCODED_PATTERNS : JBIterable.empty())).append((Iterable)(((Boolean)key.first != false ? userPatterns.inLiterals : userPatterns.inScripts) ? userPatterns.patterns : JBIterable.empty()));
        return this.createPattern((Iterable<UserPatterns.ParameterPattern>)p2, (Boolean)key.first, (Language)key.second);
    }

    @Nullable
    private TokenPattern createPattern(Iterable<UserPatterns.ParameterPattern> patterns2, boolean injected, Language language) {
        StringBuilder sb = new StringBuilder();
        for (UserPatterns.ParameterPattern p2 : patterns2) {
            if (!(injected ? p2.inLiterals : p2.inScripts) || StringUtil.isEmptyOrSpaces((String)p2.pattern) || this.myValidityCache.get(p2.pattern) != Boolean.TRUE) continue;
            int decisionLevel = -1;
            boolean addThisOne = false;
            String adjustedScope = StringUtil.notNullize((String)StringUtil.nullize((String)p2.scope, (boolean)true), (String)"*");
            for (String s2 : ourSplitter.split(adjustedScope)) {
                boolean exclude = s2.startsWith("-");
                String id = exclude ? s2.substring(1) : s2;
                int level = 0;
                Language l = language;
                while (l != null) {
                    if (("*".equals(id) && l == Language.ANY || id.equals(l.getID())) && (decisionLevel < 0 || decisionLevel > level)) {
                        addThisOne = !exclude;
                        decisionLevel = level;
                    }
                    ++level;
                    l = l == Language.ANY ? null : (Language)ObjectUtils.notNull((Object)l.getBaseLanguage(), (Object)Language.ANY);
                }
            }
            if (!addThisOne) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(p2.pattern);
        }
        if (sb.length() == 0) {
            return null;
        }
        return (TokenPattern)this.myCache2.get(sb.toString());
    }

    @Nullable
    private static TokenPattern compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            TokenPatternCache.$$$reportNull$$$0(4);
        }
        try {
            return new TokenPattern(pattern);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/util/TokenPatternCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPatternError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compilePattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

