/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.AuxiliaryFamilyGroup;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.HostGroup;
import com.intellij.database.view.NodeGroup;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u00013B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0010\u0010.\u001a\u0004\u0018\u00010\u00182\u0006\u0010/\u001a\u00020\u0017J\u0010\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020201H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u0082\u0001\u000245\u00a8\u00066"}, d2={"Lcom/intellij/database/view/AuxiliaryObjectsGroup;", "Lcom/intellij/database/view/HostGroup;", "host", "Lcom/intellij/database/model/basic/BasicElement;", "name", "", "parentNode", "Lcom/intellij/database/model/basic/BasicNode;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "viewOptions", "Lcom/intellij/database/view/DatabaseViewOptions;", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/String;Lcom/intellij/database/model/basic/BasicNode;Lcom/intellij/database/psi/DbDataSource;Lcom/intellij/database/view/DatabaseViewOptions;)V", "getDbDataSource", "()Lcom/intellij/database/psi/DbDataSource;", "hasInnerGroups", "", "getHasInnerGroups", "()Z", "hasInnerGroupsToShow", "getHasInnerGroupsToShow", "innerGroups", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/AuxiliaryFamilyGroup;", "kindCondition", "Lcom/intellij/database/view/AuxiliaryObjectsGroup$KindCondition;", "parent", "", "getParent", "()Ljava/lang/Object;", "getParentNode", "()Lcom/intellij/database/model/basic/BasicNode;", "shown", "getShown", "size", "", "getSize", "()I", "getViewOptions", "()Lcom/intellij/database/view/DatabaseViewOptions;", "getDbParent", "Lcom/intellij/database/psi/DbElement;", "getIcon", "Ljavax/swing/Icon;", "open", "getInnerGroup", "kidKind", "iterateChildren", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/view/NodeGroup;", "KindCondition", "Lcom/intellij/database/view/ServerObjectsGroup;", "Lcom/intellij/database/view/DatabaseObjectsGroup;", "intellij.database.impl"})
public abstract class AuxiliaryObjectsGroup
extends HostGroup {
    private final Map<ObjectKind, AuxiliaryFamilyGroup> innerGroups;
    private final KindCondition kindCondition;
    @NotNull
    private final BasicNode parentNode;
    @NotNull
    private final DbDataSource dbDataSource;
    @NotNull
    private final DatabaseViewOptions viewOptions;

    public final boolean getShown() {
        return DatabaseViewTreeFun.getGroupAuxObjects(this.viewOptions);
    }

    public final boolean getHasInnerGroups() {
        Map<ObjectKind, AuxiliaryFamilyGroup> map2 = this.innerGroups;
        boolean bl = false;
        return !map2.isEmpty();
    }

    public final boolean getHasInnerGroupsToShow() {
        return this.getHasInnerGroups() && this.iterateChildren().isNotEmpty();
    }

    @Nullable
    public final AuxiliaryFamilyGroup getInnerGroup(@NotNull ObjectKind kidKind) {
        Intrinsics.checkNotNullParameter((Object)kidKind, (String)"kidKind");
        return this.innerGroups.get(kidKind);
    }

    @Override
    @NotNull
    public Object getParent() {
        return this.parentNode;
    }

    @NotNull
    public JBIterable<? extends NodeGroup> iterateChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.innerGroups.values()).filter((Condition)this.kindCondition);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(innerGro\u2026es).filter(kindCondition)");
        return jBIterable;
    }

    @Nullable
    public final DbElement getDbParent() {
        return DbImplUtilCore.findElement(this.dbDataSource, this.host);
    }

    @Override
    @NotNull
    public Icon getIcon(boolean open) {
        Icon icon = AllIcons.Nodes.Folder;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Nodes.Folder");
        return icon;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @NotNull
    public final BasicNode getParentNode() {
        return this.parentNode;
    }

    @NotNull
    public final DbDataSource getDbDataSource() {
        return this.dbDataSource;
    }

    @NotNull
    public final DatabaseViewOptions getViewOptions() {
        return this.viewOptions;
    }

    private AuxiliaryObjectsGroup(BasicElement host, @Nls String name, BasicNode parentNode, DbDataSource dbDataSource, DatabaseViewOptions viewOptions) {
        super(host, name);
        this.parentNode = parentNode;
        this.dbDataSource = dbDataSource;
        this.viewOptions = viewOptions;
        this.innerGroups = new TreeMap();
        Dbms dbms = this.dbDataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dbDataSource.dbms");
        Dbms dbms2 = dbms;
        for (ObjectKind kidKind : host.getFamilyKinds()) {
            String kidNames;
            String kidName;
            if (Intrinsics.areEqual((Object)kidKind, (Object)ObjectKind.DATABASE) || Intrinsics.areEqual((Object)kidKind, (Object)ObjectKind.SCHEMA) || Intrinsics.areEqual((Object)kidKind, (Object)ObjectKind.ROOT)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)DbPresentation.getPresentableName(kidKind, dbms2), (String)"DbPresentation.getPresentableName(kidKind, dbms)");
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.pluralize((String)kidName), (String)"StringUtil.pluralize(kidName)");
            ObjectKind objectKind = kidKind;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"kidKind");
            AuxiliaryFamilyGroup fg = new AuxiliaryFamilyGroup(host, kidNames, objectKind, this, this.dbDataSource, this.viewOptions, kidKind.getOrder());
            this.innerGroups.put(kidKind, fg);
        }
        this.kindCondition = new KindCondition();
    }

    public /* synthetic */ AuxiliaryObjectsGroup(BasicElement host, String name, BasicNode parentNode, DbDataSource dbDataSource, DatabaseViewOptions viewOptions, DefaultConstructorMarker $constructor_marker) {
        this(host, name, parentNode, dbDataSource, viewOptions);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/view/AuxiliaryObjectsGroup$KindCondition;", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/database/view/AuxiliaryFamilyGroup;", "(Lcom/intellij/database/view/AuxiliaryObjectsGroup;)V", "value", "", "t", "intellij.database.impl"})
    private final class KindCondition
    implements Condition<AuxiliaryFamilyGroup> {
        public boolean value(@NotNull AuxiliaryFamilyGroup t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            DatabaseViewOptions vo = AuxiliaryObjectsGroup.this.getViewOptions();
            ObjectKind kind = t.kidKind;
            if (vo != null && vo.HIDDEN_KINDS.contains(kind.code())) {
                return false;
            }
            if (vo != null && vo.SHOW_EMPTY_GROUPS) {
                return true;
            }
            Family<? extends BasicElement> f = AuxiliaryObjectsGroup.this.host.familyOf(kind);
            return f != null && f.isNotEmpty();
        }
    }
}

