/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.AuxiliaryFamilyGroup;
import com.intellij.database.view.AuxiliaryObjectsGroup;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 `2\u00020\u00012\u00020\u00022\u00020\u0003:\u0005`abcdB\u0017\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0016\u0010(\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u001a\u0010)\u001a\u00020$2\b\b\u0001\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010/\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 J\u0018\u00100\u001a\u00020$2\u0006\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u00105\u001a\b\u0012\u0004\u0012\u0002060&2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c07H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u00109\u001a\u00020:H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u0010;\u001a\u00020<H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010B\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010C\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010D\u001a\u00020\u0019J\u000e\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u00020\u00192\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010L\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010M\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010N\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010O\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0016J=\u0010P\u001a\u00020$2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010T2\b\b\u0001\u0010*\u001a\u00020\u001c2\u0012\u0010U\u001a\n\u0012\u0006\b\u0001\u0012\u00020G0\u001b\"\u00020GH\u0002\u00a2\u0006\u0002\u0010VJ5\u0010P\u001a\u00020$2\b\u0010S\u001a\u0004\u0018\u00010T2\b\b\u0001\u0010*\u001a\u00020\u001c2\u0012\u0010U\u001a\n\u0012\u0006\b\u0001\u0012\u00020G0\u001b\"\u00020GH\u0002\u00a2\u0006\u0002\u0010WJ.\u0010X\u001a\u00020$2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010Y\u001a\u00020Z2\b\b\u0001\u0010[\u001a\u00020\u001c2\b\b\u0001\u0010\\\u001a\u00020\u001cH\u0002J\u0012\u0010]\u001a\u0004\u0018\u0001022\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010^\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010_\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/ide/CutProvider;", "Lcom/intellij/ide/PasteProvider;", "context", "Lcom/intellij/database/view/DatabaseTreeContext;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "(Lcom/intellij/database/view/DatabaseTreeContext;Lcom/intellij/ui/treeStructure/Tree;)V", "defaultCopyProvider", "getDefaultCopyProvider", "()Lcom/intellij/ide/CopyProvider;", "defaultCutProvider", "getDefaultCutProvider", "()Lcom/intellij/ide/CutProvider;", "defaultDelegator", "Lcom/intellij/ide/CopyPasteSupport;", "defaultPasteProvider", "getDefaultPasteProvider", "()Lcom/intellij/ide/PasteProvider;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "areCutDataSourcesSameAs", "", "ids", "", "", "([Ljava/lang/String;)Z", "canPaste", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "canShow", "clipboardContainsDataSourcesOnlyAndItCanBeCopied", "doCopyDataSources", "", "dataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "doCutDataSources", "doInsideCommand", "messageKey", "runnable", "Ljava/lang/Runnable;", "doMoveDataSources", "doPaste", "doPasteDataSourceOrShowError", "doPasteDataSourcesFromCapsule", "capsule", "Lcom/intellij/database/dataSource/DataSourceSettingsCapsule;", "doPasteDataSourcesFromText", "text", "findDataSources", "Lcom/intellij/database/dataSource/AbstractDataSource;", "", "getDataSourceGroupPath", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "basicElement", "Lcom/intellij/database/model/basic/BasicElement;", "getPasteGroupPath", "isCopyEnabled", "isCopyVisible", "isCutEnabled", "isCutVisible", "isDataSourceCopyAndCutEnabled", "isDataSourcePasteEnabled", "andVisible", "isNodeCut", "node", "", "isOurFlavourSupported", "t", "Ljava/awt/datatransfer/Transferable;", "isPasteEnabled", "isPastePossible", "performCopy", "performCut", "performPaste", "sayInBalloon", "notificationType", "Lcom/intellij/notification/NotificationType;", "icon", "Ljavax/swing/Icon;", "params", "(Lcom/intellij/notification/NotificationType;Ljavax/swing/Icon;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljavax/swing/Icon;Ljava/lang/String;[Ljava/lang/Object;)V", "sayInBalloon2", "number", "", "messageKey1", "messageKey2", "tryToGetCapsule", "tryToPasteDataSource", "undoCut", "Companion", "CutDataSourceUndoableAction", "DatabaseTreeUndoableAction", "MoveDataSourceUndoableAction", "PasteDataSourceUndoableAction", "intellij.database.impl"})
public final class DatabaseCopyPasteProvider
implements CopyProvider,
CutProvider,
PasteProvider {
    private final DatabaseTreeContext context;
    private final Tree tree;
    private final CopyPasteSupport defaultDelegator;
    private static final Logger log;
    private static final String notificationGroupId = "Data Source clipboard action";
    private static final Icon iconOfCopy;
    private static final Icon iconOfCut;
    private static final Icon iconOfPaste;
    @NotNull
    public static final Companion Companion;

    private final Project getProject() {
        return this.context.getProject();
    }

    public final boolean isNodeCut(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.context.isNodeCut(node);
    }

    private final CopyProvider getDefaultCopyProvider() {
        CopyPasteSupport copyPasteSupport = this.defaultDelegator;
        return copyPasteSupport != null ? copyPasteSupport.getCopyProvider() : null;
    }

    private final CutProvider getDefaultCutProvider() {
        CopyPasteSupport copyPasteSupport = this.defaultDelegator;
        return copyPasteSupport != null ? copyPasteSupport.getCutProvider() : null;
    }

    private final PasteProvider getDefaultPasteProvider() {
        CopyPasteSupport copyPasteSupport = this.defaultDelegator;
        return copyPasteSupport != null ? copyPasteSupport.getPasteProvider() : null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        block1: {
            Collection<LocalDataSource> dataSources;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled() && (dataSources = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dataContext)) != null) {
                this.doCopyDataSources(dataSources);
                return;
            }
            CopyProvider copyProvider = this.getDefaultCopyProvider();
            if (copyProvider == null) break block1;
            copyProvider.performCopy(dataContext);
        }
    }

    public void performCut(@NotNull DataContext dataContext) {
        block1: {
            Collection<LocalDataSource> dataSources;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled() && (dataSources = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dataContext)) != null) {
                this.doInsideCommand("database.view.command.name.cut.data.sources", new Runnable(this, dataSources){
                    final /* synthetic */ DatabaseCopyPasteProvider this$0;
                    final /* synthetic */ Collection $dataSources;

                    public final void run() {
                        DatabaseCopyPasteProvider.access$doCutDataSources(this.this$0, this.$dataSources);
                    }
                    {
                        this.this$0 = databaseCopyPasteProvider;
                        this.$dataSources = collection;
                    }
                });
                return;
            }
            CutProvider cutProvider = this.getDefaultCutProvider();
            if (cutProvider == null) break block1;
            cutProvider.performCut(dataContext);
        }
    }

    private final void doCopyDataSources(Collection<? extends LocalDataSource> dataSources) {
        DataSourceSettingsHelperKt.doCopyDataSourceSettings(dataSources);
        this.sayInBalloon2(iconOfCopy, dataSources.size(), "database.view.data.sources.copied.1", "database.view.data.sources.copied.2");
    }

    /*
     * WARNING - void declaration
     */
    private final void doCutDataSources(Collection<? extends LocalDataSource> dataSources) {
        void $this$mapTo$iv$iv;
        String string = DataSourceSettingsHelperKt.doCopyDataSourceSettings(dataSources);
        if (string == null) {
            return;
        }
        String text2 = string;
        Iterable $this$map$iv = dataSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it2.getUniqueId();
            collection.add(string2);
        }
        Set cutIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        CutDataSourceUndoableAction undoableAction = new CutDataSourceUndoableAction(cutIds, text2);
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.context.assignCutDataSources((Iterable<? extends LocalDataSource>)dataSources);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            TreePath[] $this$forEach$iv = treePathArray;
            boolean $i$f$forEach = false;
            TreePath[] treePathArray2 = $this$forEach$iv;
            int n = treePathArray2.length;
            for (int j = 0; j < n; ++j) {
                TreePath element$iv;
                TreePath path = element$iv = treePathArray2[j];
                boolean bl = false;
                this.tree.collapsePath(path);
            }
        }
        this.tree.clearSelection();
        this.sayInBalloon2(iconOfCut, dataSources.size(), "database.view.data.sources.cut.1", "database.view.data.sources.cut.2");
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CopyProvider copyProvider = this.getDefaultCopyProvider();
        if (copyProvider == null) {
            return false;
        }
        CopyProvider dcp = copyProvider;
        return dcp.isCopyEnabled(dataContext);
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CopyProvider copyProvider = this.getDefaultCopyProvider();
        if (copyProvider == null) {
            return false;
        }
        CopyProvider dcp = copyProvider;
        return dcp.isCopyVisible(dataContext);
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CutProvider cutProvider = this.getDefaultCutProvider();
        if (cutProvider == null) {
            return false;
        }
        CutProvider dcp = cutProvider;
        return dcp.isCutEnabled(dataContext);
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CutProvider cutProvider = this.getDefaultCutProvider();
        if (cutProvider == null) {
            return false;
        }
        CutProvider dcp = cutProvider;
        return dcp.isCutVisible(dataContext);
    }

    public final boolean isDataSourceCopyAndCutEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.clipboardContainsDataSourcesOnlyAndItCanBeCopied(dataContext);
    }

    private final boolean clipboardContainsDataSourcesOnlyAndItCanBeCopied(DataContext dataContext) {
        if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled()) {
            Collection<LocalDataSource> dataSources = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dataContext);
            return dataSources != null;
        }
        return false;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourcePasteEnabled(dataContext, false)) {
            return true;
        }
        PasteProvider pasteProvider = this.getDefaultPasteProvider();
        if (pasteProvider == null) {
            return false;
        }
        PasteProvider dpp = pasteProvider;
        return dpp.isPastePossible(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourcePasteEnabled(dataContext, false)) {
            return true;
        }
        PasteProvider pasteProvider = this.getDefaultPasteProvider();
        if (pasteProvider == null) {
            return false;
        }
        PasteProvider dpp = pasteProvider;
        return dpp.isPasteEnabled(dataContext);
    }

    public final boolean isDataSourcePasteEnabled(@NotNull DataContext dataContext, boolean andVisible) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.canPaste(dataContext, andVisible);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.doPaste(dataContext);
    }

    private final boolean canPaste(DataContext dataContext, boolean canShow) {
        boolean ok;
        Transferable transferable = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (transferable == null) {
            return false;
        }
        Transferable t = transferable;
        boolean bl = ok = t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR) || t.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (!ok) {
            return false;
        }
        Object[] selectedNodes = DatabaseContextFun.getSelectedNodesArray(dataContext);
        int selectedNodesCount = selectedNodes.length;
        if (selectedNodesCount == 0) {
            return true;
        }
        if (selectedNodesCount >= 2) {
            return false;
        }
        if (!canShow) {
            return true;
        }
        Object selectedNode = ArraysKt.firstOrNull((Object[])selectedNodes);
        return selectedNode instanceof DatabaseStructure.DbGroup || selectedNode instanceof DasDataSource;
    }

    private final void doPaste(DataContext dataContext) {
        block1: {
            PasteProvider dpp;
            boolean ok = this.tryToPasteDataSource(dataContext);
            if (ok) {
                return;
            }
            PasteProvider pasteProvider = dpp = this.getDefaultPasteProvider();
            if (pasteProvider == null) break block1;
            pasteProvider.performPaste(dataContext);
        }
    }

    public final void doPasteDataSourceOrShowError(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean ok = this.tryToPasteDataSource(dataContext);
        if (!ok) {
            this.sayInBalloon(NotificationType.ERROR, iconOfPaste, "database.view.clipboard.contains.no.data.source", new Object[0]);
        }
    }

    private final boolean tryToPasteDataSource(DataContext dataContext) {
        String string;
        block11: {
            block10: {
                Transferable transferable = DataSourceSettingsHelperKt.getTransferableFromClipboard();
                if (transferable == null) {
                    return false;
                }
                Transferable t = transferable;
                DataSourceSettingsCapsule capsule = this.tryToGetCapsule(t);
                if (capsule != null) {
                    if (this.context.isSomeDataSourceCut() && this.areCutDataSourcesSameAs(capsule.ids)) {
                        this.doInsideCommand("database.view.command.name.move.data.sources", new Runnable(this, dataContext){
                            final /* synthetic */ DatabaseCopyPasteProvider this$0;
                            final /* synthetic */ DataContext $dataContext;

                            public final void run() {
                                DatabaseCopyPasteProvider.access$doMoveDataSources(this.this$0, this.$dataContext);
                            }
                            {
                                this.this$0 = databaseCopyPasteProvider;
                                this.$dataContext = dataContext;
                            }
                        });
                    } else {
                        this.doInsideCommand("database.view.command.name.paste.data.sources", new Runnable(this, capsule, dataContext){
                            final /* synthetic */ DatabaseCopyPasteProvider this$0;
                            final /* synthetic */ DataSourceSettingsCapsule $capsule;
                            final /* synthetic */ DataContext $dataContext;

                            public final void run() {
                                DatabaseCopyPasteProvider.access$doPasteDataSourcesFromCapsule(this.this$0, this.$capsule, this.$dataContext);
                            }
                            {
                                this.this$0 = databaseCopyPasteProvider;
                                this.$capsule = dataSourceSettingsCapsule;
                                this.$dataContext = dataContext;
                            }
                        });
                    }
                    return true;
                }
                string = ClipboardUtil.getTextInClipboard();
                if (string == null) break block10;
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                if (string != null) break block11;
            }
            return false;
        }
        String text2 = string;
        if (DataSourceSettingsHelperKt.isDataSourceSettings(text2)) {
            if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled()) {
                this.doInsideCommand("database.view.command.name.paste.data.sources", new Runnable(this, text2, dataContext){
                    final /* synthetic */ DatabaseCopyPasteProvider this$0;
                    final /* synthetic */ String $text;
                    final /* synthetic */ DataContext $dataContext;

                    public final void run() {
                        DatabaseCopyPasteProvider.access$doPasteDataSourcesFromText(this.this$0, this.$text, this.$dataContext);
                    }
                    {
                        this.this$0 = databaseCopyPasteProvider;
                        this.$text = string;
                        this.$dataContext = dataContext;
                    }
                });
            }
            return true;
        }
        return false;
    }

    private final DataSourceSettingsCapsule tryToGetCapsule(Transferable t) {
        if (this.isOurFlavourSupported(t)) {
            try {
                Object capsule = t.getTransferData(DataSourceSerializedSettingsTransferable.FLAVOR);
                Object object = capsule;
                if (!(object instanceof DataSourceSettingsCapsule)) {
                    object = null;
                }
                return (DataSourceSettingsCapsule)object;
            }
            catch (UnsupportedFlavorException ufe) {
                log.debug("Failed to get capsule \u2014 unsupported flavor: " + ufe.getMessage(), (Throwable)ufe);
            }
            catch (IOException ioe) {
                log.debug("Failed to get capsule \u2014 IO error: " + ioe.getMessage(), (Throwable)ioe);
            }
            catch (Exception e) {
                log.warn("Failed to get capsule \u2014 unexpected exception " + e.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private final boolean isOurFlavourSupported(Transferable t) {
        return t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR);
    }

    private final boolean areCutDataSourcesSameAs(String[] ids) {
        block7: {
            block6: {
                if (ids == null) break block6;
                String[] stringArray = ids;
                boolean bl = false;
                if (!(stringArray.length == 0)) break block7;
            }
            return false;
        }
        if (!this.context.isSomeDataSourceCut()) {
            return false;
        }
        Set<String> set = this.context.getCutDataSourcesIds();
        if (set == null) {
            return false;
        }
        Set<String> cutIds = set;
        if (cutIds.isEmpty()) {
            return false;
        }
        Set set2 = ArraysKt.toSet((Object[])ids);
        return Intrinsics.areEqual(cutIds, (Object)set2);
    }

    /*
     * WARNING - void declaration
     */
    private final void doMoveDataSources(DataContext dataContext) {
        void $this$associateByTo$iv$iv;
        Set<String> set = this.context.getCutDataSourcesIds();
        if (set == null) {
            return;
        }
        Set<String> dataSourcesIds = set;
        Collection<AbstractDataSource> dataSources = this.findDataSources(dataSourcesIds);
        Iterable $this$associateBy$iv = dataSources;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            AbstractDataSource it2;
            AbstractDataSource abstractDataSource = (AbstractDataSource)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.uniqueId");
            String string2 = string;
            it2 = (AbstractDataSource)element$iv$iv;
            boolean bl2 = false;
            String string3 = it2.getGroupName();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            map2.put(string2, string4);
        }
        Map oldPaths = destination$iv$iv;
        String newPath = this.getPasteGroupPath(dataContext);
        for (AbstractDataSource dataSource2 : dataSources) {
            dataSource2.setGroupName(newPath);
        }
        MoveDataSourceUndoableAction undoableAction = new MoveDataSourceUndoableAction(dataSourcesIds, oldPaths, newPath);
        this.context.clearCut();
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.context.invokeRefresh();
        this.sayInBalloon2(iconOfPaste, dataSources.size(), "database.view.data.sources.moved.1", "database.view.data.sources.moved.2");
    }

    /*
     * WARNING - void declaration
     */
    private final void doPasteDataSourcesFromCapsule(DataSourceSettingsCapsule capsule, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        this.context.clearCut();
        String groupPath = this.getPasteGroupPath(dataContext);
        String string = capsule.content;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capsule.content");
        String text2 = string;
        List<DbDataSource> importedDataSources = DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text2, this.getProject(), groupPath);
        Iterable $this$map$iv = importedDataSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DbDataSource dbDataSource = (DbDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it2.getUniqueId();
            collection.add(string2);
        }
        List importedIds = (List)destination$iv$iv;
        PasteDataSourceUndoableAction undoableAction = new PasteDataSourceUndoableAction(importedIds, text2);
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.sayInBalloon2(iconOfPaste, importedDataSources.size(), "database.view.data.sources.pasted.1", "database.view.data.sources.pasted.2");
    }

    /*
     * WARNING - void declaration
     */
    private final void doPasteDataSourcesFromText(String text2, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        this.context.clearCut();
        String groupPath = this.getPasteGroupPath(dataContext);
        List<DbDataSource> importedDataSources = DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text2, this.getProject(), groupPath);
        Iterable $this$map$iv = importedDataSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DbDataSource dbDataSource = (DbDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it2.getUniqueId();
            collection.add(string);
        }
        List importedIds = (List)destination$iv$iv;
        PasteDataSourceUndoableAction undoableAction = new PasteDataSourceUndoableAction(importedIds, text2);
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.sayInBalloon2(iconOfPaste, importedDataSources.size(), "database.view.data.sources.pasted.1", "database.view.data.sources.pasted.2");
    }

    private final Collection<AbstractDataSource> findDataSources(Set<String> ids) {
        JBIterable<DbDataSource> jBIterable = DbUtil.getDataSources(this.getProject());
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"DbUtil.getDataSources(project)");
        Iterable allDataSources = (Iterable)jBIterable;
        ArrayList found = new ArrayList(ids.size());
        for (DbDataSource dds : allDataSources) {
            DasDataSource ds;
            if (!ids.contains(dds.getUniqueId()) || !((ds = DbImplUtil.unwrapDS(dds)) instanceof AbstractDataSource)) continue;
            Collection collection = found;
            boolean bl = false;
            collection.add(ds);
        }
        return found;
    }

    private final String getPasteGroupPath(DataContext dataContext) {
        String string;
        Object[] selectedNodes;
        Object[] objectArray = selectedNodes = DatabaseContextFun.getSelectedNodesArray(dataContext);
        boolean bl = false;
        if (objectArray.length == 0) {
            return null;
        }
        Object node = selectedNodes[0];
        Object object = node;
        if (object instanceof DatabaseStructure.DbGroup) {
            string = ((DatabaseStructure.DbGroup)node).getQualifiedName();
        } else if (object instanceof DasDataSource) {
            string = this.getDataSourceGroupPath((DasDataSource)node);
        } else if (object instanceof DbElement) {
            DbDataSource dbDataSource = ((DbElement)node).getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"node.dataSource");
            string = this.getDataSourceGroupPath(dbDataSource);
        } else if (object instanceof BasicElement) {
            string = this.getDataSourceGroupPath((BasicElement)node);
        } else if (object instanceof AuxiliaryObjectsGroup) {
            string = this.getDataSourceGroupPath(((AuxiliaryObjectsGroup)node).getDbDataSource());
        } else if (object instanceof AuxiliaryFamilyGroup) {
            DbDataSource dbDataSource = ((AuxiliaryFamilyGroup)node).dataSource;
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"node.dataSource");
            string = this.getDataSourceGroupPath(dbDataSource);
        } else if (object instanceof DatabaseStructure.FamilyGroup) {
            DbDataSource dbDataSource = ((DatabaseStructure.FamilyGroup)node).dataSource;
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"node.dataSource");
            string = this.getDataSourceGroupPath(dbDataSource);
        } else {
            string = null;
        }
        return string;
    }

    private final String getDataSourceGroupPath(DasDataSource dataSource2) {
        DasDataSource ds = dataSource2;
        if (ds instanceof DbDataSource) {
            DasDataSource dasDataSource = DbImplUtil.unwrapDS(ds);
            if (dasDataSource == null) {
                return null;
            }
            ds = dasDataSource;
        }
        if (ds instanceof AbstractDataSource) {
            return ((AbstractDataSource)ds).getGroupName();
        }
        return null;
    }

    private final String getDataSourceGroupPath(BasicElement basicElement) {
        BasicModel model = basicElement.getModel();
        JBIterable<DbDataSource> jBIterable = DbUtil.getDataSources(this.getProject());
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"DbUtil.getDataSources(project)");
        JBIterable<DbDataSource> dataSources = jBIterable;
        Iterator iterator = dataSources.iterator();
        while (iterator.hasNext()) {
            DbDataSource dataSource2;
            DbDataSource dbDataSource = dataSource2 = (DbDataSource)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"dataSource");
            if (dbDataSource.getModel() != model) continue;
            return this.getDataSourceGroupPath(dataSource2);
        }
        return null;
    }

    public final void undoCut() {
        this.context.clearCut();
        this.context.invokeRefresh();
    }

    private final void doInsideCommand(@NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey, Runnable runnable) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), runnable, DatabaseBundle.message(messageKey, new Object[0]), null);
    }

    private final void sayInBalloon(Icon icon, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey, Object ... params) {
        this.sayInBalloon(NotificationType.INFORMATION, icon, messageKey, Arrays.copyOf(params, params.length));
    }

    private final void sayInBalloon(NotificationType notificationType, Icon icon, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey, Object ... params) {
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(this, messageKey, params, notificationType, icon){
            final /* synthetic */ DatabaseCopyPasteProvider this$0;
            final /* synthetic */ String $messageKey$inlined;
            final /* synthetic */ Object[] $params$inlined;
            final /* synthetic */ NotificationType $notificationType$inlined;
            final /* synthetic */ Icon $icon$inlined;
            {
                this.this$0 = databaseCopyPasteProvider;
                this.$messageKey$inlined = string;
                this.$params$inlined = objectArray;
                this.$notificationType$inlined = notificationType;
                this.$icon$inlined = icon;
            }

            public final void run() {
                boolean bl = false;
                String string = DatabaseBundle.message(this.$messageKey$inlined, Arrays.copyOf(this.$params$inlined, this.$params$inlined.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(messageKey, *params)");
                String messageText = string;
                new Notification("Data Source clipboard action", messageText, this.$notificationType$inlined).setIcon(this.$icon$inlined).notify(DatabaseCopyPasteProvider.access$getContext$p(this.this$0).getProject());
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    private final void sayInBalloon2(Icon icon, int number, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey1, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey2) {
        if (number == 1) {
            this.sayInBalloon(icon, messageKey1, new Object[0]);
        } else if (number >= 2) {
            this.sayInBalloon(icon, messageKey2, number);
        }
    }

    public DatabaseCopyPasteProvider(@NotNull DatabaseTreeContext context, @NotNull Tree tree) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.context = context;
        this.tree = tree;
        this.defaultDelegator = (CopyPasteSupport)new CopyPasteDelegator(this.getProject(), (JComponent)tree);
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(DatabaseCopyPasteProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Datab\u2026asteProvider::class.java)");
        log = logger2;
        Icon icon = AllIcons.Actions.Copy;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Copy");
        iconOfCopy = icon;
        Icon icon2 = AllIcons.Actions.MenuCut;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Actions.MenuCut");
        iconOfCut = icon2;
        Icon icon3 = AllIcons.Actions.MenuPaste;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Actions.MenuPaste");
        iconOfPaste = icon3;
    }

    public static final /* synthetic */ void access$doCutDataSources(DatabaseCopyPasteProvider $this, Collection dataSources) {
        $this.doCutDataSources(dataSources);
    }

    public static final /* synthetic */ void access$doMoveDataSources(DatabaseCopyPasteProvider $this, DataContext dataContext) {
        $this.doMoveDataSources(dataContext);
    }

    public static final /* synthetic */ void access$doPasteDataSourcesFromCapsule(DatabaseCopyPasteProvider $this, DataSourceSettingsCapsule capsule, DataContext dataContext) {
        $this.doPasteDataSourcesFromCapsule(capsule, dataContext);
    }

    public static final /* synthetic */ void access$doPasteDataSourcesFromText(DatabaseCopyPasteProvider $this, String text2, DataContext dataContext) {
        $this.doPasteDataSourcesFromText(text2, dataContext);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$DatabaseTreeUndoableAction;", "Lcom/intellij/openapi/command/undo/UndoableAction;", "getAffectedDocuments", "", "isGlobal", "", "intellij.database.impl"})
    public static interface DatabaseTreeUndoableAction
    extends UndoableAction {
        @Nullable
        public Void getAffectedDocuments();

        public boolean isGlobal();

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            @Nullable
            public static Void getAffectedDocuments(@NotNull DatabaseTreeUndoableAction $this) {
                return null;
            }

            public static boolean isGlobal(@NotNull DatabaseTreeUndoableAction $this) {
                return true;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$CutDataSourceUndoableAction;", "Lcom/intellij/database/view/DatabaseCopyPasteProvider$DatabaseTreeUndoableAction;", "dataSourceIds", "", "", "dataSourcesText", "(Lcom/intellij/database/view/DatabaseCopyPasteProvider;Ljava/lang/Iterable;Ljava/lang/String;)V", "cancelled", "", "getDataSourcesText", "()Ljava/lang/String;", "dsIds", "", "redo", "", "undo", "intellij.database.impl"})
    public final class CutDataSourceUndoableAction
    implements DatabaseTreeUndoableAction {
        private final Set<String> dsIds;
        private boolean cancelled;
        @NotNull
        private final String dataSourcesText;

        public void undo() {
            if (this.cancelled) {
                return;
            }
            DatabaseCopyPasteProvider.this.undoCut();
            this.cancelled = true;
        }

        public void redo() {
            if (!this.cancelled) {
                return;
            }
            DatabaseCopyPasteProvider.this.context.assignCutDataSourcesIds((Iterable<String>)this.dsIds);
            this.cancelled = false;
            DatabaseCopyPasteProvider.this.context.invokeRefresh();
        }

        @NotNull
        public final String getDataSourcesText() {
            return this.dataSourcesText;
        }

        public CutDataSourceUndoableAction(@NotNull Iterable<String> dataSourceIds, String dataSourcesText) {
            Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
            Intrinsics.checkNotNullParameter((Object)dataSourcesText, (String)"dataSourcesText");
            this.dataSourcesText = dataSourcesText;
            this.dsIds = CollectionsKt.toSet(dataSourceIds);
        }

        @Override
        @Nullable
        public Void getAffectedDocuments() {
            return DatabaseTreeUndoableAction.DefaultImpls.getAffectedDocuments(this);
        }

        @Override
        public boolean isGlobal() {
            return DatabaseTreeUndoableAction.DefaultImpls.isGlobal(this);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$MoveDataSourceUndoableAction;", "Lcom/intellij/database/view/DatabaseCopyPasteProvider$DatabaseTreeUndoableAction;", "dataSourceIds", "", "", "oldPaths", "", "newPath", "(Lcom/intellij/database/view/DatabaseCopyPasteProvider;Ljava/util/Set;Ljava/util/Map;Ljava/lang/String;)V", "getDataSourceIds", "()Ljava/util/Set;", "getNewPath", "()Ljava/lang/String;", "getOldPaths", "()Ljava/util/Map;", "undone", "", "redo", "", "undo", "intellij.database.impl"})
    public final class MoveDataSourceUndoableAction
    implements DatabaseTreeUndoableAction {
        private boolean undone;
        @NotNull
        private final Set<String> dataSourceIds;
        @NotNull
        private final Map<String, String> oldPaths;
        @Nullable
        private final String newPath;

        public void undo() {
            if (this.undone) {
                return;
            }
            Collection dataSources = DatabaseCopyPasteProvider.this.findDataSources(this.dataSourceIds);
            for (AbstractDataSource dataSource2 : dataSources) {
                dataSource2.setGroupName(StringKt.nullize$default((String)this.oldPaths.get(dataSource2.getUniqueId()), (boolean)false, (int)1, null));
            }
            DatabaseCopyPasteProvider.this.context.assignCutDataSourcesIds((Iterable<String>)this.dataSourceIds);
            this.undone = true;
            DatabaseCopyPasteProvider.this.context.invokeRefresh();
        }

        public void redo() {
            if (!this.undone) {
                return;
            }
            Collection dataSources = DatabaseCopyPasteProvider.this.findDataSources(this.dataSourceIds);
            for (AbstractDataSource dataSource2 : dataSources) {
                dataSource2.setGroupName(this.newPath);
            }
            this.undone = false;
            DatabaseCopyPasteProvider.this.context.invokeRefresh();
        }

        @NotNull
        public final Set<String> getDataSourceIds() {
            return this.dataSourceIds;
        }

        @NotNull
        public final Map<String, String> getOldPaths() {
            return this.oldPaths;
        }

        @Nullable
        public final String getNewPath() {
            return this.newPath;
        }

        public MoveDataSourceUndoableAction(@NotNull Set<String> dataSourceIds, @Nullable Map<String, String> oldPaths, String newPath) {
            Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
            Intrinsics.checkNotNullParameter(oldPaths, (String)"oldPaths");
            this.dataSourceIds = dataSourceIds;
            this.oldPaths = oldPaths;
            this.newPath = newPath;
        }

        @Override
        @Nullable
        public Void getAffectedDocuments() {
            return DatabaseTreeUndoableAction.DefaultImpls.getAffectedDocuments(this);
        }

        @Override
        public boolean isGlobal() {
            return DatabaseTreeUndoableAction.DefaultImpls.isGlobal(this);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$PasteDataSourceUndoableAction;", "Lcom/intellij/database/view/DatabaseCopyPasteProvider$DatabaseTreeUndoableAction;", "dataSourceIds", "", "", "dataSourcesText", "(Lcom/intellij/database/view/DatabaseCopyPasteProvider;Ljava/lang/Iterable;Ljava/lang/String;)V", "getDataSourcesText", "()Ljava/lang/String;", "dsIds", "", "undone", "", "redo", "", "undo", "intellij.database.impl"})
    public final class PasteDataSourceUndoableAction
    implements DatabaseTreeUndoableAction {
        private Set<String> dsIds;
        private boolean undone;
        @NotNull
        private final String dataSourcesText;

        public void undo() {
            if (this.undone) {
                return;
            }
            DataSourceSettingsHelperKt.removeDataSources(DatabaseCopyPasteProvider.this.getProject(), this.dsIds);
            this.undone = true;
        }

        /*
         * WARNING - void declaration
         */
        public void redo() {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!this.undone) {
                return;
            }
            Collection<LocalDataSource> dataSources = DataSourceSettingsHelperKt.importDataSourcesFromTextDirectly(this.dataSourcesText, DatabaseCopyPasteProvider.this.getProject(), null);
            Iterable iterable = dataSources;
            PasteDataSourceUndoableAction pasteDataSourceUndoableAction = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it2.getUniqueId();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            pasteDataSourceUndoableAction.dsIds = CollectionsKt.toSet((Iterable)collection);
            this.undone = false;
        }

        @NotNull
        public final String getDataSourcesText() {
            return this.dataSourcesText;
        }

        public PasteDataSourceUndoableAction(@NotNull Iterable<String> dataSourceIds, String dataSourcesText) {
            Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
            Intrinsics.checkNotNullParameter((Object)dataSourcesText, (String)"dataSourcesText");
            this.dataSourcesText = dataSourcesText;
            this.dsIds = CollectionsKt.toSet(dataSourceIds);
        }

        @Override
        @Nullable
        public Void getAffectedDocuments() {
            return DatabaseTreeUndoableAction.DefaultImpls.getAffectedDocuments(this);
        }

        @Override
        public boolean isGlobal() {
            return DatabaseTreeUndoableAction.DefaultImpls.isGlobal(this);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$Companion;", "", "()V", "copyDataSourceEnabled", "", "getCopyDataSourceEnabled", "()Z", "iconOfCopy", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "iconOfCut", "iconOfPaste", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "notificationGroupId", "", "intellij.database.impl"})
    public static final class Companion {
        private final boolean getCopyDataSourceEnabled() {
            return Registry.is((String)"database.view.copy.datasource", (boolean)true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

