/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableChildEditorModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.sql.util.NameTemplate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndexEditorModel
extends TableChildEditorModel<DeIndex> {
    private final EditorModelUtil.GeneratedNameHelper myGenHelper;

    public IndexEditorModel(@NotNull DeIndex object, @NotNull EditorModelsCache models) {
        if (object == null) {
            IndexEditorModel.$$$reportNull$$$0(0);
        }
        if (models == null) {
            IndexEditorModel.$$$reportNull$$$0(1);
        }
        super(object, models);
        this.fix();
        this.myGenHelper = new EditorModelUtil.GeneratedNameHelper<DeIndex>(object, this::genName);
        this.myGenHelper.updateGenerated();
    }

    @NotNull
    public String genName(@NotNull DeIndex idx) {
        if (idx == null) {
            IndexEditorModel.$$$reportNull$$$0(2);
        }
        String string = this.getModel().getCasing((ObjectKind)ObjectKind.INDEX, null).plain.apply(new NameTemplate.IndexNameTemplate(this.modelsCache.settings).getName(idx.table.name, idx.getColumnNames(), idx.unique));
        if (string == null) {
            IndexEditorModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void fix() {
        List<DeIndex.Item> items2 = ((DeIndex)this.myObject).items;
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            DeIndex.Item item = items2.get(i2);
            if (item.column != null) continue;
            items2.set(i2, new DeIndex.Item(EditorModelUtil.stubbize(item.column, ((DeIndex)this.myObject).table, ((DeIndex)this.myObject).model), item.sorting));
        }
    }

    @NotNull
    public List<DeIndex.Item> getItems() {
        List<DeIndex.Item> list = Collections.unmodifiableList(((DeIndex)this.myObject).items);
        if (list == null) {
            IndexEditorModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setItems(@NotNull List<DeIndex.Item> items2) {
        if (items2 == null) {
            IndexEditorModel.$$$reportNull$$$0(5);
        }
        if (((DeIndex)this.myObject).items.equals(items2)) {
            return;
        }
        ((DeIndex)this.myObject).items.clear();
        ((DeIndex)this.myObject).items.addAll(items2);
        this.modify();
    }

    public boolean isUnique() {
        return ((DeIndex)this.myObject).unique;
    }

    public void setUnique(boolean unique) {
        if (Comparing.equal((Object)unique, (Object)((DeIndex)this.myObject).unique)) {
            return;
        }
        ((DeIndex)this.myObject).unique = unique;
        this.modify();
    }

    public int getItemsCount() {
        return ((DeIndex)this.myObject).items.size();
    }

    @Override
    public void commit() {
        if (this.myGenHelper.updateGenerated()) {
            this.modify();
        }
        super.commit();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/IndexEditorModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/IndexEditorModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "genName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "genName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

