/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.HideableDecorator;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreviewPanel
extends JPanel {
    private final SqlPreviewComponent myPreviewComponent;
    private final HideableDecorator myDecorator;

    public SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String query, @NotNull String propertyKey, boolean isViewer, @NotNull Runnable closeDialog) {
        if (project == null) {
            SqlPreviewPanel.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            SqlPreviewPanel.$$$reportNull$$$0(1);
        }
        if (query == null) {
            SqlPreviewPanel.$$$reportNull$$$0(2);
        }
        if (propertyKey == null) {
            SqlPreviewPanel.$$$reportNull$$$0(3);
        }
        if (closeDialog == null) {
            SqlPreviewPanel.$$$reportNull$$$0(4);
        }
        this(propertyKey, new SqlPreviewComponent(project, dataSource2, searchPath, query, isViewer, closeDialog));
    }

    public SqlPreviewPanel(@NotNull String propertyKey, SqlPreviewComponent previewComponent) {
        if (propertyKey == null) {
            SqlPreviewPanel.$$$reportNull$$$0(5);
        }
        super(new BorderLayout());
        this.myPreviewComponent = previewComponent;
        final String expansionProperty = propertyKey + ".previewExpanded";
        boolean isExpanded = PropertiesComponent.getInstance().getBoolean(expansionProperty, true);
        JComponent open = this.myPreviewComponent.createToolbar();
        this.myDecorator = new HideableDecorator(this, DatabaseBundle.message("separator.preview", new Object[0]), true, open){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(expansionProperty, this.isExpanded());
            }
        };
        this.myDecorator.setContentComponent((JComponent)this.myPreviewComponent.getEditor());
        this.myDecorator.setOn(isExpanded);
    }

    public SqlPreviewComponent getPreviewComponent() {
        return this.myPreviewComponent;
    }

    public void setTitle(@NlsContexts.Separator @NotNull String title) {
        if (title == null) {
            SqlPreviewPanel.$$$reportNull$$$0(6);
        }
        this.myDecorator.setTitle(title);
    }

    @NotNull
    public HideableDecorator getHideableDecorator() {
        HideableDecorator hideableDecorator = this.myDecorator;
        if (hideableDecorator == null) {
            SqlPreviewPanel.$$$reportNull$$$0(7);
        }
        return hideableDecorator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/SqlPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/SqlPreviewPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHideableDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

