/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.AttachDirectoryUtils;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSourceDialectComponent;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceManager;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceConfigurable
extends AbstractDataSourceConfigurable<SqlDataSourceManager, SqlDataSourceImpl> {
    private JPanel myRootPanel;
    private JPanel myContentPanel;
    private JPanel myNamePanel;
    private JPanel myDdlListPanel;
    private ComboBox<DbDataSource> myParentCombo;
    private ComboBox<File> myOutLayout;
    private TextFieldWithBrowseButton myOutPath;
    private JPanel myGenerationSettingsPanel;
    private JPanel myDdlFooter;
    private ComboBox<@NlsSafe String> myCodeStyle;
    private SqlDataSourceDialectComponent myDialectComponent;
    private DatabaseNameComponent myNameComponent;
    private JList<String> myDdlList;
    private final ScriptOptionsPanel myScriptOptionsPanel;
    private SqlLanguageDialect myPresetDialect;
    private final SqlDataSourceImpl myTempDataSource;
    private final Map<String, DbDataSource> myParentMap;

    public SqlDataSourceConfigurable(SqlDataSourceManager manager, SqlDataSourceImpl dataSource2, Project project) {
        super(manager, dataSource2, project);
        Function0 function0 = () -> null;
        this.$$$setupUI$$$();
        this.myScriptOptionsPanel = new ScriptOptionsPanel((Function0<Unit>)function0);
        this.myParentMap = FactoryMap.create(this::getParentDataSource);
        this.myTempDataSource = dataSource2.copy();
        Dbms dbms = dataSource2.getDbms();
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(dbms);
        this.myCodeStyle.setModel(DataSourceOptionsPanel.createCodeStyleComboBox(dialect));
        final CollectionComboBoxModel model = new CollectionComboBoxModel(new ArrayList<File>(SchemaLayoutScripts.getScriptFiles()));
        this.myOutLayout.setModel((ComboBoxModel)model);
        this.myOutLayout.setRenderer((ListCellRenderer)new ColoredListCellRenderer<File>(){

            protected void customizeCellRenderer(@NotNull JList<? extends File> list, File value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    this.append(FileUtil.getNameWithoutExtension((String)StringUtil.notNullize((String)SqlDataSourceImpl.getDefaultLayout())), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(FileUtil.getNameWithoutExtension((File)value2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceConfigurable$1", "customizeCellRenderer"));
            }
        });
        this.myOutLayout.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                model.replaceAll(SchemaLayoutScripts.getScriptFiles());
            }
        });
        this.myGenerationSettingsPanel.add((Component)this.myScriptOptionsPanel.getComponent(), "Center");
        this.updateScriptUi(DefaultScriptingOptions.INSTANCE);
        this.myOutPath.addBrowseFolderListener(DatabaseBundle.message("dialog.title.root.path", new Object[0]), DatabaseBundle.message("label.where.to.generate.sources", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    private void updateScriptUi(ScriptingOptions options) {
        ScriptingSingleModelTask task2 = new ScriptingSingleModelTaskBuilder((BasicModel)ModelFactory.BLACK_HOLE.createModel(Dbms.UNKNOWN), ScriptCategory.CREATE_COMPLETE).build();
        this.myScriptOptionsPanel.adjustOptionsUI(task2, options);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @NotNull
    private CollectionListModel<String> getUrlListModel() {
        CollectionListModel collectionListModel = (CollectionListModel)this.myDdlList.getModel();
        if (collectionListModel == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        return collectionListModel;
    }

    @Override
    @NotNull
    public SqlDataSourceImpl getTempDataSource() {
        this.saveData(this.myTempDataSource);
        SqlDataSourceImpl sqlDataSourceImpl = this.myTempDataSource;
        if (sqlDataSourceImpl == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        return sqlDataSourceImpl;
    }

    private void doChooseFiles() {
        Object[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE);
            }
        };
        if (!PlatformUtils.isDataGrip()) {
            descriptor2.setRoots((VirtualFile[])roots);
            descriptor2.withTreeRootVisible(true);
        }
        descriptor2.setTitle(SqlBundle.message("dialog.title.choose.ddl.files", new Object[0]));
        VirtualFile tgt = (VirtualFile)ContainerUtil.getFirstItem(((SqlDataSourceImpl)this.myDataSource).getRoots());
        if (tgt == null) {
            tgt = (VirtualFile)ArrayUtil.getLastElement((Object[])roots);
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)tgt, files2 -> {
            CollectionListModel<String> model = this.getUrlListModel();
            LinkedHashSet<String> set = new LinkedHashSet<String>(model.toList());
            for (VirtualFile f : files2) {
                set.add(f.getUrl());
            }
            SqlDataSourceConfigurable.setItemsImpl(set, model);
            this.updateDefaultTexts(model.getItems());
            this.reinitDataSourceCombo(this.getTempDataSource());
        });
    }

    private static void setItemsImpl(Iterable<String> items2, @NotNull CollectionListModel<String> model) {
        if (model == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        int len = model.getSize();
        int i2 = 0;
        for (String s2 : items2) {
            if (i2 < len) {
                model.setElementAt((Object)s2, i2++);
                continue;
            }
            model.add((Object)s2);
        }
        while (i2 < len) {
            model.removeRow(i2++);
        }
    }

    public static boolean checkGenericDialectUsage(final Project project, Collection<String> urls) {
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        final Ref selectFile2 = Ref.create(null);
        final List<VirtualFile> files2 = SqlDataSourceConfigurable.getFiles(urls);
        for (VirtualFile file : files2) {
            if (!selectFile2.isNull() || mappings.getMapping(file) != SqlDialects.getGenericDialect()) continue;
            selectFile2.set((Object)file);
        }
        if (!selectFile2.isNull()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    final SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
                    SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable){

                        protected ValidationInfo doValidate() {
                            for (VirtualFile file : files2) {
                                SqlLanguageDialect dialect = (SqlLanguageDialect)configurable.getNewMapping(file);
                                if (dialect != SqlDialects.getGenericDialect()) continue;
                                return new ValidationInfo(SqlBundle.message("generic.sql.dialect.usage.error.message", VfsUtilCore.urlToPath((String)file.getPresentableUrl()), StringUtil.escapeXmlEntities((String)SqlDialects.getGenericDialect().getDisplayName())));
                            }
                            return super.doValidate();
                        }

                        protected boolean postponeValidation() {
                            return false;
                        }
                    };
                    configurable.selectFile((VirtualFile)selectFile2.get());
                    editor.show();
                }
            });
        }
        return true;
    }

    public static void applyPresetMapping(@NotNull Project project, @NotNull Collection<String> urls, @NotNull SqlLanguageDialect dialect) {
        if (project == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        if (urls == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        List<VirtualFile> files2 = SqlDataSourceConfigurable.getFiles(urls);
        for (VirtualFile file : files2) {
            if (mappings.getMapping(file) == dialect || mappings.getImmediateMapping(file) != null) continue;
            mappings.setMapping(file, dialect);
        }
    }

    @NotNull
    private static List<VirtualFile> getFiles(Collection<String> urls) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            files2.add(file);
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nls
    private String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "Connecting_to_a_database";
    }

    @Nullable
    public JComponent createComponent() {
        this.myDialectComponent = new SqlDataSourceDialectComponent(this);
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, true);
        this.myNamePanel.add((Component)this.myNameComponent.getComponent(), "Center");
        this.myDdlList = new JBList((ListModel)new CollectionListModel((Object[])new String[0]));
        StatusText text2 = ((JBList)this.myDdlList).getEmptyText();
        text2.clear();
        text2.appendText(DatabaseBundle.message("status.text.no.ddl.files.folders.added", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.doChooseFiles());
        this.myDdlList.setCellRenderer((ListCellRenderer<String>)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list, String value2, int index2, boolean selected, boolean hasFocus) {
                VirtualFile file;
                if (list == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((file = VirtualFileManager.getInstance().findFileByUrl(value2)) != null) {
                    this.append(file.getPresentableUrl(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(file.isDirectory() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)file));
                } else {
                    this.append(VfsUtilCore.urlToPath((String)value2), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.setIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceConfigurable$5", "customizeCellRenderer"));
            }
        });
        JPanel panel2 = ToolbarDecorator.createDecorator(this.myDdlList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SqlDataSourceConfigurable.this.doChooseFiles();
            }
        }).addExtraAction(new AnActionButton(SqlBundle.message("button.configure.sql.dialect", new Object[0]), AllIcons.Actions.Edit){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                List files2 = ContainerUtil.mapNotNull(SqlDataSourceConfigurable.this.myDdlList.getSelectedValuesList(), url -> VirtualFileManager.getInstance().findFileByUrl(url));
                SqlDialectsConfigurable.openDialectsConfigurable(SqlDataSourceConfigurable.this.myProject, files2);
                SqlDataSourceConfigurable.this.reinitDataSourceCombo(SqlDataSourceConfigurable.this.getTempDataSource());
                SqlDataSourceConfigurable.this.myController.refresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/database/SqlDataSourceConfigurable$6", "actionPerformed"));
            }
        }).createPanel();
        panel2.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        this.myDdlListPanel.add((Component)panel2, "Center");
        this.myContentPanel.setBorder(null);
        this.myDdlFooter.setBorder((Border)JBUI.Borders.empty((int)4, (int)UIUtil.PANEL_REGULAR_INSETS.left, (int)0, (int)UIUtil.PANEL_REGULAR_INSETS.right));
        return this.myRootPanel;
    }

    public void saveData(@NotNull SqlDataSourceImpl dataSource2) {
        if (dataSource2 == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(7);
        }
        ListModel<String> model = this.myDdlList.getModel();
        ArrayList<String> urls = new ArrayList<String>();
        int len = model.getSize();
        for (int i2 = 0; i2 < len; ++i2) {
            urls.add(model.getElementAt(i2));
        }
        this.myNameComponent.save(dataSource2);
        DasDataSource parent2 = (DasDataSource)this.myParentCombo.getSelectedItem();
        dataSource2.setParentUniqueId(parent2 == null ? null : parent2.getUniqueId());
        dataSource2.setUrls(urls);
        File layout = (File)this.myOutLayout.getItem();
        dataSource2.setOutputLayout(layout == null ? null : layout.getName());
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        this.myScriptOptionsPanel.gatherOptions().export(opts);
        dataSource2.setScriptOptions(opts);
        dataSource2.setOutputPath(StringUtil.nullize((String)this.myOutPath.getText()));
        dataSource2.setCodeStyleName(StringUtil.nullize((String)((String)this.myCodeStyle.getSelectedItem()), (String)"Default"));
    }

    public void apply() throws ConfigurationException {
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        if (this.myPresetDialect != null) {
            SqlDataSourceConfigurable.applyPresetMapping(this.myProject, tempDataSource.getUrls(), this.myPresetDialect);
        }
        SqlDataSourceConfigurable.checkGenericDialectUsage(this.myProject, tempDataSource.getUrls());
        this.saveData((SqlDataSourceImpl)this.myDataSource);
        if (this.isNewDataSource()) {
            ((SqlDataSourceManager)this.myManager).addDataSource((SqlDataSourceImpl)this.myDataSource);
        }
        this.reinitDataSourceCombo(tempDataSource);
        if (PlatformUtils.isDataGrip()) {
            AttachDirectoryUtils.addDirectoriesWithUndo((Project)this.myProject, ((SqlDataSourceImpl)this.myDataSource).getRoots());
        }
    }

    @Override
    protected void reset(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(8);
        }
        this.myNameComponent.reset(o, null);
        this.reinitDataSourceCombo(o);
        String parentUniqueId = o.getParentUniqueId();
        DbDataSource parent2 = StringUtil.isEmpty((String)parentUniqueId) ? null : this.myParentMap.get(parentUniqueId);
        this.myParentCombo.setSelectedItem((Object)parent2);
        SqlDataSourceConfigurable.setItemsImpl(o.getUrls(), this.getUrlListModel());
        this.updateDefaultTexts(o.getUrls());
        String layout = o.getState().outLayout;
        this.myOutLayout.setItem((Object)(layout == null ? null : SchemaLayoutScripts.findScript(layout)));
        this.myOutPath.setText(o.getState().outPath);
        this.myCodeStyle.setSelectedItem((Object)StringUtil.notNullize((String)o.getCodeStyleName(), (String)"Default"));
        this.updateScriptUi(ScriptingOptionStatic.importScriptingOptions(o.getScriptOptions()));
    }

    private void updateDefaultTexts(@NotNull Collection<String> urls) {
        if (urls == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(9);
        }
        String path = SqlDataSourceImpl.getDefaultOutputPath(this.getProject(), SqlDataSourceConfigurable.getFiles(urls));
        ((JBTextField)this.myOutPath.getTextField()).getEmptyText().setText(StringUtil.notNullize((String)path));
    }

    @Override
    public JComponent getCommonBar() {
        return this.myDialectComponent.getComponent();
    }

    @NotNull
    private DbDataSource getParentDataSource(@NotNull String parentUniqueId) {
        DbPsiFacade facade;
        DbDataSource parentDataSource;
        if (parentUniqueId == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(10);
        }
        if ((parentDataSource = (facade = DbPsiFacade.getInstance(this.myProject)).findDataSource(parentUniqueId)) != null) {
            DbDataSource dbDataSource = parentDataSource;
            if (dbDataSource == null) {
                SqlDataSourceConfigurable.$$$reportNull$$$0(11);
            }
            return dbDataSource;
        }
        SqlDataSourceImpl ds = new SqlDataSourceImpl("<invalid>", this.myProject, null);
        SqlDataSourceImpl.State state = new SqlDataSourceImpl.State();
        state.name = ds.getName();
        state.id = parentUniqueId;
        ds.loadState(state);
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(ds, SqlDataSourceManager.getInstance(this.myProject));
        if (dbDataSource == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(12);
        }
        return dbDataSource;
    }

    protected void reinitDataSourceCombo(@NotNull SqlDataSourceImpl ds) {
        String parentUniqueId;
        if (ds == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(13);
        }
        DbDataSource parent2 = StringUtil.isEmpty((String)(parentUniqueId = ds.getParentUniqueId())) ? null : this.myParentMap.get(parentUniqueId);
        JBIterable existing = JBIterable.from(DbPsiFacade.getInstance(this.myProject).getDataSources()).filter(o -> o != parent2 && o.getDelegate() != this.myDataSource);
        DatabaseDialectEx dialect = ds.getDatabaseDialect();
        if (dialect != null) {
            existing = existing.filter(dataSource2 -> DbImplUtilCore.getDatabaseDialect(dataSource2) == dialect);
        }
        DbUIUtil.configureDataSourceComboBox(this.myProject, this.myParentCombo, JBIterable.of((Object)parent2).append((Iterable)existing), ds.getParentDataSource(), true);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((SqlDataSourceImpl)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((SqlDataSourceImpl)this.myDataSource) || this.myNameComponent.isModified();
    }

    @Override
    public void onUserActivity() {
        this.myDialectComponent.update();
    }

    @Override
    public <T> void setValue(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(14);
        }
        if (ILazyParseableElementType.LANGUAGE_KEY == key) {
            this.myPresetDialect = (SqlLanguageDialect)ObjectUtils.tryCast(value2, SqlLanguageDialect.class);
            this.onUserActivity();
        } else {
            super.setValue(key, value2);
        }
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Key<T> key) {
        if (key == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(15);
        }
        if (ILazyParseableElementType.LANGUAGE_KEY == key) {
            return (T)this.myPresetDialect;
        }
        return super.getValue(key);
    }

    @Nullable
    public SqlLanguageDialect getCurrentDialect() {
        return this.myPresetDialect != null ? this.myPresetDialect : this.getTempDataSource().getSqlDialect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUniqueId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlListModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setItemsImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyPresetMapping";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultTexts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParentDataSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reinitDataSourceCombo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        ComboBox comboBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox comboBox3;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myRootPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel6.add((Component)jBTabbedPane, "Center");
        this.myContentPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/SqlBundle", SqlDataSourceConfigurable.class).getString("title.border.ddl.files"), null, jPanel5, null);
        this.myDdlListPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel4, "Center");
        this.myDdlFooter = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, "South");
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("SqlDataSourceConfigurable.label.extend"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentCombo = comboBox3 = new ComboBox();
        jPanel3.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, new Dimension(40, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("generation.tab.title"), null, jPanel7, null);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("output.path"));
        jPanel8.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("output.layout"));
        jPanel8.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutLayout = comboBox2 = new ComboBox();
        jPanel8.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 1, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlDataSourceConfigurable.class).getString("data.source.code.style.label"));
        jPanel8.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeStyle = comboBox = new ComboBox();
        jPanel8.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGenerationSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 2, null, null, null));
        this.myNamePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, "North");
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox3);
        jBLabel4.setLabelFor((Component)comboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

