/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.AutoNeverAlways;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceManager;
import com.intellij.sql.database.SqlDataSourceUpdateQueue;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlDataSourceImpl
extends AbstractDataSource
implements SqlDataSource,
PersistentStateComponent<State>,
Iconable {
    private final Project myProject;
    private String myParentId;
    private volatile List<VirtualFilePointer> myFiles;
    private String myCodeStyleName;
    private String myOutputPath;
    private String myOutputLayout;
    private final Map<String, String> myScriptOptions;
    private volatile ComputedModel myComputedModel;

    public SqlDataSourceImpl(@NotNull String name, @NotNull Project project, @Nullable DasDataSource parent2) {
        if (name == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(1);
        }
        this.myFiles = Collections.emptyList();
        this.myScriptOptions = new LinkedHashMap<String, String>();
        this.setName(name);
        this.myProject = project;
        this.myParentId = parent2 == null ? null : parent2.getUniqueId();
        this.myScriptOptions.put(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME.getCode(), ScriptingOptionStatic.exportScriptingOptionValue((Object)AutoNeverAlways.ALWAYS));
    }

    @Override
    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    public void resetCaches() {
        this.myComputedModel.check();
    }

    @Override
    @NotNull
    public NameVersion getDatabaseVersion() {
        DbDataSource parent2 = this.getParentDataSource();
        NameVersion nameVersion = parent2 != null ? parent2.getDatabaseVersion() : NameVersion.UNKNOWN;
        if (nameVersion == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(2);
        }
        return nameVersion;
    }

    @Nullable
    public DbDataSource getParentDataSource() {
        return this.myParentId == null ? null : DbPsiFacade.getInstance(this.myProject).findDataSource(this.myParentId);
    }

    public void setParentUniqueId(@Nullable String id) {
        this.myParentId = id;
    }

    @Nullable
    public String getParentUniqueId() {
        return this.myParentId;
    }

    @NotNull
    public List<String> getUrls() {
        List list = JBIterable.from(this.myFiles).filterMap(VirtualFilePointer::getUrl).toList();
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(4);
        }
        ArrayList<LightFilePointer> newFiles = new ArrayList<LightFilePointer>();
        for (String url : urls) {
            newFiles.add(new LightFilePointer(url));
        }
        this.myFiles = ContainerUtil.newUnmodifiableList(newFiles);
        this.incModificationCount();
        this.incModelModCount();
    }

    private void incModelModCount() {
        ComputedModel model = this.myComputedModel;
        if (model != null) {
            model.incModificationCount();
        }
    }

    @NotNull
    public List<SqlFile> getSqlFiles() {
        List list = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull(this.getPsiFilesInner(), f -> (SqlFile)ObjectUtils.tryCast((Object)f, SqlFile.class)));
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getRoots() {
        List list = ContainerUtil.mapNotNull(this.myFiles, VirtualFilePointer::getFile);
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    void processFilesInner(boolean andDirs, @NotNull Processor<VirtualFile> processor) {
        if (processor == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(7);
        }
        HashSet visited = new HashSet();
        for (VirtualFilePointer root2 : this.myFiles) {
            VirtualFile file = root2.getFile();
            if (file == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)file, f -> {
                if (!visited.add(f)) {
                    return false;
                }
                if (f.isDirectory()) {
                    return !andDirs || processor.process(f);
                }
                Language language = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)f);
                if (language instanceof SqlLanguageDialect) {
                    return processor.process(f);
                }
                return true;
            });
        }
    }

    private void processPsiFilesInner(@NotNull Processor<PsiFile> processor) {
        if (processor == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(8);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        this.processFilesInner(false, (Processor<VirtualFile>)((Processor)f -> {
            PsiFile file = psiManager.findFile(f);
            return file == null || processor.process((Object)file);
        }));
    }

    private List<PsiFile> getPsiFilesInner() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        this.processPsiFilesInner((Processor<PsiFile>)((Processor)files2::add));
        return files2;
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        String url = file.getUrl();
        return ContainerUtil.exists(this.getUrls(), root2 -> FileUtil.isAncestor((String)root2, (String)url, (boolean)false));
    }

    @Override
    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myComputedModel == null ? DasUtil.emptyModel() : this.myComputedModel.getModel();
        if (dasModel == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(9);
        }
        return dasModel;
    }

    public void setFiles(VirtualFile[] virtualFiles) {
        this.setUrls(JBIterable.of((Object[])virtualFiles).filterMap(VirtualFile::getUrl).toList());
    }

    public SqlDataSourceImpl copy() {
        SqlDataSourceImpl result2 = new SqlDataSourceImpl(this.getName(), this.myProject, null);
        result2.myParentId = this.myParentId;
        result2.myFiles = this.myFiles;
        result2.setUniqueId(this.getUniqueId());
        result2.setOutputLayout(this.myOutputLayout);
        result2.setOutputPath(this.myOutputPath);
        result2.setCodeStyleName(this.myCodeStyleName);
        result2.setScriptOptions(this.myScriptOptions);
        return result2;
    }

    public State getState() {
        State state = new State();
        state.id = this.getUniqueId();
        state.name = this.getName();
        state.parent = this.myParentId;
        state.urls = ArrayUtilRt.toStringArray(this.getUrls());
        state.remarks = this.getComment();
        state.group = this.getGroupName();
        state.outLayout = this.myOutputLayout;
        state.outPath = this.myOutputPath;
        state.codeStyleName = this.myCodeStyleName;
        state.scriptOptions = this.myScriptOptions.isEmpty() ? null : new LinkedHashMap<String, String>(this.myScriptOptions);
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(10);
        }
        this.setUniqueId(state.id);
        this.setName(state.name);
        this.setComment(state.remarks);
        this.setGroupName(StringUtil.nullize((String)state.group));
        this.setUrls(JBIterable.of((Object[])state.urls).toList());
        this.myOutputLayout = state.outLayout;
        this.myOutputPath = state.outPath;
        this.myCodeStyleName = state.codeStyleName;
        this.myParentId = state.parent;
        this.setScriptOptions(state.scriptOptions == null ? Collections.emptyMap() : state.scriptOptions);
    }

    void onRemovedFromStorage() {
        if (this.myComputedModel != null) {
            Disposer.dispose((Disposable)this.myComputedModel);
            this.myComputedModel = null;
        }
    }

    void onAddedToStorage() {
        if (this.myComputedModel != null) {
            throw new AssertionError((Object)"already added");
        }
        Disposer.register((Disposable)this.myProject, () -> this.onRemovedFromStorage());
        this.myComputedModel = new ComputedModel();
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect != null) {
            return (DatabaseDialectEx)dialect.getDatabaseDialect();
        }
        DbDataSource parent2 = this.getParentDataSource();
        return parent2 == null ? null : (DatabaseDialectEx)ObjectUtils.tryCast((Object)DbImplUtilCore.getDatabaseDialect(parent2), DatabaseDialectEx.class);
    }

    @Nullable
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect != null) {
            return dialect;
        }
        DbDataSource parent2 = this.getParentDataSource();
        return parent2 == null ? null : DbSqlUtilCore.getSqlDialect(parent2);
    }

    @Nullable
    private SqlLanguageDialect getSqlDialectFromFiles() {
        Set<SqlLanguageDialect> dialects = this.getSqlDialectsFromFiles();
        if (dialects.isEmpty()) {
            return null;
        }
        SqlLanguageDialect def = SqlDialectMappings.getMapping(this.myProject, null);
        dialects.remove(def);
        SqlLanguageDialect nonDef = (SqlLanguageDialect)ContainerUtil.getFirstItem(dialects);
        return (SqlLanguageDialect)ObjectUtils.notNull((Object)nonDef, (Object)def);
    }

    @NotNull
    private Set<SqlLanguageDialect> getSqlDialectsFromFiles() {
        LinkedHashSet<SqlLanguageDialect> res2 = new LinkedHashSet<SqlLanguageDialect>();
        this.processFilesInner(true, (Processor<VirtualFile>)((Processor)f -> {
            if (f.isDirectory()) {
                ContainerUtil.addIfNotNull((Collection)res2, (Object)((SqlLanguageDialect)SqlDialectMappings.getInstance(this.myProject).getImmediateMapping((VirtualFile)f)));
            } else {
                ContainerUtil.addIfNotNull((Collection)res2, (Object)((SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)f), SqlLanguageDialect.class)));
            }
            return true;
        }));
        LinkedHashSet<SqlLanguageDialect> linkedHashSet = res2;
        if (linkedHashSet == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    public Icon getIcon(int flags) {
        return DatabaseIcons.DdlDbms;
    }

    private static long getPartialVersion(@NotNull Iterable<? extends PsiFile> files2, @Nullable SqlFile latest) {
        if (files2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(12);
        }
        long result2 = 0L;
        for (PsiFile psiFile : files2) {
            result2 = result2 * 31L + psiFile.getModificationStamp();
            if (psiFile != latest) continue;
            break;
        }
        return result2;
    }

    public long getModificationCount() {
        ComputedModel model = this.myComputedModel;
        return super.getModificationCount() + (model == null ? 0L : model.getModificationCount());
    }

    public boolean equalConfiguration(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(13);
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myParentId, (CharSequence)o.myParentId)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myOutputLayout, (CharSequence)o.myOutputLayout)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myOutputPath, (CharSequence)o.myOutputPath)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myCodeStyleName, (CharSequence)o.myCodeStyleName)) {
            return false;
        }
        if (!Objects.equals(this.myScriptOptions, o.myScriptOptions)) {
            return false;
        }
        return this.getUrls().equals(o.getUrls());
    }

    public boolean isReady() {
        ComputedModel model = this.myComputedModel;
        return model == null || model.isReady();
    }

    @NotNull
    public Map<String, String> getScriptOptions() {
        Map<String, String> map2 = this.myScriptOptions;
        if (map2 == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(14);
        }
        return map2;
    }

    public void setScriptOptions(@NotNull Map<String, String> scriptOptions) {
        if (scriptOptions == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(15);
        }
        this.myScriptOptions.clear();
        this.myScriptOptions.putAll(scriptOptions);
    }

    @NlsSafe
    @Nullable
    public String getCodeStyleName() {
        return this.myCodeStyleName;
    }

    public void setCodeStyleName(@Nullable String codeStyleName) {
        this.myCodeStyleName = codeStyleName;
    }

    public void setOutputPath(@Nullable String outputPath) {
        this.myOutputPath = outputPath;
    }

    public void setOutputLayout(@Nullable String outputLayout) {
        this.myOutputLayout = outputLayout;
    }

    @Nullable
    public String getOutputPath() {
        return this.myOutputPath == null ? SqlDataSourceImpl.getDefaultOutputPath(this.myProject, ContainerUtil.mapNotNull(this.myFiles, f -> f.getFile())) : this.myOutputPath;
    }

    @Nullable
    public String getOutputLayout() {
        return this.myOutputLayout == null ? SqlDataSourceImpl.getDefaultLayout() : this.myOutputLayout;
    }

    @Nullable
    @NlsSafe
    public static String getDefaultOutputPath(Project project, List<VirtualFile> files2) {
        VirtualFile ancestor = VfsUtil.getCommonAncestor(files2);
        if (ancestor != null && !ancestor.isDirectory()) {
            ancestor = ancestor.getParent();
        }
        boolean good = ancestor != null && ProjectFileIndex.getInstance((Project)project).isInContent(ancestor);
        return good ? ancestor.getPath() : null;
    }

    @NlsSafe
    @Nullable
    public static String getDefaultLayout() {
        File def = SchemaLayoutScripts.getDefaultScript();
        if (def == null) {
            List<File> files2 = SchemaLayoutScripts.getScriptFiles();
            def = (File)ContainerUtil.getFirstItem(files2);
        }
        return def == null ? null : def.getName();
    }

    @Nullable
    public DasObject fromModel(@Nullable DasObject delegate) {
        if (delegate == null || this.myComputedModel == null) {
            return null;
        }
        return this.myComputedModel.fromModel(delegate);
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        SqlLanguageDialect dialect = this.getSqlDialect();
        Dbms dbms = dialect == null ? Dbms.UNKNOWN : dialect.getDbms();
        if (dbms == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(16);
        }
        return dbms;
    }

    @Override
    @Nullable
    public Version getVersion() {
        DbDataSource parent2 = this.getParentDataSource();
        return parent2 != null ? parent2.getVersion() : null;
    }

    @TestOnly
    public void waitComputed() {
        ComputedModel model = this.myComputedModel;
        if (model == null) {
            return;
        }
        while (!model.isReady()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @TestOnly
    public void setModelFactory(ModelFactory mf) {
        this.myComputedModel.setModelFactory(mf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectsFromFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptOptions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFilesInner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPartialVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setScriptOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComputedModel
    extends SqlDataSourceUpdateQueue.ComputedModel {
        private final CachedValue<Long> myFilesStamp = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)((Long)ReadAction.compute(() -> SqlDataSourceImpl.getPartialVersion(SqlDataSourceImpl.this.getPsiFilesInner(), null))), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));

        private ComputedModel() {
        }

        public long getModificationCount() {
            return (Long)this.myFilesStamp.getValue() * 31L + super.getModificationCount();
        }

        protected boolean introspectPortion(SqlModelBuilder builder) {
            List<SqlFile> files2 = SqlDataSourceImpl.this.getSqlFiles();
            Pair prev = this.myIncomplete;
            int doneIdx = -1;
            if (prev != null && (doneIdx = files2.indexOf(prev.first)) != -1 && SqlDataSourceImpl.getPartialVersion(files2, (SqlFile)prev.first) != (Long)prev.second) {
                doneIdx = -1;
                builder.end();
                builder.begin(builder.getModel().getTextStorage() != BlackHoleTextStorage.INSTANCE);
            }
            int fromIdx = doneIdx + 1;
            this.myIncomplete = null;
            try {
                fromIdx = builder.introspect(files2, fromIdx, fromIdx == 0, 2000L);
                SqlFile done = files2.isEmpty() ? null : files2.get(fromIdx - 1);
                this.myIncomplete = done == null ? null : Pair.create((Object)done, (Object)SqlDataSourceImpl.getPartialVersion(files2, done));
                this.myElements = builder.getMapping();
                SqlDataSourceImpl.this.incModificationCount();
                if (fromIdx == files2.size()) {
                    this.myIncomplete = null;
                }
                builder.trace("applied");
            }
            catch (RuntimeException pce) {
                if (this.myIncomplete == null) {
                    this.myIncomplete = prev;
                }
                builder.trace("cancelled");
                throw pce;
            }
            return this.myIncomplete == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean introspect(@NotNull ProgressIndicator indicator) {
            boolean bl;
            if (indicator == null) {
                ComputedModel.$$$reportNull$$$0(0);
            }
            Logger logger2 = DatabaseGlobalAuditService.logger(SqlDataSourceImpl.this.myProject, SqlDataSourceImpl.this, null);
            Ref dbms = Ref.create();
            ReadAction.run(() -> {
                if (SqlDataSourceImpl.this.myProject.isDisposed()) {
                    return;
                }
                dbms.set((Object)SqlDataSourceImpl.this.getDbms());
            });
            if (dbms.isNull()) {
                return false;
            }
            BasicModModel model = this.ensureProperModel((Dbms)dbms.get());
            SqlModelBuilder builder = new SqlModelBuilder(SqlDataSourceImpl.this.myProject, model, this.myElements, logger2);
            try {
                builder.begin(model.getTextStorage() != BlackHoleTextStorage.INSTANCE);
                indicator.setText(SqlBundle.message("progress.text.building", SqlDataSourceImpl.this.getName()));
                Ref finished = Ref.create((Object)false);
                while (!((Boolean)finished.get()).booleanValue()) {
                    if (indicator.isCanceled()) {
                        bl = false;
                        return bl;
                    }
                    boolean ok = ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> finished.set((Object)this.introspectPortion(builder)), indicator);
                    if (!ok) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (((Boolean)finished.get()).booleanValue()) continue;
                    this.changed();
                }
            }
            catch (ProcessCanceledException pce) {
                indicator.setText2(SqlBundle.message("progress.details.interrupted", new Object[0]));
                bl = false;
                return bl;
            }
            finally {
                builder.end();
            }
            return true;
        }

        @Override
        protected Project getProject() {
            return SqlDataSourceImpl.this.myProject;
        }

        @Override
        protected void changed() {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (SqlDataSourceImpl.this.myProject.isDisposed()) {
                    return;
                }
                ((DataSourceManager.Listener)SqlDataSourceImpl.this.myProject.getMessageBus().syncPublisher(DataSourceManager.TOPIC)).dataSourceChanged(SqlDataSourceManager.getInstance(SqlDataSourceImpl.this.myProject), SqlDataSourceImpl.this);
            }, ModalityState.NON_MODAL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sql/database/SqlDataSourceImpl$ComputedModel", "introspect"));
        }
    }

    public static class State {
        public String id;
        public String name;
        public String parent;
        public String[] urls;
        public String remarks;
        public String group;
        public String outPath;
        public String codeStyleName;
        @NlsSafe
        public String outLayout;
        public Map<String, String> scriptOptions;
    }
}

