/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceValidator
extends DatabaseConfigValidator<SqlDataSourceImpl> {
    @Override
    public Class<SqlDataSourceImpl> getTargetClass() {
        return SqlDataSourceImpl.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull SqlDataSourceImpl target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        Set dbms;
        SqlLanguageDialect parentDsDialect;
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(2);
        }
        AbstractDatabaseConfigurable configurable = editor == null ? null : editor.getConfigurable(target, false, AbstractDatabaseConfigurable.class);
        SqlLanguageDialect presetDialect = configurable == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast(configurable.getValue(ILazyParseableElementType.LANGUAGE_KEY), SqlLanguageDialect.class);
        Set<SqlLanguageDialect> dialects = SqlDataSourceValidator.collectDialects(project, target, presetDialect);
        DbDataSource parentDs = target.getParentDataSource();
        SqlLanguageDialect sqlLanguageDialect = parentDsDialect = parentDs == null ? null : DbSqlUtilCore.getSqlDialect(parentDs);
        if (parentDsDialect != null) {
            dialects.add(parentDsDialect);
        }
        if ((dbms = ContainerUtil.map2LinkedSet(dialects, SqlLanguageDialect::getDbms)).size() < 2) {
            return;
        }
        @Nls String msg = SqlBundle.message("inconsistent.dialects.for.files.0.choice.0.and.parent.data.source.1", parentDs != null ? 0 : 1);
        ArrayList<Runnable> actions = new ArrayList<Runnable>(dialects.size());
        @NlsSafe StringBuilder actionsText = new StringBuilder(SqlBundle.message("sql.data.source.dialect.set.all.to", new Object[0])).append(" ");
        int sz = actionsText.length();
        for (SqlLanguageDialect dialect : dialects) {
            if (actionsText.length() != sz) {
                actionsText.append(", ");
            }
            actionsText.append("<a href='$ACTION").append(actions.size()).append("'>");
            actionsText.append(dialect.getDisplayName());
            actionsText.append("</a>");
            actions.add(() -> SqlDataSourceValidator.setAllFilesTo(project, target, dialect));
        }
        actionsText.append(". ").append("<a href='$ACTION").append(actions.size()).append("'>").append(SqlBundle.message("sql.data.source.dialect.configure", new Object[0])).append("</a>");
        actions.add(() -> SqlDataSourceValidator.configureMappings(project, target));
        problems.consume((Object)new DataSourceProblem(target, this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(msg, actionsText.toString(), actionsText.toString(), actions.toArray()), null));
    }

    @NotNull
    private static Set<SqlLanguageDialect> collectDialects(@NotNull Project project, @NotNull SqlDataSourceImpl target, @Nullable SqlLanguageDialect preset) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(3);
        }
        if (target == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(4);
        }
        TreeSet<SqlLanguageDialect> dialects = new TreeSet<SqlLanguageDialect>(Comparator.comparing(Language::getDisplayName));
        SqlDialectMappings mapping = SqlDialectMappings.getInstance(project);
        target.processFilesInner(true, (Processor<VirtualFile>)((Processor)f -> {
            ContainerUtil.addIfNotNull((Collection)dialects, (Object)((SqlLanguageDialect)mapping.getImmediateMapping((VirtualFile)f)));
            return true;
        }));
        for (VirtualFile root2 : target.getRoots()) {
            SqlLanguageDialect dialect = preset;
            if (dialect == null) {
                dialect = (SqlLanguageDialect)mapping.getDirectlyConfiguredMapping(root2);
            }
            if (dialect == null) {
                dialect = (SqlLanguageDialect)mapping.getImmediateMapping(null);
            }
            if (dialect == null) {
                dialect = mapping.getDefaultMapping(root2);
            }
            ContainerUtil.addIfNotNull(dialects, (Object)dialect);
        }
        TreeSet<SqlLanguageDialect> treeSet = dialects;
        if (treeSet == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(5);
        }
        return treeSet;
    }

    public static void configureMappings(Project project, SqlDataSourceImpl target) {
        List<VirtualFile> files2 = target.getRoots();
        SqlDialectsConfigurable.openDialectsConfigurable(project, files2);
    }

    public static void setAllFilesTo(@NotNull Project project, SqlDataSourceImpl target, SqlLanguageDialect dialect) {
        if (project == null) {
            SqlDataSourceValidator.$$$reportNull$$$0(6);
        }
        SqlDialectMappings instance = SqlDialectMappings.getInstance(project);
        for (VirtualFile root2 : target.getRoots()) {
            if (instance.getMapping(root2) == dialect) continue;
            instance.setMapping(root2, dialect);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceValidator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDialects";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAllFilesTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

