/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasTypeService;
import com.intellij.database.types.DasTypeServices;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.editor.QuoteIdentifierQuickFix;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialectEx
extends SqlLanguageDialect
implements CasingProvider {
    protected final ReservedEntity myDualEntity;
    private final Object myLock;
    private final ReservedEntity myNextValEntity;
    private final ReservedEntity myCurrValEntity;
    private Map<String, SqlFunctionDefinition.Type> myTypes;

    public SqlLanguageDialectEx(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(0);
        }
        super(id);
        this.myDualEntity = new ReservedEntity(this.getDbms(), "dual", ObjectKind.TABLE);
        this.myLock = new Object();
        this.myNextValEntity = new ReservedEntity(this.getDbms(), "nextval", ObjectKind.COLUMN);
        this.myCurrValEntity = new ReservedEntity(this.getDbms(), "currval", ObjectKind.COLUMN);
    }

    protected SqlLanguageDialectEx(@NotNull SqlLanguageDialect base, @NonNls @NotNull String id) {
        if (base == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(1);
        }
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(2);
        }
        super(base, id);
        this.myDualEntity = new ReservedEntity(this.getDbms(), "dual", ObjectKind.TABLE);
        this.myLock = new Object();
        this.myNextValEntity = new ReservedEntity(this.getDbms(), "nextval", ObjectKind.COLUMN);
        this.myCurrValEntity = new ReservedEntity(this.getDbms(), "currval", ObjectKind.COLUMN);
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(3);
        }
        SqlReferenceElementType unused = SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
        return SqlTokenRegistry.findCompositeType((String)("SQL_" + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myTypes == null) {
            this.myTypes = new HashMap<String, SqlFunctionDefinition.Type>();
            this.addTypes(this.myTypes);
        }
        Map<String, SqlFunctionDefinition.Type> map2 = this.myTypes;
        // MONITOREXIT : object
        if (map2 != null) return map2;
        SqlLanguageDialectEx.$$$reportNull$$$0(4);
        return map2;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        SqlFunctionDefinition.addSimpleTypes(myTypes, this);
    }

    @NotNull
    public final DasTypeService getTypeService() {
        DasTypeService dasTypeService = DasTypeServices.getTypeService(this.getDbms());
        if (dasTypeService == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(5);
        }
        return dasTypeService;
    }

    @NotNull
    public Set<SqlFunctionDefinition.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        if (expression != null && SqlLanguageDialectEx.isTableFunctionCallRef((PsiElement)expression)) {
            EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.NORMAL, SqlFunctionDefinition.Location.TABLE_FUNCTION);
            if (enumSet == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(6);
            }
            return enumSet;
        }
        EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.NORMAL);
        if (enumSet == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(7);
        }
        return enumSet;
    }

    @NotNull
    public abstract BuiltinFunctions getSupportedFunctions();

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(8);
        }
        return true;
    }

    @NotNull
    public JBIterable<ObjectKind> getExtraKindsStrict(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(9);
        }
        if (reference.getReferenceElementType().getTargetKind() == ObjectKind.OBJECT_TYPE) {
            JBIterable jBIterable = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.COLLECTION_TYPE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE});
            if (jBIterable == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target) {
        if (target == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(12);
        }
        Set<ObjectKind> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(13);
        }
        return set;
    }

    public boolean processTypeExtra(SqlTableType type, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        return true;
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect(this.getDbms());
        if (databaseDialectEx == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(14);
        }
        return databaseDialectEx;
    }

    @NotNull
    public abstract SqlTypeSystemBase getTypeSystem();

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(15);
        }
        TreePattern treePattern = pattern;
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(17);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlFromClause.class}) != null;
    }

    public boolean requiresAsForAliasAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(18);
        }
        return false;
    }

    public boolean canBeCalledWithoutParens(@NotNull SqlFunctionDefinition.Prototype prototype) {
        if (prototype == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(19);
        }
        SqlFunctionDefinition def = prototype.getFunction();
        return prototype.getParams().length == 0 && !"required".equals(def.getDialectAttribute("parens")) && !"true".equals(def.getDialectAttribute("analytic"));
    }

    @NotNull
    public TreePattern processImports(@NotNull SqlUseDatabaseStatement stmt, @NotNull TreePattern prev) {
        if (stmt == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(20);
        }
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(21);
        }
        SmartList refs = new SmartList();
        ObjectKind kind = null;
        boolean reset = false;
        for (SqlReferenceExpression ref : ContainerUtil.iterateBackward((List)stmt.getUseReferences())) {
            if (ref == null) {
                reset = true;
                break;
            }
            refs.add(ref);
            ObjectKind k = ref.getReferenceElementType().getTargetKind();
            assert (kind == null || kind == k);
            kind = k;
        }
        if (reset) {
            TreePattern treePattern = SqlDialectImplUtilCore.getDefaultInitialPattern((SqlFile)stmt.getContainingFile());
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(22);
            }
            return treePattern;
        }
        boolean empty = refs.isEmpty();
        if (empty || kind == null) {
            if (!this.canBeWithoutCurrentSchema()) {
                TreePattern treePattern = prev;
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(23);
                }
                return treePattern;
            }
            List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDbms());
            if (path == null) {
                TreePattern treePattern = this.applyImplicitImports(null, TreePattern.EMPTY);
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(24);
                }
                return treePattern;
            }
            ObjectKind[] kinds = ContainerUtil.reverse(path.subList(1, path.size())).toArray(new ObjectKind[path.size() - 1]);
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            TreePattern treePattern = this.applyImplicitImports(null, TreePatternUtils.mask(prev, kinds, mask, false));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(25);
            }
            return treePattern;
        }
        TreePattern state = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)refs).transform(r -> this.createRefPattern(prev, (SqlReferenceExpression)r)).filter(x -> x != null));
        final boolean inclusive = stmt.isInclusive();
        state = new TreePatternUtils.GroupedGroupFactory(){

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.hasSecond(value2);
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.hasSecond(value2);
            }

            @Override
            protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> groups) {
                return !this.hasSecond(groups);
            }

            private boolean hasSecond(@NotNull Iterable<?> value2) {
                Object second;
                Iterator<?> it2;
                if (value2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                Object first2 = (it2 = value2.iterator()).hasNext() ? it2.next() : null;
                Object v0 = second = it2.hasNext() ? it2.next() : null;
                if (second == null) {
                    return first2 != null && inclusive;
                }
                if (!(second instanceof TreePatternNode)) {
                    return true;
                }
                if (((TreePatternNode)second).naming instanceof TreePatternNode.PositiveNaming) {
                    return true;
                }
                return first2 != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasSecond";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.merge(Arrays.asList(prev, state));
        TreePattern treePattern = this.applyImplicitImports(null, state);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(26);
        }
        return treePattern;
    }

    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(28);
        }
        return SqlImportUtil.createRefPattern(ref, ref.getReferenceElementType().getTargetKind(), this.getDbms());
    }

    protected boolean canBeWithoutCurrentSchema() {
        return false;
    }

    @NotNull
    public TreePattern getDefaultImports(@Nullable DbDataSource dataSource2) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource2);
        TreePattern imports = this.getBaseImports(dataSource2, dsNames);
        TreePattern treePattern = this.applyImplicitImports(dsNames, imports);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(29);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames) {
        ObjectKind kind;
        JBIterable<ObjectKind> kinds = DbImplUtilCore.getMetaModel(this.getDbms()).getRootNamespaceKinds();
        if (kinds.contains((Object)ObjectKind.DATABASE)) {
            kind = ObjectKind.DATABASE;
        } else if (kinds.contains((Object)ObjectKind.SCHEMA)) {
            kind = ObjectKind.SCHEMA;
        } else {
            throw new AssertionError((Object)"Unexpected root kind");
        }
        ObjectName userName = ObjectName.plain(SqlDialectImplUtilCore.getUserName(SqlImportUtil.getConnectionConfig(dataSource2)));
        DasNamespace namespace = SqlLanguageDialectEx.getDefaultNamespace(dataSource2, userName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNodeIfNotNull(userName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(30);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(userName, kind, new TreePatternNode.Group[0])));
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource2);
        List<ObjectPath> elements = SearchPath.getElements(searchPath);
        TreePattern treePattern = this.applyImplicitImports(dsNames, !elements.isEmpty() ? TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(elements).transform(n -> SqlDialectImplUtilCore.createObjectPattern(dsNames, this.getDbms(), n, (TreePatternNode.Group[])null))) : (dsNames == null ? TreePattern.EMPTY : this.getBaseImports(dataSource2, dsNames)));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(31);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource2, @NotNull SearchPath object) {
        if (object == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(32);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource2, object);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(33);
        }
        return treePattern;
    }

    public boolean isSpecialFunctionReference(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(34);
        }
        return false;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return false;
    }

    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(35);
        }
        return false;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(36);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(37);
        }
        return this.quoteIdentifier(identifier, newElementName, SqlImplUtil.getIdentifierKind(identifier));
    }

    protected String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(38);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(39);
        }
        return this.quoteIdentifier(identifier.getProject(), newElementName, kind);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(40);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(41);
        }
        return this.quoteIdentifier(project, newElementName, null);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(42);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(43);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)project, (Language)this);
        boolean force = settings.QUOTE_IDENTIFIER == 2 || this.isReservedKeyword((IElementType)SqlTokenRegistry.findTokenType((String)newElementName));
        NamingService namingService = NamingServices.getNamingService(this.getDbms());
        if (namingService.isQuoted(newElementName)) {
            return newElementName;
        }
        return force ? namingService.enquote(newElementName, kind, settings.getQuotesPriority()) : namingService.catToScript(newElementName, kind, true, settings.getQuotesPriority(), false);
    }

    @NotNull
    public JBIterable<? extends DasArgument> getParametersForCallCheck(@NotNull DasRoutine routine) {
        if (routine == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(44);
        }
        JBIterable<? extends DasArgument> jBIterable = DasUtil.getParameters(routine);
        if (jBIterable == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(45);
        }
        return jBIterable;
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(46);
        }
        return false;
    }

    @NotNull
    public Icon getIcon() {
        Dbms dbms = this.getDbms();
        Icon icon = dbms == Dbms.UNKNOWN ? DatabaseIcons.Sql : dbms.getIcon();
        if (icon == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(47);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getDbms().getDisplayName();
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(48);
        }
        return string;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(50);
        }
        SqlTypeSystemBase typeSystem = this.getTypeSystem();
        if ((SqlImplUtil.equalsInsensitiveOrTrue(name, this.myNextValEntity.name, resolve) || SqlImplUtil.equalsInsensitiveOrTrue(name, this.myCurrValEntity.name, resolve)) && SqlImplUtil.getQualifierKind(place) == ObjectKind.SEQUENCE) {
            if (!processor.executeTarget((DasSymbol)this.myNextValEntity, typeSystem.integerType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget((DasSymbol)this.myCurrValEntity, typeSystem.integerType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, @Nullable Version version) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(51);
        }
        return Integer.MAX_VALUE;
    }

    protected boolean processReservedEntitiesWithTypeDual(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(53);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element2, SqlFromClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) == null) {
            return true;
        }
        if (element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).getQualifierExpression() != null) {
            return true;
        }
        return SqlLanguageDialectEx.processReservedEntitiesWithTypeSimple(this.myDualEntity, (SqlType)SqlTableTypeBase.EMPTY_TABLE, name, element2, resolve, processor, true, false);
    }

    public TokenSet getStatementSeparators() {
        return SqlCommonTokens.STATEMENT_SEPARATORS;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        ASTNode node;
        SqlColumnStub stub;
        if (column2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(54);
        }
        SqlColumnStub sqlColumnStub = stub = column2 instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)((Object)column2)).getGreenStub() : null;
        if (stub != null) {
            BasicTableColumn tc = (BasicTableColumn)ObjectUtils.tryCast((Object)stub.getElement(), BasicTableColumn.class);
            return tc != null && tc.isAutoInc();
        }
        ASTNode aSTNode = node = column2 instanceof PsiElement ? ((PsiElement)column2).getNode() : null;
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) != null;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type instanceof SqlDbElementType) {
            ContainerUtil.addIfNotNull(result2, (Object)((SqlDbElementType)type).parentType);
        }
        if (type == ObjectKind.VARIABLE) {
            result2.add((ObjectKind)ObjectKind.VARIABLE);
        }
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.TRIGGER) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OBJECT_TYPE) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.PARTITION) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        DbImplUtilCore.getMetaModel(this.getDbms()).getParentKinds(this.unaliased(type)).addAllTo(result2);
        if (type == ObjectKind.USER) {
            result2.add((ObjectKind)ObjectKind.USER);
        }
        if (type == SqlDbElementType.SYSTEM_VARIABLE) {
            result2.add((ObjectKind)SqlDbElementType.SYSTEM_VARIABLE);
        }
        return result2;
    }

    public JBIterable<? extends SqlDefinition> extractDefinitions(@NotNull SqlElement statement) {
        if (statement == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(55);
        }
        if (statement instanceof SqlSelectStatement) {
            return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)statement).expand(Conditions.notInstanceOf(SqlSelectIntoNewTableClauseImpl.class))).filter(SqlSelectIntoNewTableClauseImpl.class);
        }
        if (statement instanceof SqlBlockStatementImpl) {
            JBIterable children2 = SqlImplUtil.childrenIt((PsiElement)statement).filter(SqlCompositeElement.class);
            return children2.filter(SqlDefinition.class).append((Iterable)children2.flatten(this::extractDefinitions));
        }
        return JBIterable.empty();
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CHARSET && type != ObjectKind.COLLATION && type != ObjectKind.TABLESPACE && type != SqlDbElementType.GENERIC_AT_LINK && type != ObjectKind.USER && type != SqlDbElementType.SYSTEM_VARIABLE && type != ObjectKind.ROLE && type != ObjectKind.OPERATOR;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(56);
        }
        Casing casing = this.getDatabaseDialect().getCasing(kind, context);
        if (casing == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(57);
        }
        return casing;
    }

    public boolean mayContainExternalPsi() {
        return false;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(58);
        }
        return collection;
    }

    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(59);
        }
        return DbImplUtilCore.isDataTable(kind);
    }

    @NotNull
    protected TreePattern getSchemaBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames, boolean useSchemaDefault) {
        String schemaName = SqlDialectImplUtilCore.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource2));
        if (schemaName == null && useSchemaDefault) {
            schemaName = "default";
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted(schemaName), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    public boolean supportsJoinUsing() {
        return false;
    }

    public boolean supportsNaturalJoin() {
        return false;
    }

    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        if (place != null && SqlPsiUtilCoreKt.isSqlCalleeExpression(place)) {
            DasObject dasObject;
            SqlFunctionCallExpression call = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)place, SqlFunctionCallExpression.class);
            DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
            if (call != null && dasObject instanceof DasRoutine && !this.checkArgumentMatch((DasRoutine)dasObject, call)) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkArgumentMatch(@NotNull DasRoutine routine, @NotNull SqlFunctionCallExpression call) {
        SqlExpression arg;
        if (routine == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(60);
        }
        if (call == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(61);
        }
        if (routine instanceof DasOperator) {
            return true;
        }
        SqlExpressionList parameterList = call.getParameterList();
        List arguments = parameterList != null ? parameterList.getExpressionList() : Collections.emptyList();
        List parameters = this.getParametersForCallCheck(routine).toList();
        HashMap<DasArgument, JBIterable> argumentMap = new HashMap<DasArgument, JBIterable>();
        int paramCount = parameters.size();
        int argCount = arguments.size();
        int argIndex = 0;
        while (argIndex < argCount && !((arg = (SqlExpression)arguments.get(argIndex)) instanceof SqlNamedParameterValueExpression)) {
            if (argIndex >= paramCount) {
                return false;
            }
            DasArgument parameter = (DasArgument)parameters.get(argIndex);
            if (parameter.isVariadic()) {
                argumentMap.put(parameter, JBIterable.from(arguments.subList(argIndex, argCount)));
                argIndex = argCount;
                continue;
            }
            argumentMap.put(parameter, JBIterable.of((Object)arg));
            ++argIndex;
        }
        int namedArgStart = argIndex;
        while (argIndex < argCount) {
            SqlExpression arg2 = (SqlExpression)arguments.get(argIndex);
            if (!(arg2 instanceof SqlNamedParameterValueExpression)) {
                return false;
            }
            SqlReferenceExpression paramRef = (SqlReferenceExpression)((SqlNamedParameterValueExpression)arg2).getLOperand();
            Condition condition = DbSqlUtilCore.byName(paramRef.getName(), paramRef.isQuoted(), null, this);
            int paramIndex = ContainerUtil.indexOf((List)parameters, condition);
            if (paramIndex < namedArgStart) {
                return false;
            }
            argumentMap.put((DasArgument)parameters.get(paramIndex), JBIterable.of((Object)arg2));
            ++argIndex;
        }
        for (DasArgument parameter : parameters) {
            JBIterable args = (JBIterable)argumentMap.get(parameter);
            if (args == null && !parameter.isDefaulted()) {
                return false;
            }
            if (args == null) continue;
            for (SqlExpression arg3 : args) {
                if (this.getTypeSystem().supportsImplicitConversion(arg3.getSqlType().getDataType(), parameter.getDataType())) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return null;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, false);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (!(type instanceof SqlKeywordTokenType) || !(!pl ? this.isReservedKeyword(type) : this.isReservedKeywordPL(type))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message("identifier.1.should.be.quoted", o.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text2 = o.getText();
        if (text2.length() <= 0 || Character.isLetter(text2.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new DFABuildingVisitor(this);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        SqlErrorSpecHelper sqlErrorSpecHelper = SqlErrorSpecHelper.DEFAULT_INSTANCE;
        if (sqlErrorSpecHelper == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(62);
        }
        return sqlErrorSpecHelper;
    }

    @Nullable
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        return null;
    }

    public SqlCloseBlockProcessor[] getEnterHandlerBlockProcessors() {
        SqlCloseBlockProcessor[] sqlCloseBlockProcessorArray;
        SqlCloseBlockProcessor processor = this.getEnterHandlerBlockProcessor();
        if (processor != null) {
            SqlCloseBlockProcessor[] sqlCloseBlockProcessorArray2 = new SqlCloseBlockProcessor[1];
            sqlCloseBlockProcessorArray = sqlCloseBlockProcessorArray2;
            sqlCloseBlockProcessorArray2[0] = processor;
        } else {
            sqlCloseBlockProcessorArray = null;
        }
        return sqlCloseBlockProcessorArray;
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return null;
    }

    @Nullable
    public String adjustReferenceLookupString(@NotNull LookupElement element2, @NotNull ObjectKind kind, @NotNull Set<ObjectKind> expectedTypes) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(63);
        }
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(64);
        }
        if (expectedTypes == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(65);
        }
        return null;
    }

    private static boolean isTableFunctionCallRef(@NotNull PsiElement expr) {
        PsiElement parent2;
        if (expr == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(66);
        }
        return (parent2 = expr.getParent()) instanceof SqlFunctionCallExpression && parent2.getParent() instanceof SqlFunctionCallTableExpressionImpl || parent2 instanceof SqlQueryExpression;
    }

    @Nullable
    protected static DasNamespace getDefaultTopNamespace(@Nullable DbDataSource dataSource2, @Nullable ObjectName fallback) {
        DasModel model;
        LocalDataSource ds = dataSource2 == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), LocalDataSource.class);
        DasModel dasModel = model = ds == null ? null : ds.getModel();
        if (model == null) {
            return null;
        }
        DasNamespace cur2 = model.getCurrentRootNamespace();
        if (cur2 == null && fallback != null) {
            cur2 = (DasNamespace)model.getModelRoots().filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
        }
        return cur2;
    }

    @Nullable
    protected static DasNamespace getDefaultNamespace(@Nullable DbDataSource dataSource2, @Nullable ObjectName fallback) {
        DasNamespace cur2 = SqlLanguageDialectEx.getDefaultTopNamespace(dataSource2, fallback);
        if (cur2 == null || cur2.getKind() == ObjectKind.SCHEMA) {
            return cur2;
        }
        DasNamespace sc = SqlLanguageDialectEx.getCurrentSchema(cur2);
        return (DasNamespace)ObjectUtils.chooseNotNull((Object)sc, (Object)cur2);
    }

    @Nullable
    protected static DasNamespace getCurrentSchema(@Nullable DasNamespace cur2) {
        return cur2 == null ? null : (DasNamespace)cur2.getDasChildren(ObjectKind.SCHEMA).filter(BasicNamespace.class).filter(BasicNamespace::isCurrent).first();
    }

    protected static boolean processReservedEntitiesWithTypeSimple(ReservedEntity entity, SqlType result2, @Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor, boolean checkType, Boolean forcedCaseSense) {
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(67);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(68);
        }
        return !SqlImplUtil.equalsInsensitiveOrTrue(name, entity.getName(), resolve) || checkType && !processor.isExpected(entity.getKind()) || processor.executeTarget((DasSymbol)entity, result2, forcedCaseSense, ResolveState.initial());
    }

    @Nullable
    protected static DasNamespace getDefaultSubNamespace(@Nullable DasNamespace cur2, @Nullable ObjectName fallback) {
        if (cur2 == null) {
            return null;
        }
        DasNamespace schema = SqlLanguageDialectEx.getCurrentSchema(cur2);
        if (schema != null || fallback == null) {
            return schema;
        }
        return (DasNamespace)cur2.getDasChildren(null).filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 45: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 45: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 45: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 8: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 17: 
            case 18: 
            case 46: 
            case 52: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 36: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 49: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 50: 
            case 53: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 56: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraKindsStrict";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "processImports";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImports";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersForCallCheck";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 45: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 62: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtraKindsStrict";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "requiresAsForAliasAt";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canBeCalledWithoutParens";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialFunctionReference";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getParametersForCallCheck";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeDual";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "extractDefinitions";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "checkArgumentMatch";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferenceLookupString";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isTableFunctionCallRef";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeSimple";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 45: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.INDEX);

        LazyData() {
        }
    }

    public static interface BuiltinFunctions {
        @Nullable
        public SqlFunctionDefinition get(@Nullable String var1);

        public boolean contains(@Nullable String var1);

        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher var1);

        @NotNull
        public Collection<SqlFunctionDefinition> forTokens();

        @Nullable
        public BuiltinFunctions typeMethods(@NotNull String var1, boolean var2);
    }
}

