/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.EndIncElementContinuePattern;
import com.intellij.sql.formatter.model.EndObjectKindContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlCreateTableBlock;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTableParenthesizedColumnsSection;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "()V", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "whetherToFlatten", "Companion", "TableHeaderSection", "intellij.database.sql.core.impl"})
public final class SqlCreateTableBlock
extends SqlDdlStatementBlock {
    @NotNull
    private static final List<FlowPattern> patterns;
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getElementType() == SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE) return true;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST)) return true;
        SqlFormattingContext sqlFormattingContext = this.getContext();
        Dbms dbms = Dbms.SQLITE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.SQLITE");
        if (!sqlFormattingContext.isDialect(dbms)) return false;
        if (node.getElementType() == SqlCompositeElementTypes.SQL_CLAUSE) return true;
        if (!Intrinsics.areEqual((Object)node.getElementType().toString(), (Object)"SQL_MODULE_REFERENCE")) return false;
        return true;
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getElementType().toString();
        switch (string.hashCode()) {
            case 200314079: {
                if (string.equals("PG_INHERITS_TABLE_CLAUSE")) {
                    void $this$withSetup$iv;
                    SqlRangeBlock sqlRangeBlock = new SqlPostfixClauseBlock();
                    SqlBlock parent$iv = this;
                    boolean $i$f$withSetup = false;
                    TextRange textRange = node.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"outerNode.textRange");
                    $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
                    sqlBlock = sqlRangeBlock;
                    break;
                }
            }
            default: {
                sqlBlock = super.makeBlock(node);
            }
        }
        return sqlBlock;
    }

    @Override
    protected void configureFormattingAttributes() {
        Object v7;
        boolean bl12;
        Iterable iterable;
        boolean bl2;
        Object object;
        Wrap w;
        block23: {
            SqlBlock asWord;
            SqlBlock sqlBlock;
            boolean bl3;
            Object $this$find$iv2;
            block22: {
                Object v0;
                Indent i2;
                int openingSetting;
                block20: {
                    openingSetting = this.getContext().getSql().TABLE_OPENING;
                    w = SqlFlowBlock.makeWrap$default(this, this.getContext().getSql().TABLE_COLLAPSE ? WrapType.CHOP_DOWN_IF_LONG : WrapType.ALWAYS, false, 2, null);
                    i2 = openingSetting == 4 ? Indent.getNormalIndent((boolean)true) : SqlFormattingFunKt.getNONE_INDENT();
                    Iterable iterable2 = this.getNestedBlocks();
                    boolean bl4 = false;
                    Iterable iterable3 = iterable2;
                    boolean bl5 = false;
                    for (Object object2 : iterable3) {
                        Iterator it2 = (SqlBlock)object2;
                        boolean bl6 = false;
                        if (!(it2 instanceof SqlTableParenthesizedColumnsSection)) continue;
                        v0 = object2;
                        break block20;
                    }
                    v0 = null;
                }
                SqlBlock columnSection = v0;
                if (columnSection != null) {
                    if (this.getContext().getSql().TABLE_OPENING == 3) {
                        Object v3;
                        Object v2;
                        Alignment sectionAlignment;
                        block21: {
                            Object object2;
                            sectionAlignment = SqlFormattingModelFunKt.makeLeftAlignment();
                            SqlBlock sqlBlock2 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
                            if (sqlBlock2 != null) {
                                sqlBlock2.setMyAlign(sectionAlignment);
                            }
                            Iterable $this$find$iv2 = this.getNestedBlocks();
                            boolean $i$f$find = false;
                            Iterable iterable4 = $this$find$iv2;
                            boolean bl7 = false;
                            object2 = iterable4;
                            boolean it2 = false;
                            Iterator bl6 = object2.iterator();
                            while (bl6.hasNext()) {
                                Object t = bl6.next();
                                Block it$iv = (Block)t;
                                boolean bl8 = false;
                                if (!(it$iv instanceof SqlTableParenthesizedColumnsSection)) continue;
                                v2 = t;
                                break block21;
                            }
                            v2 = v3 = null;
                        }
                        if (!(v2 instanceof SqlTableParenthesizedColumnsSection)) {
                            v3 = null;
                        }
                        SqlTableParenthesizedColumnsSection sqlTableParenthesizedColumnsSection = (SqlTableParenthesizedColumnsSection)((Block)v3);
                        if (sqlTableParenthesizedColumnsSection != null) {
                            sqlTableParenthesizedColumnsSection.setSectionAlignment(sectionAlignment);
                        }
                    }
                    columnSection.setMyIndent(i2);
                    columnSection.setMyWrap((Wrap)(openingSetting > 1 ? w : null));
                }
                $this$find$iv2 = this.getNestedBlocks();
                bl3 = false;
                Iterable iterable5 = $this$find$iv2;
                boolean bl9 = false;
                for (Iterator it2 : iterable5) {
                    SqlBlock it3 = it2;
                    boolean bl10 = false;
                    if (!(it3 instanceof SqlKeyword && ((SqlKeyword)it3).getElementType() == SqlCommonKeywords.SQL_AS)) continue;
                    sqlBlock = it2;
                    break block22;
                }
                sqlBlock = null;
            }
            SqlBlock sqlBlock3 = asWord = (SqlBlock)sqlBlock;
            if (sqlBlock3 != null) {
                $this$find$iv2 = sqlBlock3;
                bl3 = false;
                boolean bl11 = false;
                Object it4 = $this$find$iv2;
                boolean bl12 = false;
                ((SqlBlock)it4).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_AS ? w : null));
                ((SqlBlock)it4).setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
            }
            object = this.getNestedBlocks();
            bl2 = false;
            iterable = object;
            bl12 = false;
            for (Object e : iterable) {
                SqlBlock it5 = (SqlBlock)e;
                boolean bl13 = false;
                if (!(it5 instanceof SqlQueryBlock || it5 instanceof SqlParenthesizedSubqueryBlock)) continue;
                v7 = e;
                break block23;
            }
            v7 = null;
        }
        SqlBlock querySection = v7;
        if (querySection != null) {
            Object v8;
            block24: {
                object = this.getNestedBlocks();
                bl2 = false;
                iterable = object;
                bl12 = false;
                for (Object t : iterable) {
                    SqlBlock it6 = (SqlBlock)t;
                    boolean bl14 = false;
                    if (!(it6 instanceof SqlKeyword && ((SqlKeyword)it6).getElementType() == SqlCommonKeywords.SQL_AS)) continue;
                    v8 = t;
                    break block24;
                }
                v8 = null;
            }
            SqlBlock sqlBlock = v8;
            if (sqlBlock != null) {
                object = sqlBlock;
                bl2 = false;
                boolean bl15 = false;
                Object it7 = object;
                boolean bl16 = false;
                ((SqlBlock)it7).setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_AS ? w : null));
            }
            object = querySection;
            if (object instanceof SqlQueryBlock) {
                querySection.setMyWrap((Wrap)(this.getContext().getSql().VIEW_WRAP_QUERY ? w : null));
                querySection.setMyIndent(this.getContext().getSql().VIEW_INDENT_QUERY ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
            } else if (object instanceof SqlParenthesizedSubqueryBlock) {
                Indent indent;
                querySection.setMyWrap((Wrap)(this.getContext().getSql().SUBQUERY_OPENING > 1 ? w : null));
                switch (this.getContext().getSql().SUBQUERY_OPENING) {
                    case 3: {
                        indent = Indent.getSpaceIndent((int)0, (boolean)true);
                        break;
                    }
                    case 4: {
                        indent = Indent.getNormalIndent((boolean)true);
                        break;
                    }
                    default: {
                        indent = SqlFormattingFunKt.getNORMAL_INDENT();
                    }
                }
                querySection.setMyIndent(indent);
            }
        }
        SqlCommonHandlersKt.configureAttributesForPostfixOptions(this, this.getNestedBlocks());
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (this.getShape().getCollapsing()) {
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
        SqlBlock sqlBlock = block2;
        if (sqlBlock instanceof SqlTableParenthesizedColumnsSection) {
            switch (this.getContext().getSql().TABLE_OPENING) {
                case 1: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean userRequiresExpand() {
        return !this.getContext().getSql().TABLE_COLLAPSE;
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        return blocks.getBlock2() instanceof SqlTableParenthesizedColumnsSection ? SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, this.getContext().getSql().TABLE_OPENING == 4, 2, null) : super.getNewLineIndent(blocks);
    }

    static {
        Companion = new Companion(null);
        Object[] objectArray = new FlowPattern[9];
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_CREATE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_CREATE");
        objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndObjectKindContinuePattern(SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIRTUAL_TABLE}), SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCommonTokens.SQL_LEFT_PAREN, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, (IElementType)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION}), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
        objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_ENGINE_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_ENGINE_CLAUSE");
        objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_GENERIC_SETTINGS_CLAUSE");
        objectArray[3] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlCommonKeywords.SQL_ON;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_ON");
        objectArray[4] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_COMMIT, SqlCommonKeywords.SQL_PRESERVE, SqlCommonKeywords.SQL_DELETE, SqlCommonKeywords.SQL_ROWS}), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.5.INSTANCE)));
        SqlTokenType sqlTokenType4 = SqlCommonKeywords.SQL_TABLESPACE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_TABLESPACE");
        objectArray[5] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType4), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.6.INSTANCE)));
        SqlTokenType sqlTokenType5 = SqlCommonKeywords.SQL_WITH;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_WITH");
        objectArray[6] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType5), new EndIncElementContinuePattern(SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_OIDS, SqlCommonTokens.SQL_RIGHT_PAREN}), SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_WITH, SqlCommonKeywords.SQL_TABLESPACE}), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.7.INSTANCE)));
        SqlTokenType sqlTokenType6 = SqlCommonKeywords.SQL_WITHOUT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType6, (String)"SQL_WITHOUT");
        objectArray[7] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType6), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)SqlCommonKeywords.SQL_OIDS), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.8.INSTANCE)));
        SqlTokenType sqlTokenType7 = SqlCommonKeywords.SQL_USING;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType7, (String)"SQL_USING");
        objectArray[8] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType7), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)SqlCompositeElementTypes.SQL_IDENTIFIER), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.9.INSTANCE)));
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock$TableHeaderSection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "intellij.database.sql.core.impl"})
    public static final class TableHeaderSection
    extends SqlRangeBlock {
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTableBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

