/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowProcessor;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlElementTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u00020\u001c2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0#H\u0004J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\bH\u0016J\b\u0010&\u001a\u00020\u001cH\u0014J\u0012\u0010'\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010(H\u0004J+\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\b-J\u001c\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "()V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "grown", "", "minLength", "", "getMinLength", "()I", "setMinLength", "(I)V", "nestedNodes", "", "Lcom/intellij/lang/ASTNode;", "getNestedNodes", "()Ljava/util/List;", "setNestedNodes", "(Ljava/util/List;)V", "<set-?>", "Lcom/intellij/openapi/util/TextRange;", "range", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "adjustNestedNodes", "", "adjustProducedNestedBlocks", "contains", "char", "", "flattenNestedNodes", "whetherToFlatten", "Lkotlin/Function1;", "grow", "isLeaf", "produceNestedBlocks", "produceNestedBlocksInRange", "Lkotlin/ranges/IntRange;", "setup", "parent", "Lcom/intellij/sql/formatter/model/SqlBlock;", "nodes", "setup$intellij_database_sql_core_impl", "toString", "", "intellij.database.sql.core.impl"})
public abstract class SqlRangeBlock
extends SqlFlowBlock {
    private TextRange range;
    protected List<? extends ASTNode> nestedNodes;
    private int minLength;
    private boolean grown;

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public final TextRange getRange() {
        TextRange textRange = this.range;
        if (textRange == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"range");
        }
        return textRange;
    }

    @NotNull
    protected final List<ASTNode> getNestedNodes() {
        List<ASTNode> list = this.nestedNodes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        return list;
    }

    protected final void setNestedNodes(@NotNull List<? extends ASTNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.nestedNodes = list;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(int n) {
        this.minLength = n;
    }

    public final void setup(@NotNull SqlBlock parent2, @NotNull List<? extends ASTNode> nodes2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        Collection collection = nodes2;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        TextRange textRange = ((ASTNode)CollectionsKt.first(nodes2)).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"nodes.first().textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = ((ASTNode)CollectionsKt.last(nodes2)).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"nodes.last().textRange");
        TextRange range = new TextRange(n, textRange2.getEndOffset());
        this.setup$intellij_database_sql_core_impl(parent2, range, nodes2);
    }

    public final void setup$intellij_database_sql_core_impl(@NotNull SqlBlock parent2, @NotNull TextRange range, @NotNull List<? extends ASTNode> nodes2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        super.setup$intellij_database_sql_core_impl(parent2);
        this.range = range;
        this.nestedNodes = nodes2;
        this.adjustNestedNodes();
    }

    protected void adjustNestedNodes() {
    }

    protected final void flattenNestedNodes(@NotNull Function1<? super ASTNode, Boolean> whetherToFlatten) {
        Intrinsics.checkNotNullParameter(whetherToFlatten, (String)"whetherToFlatten");
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.astTraverser();
        List<? extends ASTNode> list = this.nestedNodes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        List list2 = ((SyntaxTraverser)((SyntaxTraverser)syntaxTraverser.withRoots((Iterable)list)).expandAndSkip(new Condition(whetherToFlatten){
            final /* synthetic */ Function1 $whetherToFlatten;

            public final boolean value(ASTNode it2) {
                ASTNode aSTNode = it2;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it");
                return (Boolean)this.$whetherToFlatten.invoke((Object)aSTNode) != false || it2.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK;
            }
            {
                this.$whetherToFlatten = function1;
            }
        })).traverse().filter((Condition)flattenNestedNodes.2.INSTANCE).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"SyntaxTraverser.astTrave\u2026ace() }\n        .toList()");
        this.nestedNodes = list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grow() {
        if (this.grown) {
            return;
        }
        try {
            this.produceNestedBlocks();
            this.adjustProducedNestedBlocks();
        }
        finally {
            this.grown = true;
        }
    }

    protected void produceNestedBlocks() {
        this.produceNestedBlocksInRange(null);
    }

    protected final void produceNestedBlocksInRange(@Nullable IntRange range) {
        List<FlowPattern> patterns2;
        List<? extends ASTNode> nodesToProcess;
        List<? extends ASTNode> list;
        if (range == null) {
            list = this.nestedNodes;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
            }
        } else {
            List<? extends ASTNode> list2 = this.nestedNodes;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
            }
            list = nodesToProcess = list2.subList(range.getFirst(), range.getLast() + 1);
        }
        if ((patterns2 = this.flowPatterns()) != null) {
            FlowProcessor flowProcessor = new FlowProcessor(this.getContext(), this, nodesToProcess, patterns2, this.flowToProduceCommentsFlowBlocks());
            flowProcessor.processAll();
        } else {
            for (ASTNode aSTNode : nodesToProcess) {
                SqlBlock block = this.makeBlock(aSTNode);
                if (block.getRole() == BlockRole.NOTHING) {
                    block.setRole(this.determineRole(aSTNode));
                }
                this.addNestedBlock$intellij_database_sql_core_impl(block);
            }
        }
    }

    protected void adjustProducedNestedBlocks() {
    }

    @Override
    public boolean contains(char c2) {
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = this.range;
        if (textRange == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"range");
        }
        return sqlFormattingContext.textContains(textRange, c2);
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        List<? extends ASTNode> list = this.nestedNodes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        if (list.isEmpty()) {
            return super.toString();
        }
        List<? extends ASTNode> list2 = this.nestedNodes;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        ASTNode aSTNode = SqlUtilFun.firstLeaf((ASTNode)CollectionsKt.first(list2));
        List<? extends ASTNode> list3 = this.nestedNodes;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        String str = SqlBlockKt.access$rangeRepresentation(aSTNode, SqlUtilFun.lastLeaf((ASTNode)CollectionsKt.last(list3)));
        return super.toString() + ": " + str;
    }

    public SqlRangeBlock() {
        super(null);
    }
}

