/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.TemplateEditorWithHelp;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.util.NameTemplate;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlCodeGenerationMainPanel
extends CodeStyleAbstractPanel {
    private JBTextField myPrimaryKeyTemplate;
    private JBTextField myForeignKeyTemplate;
    private JBTextField myIndexTemplate;
    private JPanel myPanel;

    protected SqlCodeGenerationMainPanel(CodeStyleSettings oldSettings) {
        super((Language)SqlLanguage.INSTANCE, null, oldSettings);
        this.$$$setupUI$$$();
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
    }

    protected int getRightMargin() {
        return 0;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return null;
    }

    @NotNull
    protected FileType getFileType() {
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        if (sqlFileType == null) {
            SqlCodeGenerationMainPanel.$$$reportNull$$$0(0);
        }
        return sqlFileType;
    }

    @Nullable
    protected String getPreviewText() {
        return null;
    }

    public void apply(CodeStyleSettings settings) {
        SqlCodeStyleSettings cgSettings = SqlCodeStyles.getGeneralSqlSettings((CodeStyleSettings)settings);
        cgSettings.FOREIGN_KEY_NAME_TEMPLATE = this.myForeignKeyTemplate.getText();
        cgSettings.PRIMARY_KEY_NAME_TEMPLATE = this.myPrimaryKeyTemplate.getText();
        cgSettings.INDEX_NAME_TEMPLATE = this.myIndexTemplate.getText();
    }

    public boolean isModified(CodeStyleSettings settings) {
        SqlCodeStyleSettings cgSettings = SqlCodeStyles.getGeneralSqlSettings((CodeStyleSettings)settings);
        if (!Objects.equals(cgSettings.FOREIGN_KEY_NAME_TEMPLATE, this.myForeignKeyTemplate.getText())) {
            return true;
        }
        if (!Objects.equals(cgSettings.PRIMARY_KEY_NAME_TEMPLATE, this.myPrimaryKeyTemplate.getText())) {
            return true;
        }
        return !Objects.equals(cgSettings.INDEX_NAME_TEMPLATE, this.myIndexTemplate.getText());
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = SqlBundle.message("sql.code.style.settings.tab.title", new Object[0]);
        if (string == null) {
            SqlCodeGenerationMainPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        SqlCodeStyleSettings cgSettings = SqlCodeStyles.getGeneralSqlSettings((CodeStyleSettings)settings);
        this.myForeignKeyTemplate.setText(cgSettings.FOREIGN_KEY_NAME_TEMPLATE);
        this.myPrimaryKeyTemplate.setText(cgSettings.PRIMARY_KEY_NAME_TEMPLATE);
        this.myIndexTemplate.setText(cgSettings.INDEX_NAME_TEMPLATE);
    }

    private void createUIComponents() {
        this.myPrimaryKeyTemplate = new TemplateEditorWithHelp((NameTemplate)new NameTemplate.PrimaryKeyNameTemplate());
        this.myForeignKeyTemplate = new TemplateEditorWithHelp((NameTemplate)new NameTemplate.ForeignKeyNameTemplate());
        this.myIndexTemplate = new TemplateEditorWithHelp((NameTemplate)new NameTemplate.IndexNameTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/formatter/settings/SqlCodeGenerationMainPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 3, 1, 0, 1, 6, 1, null, null, null));
        JBTextField jBTextField = this.myPrimaryKeyTemplate;
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        JBTextField jBTextField2 = this.myForeignKeyTemplate;
        jPanel.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        JBTextField jBTextField3 = this.myIndexTemplate;
        jPanel.add((Component)jBTextField3, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlCodeGenerationMainPanel.class).getString("SqlCodeGenerationMainPanel.label.primary.key"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlCodeGenerationMainPanel.class).getString("SqlCodeGenerationMainPanel.label.foreign.key"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", SqlCodeGenerationMainPanel.class).getString("SqlCodeGenerationMainPanel.label.index"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
        jBLabel2.setLabelFor((Component)jBTextField2);
        jBLabel3.setLabelFor((Component)jBTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

