/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.intentions.SqlIntroduceTableAliasIntention;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlImplicitSymbol;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlShouldBeInGroupByInspection
extends SqlInspectionBase {
    private static boolean inAggregateFunctionCall(SqlReferenceExpression ref) {
        SqlFunctionCallExpression call = SqlShouldBeInGroupByInspection.getFunctionCallParent((PsiElement)ref);
        while (call != null) {
            if (SqlShouldBeInGroupByInspection.isAggregate(call)) {
                return true;
            }
            call = SqlShouldBeInGroupByInspection.getFunctionCallParent((PsiElement)call);
        }
        return false;
    }

    @Nullable
    private static SqlFunctionCallExpression getFunctionCallParent(@Nullable PsiElement o) {
        return (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlFunctionCallExpression.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
    }

    private static boolean isAggregate(@Nullable SqlFunctionCallExpression call) {
        if (call == null) {
            return false;
        }
        SqlFunctionDefinition definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)call.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (definition == null) {
            return false;
        }
        return ("true".equals(definition.getDialectAttribute("analytic")) || "true".equals(definition.getDialectAttribute("aggregate"))) && PsiTreeUtil.findSiblingForward((PsiElement)call.getFirstChild(), (IElementType)SqlCompositeElementTypes.SQL_ANALYTIC_CLAUSE, (boolean)true, null) == null;
    }

    private static SqlAsExpression getContainingAlias(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(0);
        }
        return (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlAsExpression.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
    }

    private static boolean shouldReport(@NotNull Dbms dbms) {
        if (dbms == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(1);
        }
        return dbms.isClickHouse() || dbms.isDb2() || dbms.isDerby() || dbms.isExasol() || dbms.isH2() || dbms.isHsqldb() || dbms.isMicrosoft() || dbms.isOracle() || dbms.isPostgres() || dbms.isSnowflake() || dbms.isVertica();
    }

    @Nullable
    private static PsiElement resolveUnwrappingAliases(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(2);
        }
        SqlReferenceExpression e = ref;
        while (true) {
            SqlReferenceExpression next;
            if ((next = e) instanceof SqlReferenceExpression) {
                next = next.resolve();
            } else if (next instanceof SqlAsExpression) {
                next = ((SqlAsExpression)next).getExpression();
            } else {
                return next;
            }
            if (e == next) {
                return e;
            }
            e = next;
        }
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(5);
        }
        if (!SqlShouldBeInGroupByInspection.shouldReport(dbms = dialect.getDbms())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                super.visitSqlQueryExpression(o);
                SqlTableExpression tableExpression = o.getTableExpression();
                if (tableExpression == null || tableExpression.getWindowClause() != null) {
                    return;
                }
                SqlGroupByClause groupBy = tableExpression.getGroupByClause();
                if (groupBy != null) {
                    if (dbms.isH2()) {
                        return;
                    }
                    if (dbms.isHsqldb() || dbms.isGreenplum() || dbms == Dbms.POSTGRES) {
                        for (SqlReferenceExpression groupingRef : SqlImplUtil.sqlChildren((PsiElement)groupBy).filter(SqlReferenceExpression.class)) {
                            PsiElement target = SqlShouldBeInGroupByInspection.resolveUnwrappingAliases(groupingRef);
                            if (!(target instanceof DasColumn) || !DasUtil.isPrimary((DasColumn)target)) continue;
                            return;
                        }
                    }
                }
                for (SqlReferenceExpression ref : SqlShouldBeInGroupByInspection.getNonAggregateColumnRefs(o)) {
                    JBIterable names = SqlShouldBeInGroupByInspection.getResolvesNotInGroupBy(ref, o).transform(element2 -> SqlShouldBeInGroupByInspection.getResolvedColumnName(this.myDialect.getDatabaseDialect(), ref, element2));
                    int size = names.size();
                    if (size == 0) continue;
                    String strNames = StringUtil.join((Iterable)names, (String)", ");
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ref, SqlBundle.message(size == 1 ? "column.should.be.in.group.by" : "columns.should.be.in.group.by", strNames), (LocalQuickFix)new AddToGroupByQuickFix(), ProblemHighlightType.GENERIC_ERROR, onTheFly));
                }
            }
        };
    }

    @NotNull
    private static List<SqlReferenceExpression> getNonAggregateColumnRefs(@NotNull SqlQueryExpression o) {
        SqlSelectClause selectClause;
        if (o == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(6);
        }
        if ((selectClause = o.getSelectClause()) == null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(7);
            }
            return list;
        }
        SqlTableExpression tableExpression = o.getTableExpression();
        if (tableExpression == null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(8);
            }
            return list;
        }
        final PsiElement table = SqlIntroduceTableAliasIntention.Companion.resolveTable(tableExpression);
        final List columns = table instanceof SqlAsExpression ? ((SqlAsExpression)table).getColumnAliasList() : (table instanceof DasObject ? DasUtil.getColumns((DasObject)table).filter(PsiElement.class).toList() : ContainerUtil.emptyList());
        final boolean checkAggregatesPresent = SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDbms().isH2() || tableExpression.getGroupByClause() == null;
        final boolean[] hasAggregates = new boolean[]{false};
        final SmartList nonAggregatedRefs = new SmartList();
        selectClause.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                SqlReferenceExpression ref;
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element2 instanceof SqlQueryExpression) {
                    return;
                }
                super.visitElement(element2);
                if (checkAggregatesPresent && !hasAggregates[0] && element2 instanceof SqlFunctionCallExpression) {
                    hasAggregates[0] = SqlShouldBeInGroupByInspection.isAggregate((SqlFunctionCallExpression)element2);
                }
                if (element2 instanceof SqlReferenceExpression && (ref = (SqlReferenceExpression)element2).getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && !SqlShouldBeInGroupByInspection.inAggregateFunctionCall(ref) && SqlShouldBeInGroupByInspection.shouldHighlight(table, columns, ref)) {
                    nonAggregatedRefs.add((Object)ref);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$2", "visitElement"));
            }
        });
        Object object = checkAggregatesPresent && !hasAggregates[0] ? Collections.emptyList() : nonAggregatedRefs;
        if (object == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(9);
        }
        return object;
    }

    private static boolean shouldHighlight(PsiElement table, List<? extends PsiElement> columns, SqlReferenceExpression e) {
        SqlClause clause = (SqlClause)PsiTreeUtil.getContextOfType((PsiElement)e, SqlClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class});
        if (clause != null && !(clause instanceof SqlSelectClause)) {
            return false;
        }
        SqlResultSetExpression expression = SqlShouldBeInGroupByInspection.findExpression(e);
        if (expression == null) {
            return true;
        }
        if (SqlIntroduceTableAliasIntention.Companion.isCorrelatedQuery(expression, table)) {
            return columns.contains(e.resolve());
        }
        if (expression instanceof SqlQueryExpression) {
            SqlFromClause fromClause;
            SqlTableExpression tableExpression = ((SqlQueryExpression)expression).getTableExpression();
            SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
            if (fromClause != null && fromClause.getFromExpression() instanceof SqlAsExpression) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static SqlResultSetExpression findExpression(SqlReferenceExpression e) {
        SqlParenthesizedExpression parenthesized = (SqlParenthesizedExpression)PsiTreeUtil.getContextOfType((PsiElement)e, (Class[])new Class[]{SqlParenthesizedExpression.class});
        if (parenthesized == null) {
            return null;
        }
        for (SqlExpression expression : parenthesized.getExpressionList()) {
            if (!(expression instanceof SqlResultSetExpression) || !PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)e, (boolean)true)) continue;
            return (SqlResultSetExpression)expression;
        }
        return null;
    }

    @NotNull
    private static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref, @Nullable SqlQueryExpression o) {
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(10);
        }
        return SqlShouldBeInGroupByInspection.getResolvesNotInGroupBy(ref, o == null || o.getTableExpression() == null ? null : o.getTableExpression().getGroupByClause());
    }

    private static boolean hasUsages(@NotNull PsiElement element2, @NotNull SearchScope scope, @NotNull Set<PsiElement> extraTargets) {
        if (element2 == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(12);
        }
        if (extraTargets == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(13);
        }
        return extraTargets.contains(element2) || ReferencesSearch.search((PsiElement)element2, (SearchScope)scope).findFirst() != null;
    }

    @NotNull
    private static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref, @Nullable SqlGroupByClause groupByClause) {
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(14);
        }
        JBIterable allColumns = JBIterable.from(DbSqlUtil.resolveToColumnList(ref));
        for (PsiElement column2 : allColumns) {
            if (!(column2 instanceof SqlAsExpression) && column2 != ref) continue;
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        if (groupByClause == null) {
            JBIterable jBIterable = allColumns;
            if (jBIterable == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)groupByClause);
        SmartHashSet posRefTargets = new SmartHashSet();
        for (SqlPositionalReference posRef : SqlImplUtil.sqlChildren((PsiElement)groupByClause).filter(SqlPositionalReference.class)) {
            PsiElement target = posRef.resolve();
            if (target instanceof SqlImplicitSymbol) {
                target = ((SqlImplicitSymbol)target).getTargetDefinition();
            }
            if (target == null) continue;
            posRefTargets.add((Object)target);
        }
        SqlAsExpression alias = SqlShouldBeInGroupByInspection.getContainingAlias(ref);
        if (alias != null && SqlShouldBeInGroupByInspection.hasUsages((PsiElement)alias, (SearchScope)scope, (Set<PsiElement>)posRefTargets)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        if ((allColumns = allColumns.filter(element2 -> !SqlShouldBeInGroupByInspection.hasUsages(element2, (SearchScope)scope, (Set<PsiElement>)posRefTargets))).isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        JBIterable jBIterable = alias != null ? JBIterable.of((Object)alias) : allColumns;
        if (jBIterable == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    private static String getResolvedColumnName(@NotNull DatabaseDialectEx dialect, @NotNull SqlReferenceExpression ref, @NotNull PsiElement resolved) {
        if (dialect == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(20);
        }
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(21);
        }
        if (resolved == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(22);
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref);
        if (type == null || ref.getReference().isReferenceTo(resolved)) {
            String string = ref.getReference().getCanonicalText();
            if (string == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(23);
            }
            return string;
        }
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            if (type.getColumnElement(i2) != resolved) continue;
            DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(ref.getProject(), sqlDialect).withDialect(dialect);
            String name = StringUtil.notNullize((String)type.getColumnName(i2));
            String typeAlias = type.getColumnTypeAlias(i2);
            if (typeAlias == null) {
                String string = ref.getReference().getCanonicalText();
                if (string == null) {
                    SqlShouldBeInGroupByInspection.$$$reportNull$$$0(24);
                }
                return string;
            }
            builder.columnRef(typeAlias).symbol(".").columnRef(name);
            String string = builder.getStatement();
            if (string == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = ref.getReference().getCanonicalText();
        if (string == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static Iterable<CharSequence> nameElements(@NotNull SqlTableExpression tableExpression, @NotNull SqlReferenceExpression ref, @NotNull JBIterable<PsiElement> elements) {
        if (tableExpression == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(28);
        }
        if (elements == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(29);
        }
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref).getDatabaseDialect();
        SqlTableType partType = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (partType != null) {
            List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(ref.getProject(), dialect, partType, tableExpression.getSqlType(), null);
            ArrayList<CharSequence> filtered2 = new ArrayList<CharSequence>(elements.size());
            Iterator it2 = elements.iterator();
            PsiElement cur2 = (PsiElement)it2.next();
            for (int i2 = 0; i2 < columnNames.size(); ++i2) {
                if (partType.getColumnElement(i2) != cur2) continue;
                filtered2.add(columnNames.get(i2));
                if (!it2.hasNext()) break;
                cur2 = (PsiElement)it2.next();
            }
            ArrayList<CharSequence> arrayList = filtered2;
            if (arrayList == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(30);
            }
            return arrayList;
        }
        JBIterable jBIterable = elements.transform(element2 -> SqlShouldBeInGroupByInspection.getResolvedColumnName(dialect, ref, element2));
        if (jBIterable == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(31);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraTargets";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonAggregateColumnRefs";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvesNotInGroupBy";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedColumnName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "nameElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainingAlias";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldReport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnwrappingAliases";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonAggregateColumnRefs";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResolvesNotInGroupBy";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasUsages";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedColumnName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "nameElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToGroupByQuickFix
    implements LocalQuickFix {
        private AddToGroupByQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message("quickfix.name.add.to.group.by", new Object[0]);
            if (string == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.inspections.group.name", new Object[0]);
            if (string == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiFile file;
            SqlTableExpression tableExpression;
            SqlReferenceExpression ref;
            if (project == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(3);
            }
            if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)descriptor2.getPsiElement(), SqlReferenceExpression.class)) == null) {
                return;
            }
            SqlQueryExpression o = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = o != null ? o.getTableExpression() : null;
            if (tableExpression == null) {
                return;
            }
            SqlGroupByClause groupByClause = tableExpression.getGroupByClause();
            JBIterable<PsiElement> elements = SqlShouldBeInGroupByInspection.getResolvesNotInGroupBy(ref, o);
            if (elements.isEmpty()) {
                return;
            }
            Iterable<CharSequence> names = SqlShouldBeInGroupByInspection.nameElements(tableExpression, ref, elements);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)o);
            if (groupByClause == null) {
                SqlGroupByClause groupBy = SqlPsiElementFactory.createGroupByClause(StringUtil.join(names, (String)", "), dialect, project);
                if (groupBy != null) {
                    IntentionUtilsKt.addGroupBy(o, groupBy);
                }
                return;
            }
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            Document document = instance.getDocument(file = ref.getContainingFile());
            if (document == null) {
                return;
            }
            int end2 = groupByClause.getTextRange().getEndOffset();
            PsiElement last = groupByClause.getLastChild();
            boolean needComma = true;
            if (last == null) {
                needComma = false;
            } else {
                IElementType type = last.getNode().getElementType();
                if (type == TokenType.ERROR_ELEMENT || type == SqlCommonKeywords.SQL_GROUP || type == SqlCommonKeywords.SQL_BY) {
                    needComma = false;
                }
            }
            document.insertString(end2, (CharSequence)((needComma ? "," : "") + " " + StringUtil.join(names, (String)", ")));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

