/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExpandColumnListIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.expand.column.list", new Object[0]);
        if (string == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            return false;
        }
        SqlReferenceExpression referenceExpression = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        SqlReference referenceAt = referenceExpression.getReference();
        String text2 = referenceAt.getCanonicalText();
        if (!"*".equals(text2) && !text2.endsWith(".*")) {
            return false;
        }
        SqlElement parent2 = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, (Class[])new Class[]{SqlClause.class, SqlExpression.class, SqlStatement.class});
        if (!(parent2 instanceof SqlSelectClause)) {
            return false;
        }
        SqlType type = referenceExpression.getSqlType();
        return type instanceof SqlTableType && ((SqlTableType)type).getColumnCount() > 0;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        SqlReferenceExpression referenceExpression;
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(4);
        }
        if ((referenceExpression = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlReferenceExpression.class)) == null) {
            return;
        }
        SqlType type = referenceExpression.getSqlType();
        if (!(type instanceof SqlTableType) || ((SqlTableType)type).getColumnCount() == 0) {
            return;
        }
        SqlTableType tableType = (SqlTableType)type;
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)referenceExpression);
        String columnListText = SqlExpandColumnListIntention.getAllColumnsList(project, (PsiElement)referenceExpression, tableType, dialect);
        if (StringUtil.isEmptyOrSpaces((String)columnListText)) {
            return;
        }
        String templateText = "select " + columnListText + " from t";
        SqlQueryExpression expr = SqlPsiElementFactory.createQueryExpressionFromText(templateText, (SqlLanguageDialect)dialect, project);
        if (expr == null) {
            throw new IncorrectOperationException("Not a query expression " + dialect.getDisplayName() + ": " + templateText);
        }
        List expressions2 = expr.getSelectClause().getExpressions();
        referenceExpression.getParent().addRangeBefore((PsiElement)expressions2.get(0), (PsiElement)expressions2.get(expressions2.size() - 1), (PsiElement)referenceExpression);
        referenceExpression.delete();
    }

    @NotNull
    public static String getAllColumnsList(@NotNull Project project, @Nullable PsiElement element2, @NotNull SqlTableType tableType, @NotNull SqlLanguageDialectEx dialect) {
        SqlQueryExpression queryExpression;
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(5);
        }
        if (tableType == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(7);
        }
        SqlTableExpression tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression();
        SqlTableType asteriskType = tableExpression == null ? null : tableExpression.getSqlType();
        SqlEditorOptions options = SqlEditorOptions.getInstance();
        PairFunction forceQualify = (t, i2) -> {
            SqlEditorOptions.QualificationType qualification = ModelConsts.TABLE_OR_VIEW_KINDS.contains(DasUtil.getKind((DasObject)ObjectUtils.tryCast((Object)t.getColumnQualifier(i2.intValue()), DasObject.class))) ? options.getTableQualification() : options.getAliasQualification();
            return qualification.shouldQualify(1);
        };
        List<String> columnNames = asteriskType == null ? DbSqlUtil.getUnambiguousColumnNames(project, dialect.getDatabaseDialect(), tableType, (PairFunction<? super SqlTableType, ? super Integer, Boolean>)forceQualify) : DbSqlUtil.getUnambiguousColumnNames(project, dialect.getDatabaseDialect(), tableType, asteriskType, (PairFunction<? super SqlTableType, ? super Integer, Boolean>)forceQualify);
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, dialect).withDialect(dialect.getDatabaseDialect());
        int len = tableType.getColumnCount();
        for (int i3 = 0; i3 < len; ++i3) {
            if (i3 > 0) {
                builder.symbol(",").space();
            }
            builder.plain(columnNames.get(i3));
        }
        String string = builder.getStatement();
        if (string == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlExpandColumnListIntention";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlExpandColumnListIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllColumnsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllColumnsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

