/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0096\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\f\u0010\u001a\u001a\u00020\u0019*\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceDistinctWithGroupByIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "groupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "Lcom/intellij/sql/psi/SqlQueryExpression;", "getGroupByClause", "(Lcom/intellij/sql/psi/SqlQueryExpression;)Lcom/intellij/sql/psi/SqlGroupByClause;", "getExpressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "context", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "isReference", "intellij.database.sql.impl"})
public final class SqlReplaceDistinctWithGroupByIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.distinct.with.group.by", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026.distinct.with.group.by\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Collection collection = this.getExpressions(element2);
        boolean bl = false;
        return !collection.isEmpty();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        SqlGroupByClause sqlGroupByClause;
        block11: {
            block10: {
                SqlSelectOption it2;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                List<SqlExpression> expressions2 = this.getExpressions(element2);
                if (expressions2.isEmpty()) {
                    return;
                }
                SqlSelectClause sqlSelectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CollectionsKt.first(expressions2)), SqlSelectClause.class);
                if (sqlSelectClause == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sqlSelectClause, (String)"PsiTreeUtil.getParentOfT\u2026se::class.java) ?: return");
                SqlSelectClause selectClause = sqlSelectClause;
                PsiElement psiElement = selectClause.getParent();
                if (!(psiElement instanceof SqlQueryExpression)) {
                    psiElement = null;
                }
                SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)psiElement;
                if (sqlQueryExpression == null) {
                    return;
                }
                SqlQueryExpression query = sqlQueryExpression;
                if (this.getGroupByClause(query) != null) {
                    return;
                }
                SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)query);
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(query)");
                SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
                List list = selectClause.getOptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectClause.options");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (SqlSelectOption)element$iv;
                    boolean bl = false;
                    SqlSelectOption sqlSelectOption = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"it");
                    if (!StringsKt.equals((String)sqlSelectOption.getName(), (String)"distinct", (boolean)true) && !StringsKt.equals((String)it2.getName(), (String)"distinctrow", (boolean)true)) continue;
                    PsiElement psiElement2 = it2.getNextSibling();
                    if (!(psiElement2 instanceof PsiWhiteSpace)) {
                        psiElement2 = null;
                    }
                    PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement2;
                    PsiElement next = psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)it2;
                    it2.getParent().deleteChildRange((PsiElement)it2, next);
                }
                sqlGroupByClause = IntentionUtilsKt.createGroupByClause(expressions2, dialect, project);
                if (sqlGroupByClause == null) break block10;
                SqlGroupByClause sqlGroupByClause2 = sqlGroupByClause;
                boolean bl = false;
                boolean bl2 = false;
                it2 = sqlGroupByClause2;
                boolean bl3 = false;
                sqlGroupByClause = IntentionUtilsKt.addGroupBy(query, (SqlGroupByClause)it2);
                if (sqlGroupByClause != null) break block11;
            }
            return;
        }
        SqlGroupByClause groupBy = sqlGroupByClause;
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)groupBy);
    }

    private final List<SqlExpression> getExpressions(PsiElement context) {
        PsiElement sibling;
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)context);
        if (Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_DISTINCT) ^ true && Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_DISTINCTROW) ^ true) {
            return CollectionsKt.emptyList();
        }
        SqlSelectOption sqlSelectOption = (SqlSelectOption)PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectOption.class);
        if (sqlSelectOption == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"PsiTreeUtil.getParentOfT\u2026va) ?: return emptyList()");
        SqlSelectOption selectOption = sqlSelectOption;
        PsiElement psiElement = selectOption.getParent();
        if (!(psiElement instanceof SqlSelectClause)) {
            psiElement = null;
        }
        SqlSelectClause sqlSelectClause = (SqlSelectClause)psiElement;
        if (sqlSelectClause == null) {
            return CollectionsKt.emptyList();
        }
        SqlSelectClause selectClause = sqlSelectClause;
        PsiElement psiElement2 = selectClause.getParent();
        if (!(psiElement2 instanceof SqlQueryExpression)) {
            psiElement2 = null;
        }
        SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)psiElement2;
        if (sqlQueryExpression == null) {
            return CollectionsKt.emptyList();
        }
        SqlQueryExpression query = sqlQueryExpression;
        if (this.getGroupByClause(query) != null) {
            return CollectionsKt.emptyList();
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)selectClause);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(selectClause)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        Object distinctClause = dbms2.isPostgres() ? (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)(sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)context))), (Object)SqlCommonKeywords.SQL_ON) ? selectOption.getClause() : null) : null;
        SqlClause sqlClause = distinctClause;
        if (sqlClause == null) {
            sqlClause = (SqlClause)selectClause;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)sqlClause), SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026qlExpression::class.java)");
        List expressions2 = list;
        if (Intrinsics.areEqual((Object)dialect.getDisplayName(), (Object)"SQL92") || dbms2.isCassandra() || dbms2.isDerby()) {
            boolean bl;
            block13: {
                Iterable $this$any$iv = expressions2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        SqlExpression sqlExpression = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"it");
                        if (!(!this.isReference(sqlExpression))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return CollectionsKt.emptyList();
            }
        }
        return expressions2;
    }

    private final boolean isReference(SqlExpression $this$isReference) {
        SqlAsExpression sqlAsExpression;
        SqlExpression sqlExpression = $this$isReference;
        if (!(sqlExpression instanceof SqlAsExpression)) {
            sqlExpression = null;
        }
        if ((sqlAsExpression = (SqlAsExpression)sqlExpression) == null || (sqlAsExpression = sqlAsExpression.getExpression()) == null) {
            sqlAsExpression = $this$isReference;
        }
        return sqlAsExpression instanceof SqlReferenceExpression;
    }

    private final SqlGroupByClause getGroupByClause(SqlQueryExpression $this$groupByClause) {
        SqlTableExpression sqlTableExpression = $this$groupByClause.getTableExpression();
        if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getGroupByClause()) == null) {
            sqlTableExpression = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$groupByClause), SqlGroupByClause.class);
        }
        return sqlTableExpression;
    }
}

