/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralManipulator
extends AbstractElementManipulator<SqlStringLiteralExpressionImpl> {
    public SqlStringLiteralExpressionImpl handleContentChange(@NotNull SqlStringLiteralExpressionImpl psi, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (psi == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(1);
        }
        String oldText = psi.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + SqlStringLiteralManipulator.escapeSqlStringCharacters(newContent, SqlStringLiteralManipulator.getStringLiteralType((PsiElement)psi)) + oldText.substring(range.getEndOffset());
        return psi.updateText(newText);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull SqlStringLiteralExpressionImpl element2) {
        if (element2 == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(2);
        }
        TextRange textRange = SqlStringLiteralManipulator.getStringContentRange((PsiElement)element2);
        if (textRange == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public static String unescapeSqlStringCharacters(String text2, LiteralType type) {
        return type == LiteralType.QUOTED ? text2.replace("''", "'") : text2;
    }

    public static String escapeSqlStringCharacters(String text2, LiteralType type) {
        return type == LiteralType.QUOTED ? text2.replace("'", "''") : text2;
    }

    @Nullable
    public static PsiElement getStringElement(@Nullable PsiElement element2) {
        if (element2 instanceof SqlStringTokenElement) {
            SqlStringLiteralExpression expression = (SqlStringLiteralExpression)ObjectUtils.tryCast((Object)element2.getParent(), SqlStringLiteralExpression.class);
            return (PsiElement)ObjectUtils.notNull((Object)expression, (Object)element2);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)element2, SqlStringLiteralExpression.class);
    }

    @NotNull
    public static LiteralType getStringLiteralType(@Nullable PsiElement expression) {
        SqlStringTokenElement token;
        if (expression == null) {
            LiteralType literalType = LiteralType.RAW;
            if (literalType == null) {
                SqlStringLiteralManipulator.$$$reportNull$$$0(4);
            }
            return literalType;
        }
        if (expression instanceof SqlStringTokenElement) {
            token = (SqlStringTokenElement)expression;
        } else if (expression instanceof SqlStringLiteralExpression) {
            token = SqlStringLiteralManipulator.getStringToken((SqlStringLiteralExpression)expression);
        } else {
            LiteralType literalType = LiteralType.RAW;
            if (literalType == null) {
                SqlStringLiteralManipulator.$$$reportNull$$$0(5);
            }
            return literalType;
        }
        if (token == null) {
            LiteralType literalType = LiteralType.RAW;
            if (literalType == null) {
                SqlStringLiteralManipulator.$$$reportNull$$$0(6);
            }
            return literalType;
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)token);
        if (type != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            LiteralType literalType = LiteralType.QUOTED;
            if (literalType == null) {
                SqlStringLiteralManipulator.$$$reportNull$$$0(7);
            }
            return literalType;
        }
        PsiElement q = PsiTreeUtil.findSiblingBackward((PsiElement)token, (IElementType)SqlTokens.SQL_CUSTOM_LQUOTE, null);
        if (q == null) {
            LiteralType literalType = LiteralType.RAW;
            if (literalType == null) {
                SqlStringLiteralManipulator.$$$reportNull$$$0(8);
            }
            return literalType;
        }
        String text2 = q.getText();
        boolean quoted = text2.equals("'");
        if (!quoted) {
            int l = text2.length();
            quoted = l > 1 && text2.charAt(l - 1) == '\'' && Character.isAlphabetic(text2.charAt(l - 2));
        }
        LiteralType literalType = quoted ? LiteralType.QUOTED : LiteralType.RAW;
        if (literalType == null) {
            SqlStringLiteralManipulator.$$$reportNull$$$0(9);
        }
        return literalType;
    }

    @Nullable
    private static SqlStringTokenElement getStringToken(SqlStringLiteralExpression expression) {
        return (SqlStringTokenElement)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlStringTokenElement.class);
    }

    public static TextRange getStringContentRange(PsiElement element2) {
        LeafPsiElement unclosed;
        if (element2 instanceof SqlStringTokenElement) {
            return ((SqlStringTokenElement)element2).getRangeInElement();
        }
        SqlStringLiteralExpression str = (SqlStringLiteralExpression)ObjectUtils.tryCast((Object)element2, SqlStringLiteralExpression.class);
        if (str == null) {
            return TextRange.create((int)0, (int)element2.getTextLength());
        }
        SqlStringTokenElement token = (SqlStringTokenElement)((Object)ObjectUtils.tryCast((Object)((Object)SqlStringLiteralManipulator.getStringToken(str)), SqlStringTokenElement.class));
        if (token != null && token.getElementType() == SqlTokens.SQL_STRING_TOKEN) {
            return token.getRangeInElement().shiftRight(token.getStartOffsetInParent());
        }
        ASTNode quote = str.getNode().findChildByType((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE);
        if (quote == null && (unclosed = (LeafPsiElement)ObjectUtils.tryCast((Object)str.getNode().findChildByType((IElementType)SqlTokens.SQL_UNCLOSED_TOKEN), LeafPsiElement.class)) != null) {
            return SqlStringTokenElement.getRangeInElement((ASTNode)unclosed).shiftRight(unclosed.getStartOffsetInParent());
        }
        assert (quote instanceof LeafPsiElement) : str.getText() + " : " + str.getClass().getName();
        ASTNode rquote = str.getNode().findChildByType((IElementType)SqlTokens.SQL_CUSTOM_RQUOTE);
        int start2 = quote.getStartOffsetInParent() + quote.getTextLength();
        return rquote == null ? TextRange.from((int)start2, (int)0) : TextRange.create((int)start2, (int)rquote.getStartOffsetInParent());
    }

    @Nullable
    static String getLiteralText(SqlStringLiteralExpression literal) {
        SqlStringTokenElement stringToken = SqlStringLiteralManipulator.getStringToken(literal);
        return stringToken == null ? null : stringToken.getTokenText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlStringLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlStringLiteralManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LiteralType {
        QUOTED,
        RAW,
        DELIMITED_IDENTIFIER;

    }
}

