/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.images;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.ConfigureImageLineMarkerProviderBase;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureTextHtmlImageLineMarkerProvider;", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;", "Lcom/intellij/psi/PsiElement;", "()V", "applyChanges", "", "element", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "convertToMarkdown", "createDialog", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "obtainLeafElement", "obtainOuterElement", "obtainPathText", "", "updateAttributes", "intellij.markdown"})
public final class ConfigureTextHtmlImageLineMarkerProvider
extends ConfigureImageLineMarkerProviderBase<PsiElement> {
    @Override
    @Nullable
    public PsiElement obtainLeafElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)MarkdownTokenTypes.HTML_TAG) ^ true) {
            return null;
        }
        PsiElement psiElement = element;
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        return ImageUtils.createImageTagFromText(element) != null ? psiElement : null;
    }

    @Override
    @Nullable
    public PsiElement obtainOuterElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.obtainLeafElement(element);
    }

    @Override
    @Nullable
    public String obtainPathText(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XmlTag xmlTag = ImageUtils.createImageTagFromText(element);
        return xmlTag != null ? xmlTag.getAttributeValue("src") : null;
    }

    @Override
    @Nullable
    public ConfigureImageDialog createDialog(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XmlTag xmlTag = ImageUtils.createImageTagFromText(element);
        if (xmlTag == null) {
            return null;
        }
        XmlTag image = xmlTag;
        Project project = image.getProject();
        String string = MarkdownBundle.message("markdown.configure.image.title.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026figure.image.title.text\")");
        return new ConfigureImageDialog(project, string, this.obtainPathText(element), image.getAttributeValue("width"), image.getAttributeValue("height"), image.getAttributeValue("title"), image.getAttributeValue("alt"), true);
    }

    @Override
    public void applyChanges(@NotNull PsiElement element, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        if (imageData.getShouldConvertToHtml()) {
            this.updateAttributes(element, imageData);
        } else {
            this.convertToMarkdown(element, imageData);
        }
    }

    private final void updateAttributes(PsiElement element, MarkdownImageData imageData) {
        Runnable action2 = new Runnable(element, imageData){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ MarkdownImageData $imageData;

            public final void run() {
                PsiElement psiElement = MarkdownPsiElementFactory.createHtmlImageTag(this.$element.getProject(), this.$imageData);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"MarkdownPsiElementFactor\u2026ement.project, imageData)");
                PsiElement replacement = psiElement;
                this.$element.replace(replacement);
            }
            {
                this.$element = psiElement;
                this.$imageData = markdownImageData;
            }
        };
        WriteCommandAction.runWriteCommandAction((Project)element.getProject(), (String)MarkdownBundle.message("markdown.configure.image.line.marker.update.html.image.attributes.command.name", new Object[0]), null, (Runnable)action2, (PsiFile[])new PsiFile[0]);
    }

    private final void convertToMarkdown(PsiElement element, MarkdownImageData imageData) {
        Runnable action2 = new Runnable(element, imageData){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ MarkdownImageData $imageData;

            public final void run() {
                this.$element.replace(MarkdownPsiElementFactory.createImage(this.$element.getProject(), this.$imageData.getDescription(), this.$imageData.getPath(), this.$imageData.getTitle()));
            }
            {
                this.$element = psiElement;
                this.$imageData = markdownImageData;
            }
        };
        WriteCommandAction.runWriteCommandAction((Project)element.getProject(), (String)MarkdownBundle.message("markdown.configure.image.line.marker.convert.html.to.markdown.command.name", new Object[0]), null, (Runnable)action2, (PsiFile[])new PsiFile[0]);
    }
}

