/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.docx;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionsBaseDialog;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/docx/MarkdownImportDocxDialog;", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "fileToImport", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "suggestedFilePath", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "doAction", "", "selectedFileUrl", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "intellij.markdown"})
public final class MarkdownImportDocxDialog
extends MarkdownFileActionsBaseDialog {
    private final VirtualFile fileToImport;

    @Override
    protected void doAction(@NotNull String selectedFileUrl) {
        Intrinsics.checkNotNullParameter((Object)selectedFileUrl, (String)"selectedFileUrl");
        MarkdownImportExportUtils.INSTANCE.copyAndConvertToMd(this.getProject(), this.fileToImport, selectedFileUrl);
    }

    @Override
    @Nullable
    protected String getFileNameIfExist(@NotNull String dir, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        return FileUtil.exists((String)FileUtil.join((String[])new String[]{dir, fileNameWithoutExtension + ".md"})) ? fileNameWithoutExtension + ".md" : (FileUtil.exists((String)FileUtil.join((String[])new String[]{dir, fileNameWithoutExtension + ".docx"})) ? fileNameWithoutExtension + ".docx" : null);
    }

    public MarkdownImportDocxDialog(@NotNull VirtualFile fileToImport, @NotNull Project project, @NotNull String suggestedFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileToImport, (String)"fileToImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath, (String)"suggestedFilePath");
        super(project, suggestedFilePath, fileToImport);
        this.fileToImport = fileToImport;
        this.setTitle(MarkdownBundle.message("markdown.import.from.docx.dialog.title", new Object[0]));
        this.setOKButtonText(MarkdownBundle.message("markdown.import.dialog.ok.button", new Object[0]));
    }
}

