/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection.alias;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.alias.LanguageInfoString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/injection/alias/LanguageGuesser;", "", "()V", "customProviders", "", "Lorg/intellij/plugins/markdown/injection/CodeFenceLanguageProvider;", "getCustomProviders", "()Ljava/util/List;", "guessLanguage", "Lcom/intellij/lang/Language;", "value", "", "guessLanguageForInjection", "intellij.markdown"})
public final class LanguageGuesser {
    @NotNull
    public static final LanguageGuesser INSTANCE;

    @NotNull
    public final List<CodeFenceLanguageProvider> getCustomProviders() {
        ExtensionPointName<CodeFenceLanguageProvider> extensionPointName = CodeFenceLanguageProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"CodeFenceLanguageProvider.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CodeFenceLanguageProvider.EP_NAME.extensionList");
        return list;
    }

    @JvmStatic
    @Nullable
    public static final Language guessLanguageForInjection(@NotNull String value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Language language = LanguageGuesser.guessLanguage(value);
        if (language != null) {
            Language language2 = language;
            boolean bl = false;
            boolean bl2 = false;
            Language it = language2;
            boolean bl3 = false;
            object = LanguageUtil.isInjectableLanguage((Language)it) ? language2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @JvmStatic
    private static final Language guessLanguage(String value) {
        String name = LanguageInfoString.INSTANCE.findId(value);
        for (CodeFenceLanguageProvider provider : INSTANCE.getCustomProviders()) {
            Language lang = provider.getLanguageByInfoString(name);
            if (lang == null) continue;
            return lang;
        }
        String lower = StringUtil.toLowerCase((String)name);
        Language candidate = Language.findLanguageByID((String)lower);
        if (candidate != null) {
            return candidate;
        }
        Iterator iterator = Language.getRegisteredLanguages().iterator();
        while (iterator.hasNext()) {
            Language language;
            Language language2 = language = (Language)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"language");
            if (!Intrinsics.areEqual((Object)StringUtil.toLowerCase((String)language2.getID()), (Object)lower)) continue;
            return language;
        }
        iterator = EmbeddedTokenTypesProvider.getProviders().iterator();
        while (iterator.hasNext()) {
            EmbeddedTokenTypesProvider provider;
            EmbeddedTokenTypesProvider embeddedTokenTypesProvider = provider = (EmbeddedTokenTypesProvider)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)embeddedTokenTypesProvider, (String)"provider");
            if (!StringsKt.equals((String)embeddedTokenTypesProvider.getName(), (String)name, (boolean)true)) continue;
            IElementType iElementType = provider.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"provider.elementType");
            return iElementType.getLanguage();
        }
        return null;
    }

    private LanguageGuesser() {
    }

    static {
        LanguageGuesser languageGuesser;
        INSTANCE = languageGuesser = new LanguageGuesser();
    }
}

