/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.extensions.CodeFencePluginFlavourDescriptor;
import org.intellij.plugins.markdown.lang.parser.GFMCommentAwareFlavourDescriptor;
import org.jetbrains.annotations.NotNull;

public final class MarkdownParserManager {
    public static final Key<MarkdownFlavourDescriptor> FLAVOUR_DESCRIPTION = Key.create((String)"Markdown.Flavour");
    public static final GFMCommentAwareFlavourDescriptor FLAVOUR = new GFMCommentAwareFlavourDescriptor();
    public static final CodeFencePluginFlavourDescriptor CODE_FENCE_PLUGIN_FLAVOUR = new CodeFencePluginFlavourDescriptor();
    private static final AtomicReference<ParsingInfo> ourLastParsingResult = new AtomicReference();

    public static ASTNode parseContent(@NotNull CharSequence buffer) {
        if (buffer == null) {
            MarkdownParserManager.$$$reportNull$$$0(0);
        }
        return MarkdownParserManager.parseContent(buffer, (MarkdownFlavourDescriptor)FLAVOUR);
    }

    public static ASTNode parseContent(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
        ParsingInfo info;
        if (buffer == null) {
            MarkdownParserManager.$$$reportNull$$$0(1);
        }
        if (flavour == null) {
            MarkdownParserManager.$$$reportNull$$$0(2);
        }
        if ((info = ourLastParsingResult.get()) != null && info.myBufferHash == buffer.hashCode() && info.myBuffer.equals(buffer)) {
            return info.myParseResult;
        }
        ASTNode parseResult = new MarkdownParser(flavour).parse(MarkdownElementTypes.MARKDOWN_FILE, buffer.toString(), false);
        ourLastParsingResult.set(new ParsingInfo(buffer, parseResult));
        return parseResult;
    }

    static {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                ourLastParsingResult.set(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/intellij/plugins/markdown/lang/parser/MarkdownParserManager$1", "beforePluginUnload"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "buffer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "flavour";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/markdown/lang/parser/MarkdownParserManager";
        objectArray[2] = "parseContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ParsingInfo {
        @NotNull
        final CharSequence myBuffer;
        final int myBufferHash;
        @NotNull
        final ASTNode myParseResult;

        ParsingInfo(@NotNull CharSequence buffer, @NotNull ASTNode parseResult) {
            if (buffer == null) {
                ParsingInfo.$$$reportNull$$$0(0);
            }
            if (parseResult == null) {
                ParsingInfo.$$$reportNull$$$0(1);
            }
            this.myBuffer = buffer;
            this.myBufferHash = this.myBuffer.hashCode();
            this.myParseResult = parseResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parseResult";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

