/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFencePluginGeneratingProvider;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.jetbrains.annotations.NotNull;

class MarkdownLAFListener
implements LafManagerListener {
    MarkdownLAFListener() {
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        if (source == null) {
            MarkdownLAFListener.$$$reportNull$$$0(0);
        }
        MarkdownLAFListener.reinit();
    }

    public static void reinit() {
        MarkdownCodeFencePluginGeneratingProvider.Companion.notifyLAFChanged();
        MarkdownLAFListener.updateCssSettingsForced();
    }

    private static void updateCssSettingsForced() {
        MarkdownCssSettings currentCssSettings = MarkdownApplicationSettings.getInstance().getMarkdownCssSettings();
        String stylesheetUri = StringUtil.isEmpty((String)currentCssSettings.getCustomStylesheetPath()) ? MarkdownCssSettings.DEFAULT.getCustomStylesheetPath() : currentCssSettings.getCustomStylesheetPath();
        MarkdownCssSettings newSettings = new MarkdownCssSettings(currentCssSettings.isCustomStylesheetEnabled(), stylesheetUri, currentCssSettings.isTextEnabled(), currentCssSettings.getCustomStylesheetText(), currentCssSettings.getFontSize(), currentCssSettings.getFontFamily());
        MarkdownApplicationSettings.getInstance().setMarkdownCssSettings(newSettings);
        ((MarkdownApplicationSettings.SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MarkdownApplicationSettings.SettingsChangedListener.TOPIC)).settingsChanged(MarkdownApplicationSettings.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/intellij/plugins/markdown/settings/MarkdownLAFListener", "lookAndFeelChanged"));
    }
}

