/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.mock;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetType;
import com.intellij.facet.mock.MockFacetConfiguration;
import com.intellij.facet.mock.MockFacetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MockFacet
extends Facet<MockFacetConfiguration>
implements FacetRootsProvider {
    private boolean myInitialized;
    private boolean myDisposed;
    private boolean myConfigured;

    public MockFacet(@NotNull Module module, String name) {
        if (module == null) {
            MockFacet.$$$reportNull$$$0(0);
        }
        this(module, name, new MockFacetConfiguration());
    }

    public MockFacet(Module module, String name, MockFacetConfiguration configuration2) {
        super((FacetType)MockFacetType.getInstance(), module, name, (FacetConfiguration)configuration2, null);
    }

    public void initFacet() {
        this.myInitialized = true;
    }

    public void disposeFacet() {
        this.myDisposed = true;
    }

    public boolean isConfigured() {
        return this.myConfigured;
    }

    public void configure() {
        this.myConfigured = true;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void addRoot(VirtualFile root) {
        ((MockFacetConfiguration)this.getConfiguration()).addRoot(root);
        this.fireFacetChangedEvent();
    }

    private void fireFacetChangedEvent() {
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    public void removeRoot(VirtualFile root) {
        ((MockFacetConfiguration)this.getConfiguration()).removeRoot(root);
        this.fireFacetChangedEvent();
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        List list = ContainerUtil.mapNotNull(((MockFacetConfiguration)this.getConfiguration()).getRootUrls(), arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0));
        if (list == null) {
            MockFacet.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/mock/MockFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/mock/MockFacet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

