/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.ExpectedAnnotations;
import com.jetbrains.cidr.ExpectedAnnotationsKt;
import com.jetbrains.cidr.TestAnnotationInfoList;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestAnnotationHolder
extends TestAnnotationInfoList {
    private final PsiFile myFile;
    private final Document myDocument;
    private final HighlightSeverity myMinimalSeverity;
    private final boolean myRunInspections;
    private final boolean myTestDisabled;
    private final Map<PsiElement, ExpectedAnnotations> myAssertions;

    public TestAnnotationHolder(@Nullable HighlightSeverity minimalSeverity, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TestAnnotationHolder.$$$reportNull$$$0(0);
        }
        this.myAssertions = new HashMap<PsiElement, ExpectedAnnotations>();
        this.myFile = psiFile;
        this.myMinimalSeverity = minimalSeverity == null ? HighlightSeverity.WEAK_WARNING : minimalSeverity;
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        this.myFile.getProject().putUserData(OCFile.UNUSED_CHECKS, (Object)OCFile.UnusedChecksMode.ENABLED);
        this.myFile.getProject().putUserData(OCFile.DFA_UNUSED_CHECKS, (Object)OCFile.UnusedChecksMode.ENABLED);
        this.myRunInspections = this.myFile.getText().contains("Run inspections");
        this.myTestDisabled = this.myFile.getText().contains("Test disabled");
        if (this.myFile.getProject().getUserData(OCResolveContext.FAIL_ON_RESOLVE_CYCLE) == null) {
            this.myFile.getProject().putUserData(OCResolveContext.FAIL_ON_RESOLVE_CYCLE, (Object)(!this.myFile.getText().contains("Allow resolve cycle") ? 1 : 0));
        }
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType((PsiElement)this.myFile, (Class[])new Class[]{PsiComment.class})) {
            ExpectedAnnotations expected = ExpectedAnnotationsKt.createByComment((PsiElement)comment);
            if (expected == null) continue;
            this.myAssertions.put((PsiElement)comment, expected);
        }
    }

    public synchronized void checkAllExpectedAnnotationsFound() {
        for (TestAnnotationInfoList.AnnotationInfo annotation : this.myAnnotationHolder) {
            this.checkAnnotation(annotation.range, annotation.severity, annotation.message);
        }
        ArrayList<CallSite> annotations = new ArrayList<CallSite>();
        for (Map.Entry<PsiElement, ExpectedAnnotations> entry : this.myAssertions.entrySet()) {
            String errorMessage = entry.getValue().checkRemaining();
            if (errorMessage == null) continue;
            annotations.add((CallSite)((Object)("Line " + (this.myDocument.getLineNumber(entry.getKey().getTextOffset()) + 1) + ": " + errorMessage)));
        }
        if (!annotations.isEmpty()) {
            Collections.sort(annotations);
            this.fail("Annotations not found:\n" + StringUtil.join(annotations, (String)"\n"));
        }
    }

    protected void fail(String message) {
        TestCase.fail((String)message);
    }

    protected void assertTrue(String message, boolean condition) {
        TestCase.assertTrue((String)message, (boolean)condition);
    }

    public static void findAndSetEnabledLanguageFeatures(String text, Project project2) {
        int pos = 0;
        while ((pos = text.indexOf("Enable language feature ", pos)) != -1) {
            int newline = text.indexOf("\n", pos);
            String feature = text.substring(pos + "Enable language feature ".length(), newline);
            OCCompilerFeatures.set((Project)project2, (OCCompilerFeatures.Type)OCCompilerFeatures.Feature.valueOf((String)feature), (Object)true);
            pos = newline;
        }
    }

    public static List<String> findDisabledClangWarnings(String text, Project project2) {
        int pos = 0;
        ArrayList<String> warnings = new ArrayList<String>();
        while ((pos = text.indexOf("Disable clang warning ", pos)) != -1) {
            int newline = text.indexOf("\n", pos);
            String warning = text.substring(pos + "Disable clang warning ".length(), newline);
            warnings.add(warning);
            pos = newline;
        }
        return warnings;
    }

    private synchronized void checkAnnotation(TextRange range, HighlightSeverity severity, String message) {
        int line;
        PsiElement original;
        if (severity.compareTo(this.myMinimalSeverity) >= 0 && (severity != HighlightSeverity.INFORMATION || message != null) && (original = this.myFile.findElementAt(this.myDocument.getLineEndOffset(line = this.myDocument.getLineNumber(range.getStartOffset())) - 1)) != null) {
            if (original.getParent() instanceof OCIncludeDirective) {
                original = original.getParent();
            }
            if (!(original instanceof PsiComment)) {
                original = PsiTreeUtil.skipWhitespacesBackward((PsiElement)original);
            }
            if (this.myAssertions.containsKey(original)) {
                String errorMessage = this.myAssertions.get(original).checkAnnotation(message);
                if (errorMessage != null) {
                    this.fail(String.format("Line %d: %s", line + 1, errorMessage));
                }
                return;
            }
            this.fail(String.format("Line %d: Non expected \"%s\"", line + 1, message));
        }
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public boolean isRunInspections() {
        return this.myRunInspections;
    }

    public boolean isTestDisabled() {
        return this.myTestDisabled;
    }

    @Override
    public void createQuickFix(@Nullable Segment annotation, @NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            TestAnnotationHolder.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/TestAnnotationHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createQuickFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

